/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : main.c
* Author             : MPA Systems Lab
* Date First Issued  : 06/04/2005
* Description        : Main function.
*                      
********************************************************************************
* History:
* 06/04/2005
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include <stdio.h>
#include "71x_lib.h"
#include "uip.h"
#include "uip_arp.h"
#include "ethdev.h"
#include "parmgt.h"
#include "slipdev.h"
#include <float.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define USE_ETH
//#define USE_SLIP

/* Private macro -------------------------------------------------------------*/
#define BUF ((struct uip_eth_hdr *)&uip_buf[0])

#ifndef NULL
#define NULL (void *)0
#endif /* NULL */

#ifndef MY_DEBUG
#define MY_DEBUG
#endif

/* Private variables ---------------------------------------------------------*/
volatile u8 one_msec = 0;
unsigned int time;
float time1;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : TCP_IP_Stack
* Description    : TCP/IP stack processing function.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
void TCP_IP_Stack( void ){

u8_t i, arptimer;
  int count; 

    //time = RTC_CounterValue();
    //time = time * 31 *32 / 1000;
    //printf("%d mSec.\n", time);
    //while ( !one_msec ){}
    //one_msec = 0;
    /* Let the tapdev network device driver read an entire IP packet
       into the uip_buf. If it must wait for more than 0.5 seconds, it
       will return with the return value 0. If so, we know that it is
       time to call upon the uip_periodic(). Otherwise, the tapdev has
       received an IP packet that is to be processed by uIP. */
#ifdef USE_ETH
    uip_len = ethdev_read(); //Read packet...
#endif
#ifdef USE_SLIP
    uip_len = slipdev_poll(); //Read packet...
#endif

    if(uip_len == 0) {
    	for(i = 0; i < UIP_CONNS; i++) {
			uip_periodic(i);
	/* If the above function invocation resulted in data that
	   should be sent out on the network, the global variable
	   uip_len is set to a value > 0. */
			if(uip_len > 0) {
	  			uip_arp_out();
#ifdef USE_ETH
	  			ethdev_send();
#endif
#ifdef USE_SLIP
    			slipdev_send();
#endif
			}
    	}

#if UIP_UDP
    	for(i = 0; i < UIP_UDP_CONNS; i++) {
			uip_udp_periodic(i);
	/* If the above function invocation resulted in data that
	   should be sent out on the network, the global variable
	   uip_len is set to a value > 0. */
			if(uip_len > 0) {
	  			uip_arp_out();
#ifdef USE_ETH
	  			ethdev_send();
#endif
#ifdef USE_SLIP
    			slipdev_send();
#endif
			}
    	}
#endif /* UIP_UDP */
      
      /* Call the ARP timer function every 10 seconds. */
    	if(++arptimer == 20) {	
			uip_arp_timer();
			arptimer = 0;
    	}
      
    } else {
      	if(BUF->type == htons(UIP_ETHTYPE_IP)) {
			uip_arp_ipin();
			uip_input();
	/* If the above function invocation resulted in data that
	   should be sent out on the network, the global variable
	   uip_len is set to a value > 0. */
			if(uip_len > 0) {
	  			uip_arp_out();
#ifdef USE_ETH
	  			ethdev_send();
#endif
#ifdef USE_SLIP
    			slipdev_send();
#endif
			}
      	} else if(BUF->type == htons(UIP_ETHTYPE_ARP)) {
			uip_arp_arpin();
	/* If the above function invocation resulted in data that
	   should be sent out on the network, the global variable
	   uip_len is set to a value > 0. */	
			if(uip_len > 0) {	
#ifdef USE_ETH
	  			ethdev_send();
#endif
#ifdef USE_SLIP
    			slipdev_send();
#endif
			}
      	}
    }
    
}


/*******************************************************************************
* Function Name  : main
* Description    : Main function.
* Input          : None.
* Output         : None.
* Return         : None.
*******************************************************************************/
int
main(void){
  u8_t i, arptimer;
  int count; 
  int InitOK = 0;

  	/*------------------------------------------------------------------
			SET FREQUENCY definition Core, Mem, APBs Bus
	--------------------------------------------------------------------*/
	RCCU_Div2Config(ENABLE);
	RCCU_MCLKConfig(RCCU_DEFAULT); 	// MCLK = RCLK
	RCCU_PLL1Config(RCCU_Mul_12,RCCU_Div_2); //div2
	RCCU_RCLKSourceConfig(RCCU_PLL1_Output);
	RCCU_MCLKConfig(RCCU_DEFAULT);	//	RCCU_DEFAULT 48MHz Core and Memory
	RCCU_FCLKConfig(RCCU_RCLK_2);	//	24MHz for PCLK1 (APB1)
	RCCU_PCLKConfig(RCCU_RCLK_4);	//	12MHz for PCLK2 (APB2)

	GPIO_Config (GPIO2, 0xFF, GPIO_AF_PP);
	EMI_Config(1, EMI_ENABLE | EMI_WAITSTATE(7) | EMI_SIZE_16);


#ifdef USE_ETH
  /* Initialize the device driver. */ 
  //Comm_Conf();
  InitOK = ethdev_init();
#endif

#ifdef USE_SLIP
  /* Initialize the device driver. */ 
  slipdev_init();
  InitOK = 1;
#endif
#ifdef MY_DEBUG
  printf("\n\rSTR7 TCP/IP Demo\n\r");
#endif

  /* Initialize the uIP TCP/IP stack. */
  uip_init();

  Init_Conf();

  /* Initialize the HTTP server. */
  httpd_init();
  //parmgt_init();
  
  arptimer = 0;
  printf("\n");
/*  if ( InitOK ){
  	RTC_PrescalerConfig(32);  // 1 mSec.
	RTC_ClearCounter ();
	RTC_AlarmConfig (5000); //5 Sec.
	RTC_ITConfig(RTC_AIT|RTC_GIT, ENABLE);
	EIC_IRQChannelConfig(RTC_IRQChannel, ENABLE);
	EIC_IRQChannelPriorityConfig(RTC_IRQChannel, 4);
	EIC_IRQConfig(ENABLE);
  }*/
  while(InitOK){
	count = 5000;
	while(count--){}
  	TCP_IP_Stack();
  }
  return 0;
}

/*******************************************************************************
* Function Name  : uip_log
* Description    : TCP/IP log function.
* Input          : Pointer to the message string.
* Output         : None.
* Return         : None.
*******************************************************************************/
void
uip_log(char *m)
{
  printf("uIP log message: %s\n", m);
}
/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/