/******************** (C) COPYRIGHT 2005 STMicroelectronics ********************
* File Name          : device_RFID.h
* Author             : ARM MLD&EMR Application Team
* Date First Issued  : 27/01/2005
* Description        : This file contains all the functions prototypes for the
*                      APB bridge software library.
********************************************************************************
* History:
*  27/01/2005 
*******************************************************************************/


/*------------------------------------------------------------------
	DEFINES
-------------------------------------------------------------------*/
#define T0_PROTOCOL		0x00		// T0 PROTOCOL
#define DIRECT			0x3B		// direct bit convention
#define INDIRECT		0x3F		// indirect bit convention
#define SETUP_LENGHT	20
#define HIST_LENGHT		20
#define LCmax			20
#define Reader_to_SC	0			// direction to sc
#define SC_to_reader	1			// direction to reader
#define SC_Receive_Timeout	12		// direction to reader

//#define SC_PARITY_HANDLER_TEST 1	// test parity error handling


/*------------------------------------------------------------------
	SC TREE STRUCTURE:
	
			MasterFile
		________|___________
	   |        |           |
	System   UserData     Note
			   
-------------------------------------------------------------------*/
#define MF				0x10
#define DF				0x10
#define EF				0x80
#define NULL_PARAM		0x00
#define PWD_LENGHT		8







/*------------------------------------------------------------------
2.	SC ADPU COMMAND:
   		 - Operation Code			
-------------------------------------------------------------------*/

//2.1	--------------------------Data Area Management Commands-----
#define SC_SELECT_FILE		0xA4
#define SC_GET_RESPONCE		0xC0
#define SC_STATUS			0xF2
#define SC_UPDATE_BINARY	0xD6
#define SC_READ_BINARY		0xB0
#define SC_WRITE_BINARY		0xD0
#define SC_UPDATE_RECORD	0xDC
#define SC_READ_RECORD		0xB2




//2.2--------------------------Administrative Commands----------------- 
#define SC_CREATE_FILE		0xE0

//2.3--------------------------Safety Management Commands-------------- 
#define SC_VERIFY			0x20
#define SC_CHANGE			0x24
#define SC_UNBLOCK			0x2C
#define SC_EXTERNAL_AUTH	0x82
#define SC_GET_CHALLENGE	0x84

//2.3--------------------------Answer to reset Commands-------------- 
#define SC_GET_A2R				0x00


/*------------------------------------------------------------------
2.	SC STATUS:
   		 - Status Code			
-------------------------------------------------------------------*/
#define SC_EF_SELECTED		0x6108
#define SC_DF_SELECTED		0x610B
#define SC_OP_TERMINATED	0x9000
#define SC_DF_EXISTENT		0x6200

#define SC_EF_NOT_SELECTED	0x6986
#define SC_ID_NOT_FOUND		0x6A82
#define SC_MEMORY_PROBLEM	0x6581
#define SC_WRONG_HEADER		0x6F00
#define SC_WRONG_P1_P2		0x6B00
#define SC_WRONG_LC_LE		0x6700


/*------------------------------------------------------------------
3.	SC PINS:
-------------------------------------------------------------------*/
#define SC_PIN1_W		0x10
#define SC_PIN2_W		0x20
#define SC_PIN3_W		0x40
#define SC_PIN4_W		0x80
#define SC_PIN1_R		0x00
#define SC_PIN2_R		0x02
#define SC_PIN3_R		0x04
#define SC_PIN4_R		0x08

#define SC_VERIFY_PIN1	0x00
#define SC_VERIFY_PIN2	0x01
#define SC_VERIFY_PIN3	0x02
#define SC_VERIFY_PIN4	0x03

typedef enum
{
	EF_Selected,
	MF_DF_Selected,		
	MEMORY_Problem,				
	ID_NotFound,						
	GenericError,									
	P1_P2_Error,								
	Data_Lenght_Error										
} SC_CommandStatus;


typedef enum
{
  SC_POWER_ON		= 0x00,
  SC_RESET_LOW		= 0x01,
  SC_RESET_HIGH		= 0x02,
  SC_ACTIVE			= 0x03,
  SC_ACTIVE_ON_T0	= 0x04,
  SC_POWER_OFF		= 0x05
} SC_State;



/*------------------------------------------------------------------
	MACRO
-------------------------------------------------------------------*/
extern u8 SC_data;

/*------------------------------------------------------------------
	STRUCTURE
-------------------------------------------------------------------*/

	/*------------------------------------------------------------------
		ATR STRUCTURE - ANSWER TO RESET
	-------------------------------------------------------------------*/
	typedef  struct SmartCard_ATR_Type {
		char 		TS;				//Bit Convention			
		char 		T0;				//high nibble=N. of setup byte; low nibble=N. of historical byte
		char 		T[SETUP_LENGHT];//setup array						
		char 		H[HIST_LENGHT];	//historical array
		u8 			Tlenght;		//setup array dimension
		u8 			Hlenght;		//historical array dimension
	} SC_ATR;

	/*------------------------------------------------------------------
		ADPU-Header COMMAND STRUCTURE
	-------------------------------------------------------------------*/
	typedef  struct SmartCard_Header_Type {
		char	 	CLA;			//Command class							
		char	 	INS;			//Operation code
		char		P1;				//Selection Mode
		char		P2;				//Selection Option
	} SC_Header;

	/*------------------------------------------------------------------
		ADPU-Body COMMAND STRUCTURE
	-------------------------------------------------------------------*/
	typedef  struct SmartCard_Body_Type {
		char 		LC;				//Data field lenght							
		char	 	Data[LCmax];	//Command parameters
		char		LE;				//Expected lenght of data to be returned				
	} SC_Body;

	/*------------------------------------------------------------------
		ADPU COMMAND STRUCTURE
	-------------------------------------------------------------------*/
	typedef  struct SmartCard_ADPU_Type {
		SC_Header 	Header;							
		SC_Body 	Body;				
	} SC_ADPU_Commands;

	/*------------------------------------------------------------------
		SC RESPONCE STRUCTURE
	-------------------------------------------------------------------*/
	typedef  struct SmartCard_ADPU_Responce_Type {
		char	 	Data[LCmax];			//Data returned from the card
		char	 	SW1;					//Command Processing status		
		char	 	SW2;					//Command Processing qualification		
	} SC_ADPU_Responce;





/*------------------------------------------------------------------
	FUNCTIONS
-------------------------------------------------------------------*/

/*------------------------------------------------------------------

	A. APPLICATION LAYER

-------------------------------------------------------------------*/
extern void SCR_example(void);														// application layer interface
extern u8 SC_Handler(u8 SC_Action, u8 *Data_to_SC, u8 Data_lenght, u8 P1, u8 P2, SC_State *SC_state, u16 *CmdStatus, u8 *Data_from_SC);



/*------------------------------------------------------------------

	B. TRANSPORT LAYER

-------------------------------------------------------------------*/
//1. --------------------ATR-------------------------------------------
extern void SC_AnswerReq(SC_State *SC_state, u8 *card, u8 lenght);					// ask		ATR
extern u8	SC_decode_Answer2reset(u8 *card);										// decode	ATR

//2. -------------------APDU-------------------------------------------
//2.1--------------------------Data Area Management Commands----------- 
extern u16	SC_Cmd(u8 SC_Action, u8 *Data, u8 Data_lenght,u8 P1, u8 P2 );
 

//2.3--------------------------Utility ----------------------------- 
extern void SC_Reset_ReceivedFrame(SC_ADPU_Responce *SC_ResponceStatus);			// reset receive buffer
extern u16 SC_Send_Receive_Cmd(u8 Cmd, u8 P1, u8 P2, u8 LC,  u8 *Data, u8 LE, u8 ReceiveDataFlag);

/*------------------------------------------------------------------

	C. PHYSICAL PORT LAYER

-------------------------------------------------------------------*/
extern void SC_SendData(SC_ADPU_Commands 	*SC_ADPU, SC_ADPU_Responce 	*SC_ResponceStatus, u8 ReceiveDataFlag);
extern void	SC_Pack_ADPU_Command(u8 CLA,u8 INS,u8 P1, u8 P2,u8 LC, u8 *FileID,u8 LE);// PACK ADPU COMMANDS
extern void SC_inverse(char *data, int len);										// INVERT DATA 
extern void SCR_delay(u8 value);
extern void  SC_ParityErrorIRQHandler(void);





/**** (c) 2001 STMicroelectronics *******	END OF FILE	 **********/





