/******************** (C) COPYRIGHT 2005 STMicroelectronics ********************
* File Name          : device_conf.h
* Author             : ARM MLD&EMR Application Team
* Date First Issued  : 27/01/2005
* Description        : Device configuration
********************************************************************************
* History:
*  27/01/05 : Created
*******************************************************************************/
#include "71x_lib.h"

/* Max Devices Number to comunicate with LCD display*/

#define N_device 			3

/*FIFO device length*/
#define lFIFO				30

/*LCD length String*/
#define lLCD				16

/*Defining MASK*/
#define FIFO_empty_mask		0x02
#define FIFO_full_mask		0x01


/* Define the Device ID_Number */
#define KeyPad_ID 			0
#define BarCode_ID			1 
#define RFID_ID				2 

/* Define the Device ID_Number */
#define NotFound 		0
#define Found			1 


/* Token Status */
#define FREE 				0
#define BUSY				1 


typedef struct PacketType
	{
    	u8 deviceData;
	} Packet;
	


typedef struct DeviceFIFOType
	{
    	Packet 	FIFO[lFIFO]; 
    	u8		first;
    	u8		last;
    	u8		status;
    	u8 		token;
    	u8		writing;
	} DeviceFIFO;
	
/*------------------------------------
		KEYBOARD 2 ASCII STRUCT
------------------------------------*/
typedef  struct K2A_Tag {
	u8 		keyboard;
	u8 		ascii;
} K2A;

typedef  struct K2A_MAPTag {
	 u8		CapsLock;
	 u8		NumLock;
	 K2A	*MAP;
} K2A_MAP;



/*------------------------------------
		ASCII UPPER 2 LOW CASE
------------------------------------*/
typedef  struct U2l_Tag {
	u8 		U_ascii;
	u8 		l_ascii;
} U2l;

typedef  struct U2l_MAPTag {
	U2l 		MAP[26];
} U2l_MAP;




/* ASCII Keys Dec */

#define key_0 		'\060' /* 1 */
#define key_1 		'\061' /* 1 */
#define key_2 		'\062' /* 2 */
#define key_3 		'\063' /* 3 */
#define key_4 		'\064' /* 4 */
#define key_5 		'\065' /* 5 */
#define key_6 		'\066' /* 6 */
#define key_7 		'\067' /* 7 */
#define key_8 		'\068' /* 8 */
#define key_9 		'\069' /* 9 */
#define keySpace	0x20//'\020' /* Space */
#define keyDot 		'\056' /* . */
#define keyPlus 	'\053' /* + */
#define keyLess 	'\055' /* - */
#define keyEqu 		'\075' /* = */
#define keyEnter	0x0D   /* Enter, carriage return */
#define keyF1		'\001' /* Function1, Correct Code To be Defined */
#define keyF2		'\002' /* Function2, Correct Code To be Defined */
#define keyF3		'\003' /* Function3, Correct Code To be Defined */
#define keyF4		'\004' /* Function4, Correct Code To be Defined */
#define keyNL 		0x0a   /* NL, line feed, new line */

/* Function Map */
#define Null		0x00
#define Summ		0x01
#define Diff		0x02
#define Enter		0x03
#define NewLine		0x04
#define F1			0x10
#define F2			0x11
#define F3			0x12
#define F4			0x13
