/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* File Name          : lcd.h
* Author             : MCD Application Team
* Date First Issued  : 20/05/2003
* Description        : This file contains all the functions prototypes for the
*                      LCD library.
********************************************************************************
* History:
*  20/05/03 : First Version.
*******************************************************************************/
#ifndef __LCD_H
#define __LCD_H

#include "71x_type.h"

// choose one of the following interfaces to drive the LCD
//#define LCD_I2C
#define LCD_EMI


#ifdef LCD_I2C
void LCD_Init(u32 speed);
#endif
#ifdef LCD_EMI
void LCD_Init(void);
#endif

void LCD_AutoScrollOn(void);
void LCD_AutoScrollOff(void);
void LCD_SetCursorPosition(u8 col, u8 row);
void LCD_SetCursorHome(void);
void LCD_UnderlineCursorOn(void);
void LCD_UnderlineCursorOff(void);
void LCD_BlockCursorOn(void);
void LCD_BlockCursorOff(void);
void LCD_CursorLeft(void);
void LCD_CursorRight(void);

void LCD_DisplayCharacter (u8 c, u8 col, u8 row);
void LCD_CreateCharacter(u8 c, u8 *pattern);

void LCD_String(char *String, u8 col, u8 row);
void LCD_ClearLine (u8 line);

void LCD_ScrollMessage(char *String, u8 row, u16 time_1ms);

#endif // __LCD_H

/******************* (C) COPYRIGHT 2003 STMicroelectronics *****END OF FILE****/
