/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* File Name          : sc.h
* Author             : MCD Application Team
* Date First Issued  : 16/05/2005
* Description        : This file contains all the functions prototypes for the
*                      SC software library.
********************************************************************************
* History:
* 
*  
*  
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
#ifndef __sc_H
#define __sc_H

#include "71x_map.h"

typedef enum
{
  CLK_DIV2   = 0x01,
  CLK_DIV4   = 0x02
} SC_CLKVal;

#define SMARTCARD_RESET			0
#define SMARTCARD_VCC			1		 	 /* If you want to use a GPIO Pin to power the card  */
#define SMARTCARD_DETECT		2			 /* If you use a smart card reader with a card detect signal */ 

#define SMARTCARD_DATAIN_OUT	10
#define SMARTCARD_CLOCK_OUT		12

#define HIGH 					1
#define LOW 					0

#define SC_PARITY_HANDLER_LOOPBACK	// uncomment:	parity error handling via loopback enabled
									// comment:		parity error handling via delated TxEmpty enabled


/*******************************************************************************
* Function Name  : SC_ClockConfig
* Description    : This function configures the mode of UART1.
* Input 1        : SC
* Input 2        : 
* Output         : None
* Return         : None
*******************************************************************************/
inline void SC_ClockConfig( SC_CLKVal SC_CLKVal)
{
  SC->CLKVAL = (SC->CLKVAL&0xFFE0)|(u16)SC_CLKVal;
}

/*******************************************************************************
* Function Name  : SC_CLKCON
* Description    : This function enables or disables clock output of smart card interface
* Input 	       : ENABLE or DISABLE
* Output         : None
* Return         : None
*******************************************************************************/
inline void SC_CLKCON(FunctionalState NewStatus)
{
  if (NewStatus==ENABLE) SC->CLKCON|=0x01; else SC->CLKCON&=~0x01;
}

/*****************************************************************************/

extern void SC_Init(void);
extern void SC_Reset(u8 reset_value);
extern void SC_Communication( u8 *BufferPoint, u8 BufferLength);
extern u8 SC_Detect(void);
extern void SC_Power(FunctionalState NewState);
extern u8  Uart_ByteSend_SC(u8* data);
extern void  Uart_ByteSend_SCirq(u8* data);
void UART_SCWaitEndOfDataSending(void);
#endif /* __sc_H */

/******************* (C) COPYRIGHT 2005 STMicroelectronics *****END OF FILE****/
