/******************** (C) COPYRIGHT 2005 STMicroelectronics ********************
* File Name          : device_SCR.c
* Author             : ARM MLD&EMR  Application Team
* Date First Issued  : 27/01/2005
* Description        : This file provides all the API device software functions
********************************************************************************
* History:
*  27/01/2005 
*******************************************************************************/
#define TEST_SCR	0
#define TIMEOUT_SCR 10000



#include <stdio.h>
#include "71x_lib.h"
#include "device_conf.h"
#include "device_SCR.h"
#include "uart.h"


/*-------------------------------------------------------------------------------
	GLOBAL VARIABLES DEFINITION AND INITIALIZATION
--------------------------------------------------------------------------------*/
SC_ATR 					SC_A2R;									
SC_ADPU_Commands 		SC_ADPU;
u8 SC_data;
/*-------------------------------------------------------------------------------
	SCR_DELAY
  -------------------------------------------------------------------------------
		input:
			-
			
		output:
			-
--------------------------------------------------------------------------------*/
void SCR_delay(u8 value)
{
  u16 i, j;
  j = 0;
  while(j<2)
  {
      for(i=0; i<value;i++);
      j++;
  }
}

/*-------------------------------------------------------------------------------
	SCR_DELAY
  -------------------------------------------------------------------------------
		input:
			-
			
		output:
			-
--------------------------------------------------------------------------------*/
void SC_delay(void)
{
  u16 i, j;
  j = 0;
  while(j<2)
  {
      for(i=0; i<0xff;i++);
      j++;
  }
}

/*-------------------------------------------------------------------------------
	SCR_EXAMPLE
  -------------------------------------------------------------------------------
		input:
			-
			
		output:
			-
--------------------------------------------------------------------------------*/
u8 SC_Handler(u8 SC_Action, u8 *Data_to_SC, u8 Data_lenght, u8 P1, u8 P2, SC_State *SC_state, u16 *CmdStatus, u8 *Data_from_SC){

u8					i=0;
u8					status=0;
u8					lenght=0;

	switch(*SC_state){

				case SC_POWER_ON:
						if (SC_Action== SC_GET_A2R){

							/*-----------------------------------------------------------
								SMART CARD PHERIPERAL INIT
							-------------------------------------------------------------*/
							SC_Init();						
							
							/*-----------------------------------------------------------
								Reset Data from SC buffer
							-------------------------------------------------------------*/
							for (i=0;i<40;i++) Data_from_SC[i]=0;

							/*-----------------------------------------------------------
								Reset A2R buffer
							-------------------------------------------------------------*/
							SC_A2R.TS=0;
							SC_A2R.T0=0;
							for (i=0;i<SETUP_LENGHT;i++) SC_A2R.T[i]=0;
							for (i=0;i<HIST_LENGHT;i++) SC_A2R.H[i]=0;
							SC_A2R.Tlenght=0;
							SC_A2R.Hlenght=0;

							/*-----------------------------------------------------------
								Next State
							-------------------------------------------------------------*/
							*SC_state=SC_RESET_LOW;

							/*-----------------------------------------------------------
								Delay
							-------------------------------------------------------------*/
							SC_delay();
							SC_delay();
							SC_delay();
							SC_delay();																		
						}
						break;

				case SC_RESET_LOW:
						if (SC_Action== SC_GET_A2R){
							/*-----------------------------------------------------------
								if (DETECT CARD) then (POWER ON, CARD RESET and wait for an answer)
							-------------------------------------------------------------*/
							if (SC_Detect())
									while(((*SC_state)!=SC_POWER_OFF)&((*SC_state)!=SC_ACTIVE))
										SC_AnswerReq(SC_state,&Data_from_SC[0],40);										// CHECK FOR ANSWER TO RESET
							else (*SC_state)=SC_POWER_OFF;
							SC_delay();
						}
						break;

				case SC_ACTIVE:
						if (SC_Action== SC_GET_A2R){
							if(SC_decode_Answer2reset(&Data_from_SC[0])==T0_PROTOCOL)(*SC_state)=SC_ACTIVE_ON_T0;
							else{
								(*SC_state)=SC_POWER_OFF; 
								printf("PROTOCOL NOT SUPPORTED");
							}
						}
						break;

				case SC_ACTIVE_ON_T0:
						/*-----------------------------------------------------------
							Copy Data to send to SC into Data_from_SC[] buffer
						-------------------------------------------------------------*/
						if(Data_lenght<3) lenght=3;
						else lenght=Data_lenght;
						for (i=0;i<lenght;i++) Data_from_SC[i]=Data_to_SC[i];
						
						(*CmdStatus)=SC_Cmd(SC_Action, Data_from_SC, Data_lenght, P1, P2);

						break;

				case SC_POWER_OFF:
					    SC_Power(ENABLE);					    // disable power - logica negata
						break;
				default: (*SC_state)=SC_POWER_OFF;
	}
return status;
}

/*-------------------------------------------------------------------------------
	SC_Cmd
  -------------------------------------------------------------------------------
		input: 	
			-
			
		output:
			-
--------------------------------------------------------------------------------*/
u16 SC_Cmd(u8 SC_Action, u8 *Data, u8 Data_Lenght, u8 P1, u8 P2){
u8 * pvoid;
u8 FileParam[8];
	switch(SC_Action){
		case SC_SELECT_FILE:
			return SC_Send_Receive_Cmd(SC_Action, 0, 0, 2, Data, 0, 0);
			break;
		case SC_GET_RESPONCE:
			Data_Lenght=8;
			return SC_Send_Receive_Cmd(SC_Action, 0, 0, 0, Data, Data_Lenght, 1);
			break;
		case SC_STATUS:
			return SC_Send_Receive_Cmd(SC_Action, 0, 0, 0xB, pvoid, 0, 1);
			break;
		case SC_UPDATE_BINARY:
			return SC_Send_Receive_Cmd(SC_Action, P1, P2, Data_Lenght, Data, 0, 1);
			break;
		case SC_READ_BINARY:
			return SC_Send_Receive_Cmd(SC_Action, P1, P2, 0, Data, Data_Lenght, 1);
			break;
		case SC_WRITE_BINARY:
			return SC_Send_Receive_Cmd(SC_Action, P1, P2, Data_Lenght, Data, 0, 0);
			break;
		case SC_UPDATE_RECORD:
			return SC_Send_Receive_Cmd(SC_Action, P1, P2, Data_Lenght, Data, 0, 0);
			break;
		case SC_READ_RECORD:
			return SC_Send_Receive_Cmd(SC_Action, P1, P2, Data_Lenght, Data, 0, 0);
			break;
		case SC_CREATE_FILE:
			FileParam[0]=0x85;			//Payload code

			FileParam[1]=Data[0];		//File ID
			FileParam[2]=Data[1];		//File ID
			
			FileParam[3]=0;				//16bit size in byte - high byte
			FileParam[4]=Data_Lenght;	//16bit size in byte - low byte

			FileParam[5]=Data[2];		//File Type: EF or DF
			
			FileParam[6]=P1;			//Access conditions
			FileParam[7]=P2;			//Record lenght 
		
			return SC_Send_Receive_Cmd(SC_Action, 0x1, 0, 0x8, FileParam, 0, 0);
			break;
		case SC_VERIFY:
			return SC_Send_Receive_Cmd(SC_Action, 0, P2, 0x8, Data, 0, 0);
			break;
		case SC_CHANGE:
			return SC_Send_Receive_Cmd(SC_Action, 0, P2, 0x10, Data, 0, 0);
			break;
		case SC_UNBLOCK:
			return SC_Send_Receive_Cmd(SC_Action, 0, P2, 0x10, Data, 0, 0);
			break;
		case SC_EXTERNAL_AUTH:
			return SC_Send_Receive_Cmd(SC_Action, P1, 0, 0x8, Data, 0, 0);
			break;
		case SC_GET_CHALLENGE:
			return SC_Send_Receive_Cmd(SC_Action, 0, 0, 0, Data, 0x8, 0);
			break;
	}
}



/*-------------------------------------------------------------------------------
	SC_SEND_RECEIVE_COMMAND
  -------------------------------------------------------------------------------
		input:	
				
			-
			
		output:
			-
--------------------------------------------------------------------------------*/
u16 SC_Send_Receive_Cmd(u8 Cmd, u8 P1, u8 P2, u8 LC,  u8 *Data, u8 LE, u8 ReceiveDataFlag){
SC_ADPU_Responce 	SC_ResponceStatus;
u8 i=0;

	/*-----------------------------------------------------------
		COMMAND TO SEND TO SC
	-------------------------------------------------------------*/
	SC_Pack_ADPU_Command(0x80,Cmd,P1,P2,LC,&(*Data),LE);

	/*-----------------------------------------------------------
		SEND COMMAND TO SC
	-------------------------------------------------------------*/
	SC_SendData(&SC_ADPU,&SC_ResponceStatus, ReceiveDataFlag);						//Send Data
	
	/*-----------------------------------------------------------
		COPY DATA INTO OUTPUT BUFFER
	-------------------------------------------------------------*/
	for(i=0;i<SC_ADPU.Body.LE;i++) Data[i]=SC_ResponceStatus.Data[i];

	/*-----------------------------------------------------------
		DECODE STATUS
	-------------------------------------------------------------*/
	return (SC_ResponceStatus.SW2|(SC_ResponceStatus.SW1<<8));

}


/*-------------------------------------------------------------------------------
	PACK_ADPU_COMMAND TO SEND TO_SC
  -------------------------------------------------------------------------------
		input: ADPU COMMANDS
			-
			
		output:
			-
--------------------------------------------------------------------------------*/
void	SC_Pack_ADPU_Command(u8 CLA,u8 INS,u8 P1, u8 P2,u8 LC, u8 *FileID,u8 LE){
u8 i=0;
	SC_ADPU.Header.CLA=CLA;
	SC_ADPU.Header.INS=INS;			//Opertation Code
	SC_ADPU.Header.P1=P1;			//Selection Mode (By file ID)
	SC_ADPU.Header.P2=P2;			//Selection Option not supported

	SC_ADPU.Body.LC=LC;				//Data field lenght

	for(i=0;i<SC_ADPU.Body.LC;i++)
	 SC_ADPU.Body.Data[i]=FileID[i];//File identifier

	while(i<LCmax) SC_ADPU.Body.Data[i++]=0; //reset other field

	SC_ADPU.Body.LE=LE;

}



/*-------------------------------------------------------------------------------
	SEND_DATA_TO_SC
  -------------------------------------------------------------------------------
		input: ADPU COMMANDS
			-
			
		output:
			-
--------------------------------------------------------------------------------*/


void SC_SendData(SC_ADPU_Commands 	*SC_ADPU, SC_ADPU_Responce 	*SC_ResponceStatus, u8 ReceiveDataFlag){
u8 i=0;
u8 locData=0;
u8 timeout=0;

	
	/* --------------------------------------------------------
			RESET RESPONCE BUFFER
	   -------------------------------------------------------- */
	 for(i=0;i<LCmax;i++)	(*SC_ResponceStatus).Data[i]=0;
	 (*SC_ResponceStatus).SW1=0;
	 (*SC_ResponceStatus).SW2=0;

	
	/* --------------------------------------------------------
			SEND HEADER
	   -------------------------------------------------------- */
	UART_RxConfig(UART1 ,DISABLE);          // Disable Rx


	SC_data=(*SC_ADPU).Header.CLA;
	Uart_ByteSend_SCirq((u8 *)&SC_data);
	SC_data=(*SC_ADPU).Header.INS;
	Uart_ByteSend_SCirq((u8 *)&SC_data);
	SC_data=(*SC_ADPU).Header.P1;
	Uart_ByteSend_SCirq((u8 *)&SC_data);
	SC_data=(*SC_ADPU).Header.P2;
	Uart_ByteSend_SCirq((u8 *)&SC_data);
	
	/* --------------------------------------------------------
			SEND BODY LENGHT TO/FROM SC 
	   -------------------------------------------------------- */
	if ((*SC_ADPU).Body.LC){
			SC_data=(*SC_ADPU).Body.LC;
			Uart_ByteSend_SCirq((u8 *)&SC_data);
	}	 
    else if((*SC_ADPU).Body.LE){ 
			SC_data=(*SC_ADPU).Body.LE;
			Uart_ByteSend_SCirq((u8 *)&SC_data);
	}	  
						
	UART_SCWaitEndOfDataSending();
	UART_ByteReceive(UART1,&locData,0xff);	  


	/* --------------------------------------------------------
			WAIT PROCEDURE BYTE FROM CARD:
				1 - ACK
				2 - NULL
				3 - SW1; SW2
	   -------------------------------------------------------- */
	 UART_RxConfig(UART1 ,ENABLE);          // Enable Rx
	 if(!( UART_ByteReceive(UART1,&locData,0xaa) & (1<<7))){
			    	 if((locData&0xf0)==0x60 || (locData&0xf0)==0x90){							// SW1 received
				    	 (*SC_ResponceStatus).SW1=locData;			
			    	 	 UART_RxConfig(UART1 ,ENABLE);          								// Enable Rx
						 if(!( UART_ByteReceive(UART1,&locData,0xaa) & (1<<7)))
 					    	 (*SC_ResponceStatus).SW2=locData;			
					 }    	 
			    	 else if ((locData&0xfe)==((~(*SC_ADPU).Header.INS)&0xfe)||(locData&0xfe)==((*SC_ADPU).Header.INS & 0xfe))
 					    	 (*SC_ResponceStatus).Data[0]=locData;						    	 // ACK received
	}
	
	/* --------------------------------------------------------
			IF NO STATUS BYTES RECEIVED...
	   -------------------------------------------------------- */
   	 if(!(*SC_ResponceStatus).SW1){
			/* --------------------------------------------------------
					SEND BODY DATA TO SC ...  
			   -------------------------------------------------------- */
			if 	((*SC_ADPU).Body.LC){
				for(i=0;i<(*SC_ADPU).Body.LC;i++){
					SC_data=(*SC_ADPU).Body.Data[i];
					Uart_ByteSend_SCirq((u8 *)&SC_data);
					UART_SCWaitEndOfDataSending();
					
					timeout=0;
					UART_RxConfig(UART1 ,ENABLE);          // Enable Rx
					while((( UART_ByteReceive(UART1,&locData,0xff) & (1<<7))) && (timeout++<SC_Receive_Timeout));
						    	(*SC_ResponceStatus).Data[1]=locData;
					timeout=0;
					UART_RxConfig(UART1 ,ENABLE);          // Enable Rx
					while((( UART_ByteReceive(UART1,&locData,0xff) & (1<<7))) && (timeout++<SC_Receive_Timeout));
						    	(*SC_ResponceStatus).Data[2]=locData;

					timeout=0;
					UART_RxConfig(UART1 ,ENABLE);          // Enable Rx
					while((( UART_ByteReceive(UART1,&locData,0xff) & (1<<7))) && (timeout++<SC_Receive_Timeout));
						    	(*SC_ResponceStatus).Data[3]=locData;

				}
	    	(*SC_ResponceStatus).SW1=(*SC_ResponceStatus).Data[2];			
	    	(*SC_ResponceStatus).SW2=(*SC_ResponceStatus).Data[3];				    	
			}	    

			/* --------------------------------------------------------
					... OR RECEIVE BODY DATA FROM SC 
			   -------------------------------------------------------- */
			else if 	((*SC_ADPU).Body.LE){
			    if(ReceiveDataFlag)
					for(i=0;i<(*SC_ADPU).Body.LE;i++){
						UART_RxConfig(UART1 ,ENABLE);          // Enable Rx
					    if(!( UART_ByteReceive(UART1,&locData,0xaa) & (1<<7))) (*SC_ResponceStatus).Data[i]=locData;
					}
		
				/* --------------------------------------------------------
						WAIT SW1
				   -------------------------------------------------------- */
			   	 UART_RxConfig(UART1 ,ENABLE);          // Enable Rx
				 i=0;
				 while(i<10){
				    if(!( UART_ByteReceive(UART1,&locData,0xaa) & (1<<7))){
				    	 (*SC_ResponceStatus).SW1=locData;			
				    	 i=11;
					}		    
				    else i++;
				 }
				
				 /* --------------------------------------------------------
				 		WAIT SW2
				   -------------------------------------------------------- */
				 UART_RxConfig(UART1 ,ENABLE);          // Enable Rx
				 i=0;
				 while(i<10){
				   if(!( UART_ByteReceive(UART1,&locData,0xaa) & (1<<7))){
					    	 (*SC_ResponceStatus).SW2=locData;			
					    	 i=11;
					}		    
				    else i++;
				 }


				
		}
	}
}


/*-------------------------------------------------------------------------------
	INVERT BIT CONVENTION
  -------------------------------------------------------------------------------
		input: DATA
			-
			
		output: DATA LENGHT
			-
		EXAMPLE: 
 		Reverse and invert all bits in each byte of a string.
		E.g. 10010111b (0x97) becomes 00010110b (0x16).
--------------------------------------------------------------------------------*/
extern void SC_inverse(char *data, int len) {
  int i, j;
  unsigned char c;
 
  for (i = 0; i < len; i++) {
  c = 0;
    for (j = 0; j < 8; j++)
      c |= ((data[i] & (1 << j)) != 0) << (7 - j);
    data[i] = ~c;
  }
 
  return;
}


/*-------------------------------------------------------------------------------
	RESET RESPONCE BUFFER
  -------------------------------------------------------------------------------
		input: RESPONCE BUFFER
			-
			
		output: 
			-
--------------------------------------------------------------------------------*/
void SC_Reset_ReceivedFrame(SC_ADPU_Responce *SC_ResponceStatus){
u8 i=0;
	for(i=0;i<LCmax;i++) (*SC_ResponceStatus).Data[i]=0;			//Data returned from the card
	(*SC_ResponceStatus).SW1=0;									//Command Processing status		
	(*SC_ResponceStatus).SW2=0;									//Command Processing qualification		
}





/*-------------------------------------------------------------------------------
	SC_ANSWERREQ
  -------------------------------------------------------------------------------
		input: 	SC_STATE
				SC_BUFFER
				SC_LENGHT
			-
			
		output:
			-
--------------------------------------------------------------------------------*/

void SC_AnswerReq(SC_State *SC_state, u8 *card, u8 lenght){
u8 Data=0;			
u8 i=0;
			switch(*SC_state){
				case SC_RESET_LOW:
					/*-----------------------------------------------------------
						CHECK RESPONCE WITH RESET LOW
					-------------------------------------------------------------*/
					 SC_Reset(1);						// reset low - a bjt is used as level shifter from 3.3 to 5 V
					 SC_Power(DISABLE);					// power on  - a bjt is used as level shifter from 3.3 to 5 V
					 
					 SC_ClockConfig(CLK_DIV2);				//8MHz/2=4MHz
					 //====================================================================c
					 // ETU = Elementary Time Unit
					 // ... smart card answer to reset with frequency (1/ETU)=(SC_CLK)/372
					 // 
					 // (1/ETU)	= SC_CLK / 372 = 10,75 Kbit/sec
					 //====================================================================					 
					 

					 UART_FifoReset(UART1, UART_RxFIFO);  // Reset the UART_RxFIFO
					 UART_FifoReset(UART1, UART_TxFIFO);  // Reset the UART_TxFIFO
   					 UART_RxConfig(UART1, ENABLE);         			// Enable Rx
					 SC_CLKCON(ENABLE);
		 			 
				     for (i=0;i<lenght;i++) if(!( UART_ByteReceive(UART1,&Data,0xff) & (1<<7))) card[i]=Data;						
		 			 //UART_DataReceive(UART1,&card[0],lenght,0xFF);	//receive data for timeout=0xFF
 			 		 
 			 		 if(card[0]){
 			 		 	(*SC_state)=SC_ACTIVE;
 						 SC_Reset(1);						
 					 }	 
 			 		 						 
 			 		 else			(*SC_state)=SC_RESET_HIGH;
					 break;

				case SC_RESET_HIGH:
					/*-----------------------------------------------------------
						CHECK RESPONCE WITH RESET HIGH
					-------------------------------------------------------------*/
		 			 SC_Reset(0);						// reset high - a bjt is used as level shifter from 3.3 to 5 V
			 		 UART_DataReceive(UART1,&(*card),lenght,0xFF);	//receive data for timeout=0xFF
 			 		 if(card[0])	(*SC_state)=SC_ACTIVE;
 			 		 else			(*SC_state)=SC_POWER_OFF;
					 break;

				case SC_ACTIVE:
					 break;
				
				case SC_POWER_OFF:
					/*-----------------------------------------------------------
						CLOSE CONNECTION IF NO ANSWER RECEVEID
					-------------------------------------------------------------*/
					 SC_Reset(0);								// reset high - a bjt is used as level shifter from 3.3 to 5 V
					 SC_Power(ENABLE);
					 SC_CLKCON(DISABLE);
					 break;
				default: (*SC_state)=SC_RESET_LOW;
			}
}


/*-------------------------------------------------------------------------------
	SC_ANSWERREQ
  -------------------------------------------------------------------------------
		input: SC_BUFFER
			-
			
		output:
			-
--------------------------------------------------------------------------------*/
u8 SC_decode_Answer2reset(u8 *card){
u8 i=0;
u8 flag=0;
u8 buf=0;
u8 protocol=0;

	SC_A2R.TS=card[0];														// INITIAL CHARACTER
	SC_A2R.T0=card[1];														// FORMAT CHARACTER
	
	SC_A2R.Hlenght	=SC_A2R.T0&0x0F;
	
	if ((SC_A2R.T0&0x80)==0x80) flag=1;
	
	for(i=0;i<4;i++) 	SC_A2R.Tlenght = SC_A2R.Tlenght + (((SC_A2R.T0&0xF0)>>(4+i)) & 0x1);
	
	for(i=0;i<SC_A2R.Tlenght;i++) 	SC_A2R.T[i]=card[i+2];
	
	protocol = SC_A2R.T[SC_A2R.Tlenght-1]&0x0f; 
	
	while (flag) {
		
			if ((SC_A2R.T[SC_A2R.Tlenght-1]&0x80)==0x80) flag=1;
			else flag=0;
			
			buf=SC_A2R.Tlenght;
			SC_A2R.Tlenght=0;
			
			for(i=0;i<4;i++) 	SC_A2R.Tlenght = SC_A2R.Tlenght + (((SC_A2R.T[buf-1]&0xF0)>>(4+i)) & 0x1);
			for(i=0;i<SC_A2R.Tlenght;i++) 	SC_A2R.T[buf+i]=card[i+2+buf];
			SC_A2R.Tlenght += buf;

	}
	
	for(i=0;i<SC_A2R.Hlenght;i++)	SC_A2R.H[i]=card[i+2+SC_A2R.Tlenght];

return protocol;

}



/*******************************************************************************
* Function Name  : SC_ParityErrorIRQHandler
* Description    : Read ack from smart card and resend last data in case of parity error
* Input 1        : void 
* Input 2        : 
* Input 3        : 
* Output         : 
* Return         : void
*******************************************************************************/
void  SC_ParityErrorIRQHandler(void)
{
#ifdef SC_PARITY_HANDLER_LOOPBACK
	if ((UART1->SR & UART_FrameError)) UART_ByteSend(UART1, (u8 *) &SC_data);	// check frame error and send data again
  	UART_ItConfig(UART1,UART_FrameError, DISABLE);
#endif

#ifndef SC_PARITY_HANDLER_LOOPBACK
u8 parity_error=0;
	if ((UART1->SR & UART_TxEmpty)){											// check irq source
		  GPIO_Config(GPIO0, 1<<SMARTCARD_DATAIN_OUT,GPIO_IN_TRI_TTL);			//Configure P0.10 as GPIO 
		  parity_error=(~GPIO_BitRead(GPIO0, 10))&0x1;
		  GPIO_Config(GPIO0, (1<<SMARTCARD_DATAIN_OUT),GPIO_AF_PP);		   		//Configure P0.10 as SC Data line 
		  if(parity_error)  UART_ByteSend(UART1, (u8 *) &SC_data);

		  #ifdef SC_PARITY_HANDLER_TEST
			  GPIO_BitWrite(GPIO0, 0,1);
			  SCR_delay(10);
		  	  GPIO_BitWrite(GPIO0, 0,0);
	  	  #endif
		  
		}
	  UART_ItConfig(UART1,UART_TxEmpty, DISABLE);
	  EIC->IPR = 0xFFFFFFFF; // Clear all pending bits
#endif
}

