/******************** (C) COPYRIGHT 2005 STMicroelectronics ********************
* File Name          : sc.c
* Author             : MCD Application Team
* Date First Issued  : 16/05/2005
* Description        : This file provides all the GPIO software functions
********************************************************************************
* History:
*  
*  
*  
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

#include "sc.h"
#include "eic.h"
#include "uart.h"
#include "gpio.h"


/*******************************************************************************
* Function Name  : SC_Init
* Description    : 
* Input 1        : 
* Input 2        : 
* Input 3        : 
* Output         : None
* Return         : None
*******************************************************************************/
void SC_Init(void)
{
   /*--------------------------------------------------------------------------
		INIT SC PINS
	---------------------------------------------------------------------------*/
   GPIO_Config(GPIO0, (1<<SMARTCARD_DATAIN_OUT)|(1<<SMARTCARD_CLOCK_OUT),GPIO_AF_PP);	// P010 as SMC Data In/Out
																		    			// P012 as SMC Clock
   																				
   GPIO_Config(GPIO0, 1<<SMARTCARD_RESET,GPIO_OUT_PP);			// P00 as SMC Reset
   GPIO_Config(GPIO0, 1<<SMARTCARD_VCC,GPIO_OUT_PP);			// P01 as SMC VCC
   GPIO_Config(GPIO0, 1<<SMARTCARD_DETECT,GPIO_IN_TRI_TTL);	// P02 as SMC Detect

   /*--------------------------------------------------------------------------
		CONFIGURE SC CLOCK
	---------------------------------------------------------------------------*/
   SC_ClockConfig(CLK_DIV2);								
  																				
   /*--------------------------------------------------------------------------
		INIT SC PHERIPERAL
	---------------------------------------------------------------------------*/
   UART_Init(UART1);
   UART_OnOffConfig(UART1, ENABLE);     // Turn UARTX on
   UART_SC_Config(UART1,ENABLE);		// Enable Smart Card Interface
   UART_FifoConfig (UART1, DISABLE);    // Disable FIFOs
   UART_FifoReset(UART1, UART_RxFIFO);  // Reset the UART_RxFIFO
   UART_FifoReset(UART1, UART_TxFIFO);  // Reset the UART_TxFIFO
   UART_LoopBackConfig(UART1, DISABLE);	// Disable Loop Back
                                         /* Configure the UARTX as following:
                                             - Baudrate = 9600 Bps
                                             - Odd arity
                                             - 8 data bits + 1 byte Parity
                                             - 1.5 stop bit */
   //UART_Config(UART1, 9600, UART_EVEN_PARITY, UART_1_5_StopBits, UARTM_8D_P);
   //UART_Config(UART1, 10752, UART_EVEN_PARITY, UART_1_5_StopBits, UARTM_8D_P);
   UART_Config(UART1, 10752, UART_EVEN_PARITY, UART_1_5_StopBits, UARTM_8D_P);
   //UART_Config(UART1, 5370, UART_EVEN_PARITY, UART_1_5_StopBits, UARTM_8D_P);
   UART_RxConfig(UART1, ENABLE);         // Disable Rx
   UART_GuardTimeConfig(UART1,0x3);

   /*--------------------------------------------------------------------------
		INIT BUS
	---------------------------------------------------------------------------*/
   SC_Reset(LOW);							// reset pin = 1 - logica negata   
   SC_Power(ENABLE);					    // disable power - logica negata
   SC_CLKCON(DISABLE);   
   
   /*--------------------------------------------------------------------------
		CONFIGURE IRQ
	---------------------------------------------------------------------------*/
   UART_GuardTimeConfig(UART1,2);						// delay TX_empty assertion of 2 bit@Baudrate
   EIC->IPR = 0xFFFFFFFF; 								// Clear all pending bits
   EIC_IRQChannelPriorityConfig(UART1_IRQChannel, 1);
   EIC_IRQChannelConfig(UART1_IRQChannel, ENABLE);
   EIC_IRQConfig(ENABLE);
}
/*******************************************************************************
* Function Name  : SC_Reset
* Description    : 
* Input 1        : 
* Input 2        : 
* Input 3        : 
* Output         : None
* Return         : None
*******************************************************************************/
void SC_Reset(u8 reset_value)
{
	GPIO_BitWrite(GPIO0,SMARTCARD_RESET,reset_value);
}


/*******************************************************************************
* Function Name  : SC_Communication
* Description    : 
* Input 1        : 
* Input 2        : 
* Input 3        : 
* Output         : None
* Return         : None
*******************************************************************************/
void SC_Communication(u8 *BufferPoint, u8 BufferLength)
{
	u8 States[2];
        u8 DataLength = 40;
	
	UART_DataSend(UART1, BufferPoint, BufferLength);
	UART_DataReceive(UART1,States,DataLength,960);
	UART_DataSend(UART1, BufferPoint, BufferLength);
	UART_DataReceive(UART1,BufferPoint,DataLength,960);

}


/*******************************************************************************
* Function Name  : SC_Detect
* Description    : 
* Input 1        :  
* Input 2        : 
* Input 3        : 
* Output         : Status: 1-smart card inserted; 0-smart card not inserted
* Return         : None
*******************************************************************************/
u8 SC_Detect(void)
{
  return (((GPIO0->PD)>>SMARTCARD_DETECT)&0x1);
}


/*******************************************************************************
* Function Name  : SC_Detect
* Description    : 
* Input 1        :  
* Input 2        : 
* Input 3        : 
* Output         : Status: 1-smart card inserted; 0-smart card not inserted
* Return         : None
*******************************************************************************/
void SC_Power(FunctionalState NewState)
{
  if (NewState==ENABLE)  GPIO0->PD |= (1<<SMARTCARD_VCC);
  else GPIO0->PD &= ~(1<<SMARTCARD_VCC);
}



/*******************************************************************************
* Function Name  : Uart_ByteSend_SC
* Description    : Send a data on SC data line and check for parity error
* Input 1        : data to send 
* Input 2        : 
* Input 3        : 
* Output         : 
* Return         : parity_error (1=no error; 0=error)
*******************************************************************************/
u8  Uart_ByteSend_SC(u8* data)
{
  u8	parity_error=0;
      				
  UART_ByteSend(UART1, data);
  while(!((UART_FlagStatus(UART1) & UART_TxEmpty)==2)); 			//while the transmit shift register not empty 
  GPIO_Config(GPIO0, 1<<SMARTCARD_DATAIN_OUT,GPIO_IN_TRI_TTL);		//Configure P0.10 as GPIO 
  parity_error=GPIO_BitRead(GPIO0, 10);           					//Check Parity error
  GPIO_Config(GPIO0, (1<<SMARTCARD_DATAIN_OUT),GPIO_AF_PP);   		//Configure P0.10 as SC Data line 
  
  return parity_error;  
}

/*******************************************************************************
* Function Name  : Uart_ByteSend_SCirq
* Description    : Send a data on SC data line and enable TX_Empty irq
* Input 1        : data to send 
* Input 2        : 
* Input 3        : 
* Output         : 
* Return         : void
*******************************************************************************/
void  Uart_ByteSend_SCirq(u8* data)
{
#ifdef SC_PARITY_HANDLER_LOOPBACK
	  UART_RxConfig(UART1 ,ENABLE);          								// Enable Rx
	  UART_ByteSend(UART1, data);
	  UART_ItConfig(UART1,UART_FrameError, ENABLE);
#endif

#ifndef SC_PARITY_HANDLER_LOOPBACK
  UART_ByteSend(UART1, data);
  UART_ItConfig(UART1,UART_TxEmpty, ENABLE);
#endif

}

/*******************************************************************************
* Function Name  : UART_SCWaitEndOfDataSending
* Description    : Wait the end of trasmission of the last data sent
* Input 1        : void 
* Input 2        : 
* Input 3        : 
* Output         : 
* Return         : void
*******************************************************************************/
void UART_SCWaitEndOfDataSending(void){
	while (!(UART1->SR & UART_TxEmpty)); 													// while the transmit shift register not empty	
	#ifdef SC_PARITY_HANDLER_LOOPBACK
	  UART_ItConfig(UART1,UART_FrameError, DISABLE);
	#endif
}

/******************* (C) COPYRIGHT 2005 STMicroelectronics *****END OF FILE****/
