/******************** (C) COPYRIGHT 2003 STMicroelectronics ********************
* File Name          : main.c
* Author             : MLD Clab 32-bit Application Team
* Date First Issued  : 18/06/2003
* Description        : Smart Card Example
********************************************************************************
* History:
*  06/09/2005 : creation
*  06/09/2005 : V0.0
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

#include "71x_lib.h"					// STR7	LIB			- PHERIPHERAL DRIVER
#include "cfg_clock.h"					// CLK	LIB 		- STR7 CLOCK CFG
#include "device_SCR.h"					// SMART CARD LIB 	


/*------------------------------------
		M A I N 
------------------------------------*/
int main(void)
{
const u8	MasterRoot[3]={0x3f,0x00,MF};
u8			PrivateDir[3]={0xCA,0x00,DF};
u8			PrivateFile[3]={0xCA,0xA1,EF};
u8			PublicFile[3]={0xCD,0x00,EF};
u8			PublicDir[3]={0xDD,0x00,DF};
u8			PwdFile[3]={0xDD,0xDD,EF};
u8			Pwd[8]={'1','1','1','1','1','1','1','1'};

u8			i=0;
u16			u16_status=0;
u8 			* pvoid;

u8			card[40];  
u8			responce[40];  
u8			FileParamST[40]="SmartCardDemo";

u8			offset_low=0;
u8			offset_high=0;
u8			byte_number=0;

SC_State 	SC_state=SC_POWER_OFF;


/*------------------------------------------------------------------
			DEBUG
--------------------------------------------------------------------*/
#ifdef DEBUG
	    debug();
#endif

	/*------------------------------------------------------------------
	  		IDLE TASK
	--------------------------------------------------------------------*/
 while(1)
 {


 	for(i=0;i<40;i++) responce[i]=0;
	/*------------------------------------------------------------------
	  		Start SC Demo
	--------------------------------------------------------------------*/

	/*------------------------------------------------------------------
	  		WAIT A2R
	--------------------------------------------------------------------*/
	SC_state=SC_POWER_ON;
	while (SC_state!=SC_ACTIVE_ON_T0)	SC_Handler(SC_GET_A2R, pvoid, NULL_PARAM, NULL_PARAM, NULL_PARAM, &SC_state, &u16_status, card);	

	/*------------------------------------------------------------------
	  		SELECT MF
	--------------------------------------------------------------------*/
	SC_Handler(SC_SELECT_FILE, (u8 *) MasterRoot, NULL_PARAM, NULL_PARAM, NULL_PARAM, &SC_state, &u16_status, card);	
	

	/*------------------------------------------------------------------
	  		SELECT DF
	--------------------------------------------------------------------*/
	if (u16_status==SC_DF_SELECTED) SC_Handler(SC_SELECT_FILE, (u8 *) PrivateDir, NULL_PARAM,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;
	
	
	/*------------------------------------------------------------------
	  		SELECT EF
	--------------------------------------------------------------------*/
	if (u16_status==SC_DF_SELECTED)  SC_Handler(SC_SELECT_FILE, (u8 *) PrivateFile, NULL_PARAM,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;

	/*------------------------------------------------------------------
	  		READ EF
	--------------------------------------------------------------------*/
	offset_low=1;
	offset_high=0;	
	byte_number=3;
	
	
	if (u16_status==SC_EF_SELECTED)  SC_Handler(SC_READ_BINARY, (u8 *) PrivateFile, byte_number,offset_high,offset_low, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;
	
	
	/*------------------------------------------------------------------
	  		SELECT MF
	--------------------------------------------------------------------*/
	if (u16_status==SC_OP_TERMINATED) SC_Handler(SC_SELECT_FILE, (u8 *) MasterRoot, NULL_PARAM,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, card);	
	else SC_state=SC_POWER_OFF;


	/*------------------------------------------------------------------
	  		CREATE FILE EF
	--------------------------------------------------------------------*/
	if (u16_status==SC_DF_SELECTED) SC_Handler(SC_CREATE_FILE, (u8 *) PublicFile, 20,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;

	/*------------------------------------------------------------------
	  		SELECT MF
	--------------------------------------------------------------------*/
	SC_Handler(SC_SELECT_FILE, (u8 *) MasterRoot, NULL_PARAM,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, card);	


	/*------------------------------------------------------------------
	  		SELECT EF
	--------------------------------------------------------------------*/
	if (u16_status==SC_DF_SELECTED)  SC_Handler(SC_SELECT_FILE, (u8 *) PublicFile, NULL_PARAM,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;

	/*------------------------------------------------------------------
	  		READ EF
	--------------------------------------------------------------------*/
	offset_low=1;
	offset_high=0;	
	byte_number=19;
	
	
	if (u16_status==SC_EF_SELECTED)  SC_Handler(SC_READ_BINARY, (u8 *) PublicFile, byte_number,offset_high,offset_low, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;


	/*------------------------------------------------------------------
	  		WRITE EF
	--------------------------------------------------------------------*/


	offset_low=1;
	offset_high=0;	
	byte_number=18;
	
	
	if (u16_status==SC_OP_TERMINATED)  SC_Handler(SC_UPDATE_BINARY, (u8 *) FileParamST, byte_number,offset_high,offset_low, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;


	/*------------------------------------------------------------------
	  		SELECT MF
	--------------------------------------------------------------------*/
	if (u16_status==SC_OP_TERMINATED)  	SC_Handler(SC_SELECT_FILE, (u8 *) MasterRoot, NULL_PARAM,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, card);	
	else SC_state=SC_POWER_OFF;


	/*------------------------------------------------------------------
	  		CREATE FILE DF
	--------------------------------------------------------------------*/
	if (u16_status==SC_DF_SELECTED) SC_Handler(SC_CREATE_FILE, (u8 *) PublicDir, NULL_PARAM,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;

	/*------------------------------------------------------------------
	  		SELECT DF
	--------------------------------------------------------------------*/
	if ((u16_status==SC_OP_TERMINATED) || (u16_status==SC_DF_EXISTENT)) SC_Handler(SC_SELECT_FILE, (u8 *) PublicDir, NULL_PARAM,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;


	/*------------------------------------------------------------------
	  		CREATE FILE EF
	--------------------------------------------------------------------*/
	if (u16_status==SC_DF_SELECTED) SC_Handler(SC_CREATE_FILE, (u8 *) PwdFile, 40,SC_PIN1_W | SC_PIN1_R,NULL_PARAM, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;

	/*------------------------------------------------------------------
	  		VERIFY EF
	--------------------------------------------------------------------*/
	SC_Handler(SC_VERIFY, (u8 *) Pwd, PWD_LENGHT,NULL_PARAM,SC_VERIFY_PIN1, &SC_state, &u16_status, responce);	
	//else SC_state=SC_POWER_OFF;

	/*------------------------------------------------------------------
	  		SELECT EF
	--------------------------------------------------------------------*/
	if (u16_status==SC_OP_TERMINATED) SC_Handler(SC_SELECT_FILE, (u8 *) PwdFile, NULL_PARAM,NULL_PARAM,NULL_PARAM, &SC_state, &u16_status, responce);	
	else SC_state=SC_POWER_OFF;


	SC_state=SC_POWER_OFF;
	

 }

}

/******************* (C) COPYRIGHT 2003 STMicroelectronics *****END OF FILE****/
