#ifndef _ASSIGN_MMI_H
#define _INCLUDE_INC

#ifndef _ST72MC_H
#include "st72mc2_0.h"
#endif

#define sim()	_asm("sim")	// set interrupt mask
#define rim()	_asm("rim")	// reset interrupt mask
#define halt()	_asm("halt")	

#define  NULL  0

/*****************************************************************************/
/******************************  TYPEDEFS  ***********************************/
/*****************************************************************************/
typedef  unsigned char  u8;
typedef  signed char    s8;
typedef  unsigned int   u16;
typedef  signed int     s16;
typedef  unsigned long  u32;
typedef  signed long    s32;

union uDouble_byte {
  u16 word;
  struct  {
    u8 b1;
    u8 b0;
  }byte;
};
/**************************/
union sDouble_byte {
  s16 word;
  struct  {
    s8 b1;
    u8 b0;
  }byte;
};
/***************************/
union uDouble_word {
  u32  dw;
  struct  {
    u16 w1;
    u16 w0;
  }word;
  struct  {
    u8 b3;
    u8 b2;
    u8 b1;
    u8 b0;
  }byte;
  struct {
    u8  b3;
    u16  b21;
    u8  b0;
  } wb;
};
/**************************/
union sDouble_word {
  s32  dw;
  struct  {
    s16  w1;
    u16  w0;
  } word;
  struct  {
    s8 b3;
    u8 b2;
    u8 b1;
    u8 b0;
  }byte;
  struct {
    s8   b3;
    u16  b21;
    u8   b0;
  } wb;
};
/**************************/
typedef  union uDouble_byte    uDOUBLE_8;
typedef  union sDouble_byte    sDOUBLE_8;
typedef  union uDouble_word    uQUAD_8;
typedef  union sDouble_word    sQUAD_8;
/**************************/

/*************************************************/
/*     This file contains information about      */
/*     the assignments of PINs and parameters    */
/*     used in the system                        */
/*************************************************/


/**************************************************************************/

/**************************************************************************/

#endif   /* End of ASSIGN.H  */
