
/**************** (c) 2005  STMicroelectronics, Inc. **********************/

/**************************************************************************
     PROGRAM  : SINUSOIDAL CONTROL OF 3 PHASE BLDC MOTOR WITH HALL SENSOR
     COMPILER : COSMIC
     FILENAME : INTERRUPT.C 
     RELEASE  : 1.0
     DATE     : May 2005
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173
***************************************************************************

MODIFICATIONS :


******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/

/****************************************************************
    INTERRUPT.C  - contains unused interrupt functions only
****************************************************************/

#include "include.inc"

/********************************************************************/
/* External variables
**********************/
/********************************************************************/

/* variables for external access
********************************/
/********************************************************************/
	/* general purpose
	******************/

/********************************************************************/




/*****************************************************************************************/

@interrupt void timerA_ISR (void)	{

	/* Input Capture 1
	******************/
	if ( bitTest_TRUE(TACSR, icf1) )	{
		TAIC1LR;	/* Read LSB to clear ICF1 */
		}

	/* Input capture 2
	*******************/
	if ( bitTest_TRUE(TACSR, icf2) )	{
		TAIC2LR;	/* Read LSB to clear ICF2 */
		}

	/* Output compare 1
	********************/
	if ( bitTest_TRUE(TACSR, ocf1) )	{
		/* reading LR clears OCF1. writing HR only disables OC1 interrupts */
		TAOC1HR = TAOC1LR;
		}

	/* Output compare 2
	********************/
	if ( bitTest_TRUE(TACSR, ocf2) )	{
		/* reading LR clears OCF2. writing HR only disables OC2 interrupts */
		TAOC2HR = TAOC2LR;
		}

	/* Timer overflow
	******************/
	if ( bitTest_TRUE(TACSR, tof) )	{
		TACLR;		/* Read LSB first to clear TOF  */
		}

	}

/********************************************************************/

@interrupt void timerB_ISR(void)	{

	/* Input Capture 1
	******************/
	if ( bitTest_TRUE(TBCSR, icf1) )	{
		TBIC1LR;	/* Read LSB to clear ICF1 */
		}

	/* Input capture 2
	*******************/
	if ( bitTest_TRUE(TBCSR, icf2) )	{
		TBIC2LR;	/* Read LSB to clear ICF2 */
		}

	/* Output compare 1
	********************/
	if ( bitTest_TRUE(TBCSR, ocf1) )	{
		/* reading LR clears OCF1. writing HR only disables OC1 interrupts */
		TBOC1HR = TBOC1LR;
		}

	/* Output compare 2
	********************/
	if ( bitTest_TRUE(TBCSR, ocf2) )	{
		/* reading LR clears OCF2. writing HR only disables OC2 interrupts */
		TBOC2HR = TBOC2LR;
		}

	/* Timer overflow
	******************/
	if ( bitTest_TRUE(TBCSR, tof) )	{
		TBCLR;		/* Read LSB first to clear TOF  */
		}

	}
/********************************************************************/
/********************************************************************/
/* Unused interrupts
 *********************/
@interrupt void trap_ISR(void) 		{;}		/* trap interrupt */
//@interrupt void tli_ISR(void)  		{;}		/* TLI interrupt */
/* @interrupt void mccRtc_ISR(void)	{;}		/* Main Clock Control/ Real time clock interrupt */
@interrupt void ext0_ISR(void)		{;}		/* External0 interrupt */
@interrupt void ext1_ISR(void)		{;}		/* External1 interrupt */
@interrupt void ext2_ISR(void)		{;}		/* External2 interrupt */
/* @interrupt void mtcU_ISR(void)		{;}		/* Motor control - Event U or crnt loop or samp out interrupt */
//@interrupt void mtcRZ_ISR(void)		{;}		/* Motor control - Event U or Event Z interrupt */
/*@interrupt void mtcCD_ISR(void)		{;}		/* Motor control - Event C or Event D interrupt */
@interrupt void spi_ISR(void)		{;}		/* SPI interrupt */
/* @interrupt void timerA_ISR(void)	{;}		timerA interrupt */
/* @interrupt void timerB_ISR(void)	{;}		timerB interrupt */
@interrupt void linSci_ISR(void)	{;}		/* LIN SCI interrupt */
@interrupt void avdAdc_ISR(void)	{;}		/* AVD / ADC interrupt */
@interrupt void pwmArt_ISR(void)	{;}		/* PWM ART o/f interrupt */

/******************************************************************************/
