
/**************** (c) 2005  STMicroelectronics, Inc. **********************/

/**************************************************************************
     PROGRAM  : SINUSOIDAL CONTROL OF 3 PHASE BLDC MOTOR WITH HALL SENSOR
     COMPILER : COSMIC
     FILENAME : SCI.C 
     RELEASE  : 1.0
     DATE     : May 2005
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173
***************************************************************************

MODIFICATIONS :


******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/

/****************************************************************
	SCI.C  - contains serial tx functions only
****************************************************************/


#include "include.inc"

/************************************************/
u8 hex2asc_sndchr(u8 in) {
   in &= 0x0f;
   while (!(SCISR & TC)) ;
   if (in <= 9)
     SCIDR = in + 0x30;
   else
     SCIDR = in + 0x37;
   return;
}
///////////////////////////////////////////////
void sndchr (u8 in) {
  while (!(SCISR & TC)) ;
  SCIDR = in;
  return;
}
///////////////////////////////////////////////
void prnhx16(u16 in)  {
   hex2asc_sndchr(in >> 12);
   hex2asc_sndchr(in >> 8);
   hex2asc_sndchr((in%256) >> 4);
   hex2asc_sndchr(in);
   sndchr(' ');
   return;
}
///////////////////////////////////////////////
void prnhx8(u8 in)  {
   hex2asc_sndchr(in >> 4);
   hex2asc_sndchr(in);
   sndchr(' ');
   return;
}
///////////////////////////////////////////////
void prnstr(u8 * string)  {
u8 temp;
   while ( (temp = *string++) != NULL )
      sndchr(temp);
   return;
}
///////////////////////////////////////////////
void init_SCI_tx_2400(void)  {
u8 temp;
   // tx, rx baud 2400 (Fcpu(8MHz)/(16*13*32))
   SCIBRR = SCP1 + SCP0 + SCT2 + SCR2 + SCR0;
   SCICR1 = 0;
   SCICR2 = TE;     // tie  tcie  rie  ilie  te  re  rwu  sbk
   temp = SCISR;    // read SR to clear spurious active flags
   return;
}
/************************************************/
