#ifndef _ST72MC_H
#define _ST72MC_H

	/***************************************
	*  INCLUDE FILE : ST7REG.H             *
	*                                      *
	*   This contains                      *
	*   	- ST7 register definitions     *
	*    	- bit definitions              *
	*    	- pin definitions              *
	***************************************/

/***************************************************************************************/

/*****************************************************
*                                                    *
*    since  ASSEMBLY and C are used , the            *
*     device registers are prefixed with             *
*     'a'. This is to indicate that they             *
*    are pointers pointing to some address           *
*     location in the memory                         *
*                                                    *
*   for example, consider the following lines        *
*                                                    *
*   #define  aPCDR   0x0                             *
*   #define  PCDR    *(unsigned char *)aPCDR         *
*                                                    *
*     in assembly language, the code                 *
*     	LD   A, #0                                   *
*    	LD   aPCDR, A                                *
*                                                    *
*     is equivalent to the C code                    *
*          PCDR = 0x0;                               *
*                                                    *
******************************************************/


/* Register definitions for assembly language use
*************************************************/

/*  Port A register
 *******************/
#define	 aPADR	     0x0
#define	 aPADDR	     0x1
#define	 aPAOR	     0x2

/*  Port B register
 *******************/
#define	 aPBDR	     0x3
#define	 aPBDDR	     0x4
#define	 aPBOR	     0x5

/*  Port C register
 *******************/
#define	 aPCDR	     0x6
#define	 aPCDDR	     0x7
#define	 aPCOR	     0x8

/*  Port D register
 *******************/
#define	 aPDDR	     0x9
#define	 aPDDDR	     0xA
#define	 aPDOR	     0xB

/*  Port E register
 *******************/
#define	 aPEDR	     0xC
#define	 aPEDDR	     0xD
#define	 aPEOR	     0xE

/*  Port F register
 *******************/
#define	 aPFDR	     0xF
#define	 aPFDDR	     0x10
#define	 aPFOR	     0x11

/*  Port G register
 *******************/
#define	 aPGDR	     0x12
#define	 aPGDDR	     0x13
#define	 aPGOR	     0x14

/*  Port H register
 *******************/
#define	 aPHDR	     0x15
#define	 aPHDDR	     0x16
#define	 aPHOR	     0x17

/*  LINSCI register
 *******************/
#define	 aSCISR	     0x18
#define	 aSCIDR	     0x19
#define	 aSCIBRR     0x1A
#define	 aSCICR1     0x1B
#define	 aSCICR2     0x1C
#define	 aSCICR3     0x1D
#define	 aSCIERPR    0x1E
#define	 aSCIETPR    0x1F


/*   SPI register
*****************/
#define	 aSPIDR	     0x21
#define	 aSPICR	     0x22
#define	 aSPISR      0x23


/*  Interrupt Control Register
 *******************************/
#define  aITSPR0     0x24
#define  aITSPR1     0x25
#define  aITSPR2     0x26
#define  aITSPR3     0x27
#define  aEICR	     0x28


/* Flash Register
 *******************/
#define  aFLASH	     0x29


/*   Watch dog register
************************/
#define	 aWWDGCR     0x2A
#define	 aWWDGWR     0x2B


/* Main Clock Control Register
 *******************************/
#define  aMCCSR	     0x2C
#define  aMCCBCR     0x2D


/*   ADC register
 *****************/
#define	 aADCCSR     0x2E
#define	 aADCDRMSB   0x2F
#define	 aADCDRLSB   0x30


/*   Timer A registers
**********************/
#define  aTACR2	     0x31
#define  aTACR1	     0x32
                     
#define  aTACSR	     0x33
                     
#define  aTAIC1HR    0x34
#define  aTAIC1LR    0x35
                     
#define  aTAOC1HR    0x36
#define  aTAOC1LR    0x37
                     
#define  aTACHR	     0x38
#define  aTACLR	     0x39
                     
#define  aTAACHR     0x3A
#define  aTAACLR     0x3B
                     
#define  aTAIC2HR    0x3c
#define  aTAIC2LR    0x3d
                     
#define  aTAOC2HR    0x3e
#define  aTAOC2LR    0x3f


/*  System Control
 ********************/
#define  aSICSR      0x40

/* Timer B registers
*********************/
#define  aTBCR2	     0x41
#define  aTBCR1	     0x42
#define  aTBCSR	     0x43
#define  aTBIC1HR    0x44
#define  aTBIC1LR    0x45
#define  aTBOC1HR    0x46
#define  aTBOC1LR    0x47
#define  aTBCHR	     0x48
#define  aTBCLR	     0x49
#define  aTBACHR     0x4A
#define  aTBACLR     0x4B
#define  aTBIC2HR    0x4c
#define  aTBIC2LR    0x4d
#define  aTBOC2HR    0x4e
#define  aTBOC2LR    0x4f


/*  Motor control registers (Page 0)
 **************************************/
#define  aMTIM       0x50
#define  aMTIML      0x51
#define  aMZPRV      0x52
#define  aMZREG      0x53
#define  aMCOMP      0x54
#define  aMDREG      0x55
#define  aMWGHT      0x56
#define  aMPRSR      0x57
#define  aMIMR       0x58
#define  aMISR       0x59
#define  aMCRA       0x5a
#define  aMCRB       0x5b
#define  aMCRC       0x5c
#define  aMPHST      0x5d
#define  aMDFR       0x5e
#define  aMCFR       0x5f
#define  aMREF       0x60
#define  aMPCR       0x61
#define  aMREP       0x62
#define  aMCPWH      0x63
#define  aMCPWL      0x64
#define  aMCPVH      0x65
#define  aMCPVL      0x66
#define  aMCPUH      0x67
#define  aMCPUL      0x68
#define  aMCP0H      0x69
#define  aMCP0L      0x6a

/*  Motor control registers (Page 1)
 **************************************/
#define  aMDTG       0x50
#define  aMPOL       0x51
#define  aMPWME      0x52
#define  aMCONF      0x53
#define  aMPAR       0x54
#define  aMZFR       0x55
#define  aMSCR       0x56

/* PWM ART registers
 **********************/
#define  aPWMDCR3    0x74
#define  aPWMDCR2    0x75
#define  aPWMDCR1    0x76
#define  aPWMDCR0    0x77
#define  aPWMCR      0x78
#define  aARTCSR     0x79
#define  aARTCAR     0x7a
#define  aARTARR     0x7b
#define  aARTICCSR   0x7c
#define  aARTICR1    0x7d
#define  aARTICR2    0x7e

/* OPAMP control registers
 ***************************/
#define  aOACSR      0x7f

/***************************************************************************************/

/* Register definitions for C language use
******************************************/


typedef   volatile unsigned char   vu8;


/*   Port A register
********************/
#define	 PADR      ( * (vu8 *) aPADR  )
#define	 PADDR     ( * (vu8 *) aPADDR )
#define	 PAOR      ( * (vu8 *) aPAOR  )

/*   Port B register
********************/
#define	 PBDR      ( * (vu8 *) aPBDR  )
#define	 PBDDR     ( * (vu8 *) aPBDDR )
#define	 PBOR      ( * (vu8 *) aPBOR  )

/*  Port C register
********************/
#define	 PCDR      ( * (vu8 *) aPCDR  )
#define	 PCDDR     ( * (vu8 *) aPCDDR )
#define	 PCOR      ( * (vu8 *) aPCOR  )

/*  Port D register
 *******************/
#define	 PDDR      ( * (vu8 *) aPDDR  )
#define	 PDDDR     ( * (vu8 *) aPDDDR )
#define	 PDOR      ( * (vu8 *) aPDOR  )

/*  Port E register
 *******************/
#define	 PEDR      ( * (vu8 *) aPEDR  )
#define	 PEDDR     ( * (vu8 *) aPEDDR )
#define	 PEOR      ( * (vu8 *) aPEOR  )

/*  Port F register
 *******************/
#define	 PFDR      ( * (vu8 *) aPFDR  )
#define	 PFDDR     ( * (vu8 *) aPFDDR )
#define	 PFOR      ( * (vu8 *) aPFOR  )

/*  Port G register
 *******************/
#define	 PGDR      ( * (vu8 *) aPGDR  )
#define	 PGDDR     ( * (vu8 *) aPGDDR )
#define	 PGOR      ( * (vu8 *) aPGOR  )

/*  Port H register
 *******************/
#define	 PHDR      ( * (vu8 *) aPHDR  )
#define	 PHDDR     ( * (vu8 *) aPHDDR )
#define	 PHOR      ( * (vu8 *) aPHOR  )

/*  LINSCI register
 *******************/
#define	 SCISR     ( * (vu8 *) aSCISR   )
#define	 SCIDR     ( * (vu8 *) aSCIDR   )
#define	 SCIBRR    ( * (vu8 *) aSCIBRR  )
#define	 SCICR1    ( * (vu8 *) aSCICR1  )
#define	 SCICR2    ( * (vu8 *) aSCICR2  )
#define	 SCICR3    ( * (vu8 *) aSCICR3  )
#define	 SCIERPR   ( * (vu8 *) aSCIERPR )
#define	 SCIETPR   ( * (vu8 *) aSCIETPR )


/*   SPI register
*****************/
#define	 SPIDR     ( * (vu8 *) aSPIDR )
#define	 SPICR     ( * (vu8 *) aSPICR )
#define	 SPISR     ( * (vu8 *) aSPISR )


/*  Interrupt Control Register
 *******************************/
#define  ITSPR0    ( * (vu8 *) aITSPR0 )
#define  ITSPR1    ( * (vu8 *) aITSPR1 )
#define  ITSPR2    ( * (vu8 *) aITSPR2 )
#define  ITSPR3    ( * (vu8 *) aITSPR3 )
#define  EICR      ( * (vu8 *) aEICR   )


/* Flash Register
 *******************/
#define  FLASH     ( * (vu8 *) aFLASH )


/*   Watch dog register
************************/
#define	 WWDGCR	   ( * (vu8 *) aWWDGCR )
#define	 WWDGWR	   ( * (vu8 *) aWWDGWR )


/* Main Clock Control Register
 *******************************/
#define  MCCSR     ( * (vu8 *) aMCCSR  )
#define  MCCBCR	   ( * (vu8 *) aMCCBCR )


/*   ADC register
 *****************/
#define	 ADCCSR	   ( * (vu8 *) aADCCSR   )
#define	 ADCDRMSB  ( * (vu8 *) aADCDRMSB )
#define	 ADCDRLSB  ( * (vu8 *) aADCDRLSB )


/*   Timer A registers
**********************/
#define  TACR2     ( * (vu8 *) aTACR2   )
#define  TACR1     ( * (vu8 *) aTACR1   )
#define  TACSR	   ( * (vu8 *) aTACSR   )
#define  TAIC1HR   ( * (vu8 *) aTAIC1HR )
#define  TAIC1LR   ( * (vu8 *) aTAIC1LR )
#define  TAOC1HR   ( * (vu8 *) aTAOC1HR )
#define  TAOC1LR   ( * (vu8 *) aTAOC1LR )
#define  TACHR     ( * (vu8 *) aTACHR   )
#define  TACLR     ( * (vu8 *) aTACLR   )
#define  TAACHR    ( * (vu8 *) aTAACHR  )
#define  TAACLR    ( * (vu8 *) aTAACLR  )
#define  TAIC2HR   ( * (vu8 *) aTAIC2HR )
#define  TAIC2LR   ( * (vu8 *) aTAIC2LR )
#define  TAOC2HR   ( * (vu8 *) aTAOC2HR )
#define  TAOC2LR   ( * (vu8 *) aTAOC2LR )


/*  System Control
 ********************/
 #define  SICSR    ( * (vu8 *) aSICSR   )


/* Timer B registers
*********************/
#define  TBCR2     ( * (vu8 *) aTBCR2   )
#define  TBCR1     ( * (vu8 *) aTBCR1   )
#define  TBCSR     ( * (vu8 *) aTBCSR   )
#define  TBIC1HR   ( * (vu8 *) aTBIC1HR )
#define  TBIC1LR   ( * (vu8 *) aTBIC1LR )
#define  TBOC1HR   ( * (vu8 *) aTBOC1HR )
#define  TBOC1LR   ( * (vu8 *) aTBOC1LR )
#define  TBCHR     ( * (vu8 *) aTBCHR   )
#define  TBCLR     ( * (vu8 *) aTBCLR   )
#define  TBACHR    ( * (vu8 *) aTBACHR  )
#define  TBACLR    ( * (vu8 *) aTBACLR  )
#define  TBIC2HR   ( * (vu8 *) aTBIC2HR )
#define  TBIC2LR   ( * (vu8 *) aTBIC2LR )
#define  TBOC2HR   ( * (vu8 *) aTBOC2HR )
#define  TBOC2LR   ( * (vu8 *) aTBOC2LR )


/*  Motor control registers (Page 0)
 **************************************/
#define  MTIM      ( * (vu8 *) aMTIM  )
#define  MTIML     ( * (vu8 *) aMTIML )
#define  MZPRV     ( * (vu8 *) aMZPRV )
#define  MZREG     ( * (vu8 *) aMZREG )
#define  MCOMP     ( * (vu8 *) aMCOMP )
#define  MDREG     ( * (vu8 *) aMDREG )
#define  MWGHT     ( * (vu8 *) aMWGHT )
#define  MPRSR     ( * (vu8 *) aMPRSR )
#define  MIMR      ( * (vu8 *) aMIMR  )
#define  MISR      ( * (vu8 *) aMISR  )
#define  MCRA      ( * (vu8 *) aMCRA  )
#define  MCRB      ( * (vu8 *) aMCRB  )
#define  MCRC      ( * (vu8 *) aMCRC  )
#define  MPHST     ( * (vu8 *) aMPHST )
#define  MDFR      ( * (vu8 *) aMDFR  )
#define  MCFR      ( * (vu8 *) aMCFR  )
#define  MREF      ( * (vu8 *) aMREF  )
#define  MPCR      ( * (vu8 *) aMPCR  )
#define  MREP      ( * (vu8 *) aMREP  )
#define  MCPWH     ( * (vu8 *) aMCPWH )
#define  MCPWL     ( * (vu8 *) aMCPWL )
#define  MCPVH     ( * (vu8 *) aMCPVH )
#define  MCPVL     ( * (vu8 *) aMCPVL )
#define  MCPUH     ( * (vu8 *) aMCPUH )
#define  MCPUL     ( * (vu8 *) aMCPUL )
#define  MCP0H     ( * (vu8 *) aMCP0H )
#define  MCP0L     ( * (vu8 *) aMCP0L )

/*  Motor control registers (Page 1)
 **************************************/
#define  MDTG      ( * (vu8 *) aMDTG  )
#define  MPOL      ( * (vu8 *) aMPOL  )
#define  MPWME     ( * (vu8 *) aMPWME )
#define  MCONF     ( * (vu8 *) aMCONF )
#define  MPAR      ( * (vu8 *) aMPAR  )
#define  MZFR      ( * (vu8 *) aMZFR  )
#define  MSCR      ( * (vu8 *) aMSCR  )

/* PWM ART registers
 **********************/
#define  PWMDCR3   ( * (vu8 *) aPWMDCR3  )
#define  PWMDCR2   ( * (vu8 *) aPWMDCR2  )
#define  PWMDCR1   ( * (vu8 *) aPWMDCR1  )
#define  PWMDCR0   ( * (vu8 *) aPWMDCR0  )
#define  PWMCR     ( * (vu8 *) aPWMCR    )
#define  ARTCSR    ( * (vu8 *) aARTCSR   )
#define  ARTCAR    ( * (vu8 *) aARTCAR   )
#define  ARTARR    ( * (vu8 *) aARTARR   )
#define  ARTICCSR  ( * (vu8 *) aARTICCSR )
#define  ARTICR1   ( * (vu8 *) aARTICR1  )
#define  ARTICR2   ( * (vu8 *) aARTICR2  )

/* OPAMP control registers
 ***************************/
#define  OACSR     ( * (vu8 *) aOACSR )


/***************************************************************************************/

/* BIT FUNCTION MACROS FOR USE IN C
***********************************/

#define  BIT(A)                 ( 1 << (A) )
#define  bitToggle(A, B)        ( (A) ^= (B) )
#define  bitSet(A, B)           ( (A) |= (B) )
#define  bitClr(A, B)           ( (A) &= ~(B) )
#define  bitTest_TRUE(A, B)     (  ( (A) & (B) ) )
#define  bitTest_FALSE(A, B)    ( !( (A) & (B) ) )

/***************************************************************************************/

/* watch dog timer register bit fields */
#define	 wdga		BIT(7)

/* Miscellaneous register bit fields */
/* MISCR */
#define	 pei3   	BIT(7)
#define	 pei2  		BIT(6)
#define	 mco    	BIT(5)
#define	 pei1		BIT(4)
#define	 pei0		BIT(3)
#define	 sms  		BIT(0)

/* Timer A and Timer B bit fields */
/* TACR1 and TBCR1 */
#define	 icie   	BIT(7)
#define	 ocie   	BIT(6)
#define	 toie   	BIT(5)
#define	 folv2		BIT(4)
#define	 folv1		BIT(3)
#define	 olvl2		BIT(2)
#define	 iedg1		BIT(1)
#define	 olvl1		BIT(0)

/* TACR2 and TBCR2 */
#define	 oc1e   	BIT(7)
#define	 oc2e   	BIT(6)
#define	 opm    	BIT(5)
#define	 pwm		BIT(4)
#define	 cc1		BIT(3)
#define	 cc0		BIT(2)
#define	 iedg2		BIT(1)
#define	 exedg		BIT(0)

/* TASR and TBSR */
#define	 icf1    	BIT(7)
#define	 ocf1    	BIT(6)
#define	 tof     	BIT(5)
#define	 icf2		BIT(4)
#define	 ocf2		BIT(3)


/* SPI */
/* SPI_CR */
#define	 spie   	BIT(7)
#define	 spe    	BIT(6)
#define	 spr2   	BIT(5)
#define	 mstr 		BIT(4)
#define	 cpol 		BIT(3)
#define	 cpha 		BIT(2)
#define	 spr1		BIT(1)
#define	 spr0		BIT(0)


/* SPI_SR */
#define	 spif 		BIT(7)
#define	 wcol	 	BIT(6)
#define	 modf 		BIT(4)


/* ADC */
/* ADC_CSR */
#define	 coco		BIT(7)
#define	 adon		BIT(5)
#define	 ch2		BIT(2)
#define	 ch1		BIT(1)
#define	 ch0		BIT(0)

//////////////////////////////////////////////////////////////////////////////
//         ST72MC register BITs


// OPAM register
#define  CMPOVR      BIT(7)
#define  OFFCMP      BIT(6)
#define  AVGCMP      BIT(5)
#define  OAON        BIT(4)
#define  HIGHGAIN    BIT(3)

// LIN SCI registers bits

// SCISR register
#define  TDRE     BIT(7)
#define  TC       BIT(6)
#define  RDRF     BIT(5)
#define  IDLE     BIT(4)
#define  OR       BIT(3)
#define  NF       BIT(2)
#define  FE       BIT(1)
#define  PE       BIT(0)

// SCICR1 register
#define  R8       BIT(7)
#define  T8       BIT(6)
#define  SCID     BIT(5)
#define  M        BIT(4)
#define  WAKE     BIT(3)
#define  PCE      BIT(2)
#define  PS       BIT(1)
#define  PIE      BIT(0)

// SCICR2 register
#define  TIE      BIT(7)
#define  TCIE     BIT(6)
#define  RIE      BIT(5)
#define  ILIE     BIT(4)
#define  TE       BIT(3)
#define  RE       BIT(2)
#define  RWU      BIT(1)
#define  SBK      BIT(0)

// SCIBRR register
#define  SCP1     BIT(7)
#define  SCP0     BIT(6)
#define  SCT2     BIT(5)
#define  SCT1     BIT(4)
#define  SCT0     BIT(3)
#define  SCR2     BIT(2)
#define  SCR1     BIT(1)
#define  SCR0     BIT(0)

//////////////////////////////////////////////////////////////////////////////
 //  MTIM, MTIML, MZPRV, MZREG, MCOMP, MDREG, MWGHT
 //  MREP, MCPWH, MCPWL, MCPVH, MCPVL, MCPUH, MCPUL, MCP0H, MCP0L, 
 //  MSPD
 //  are not shown here as they dont have special function bits.  They are 
 //  used as whole bytes instead
 /////////////////////////////////////////////////////////////////////////////
// MPRSR register
#define  SA3      BIT(7)
#define  SA2      BIT(6)
#define  SA1      BIT(5)
#define  SA0      BIT(4)
#define  ST3      BIT(3)
#define  ST2      BIT(2)
#define  ST1      BIT(1)
#define  ST0      BIT(0)

// MIMR register
#define  PUM      BIT(7)
#define  SEM      BIT(6)
#define  RIM      BIT(5)
#define  CLIM     BIT(4)
#define  EIM      BIT(3)
#define  ZIM      BIT(2)
#define  DIM      BIT(1)
#define  CIM      BIT(0)

// MISR register
#define  PUI      BIT(7)
#define  RPI      BIT(6)
#define  RMI      BIT(5)
#define  CLI      BIT(4)
#define  EI       BIT(3)
#define  ZI       BIT(2)
#define  DI       BIT(1)
#define  CI       BIT(0)

// MCRA register
#define  MOE      BIT(7)
#define  CKE      BIT(6)
#define  SR       BIT(5)
#define  DAC      BIT(4)
#define  V0C1     BIT(3)
#define  SWA      BIT(2)
#define  PZ       BIT(1)
#define  DCB      BIT(0)

// MCRB register  
// (BIT7 IS ALWAYS 0)
#define  CPB      BIT(6)
#define  HDM      BIT(5)
#define  SDM      BIT(4)
#define  OCV      BIT(3)
#define  OS2      BIT(2)
#define  OS1      BIT(1)
#define  OS0      BIT(0)

// MCRC register
#define  SEI      BIT(7)
#define  HZ       BIT(6)
#define  SZ       BIT(5)
#define  SC       BIT(4)
#define  SPLG     BIT(3)
#define  VR2      BIT(2)
#define  VR1      BIT(1)
#define  VR0      BIT(0)

// MPHST register
#define  IS1      BIT(7)
#define  IS0      BIT(6)
// OO[5:0] NOT SHOWN

// MDFR register
// DEF[3:0] 
// DWF[7:0]
#define  DEF3     BIT(7)
#define  DEF2     BIT(6)
#define  DEF1     BIT(5)
#define  DEF0     BIT(4)
#define  DWF3     BIT(3)
#define  DWF2     BIT(2)
#define  DWF1     BIT(1)
#define  DWF0     BIT(0)


// MCFR register
#define  RPGS     BIT(7)
#define  RST      BIT(6)
#define  CFF2     BIT(5)
#define  CFF1     BIT(4)
#define  CFF0     BIT(3)
#define  CFW2     BIT(2)
#define  CFW1     BIT(1)
#define  CFW0     BIT(0)

// MREF register
#define  HST      BIT(7)
#define  CL       BIT(6)
#define  CFAV     BIT(5)
#define  HFE1     BIT(4)
#define  HFE0     BIT(3)
#define  HFRQ2    BIT(2)
#define  HFRQ1    BIT(1)
#define  HFRQ0    BIT(0)

// MPCR register
#define  PMS      BIT(7)
#define  OFLU     BIT(6)
#define  OFLV     BIT(5)
#define  OFLW     BIT(4)
#define  CMS      BIT(3)
#define  PCP2     BIT(2)
#define  PCP1     BIT(1)
#define  PCP0     BIT(0)

// MDTG register
#define  PCN      BIT(7)
#define  DTE      BIT(6)
#define  DTG5     BIT(5)
#define  DTG4     BIT(4)
#define  DTG3     BIT(3)
#define  DTG2     BIT(2)
#define  DTG1     BIT(1)
#define  DTG0     BIT(0)
// DTG[5:0] NOT SHOWN

// MPOL register
#define  ZVD      BIT(7)
#define  REO      BIT(6)
#define  OP5      BIT(5)
#define  OP4      BIT(4)
#define  OP3      BIT(3)
#define  OP2      BIT(2)
#define  OP1      BIT(1)
#define  OP0      BIT(0)

// MPWME register
#define  DG       BIT(7)
#define  PWMW     BIT(6)
#define  PWMV     BIT(5)
#define  PWMU     BIT(4)
#define  OT3      BIT(3)
#define  OT2      BIT(2)
#define  OT1      BIT(1)
#define  OT0      BIT(0)

// MCONF register
// DS[3:0] NOT SHOWN
#define  DS3      BIT(7)
#define  DS2      BIT(6)
#define  DS1      BIT(5)
#define  DS0      BIT(4)
#define  SOI      BIT(3)
#define  SOM      BIT(2)
#define  XT16     BIT(1)
#define  XT8      BIT(0)

// MPAR register
#define  TES1     BIT(7)
#define  TES0     BIT(6)
#define  OE5      BIT(5)
#define  OE4      BIT(4)
#define  OE3      BIT(3)
#define  OE2      BIT(2)
#define  OE1      BIT(1)
#define  OE0      BIT(0)

// MZRF register
// ZEF[3:0]
// ZWF[3:0]
#define  ZEF3     BIT(7)
#define  ZEF2     BIT(6)
#define  ZEF1     BIT(5)
#define  ZEF0     BIT(4)
#define  ZWF3     BIT(3)
#define  ZWF2     BIT(2)
#define  ZWF1     BIT(1)
#define  ZWF0     BIT(0)

// MPAR register
// BITS[6:4] ARE ALWAYS ZERO
#define  ZSV      BIT(7)
#define  SCF1     BIT(3)
#define  SCF0     BIT(2)
#define  ECM      BIT(1)
#define  DISS     BIT(0)

/***************************************************************************************/
#endif	/* -- end of ST7REG.H -- */
