
/**************** (c) 2005  STMicroelectronics, Inc. **********************/

/**************************************************************************
     PROGRAM  : SINUSOIDAL CONTROL OF 3 PHASE BLDC MOTOR WITH HALL SENSOR
     COMPILER : COSMIC
     FILENAME : VECTOR.C 
     RELEASE  : 1.0
     DATE     : May 2005
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173
***************************************************************************

MODIFICATIONS :


******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/

/****************************************************************
   VECTOR.C  - contains interrupt vector table for ST7FMC  
****************************************************************/


#include "include.inc"

extern void _stext(void);            /* startup routine */
extern void trap_ISR(void);          /* trap interrupt */
extern void tli_ISR(void);           /* TLI interrupt */
extern void mccRtc_ISR(void);        /* Main Clock Control/ Real time clock interrupt */
extern void ext0_ISR(void);          /* External0 interrupt */
extern void ext1_ISR(void);          /* External1 interrupt */
extern void ext2_ISR(void);          /* External2 interrupt */
extern void mtcU_CL_SO_ISR(void);    /* Motor control - Event U / crnt loop / samp out */
extern void mtcRZ_ISR(void);         /* Motor control - Event U or Event Z */
extern void mtcCD_ISR(void);         /* Motor control - Event C or Event D */
extern void spi_ISR(void);           /* SPI interrupt */
extern void timerA_ISR(void);        /* timerA interrupt */
extern void timerB_ISR(void);        /* timerB interrupt */
extern void linSci_ISR(void);        /* LIN SCI interrupt */
extern void avdAdc_ISR(void);        /* AVD / ADC interrupt */
extern void pwmArt_ISR(void);        /* PWM ART o/f interrupt */


void (* const _vectab[])() = 
{
   pwmArt_ISR,           /* PWM ART o/f interrupt */
   avdAdc_ISR,           /* AVD / ADC interrupt */
   linSci_ISR,           /* LIN SCI interrupt */
   timerB_ISR,           /* timerB interrupt */
   timerA_ISR,           /* timerA interrupt */
   spi_ISR,              /* SPI interrupt */
   mtcCD_ISR,            /* Motor control - Event C or Event D interrupt */
   mtcRZ_ISR,            /* Motor control - Event R or Event Z interrupt */
   mtcU_CL_SO_ISR,       /* Motor control - Event U or crnt loop or samp out */
   ext2_ISR,             /* External2 interrupt */
   ext1_ISR,             /* External1 interrupt */
   ext0_ISR,             /* External0 interrupt */
   mccRtc_ISR,           /* Main Clock Control/ Real time clock interrupt */
   tli_ISR,              /* TLI interrupt */
   trap_ISR,             /* trap interrupt */
   _stext,               /* RESET */
};
