/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Version            : V1.0
* Date               : 12/06/2007
* Description        : Main program body
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "waveplayer.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/
/* Interface functions -------------------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
void Clocks_Config(void);
ErrorCode WAVEPlayBackStatus = Valid_WAVE_File;

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
int main()
{
  #ifdef DEBUG
    debug();
  #endif

  /* Configure the differents system clocks */
  Clocks_Config();

  /* Configure BSPI0 and its associated pin */
  SPI_FLASH_Init();

  /* Drive Flash's ChipSelect line high to be sure that it is deselected */
  SPI_FLASH_ChipSelect(High);
   
  /* Start audio playback */
  WAVEPlayBackStatus = WAVE_PlayBack();
  /* If the .WAV file is valid: WAVEPlayBackStatus = Valid_WAVE_File
     else: WAVEPlayBackStatus specifies the error code */

  while(1)
  {
  }
}

/*******************************************************************************
* Function Name  : Clocks_Config
* Description    : Configures the differents system clocks.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Clocks_Config(void)
{
     /* Enable BSPI0 and BSPI1 clocks on APB1 */
  APB_ClockConfig (APB1, ENABLE, BSPI0_Periph );
 
  /* Enable GPIO0 clock on APB2 */
  APB_ClockConfig (APB2, ENABLE, GPIO0_Periph|GPIO1_Periph );

/* RCCU peripheral configuration ---------------------------------------------*/
  /* RCLK = MCLK = PCLK1= PCLK2 = 32 MHz 
  (using external 4MHz oscillator, DIV2 enabled )*/ 
  
  /* Configure PCLK1 = RCLK / 1 */
  RCCU_PCLK1Config (RCCU_DEFAULT);

  /* Configure PCLK2 = RCLK / 1 */
  RCCU_PCLK2Config (RCCU_DEFAULT);

  /* Configure MCLK clock for the CPU, RCCU_DEFAULT = RCLK /1 */
  RCCU_MCLKConfig (RCCU_DEFAULT);
 
  /* PLL1 = (4MHz / 2) * 16 = 32MHz */
  RCCU_PLL1Config(RCCU_PLL1_Mul_16, RCCU_Div_1) ;

  /* Wait PLL to lock */
  while(RCCU_FlagStatus(RCCU_PLL1_LOCK)==RESET);

  /* Select PLL1_Output as RCLK clock */
  RCCU_RCLKSourceConfig(RCCU_PLL1_Output);
  

}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
