/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : lcd.h
* Author             : MPA Systems Lab
* Date First Issued  : 31/01/2006
* Description        : LCD Management
********************************************************************************
* History:
*  31/01/2006 : V1.0
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
#ifndef __LCD_H
#define __LCD_H

/* Includes ------------------------------------------------------------------*/
#include "71x_type.h"

/* Defines ------------------------------------------------------------------*/
// choose one of the following interfaces to drive the LCD
//#define LCD_I2C
#define LCD_EMI


#ifdef LCD_I2C
/*******************************************************************************
* Function Name  : LCD_Init
* Description    : Init LCD
* Input          : speed.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_Init(u32 speed);
#endif
#ifdef LCD_EMI
void LCD_Init(void);
#endif

/*******************************************************************************
* Function Name  : LCD_AutoScrollOn
* Description    : Enable autoscroll
* Input          : None.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_AutoScrollOn(void);

/*******************************************************************************
* Function Name  : LCD_AutoScrollOff
* Description    : Disable autoscroll
* Input          : None.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_AutoScrollOff(void);

/*******************************************************************************
* Function Name  : LCD_SetCursorPosition
* Description    : set the cursor position to the specified column and row
* Input          : col, row.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_SetCursorPosition(u8 col, u8 row);

/*******************************************************************************
* Function Name  : LCD_SetCursorHome
* Description    : set the cursor to the home position
* Input          : None.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_SetCursorHome(void);

/*******************************************************************************
* Function Name  : LCD_UnderlineCursorOn
* Description    : underline cursor On
* Input          : None.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_UnderlineCursorOn(void);

/*******************************************************************************
* Function Name  : LCD_UnderlineCursorOff
* Description    : underline cursor Off
* Input          : None.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_UnderlineCursorOff(void);

/*******************************************************************************
* Function Name  : LCD_BlockCursorOn
* Description    : Block cursor On
* Input          : None.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_BlockCursorOn(void);

/*******************************************************************************
* Function Name  : LCD_BlockCursorOff
* Description    : underline cursor Off
* Input          : None.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_BlockCursorOff(void);

/*******************************************************************************
* Function Name  : LCD_CursorLeft
* Description    : bring cursor left
* Input          : None.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_CursorLeft(void);

/*******************************************************************************
* Function Name  : LCD_CursorRight
* Description    : bring cursor right
* Input          : None.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_CursorRight(void);

/*******************************************************************************
* Function Name  : LCD_DisplayCharacter
* Description    : display a character in the specified position
* Input          : c,col,row.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_DisplayCharacter (u8 c, u8 col, u8 row);

/*******************************************************************************
* Function Name  : LCD_CreateCharacter
* Description    : 
* Input          : c,pattern.
* Output         : None.
* Return         : None..
*******************************************************************************/
void LCD_CreateCharacter(u8 c, u8 *pattern);

/*******************************************************************************
* Function Name  : LCD_String
* Description    : display a string beginning from a specified position
* Input          : String, col, row.
* Output         : None.
* Return         : None.
*******************************************************************************/
void LCD_String(char *String, u8 col, u8 row);

/*******************************************************************************
* Function Name  : LCD_ClearLine
* Description    : 
* Input          : line.
* Output         : None.
* Return         : None.
*******************************************************************************/
void LCD_ClearLine (u8 line);

/*******************************************************************************
* Function Name  : LCD_ScrollMessage
* Description    : Scroll a message string from right to left
* Input          : line.
* Output         : None.
* Return         : None.
*******************************************************************************/
void LCD_ScrollMessage(char *String, u8 row, u16 time_1ms);

#endif // __LCD_H

/******************* (C) COPYRIGHT 2003 STMicroelectronics *****END OF FILE****/
