/******************** (C) COPYRIGHT 2005 STMicroelectronics ********************
* File Name          : sc.c
* Author             : MCD Application Team
* Date First Issued  : 16/05/2005
* Description        : This file provides all the GPIO software functions
********************************************************************************
* History:
*  
*  
*  
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

#include "sc.h"
#include "uart.h"
#include "gpio.h"


/*******************************************************************************
* Function Name  : SC_Init
* Description    : 
* Input 1        : 
* Input 2        : 
* Input 3        : 
* Output         : None
* Return         : None
*******************************************************************************/
void SC_Init(void)
{
   /*--------------------------------------------------------------------------
		INIT SC PINS
	---------------------------------------------------------------------------*/
   GPIO_Config(GPIO0, (1<<SMARTCARD_DATAIN_OUT)|(1<<SMARTCARD_CLOCK_OUT),GPIO_AF_PP);	// P010 as SMC Data In/Out
																		    			// P012 as SMC Clock
   																				
   GPIO_Config(GPIO0, 1<<SMARTCARD_RESET,GPIO_OUT_PP);			// P00 as SMC Reset
   GPIO_Config(GPIO0, 1<<SMARTCARD_VCC,GPIO_OUT_PP);			// P01 as SMC VCC
   GPIO_Config(GPIO0, 1<<SMARTCARD_DETECT,GPIO_IN_TRI_TTL);	// P02 as SMC Detect

   /*--------------------------------------------------------------------------
		CONFIGURE SC CLOCK
	---------------------------------------------------------------------------*/
   SC_ClockConfig(CLK_DIV2);								
  																				
   /*--------------------------------------------------------------------------
		INIT SC PHERIPERAL
	---------------------------------------------------------------------------*/
   UART_Init(UART1);
   UART_OnOffConfig(UART1, ENABLE);     // Turn UARTX on
   UART_SC_Config(UART1,ENABLE);		// Enable Smart Card Interface
   UART_FifoConfig (UART1, DISABLE);    // Disable FIFOs
   UART_FifoReset(UART1, UART_RxFIFO);  // Reset the UART_RxFIFO
   UART_FifoReset(UART1, UART_TxFIFO);  // Reset the UART_TxFIFO
   UART_LoopBackConfig(UART1, DISABLE); // Disable Loop Back
                                         /* Configure the UARTX as following:
                                             - Baudrate = 9600 Bps
                                             - Odd arity
                                             - 8 data bits + 1 byte Parity
                                             - 1.5 stop bit */
   //UART_Config(UART1, 9600, UART_EVEN_PARITY, UART_1_5_StopBits, UARTM_8D_P);
   UART_Config(UART1, 10752, UART_EVEN_PARITY, UART_1_5_StopBits, UARTM_8D_P);
   //UART_Config(UART1, 5370, UART_EVEN_PARITY, UART_1_5_StopBits, UARTM_8D_P);
   UART_RxConfig(UART1, ENABLE);         // Disable Rx
   UART_GuardTimeConfig(UART1,0x1);

   /*--------------------------------------------------------------------------
		INIT BUS
	---------------------------------------------------------------------------*/
   SC_Reset(LOW);							// reset pin = 1 - logica negata   
   SC_Power(ENABLE);					    // disable power - logica negata
   SC_CLKCON(DISABLE);   
}
/*******************************************************************************
* Function Name  : SC_Reset
* Description    : 
* Input 1        : 
* Input 2        : 
* Input 3        : 
* Output         : None
* Return         : None
*******************************************************************************/
void SC_Reset(u8 reset_value)
{
	GPIO_BitWrite(GPIO0,SMARTCARD_RESET,reset_value);
}




/*******************************************************************************
* Function Name  : SC_Detect
* Description    : 
* Input 1        :  
* Input 2        : 
* Input 3        : 
* Output         : Status: 1-smart card inserted; 0-smart card not inserted
* Return         : None
*******************************************************************************/
u8 SC_Detect(void)
{
  return (((GPIO0->PD)>>SMARTCARD_DETECT)&0x1);
}


/*******************************************************************************
* Function Name  : SC_Detect
* Description    : 
* Input 1        :  
* Input 2        : 
* Input 3        : 
* Output         : Status: 1-smart card inserted; 0-smart card not inserted
* Return         : None
*******************************************************************************/
void SC_Power(FunctionalState NewState)
{
  if (NewState==ENABLE)  GPIO0->PD |= (1<<SMARTCARD_VCC);
  else GPIO0->PD &= ~(1<<SMARTCARD_VCC);
}


/******************* (C) COPYRIGHT 2005 STMicroelectronics *****END OF FILE****/
