/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : main.c
* Author             : MPA Systems Lab
* Date First Issued  : 31/01/2006
* Description        : Example of RFID Management for SR176 tag
********************************************************************************
* History:
*  31/01/2006 : V1.0
*******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
#include "lcd.h"						// LCD	LIB	- LCD DRIVER
#include "device_RFID.h"				// RFID	LIB	- RFID DRIVER


/*------------------------------------
		M A I N 
------------------------------------*/
int main(void)
{
	/*------------------------------------------------------------------
			LOCAL VARIABLES DEFINITION
	--------------------------------------------------------------------*/
  u32	RFID_UID[2];
  u8	TX_frame[20]="RFID DEMO";
  u8	TX_lenght=20;
  u8	TX_offset=0;
  u8	RX_frame[20]="EMPTY-EMPTY-EMPTY";
  u8	RX_lenght=20;
  u8	RX_offset=0;
  u8	RFID_Action=0x7;
  u8	RFID_Polling_timeout=5;
  u8	RFID_status=0;
  
	RFID_UID[0]=0;
	RFID_UID[1]=0;

	/*------------------------------------------------------------------
			DEBUG
	--------------------------------------------------------------------*/
  #ifdef DEBUG
    debug();
  #endif



	/*------------------------------------------------------------------
	  		Configure LCD
	--------------------------------------------------------------------*/
	  #ifdef LCD_I2C
	  LCD_Init(6000);
	  #endif
	  #ifdef LCD_EMI
	  LCD_Init();
	  #endif

	/*------------------------------------------------------------------
	  		RFID Demo on LCD
	--------------------------------------------------------------------*/
    LCD_BlockCursorOff();
  	LCD_ClearLine (1);
	LCD_ClearLine (2);
	LCD_String("RFID Demo", 1, 1);
	LCD_String("STMicroelectronics", 1, 2);


	/*------------------------------------------------------------------
	  		IDLE TASK
	--------------------------------------------------------------------*/
 while(1)
 {

	/*------------------------------------------------------------------
	  		Start RFID Demo
	  ------------------------------------------------------------------
	  		
	  		Input:
	  			- RFID_Action: 3 bit
		  						   bit 0: 1=ENABLE 64UID request, 0=DISABLE 64UID request
		  						   bit 1: 1=ENABLE READ  request, 0=DISABLE READ  request
		  						   bit 2: 1=ENABLE WRITE request, 0=DISABLE WRITE request	  						   	  						   

				- TX_frame:		   TX buffer pointer (write operations)
				- TX_lenght:	   TX buffer lenght (write operations)	
				- TX_offset:	   TX offset for write operations 	

				- RX_frame:		   RX buffer pointer (read operations)
				- RX_lenght:	   RX buffer lenght (read operations)	
				- RX_offset:	   RX offset for read operations 	
	  						   
				- RFID_UID:		   64 bits RFID UID
				- RFID_timeout:	   timeout for RFID polling (number of times STR7 is trying to search tag)

			Output:
				- RX_frame:		   RX buffer pointer (read operations)
				- RFID_UID:		   64 bits RFID UID
																						   
			Return:																		   
				- Status:		   														   
							bit0: 1-No tag selected		0-tag selected				  	   
							bit1: 1-Error on 64UID		0-no error					  	   
							bit2: 1-Error on READ		0-no error					  	   
							bit3: 1-Error on WRITE		0-no error					  	   
							bit4: 1-Error on Completion 0-no error					  	   
							bit5: 1-Error on RF_OFF  	0-no error					  	   
																					  	   
	--------------------------------------------------------------------*/
	 RFID_status=RFID_Handler(RFID_Action, &TX_frame[0], TX_lenght, TX_offset, &RX_frame[0], RX_lenght, RX_offset, &RFID_UID[0], RFID_Polling_timeout);
 


	/*------------------------------------------------------------------
	  		RFID Demo on LCD
	--------------------------------------------------------------------*/
    LCD_BlockCursorOff();
  	LCD_ClearLine (1);
	LCD_ClearLine (2);
	LCD_String("Tag product:", 1, 1);
	LCD_String((char *) &RX_frame[0], 1, 2);
 }


}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/
