   1                     ; C Compiler for ST7 (COSMIC Software)
   2                     ; Generator V4.5c - 01 Mar 2005
 409                     ; 76 void main ( void ) {
 410                     	switch	.text
 411  0000               _main:
 414                     ; 78 	 RC_Calibration ();				//Calibrate the RC for 8MHz
 416  0000 ad21          	call	_RC_Calibration
 418                     ; 83    IO_Init();								//IO Init ... PA,PB...
 420  0002 ad24          	call	_IO_Init
 422                     ; 84 	 PWM_Init();							//PWM Init
 424  0004 ad3c          	call	_PWM_Init
 426                     ; 86 	 SetBit(PBDR, DEV_P);     //Deselect Flash / Set PB.0
 428  0006 1003          	bset	_PBDR,#0
 429                     ; 88 	 SPI_Init();							//SPI Init
 431  0008 ad2f          	call	_SPI_Init
 433                     ; 89 	 LiteTimer_Init();				//Lite Timer Init routine
 435  000a ad51          	call	_LiteTimer_Init
 437                     ; 91     _asm("RIM");					  //Enable all interrupts
 440  000c 9a            RIM
 442                     ; 93 	 GlobalVar_Init();				//Variable initialization 
 444  000d ad53          	call	_GlobalVar_Init
 446                     ; 94 	 LED_Display();					  //Display int file_index value
 448  000f cd00b7        	call	_LED_Display
 450                     ; 98 	 audio_file_address_mgmt[0] = NUMAUDIOADDR;
 452  0012 3f09          	clr	_audio_file_address_mgmt
 453                     ; 99  	 Read_1_Byte();								// Read flash address 0 get number of clips        	
 455  0014 cd00e8        	call	_Read_1_Byte
 457                     ; 100 	 max_file_index = fbuff[0]; 	// Save # of index files, max file is 15
 459  0017 b600          	ld	a,_fbuff
 460  0019 b704          	ld	_max_file_index,a
 461  001b               L522:
 462                     ; 104     Check_Indexbutton();       //check index button 
 464  001b cd0131        	call	_Check_Indexbutton
 466                     ; 105 	Check_Playbutton();          //check play button
 468  001e cd014d        	call	_Check_Playbutton
 471  0021 20f8          	jra	L522
 494                     ; 114 void RC_Calibration ( void ) 
 494                     ; 115 {
 495                     	switch	.text
 496  0023               _RC_Calibration:
 499                     ; 127 	RCCR = RC_Calib; // If Factory not good enough ! Do it manually !
 501  0023 a638          	ld	a,#56
 502  0025 b739          	ld	_RCCR,a
 503                     ; 128 }
 506  0027 81            	ret
 532                     ; 137 void IO_Init ( void ) {
 533                     	switch	.text
 534  0028               _IO_Init:
 537                     ; 138    PADDR = 0x1F;			// Port A DATA DIR REG config as output 
 539  0028 a61f          	ld	a,#31
 540  002a b701          	ld	_PADDR,a
 541                     ; 139    PAOR  = 0x1F;			// OPTION REG config PORT A[0..4] as push-pull 
 543  002c a61f          	ld	a,#31
 544  002e b702          	ld	_PAOR,a
 545                     ; 140    PBDDR = 0x0B;			// Port B DATA DIR REG config as output 
 547  0030 a60b          	ld	a,#11
 548  0032 b704          	ld	_PBDDR,a
 549                     ; 141    PBOR  = 0x1F;			// OPTION REG config PORT B[0..4] as push-pull 
 551  0034 a61f          	ld	a,#31
 552  0036 b705          	ld	_PBOR,a
 553                     ; 142 }/* end of IO_Init */
 556  0038 81            	ret
 580                     ; 149 void SPI_Init ( void ) {
 581                     	switch	.text
 582  0039               _SPI_Init:
 585                     ; 151 SetBit(SPICSR,1);			//configure SPICSR, then SPICR
 587  0039 1233          	bset	_SPICSR,#1
 588                     ; 152 SetBit(SPICSR,0);			//SS pin to 1 : master configuration
 590  003b 1033          	bset	_SPICSR,#0
 591                     ; 154 SPICR = 0x70;				 //SPI= interrupt disable, output enable,
 593  003d a670          	ld	a,#112
 594  003f b732          	ld	_SPICR,a
 595                     ; 158 }/* end of SPI_Init */
 598  0041 81            	ret
 627                     ; 165 void PWM_Init ( void ) {
 628                     	switch	.text
 629  0042               _PWM_Init:
 632                     ; 169 DCR0H = 0x0F;
 634  0042 a60f          	ld	a,#15
 635  0044 b717          	ld	_DCR0H,a
 636                     ; 171 DCR0L = 0x80;
 638  0046 a680          	ld	a,#128
 639  0048 b718          	ld	_DCR0L,a
 640                     ; 181 ATRH = 0x0F;
 642  004a a60f          	ld	a,#15
 643  004c b710          	ld	_ATRH,a
 644                     ; 182 ATRL = 0x00;
 646  004e 3f11          	clr	_ATRL
 647                     ; 194 ATCSR = 0x13;		//Control/status reg  CLK=FCPU enable OVF CMP interrupts Enable
 649  0050 a613          	ld	a,#19
 650  0052 b70d          	ld	_ATCSR,a
 651                     ; 196 pwm_val = 0x80; //Quiet PWM value
 653  0054 a680          	ld	a,#128
 654  0056 b711          	ld	_pwm_val,a
 655                     ; 209 PWMCR = 0x01;		//PWM CONTROL REG / PWM CHANNEL 0 enable	  
 657  0058 a601          	ld	a,#1
 658  005a b712          	ld	_PWMCR,a
 659                     ; 211 }/* end of PWM_Init */
 662  005c 81            	ret
 686                     ; 218 void LiteTimer_Init ( void )
 686                     ; 219 {
 687                     	switch	.text
 688  005d               _LiteTimer_Init:
 691                     ; 220 SetBit (LTCSR,4);	//Set TBIE to 1 
 693  005d 180b          	bset	_LTCSR,#4
 694                     ; 221 LTICR;						//Clear ICF bit by reading LTICR.
 696  005f b60c          	ld	a,_LTICR
 697                     ; 223 }/* end of LiteTimer_Init */
 700  0061 81            	ret
 728                     ; 231 void GlobalVar_Init ( void )
 728                     ; 232 {
 729                     	switch	.text
 730  0062               _GlobalVar_Init:
 733                     ; 233 	max_file_index 	= 0x0F; 	  //storage for # of sound clips
 735  0062 a60f          	ld	a,#15
 736  0064 b704          	ld	_max_file_index,a
 737                     ; 234 	file_index 		  = 0x01;		  //storage for active sound clips
 739  0066 a601          	ld	a,#1
 740  0068 b705          	ld	_file_index,a
 741                     ; 235 	IButton_flag 	  = 0x01;		  //0= key press, 1= key open  (index button)
 743  006a a601          	ld	a,#1
 744  006c b708          	ld	_IButton_flag,a
 745                     ; 236 	PButton_flag 	  = 0x01;		  //0= key press, 1= key open  (play button)
 747  006e a601          	ld	a,#1
 748  0070 b707          	ld	_PButton_flag,a
 749                     ; 237 	tcnt	 		      = 0xFE;		  //Initial timer counter
 751  0072 a6fe          	ld	a,#254
 752  0074 b713          	ld	_tcnt,a
 753                     ; 241   PADR &= ~0x1B;     
 755  0076 b600          	ld	a,_PADR
 756  0078 a4e4          	and	a,#228
 757  007a b700          	ld	_PADR,a
 759  007c               L313:
 760                     ; 243 while (tcnt!=0x00);
 762  007c 3d13          	tnz	_tcnt
 763  007e 26fc          	jrne	L313
 764                     ; 246   PADR |= 0x1B;
 766  0080 b600          	ld	a,_PADR
 767  0082 aa1b          	or	a,#27
 768  0084 b700          	ld	_PADR,a
 769                     ; 249 	tcnt	 					= 0xFE;		//Initial timer counter
 771  0086 a6fe          	ld	a,#254
 772  0088 b713          	ld	_tcnt,a
 773                     ; 250 	ClrBit(PADR,0);
 775  008a 1100          	bres	_PADR,#0
 777  008c               L123:
 778                     ; 251 	while (tcnt!=0x00);			
 780  008c 3d13          	tnz	_tcnt
 781  008e 26fc          	jrne	L123
 782                     ; 252 	SetBit(PADR,0);
 784  0090 1000          	bset	_PADR,#0
 785                     ; 255 	tcnt			= 0xFE;		//Initial timer counter
 787  0092 a6fe          	ld	a,#254
 788  0094 b713          	ld	_tcnt,a
 789                     ; 256 	ClrBit(PADR,1);
 791  0096 1300          	bres	_PADR,#1
 793  0098               L723:
 794                     ; 257 	while (tcnt!=0x00);
 796  0098 3d13          	tnz	_tcnt
 797  009a 26fc          	jrne	L723
 798                     ; 258 	SetBit(PADR,1);
 800  009c 1200          	bset	_PADR,#1
 801                     ; 261 	tcnt	 					= 0xFE;		//Initial timer counter
 803  009e a6fe          	ld	a,#254
 804  00a0 b713          	ld	_tcnt,a
 805                     ; 262 	ClrBit(PADR,3);
 807  00a2 1700          	bres	_PADR,#3
 809  00a4               L533:
 810                     ; 263 	while (tcnt!=0x00);
 812  00a4 3d13          	tnz	_tcnt
 813  00a6 26fc          	jrne	L533
 814                     ; 264 	SetBit(PADR,3);
 816  00a8 1600          	bset	_PADR,#3
 817                     ; 267 	tcnt	 					= 0xFE;		//Initial timer counter
 819  00aa a6fe          	ld	a,#254
 820  00ac b713          	ld	_tcnt,a
 821                     ; 268 	ClrBit(PADR,4);
 823  00ae 1900          	bres	_PADR,#4
 825  00b0               L343:
 826                     ; 269 	while (tcnt!=0x00);
 828  00b0 3d13          	tnz	_tcnt
 829  00b2 26fc          	jrne	L343
 830                     ; 270 	SetBit(PADR,4);
 832  00b4 1800          	bset	_PADR,#4
 833                     ; 272 }						/* end of GlobalVar_Init */
 836  00b6 81            	ret
 860                     ; 279 void LED_Display ( void )
 860                     ; 280 {
 861                     	switch	.text
 862  00b7               _LED_Display:
 865                     ; 282 	if(ValBit(file_index,0) == 0)
 867  00b7 b605          	ld	a,_file_index
 868  00b9 a501          	bcp	a,#1
 869  00bb 2604          	jrne	L753
 870                     ; 284 		SetBit(PADR,0);
 872  00bd 1000          	bset	_PADR,#0
 874  00bf 2002          	jra	L163
 875  00c1               L753:
 876                     ; 288 		ClrBit(PADR,0);
 878  00c1 1100          	bres	_PADR,#0
 879  00c3               L163:
 880                     ; 291 	if(ValBit(file_index,1) == 0)
 882  00c3 b605          	ld	a,_file_index
 883  00c5 a502          	bcp	a,#2
 884  00c7 2604          	jrne	L363
 885                     ; 293 		SetBit(PADR,1);
 887  00c9 1200          	bset	_PADR,#1
 889  00cb 2002          	jra	L563
 890  00cd               L363:
 891                     ; 297 		ClrBit(PADR,1);
 893  00cd 1300          	bres	_PADR,#1
 894  00cf               L563:
 895                     ; 300 	if(ValBit(file_index,2) == 0)
 897  00cf b605          	ld	a,_file_index
 898  00d1 a504          	bcp	a,#4
 899  00d3 2604          	jrne	L763
 900                     ; 302 		SetBit(PADR,3);
 902  00d5 1600          	bset	_PADR,#3
 904  00d7 2002          	jra	L173
 905  00d9               L763:
 906                     ; 306 		ClrBit(PADR,3);
 908  00d9 1700          	bres	_PADR,#3
 909  00db               L173:
 910                     ; 309 	if(ValBit(file_index,3) == 0)
 912  00db b605          	ld	a,_file_index
 913  00dd a508          	bcp	a,#8
 914  00df 2604          	jrne	L373
 915                     ; 311 		SetBit(PADR,4);
 917  00e1 1800          	bset	_PADR,#4
 919  00e3 2002          	jra	L573
 920  00e5               L373:
 921                     ; 315 		ClrBit(PADR,4);
 923  00e5 1900          	bres	_PADR,#4
 924  00e7               L573:
 925                     ; 318 }
 928  00e7 81            	ret
 930                     	bsct
 931  0000               L773_index:
 932  0000 00            	dc.b	0
 969                     ; 325 void Read_1_Byte ( void )
 969                     ; 326 {	
 970                     	switch	.text
 971  00e8               _Read_1_Byte:
 974                     ; 329 	ClrBit(PBDR,DEV_P);					//Tie to low Flash S Pin
 976  00e8 1103          	bres	_PBDR,#0
 977                     ; 330 	SPIDR = 0x03;								//Read Instruction -> send to SPIDR
 979  00ea a603          	ld	a,#3
 980  00ec b731          	ld	_SPIDR,a
 982  00ee               L324:
 983                     ; 331 	while(ValBit(SPICSR,7)==0);	//Wait for SPIF Bit to go up (Data sent)	
 985  00ee b633          	ld	a,_SPICSR
 986  00f0 a580          	bcp	a,#128
 987  00f2 27fa          	jreq	L324
 988                     ; 332 	SPIDR;											//Step to clear the SPIF bit
 990  00f4 b631          	ld	a,_SPIDR
 991                     ; 334 	SPIDR = audio_file_address_mgmt[2]; //location 2 is MS-byte for 24 bit address 
 993  00f6 b60b          	ld	a,_audio_file_address_mgmt+2
 994  00f8 b731          	ld	_SPIDR,a
 996  00fa               L334:
 997                     ; 336    while(ValBit(SPICSR,7)==0);	      //Wait for SPIF Bit to go up (Data sent)	
 999  00fa b633          	ld	a,_SPICSR
1000  00fc a580          	bcp	a,#128
1001  00fe 27fa          	jreq	L334
1002                     ; 338 	SPIDR = audio_file_address_mgmt[1]; //location 2 is MS-byte for 24 bit address 
1004  0100 b60a          	ld	a,_audio_file_address_mgmt+1
1005  0102 b731          	ld	_SPIDR,a
1007  0104               L344:
1008                     ; 339    while(ValBit(SPICSR,7)==0);	      //Wait for SPIF Bit to go up (Data sent)	
1010  0104 b633          	ld	a,_SPICSR
1011  0106 a580          	bcp	a,#128
1012  0108 27fa          	jreq	L344
1013                     ; 341 	SPIDR = audio_file_address_mgmt[0]; //location 2 is MS-byte for 24 bit address 
1015  010a b609          	ld	a,_audio_file_address_mgmt
1016  010c b731          	ld	_SPIDR,a
1018  010e               L354:
1019                     ; 342    while(ValBit(SPICSR,7)==0);	      //Wait for SPIF Bit to go up (Data sent)	
1021  010e b633          	ld	a,_SPICSR
1022  0110 a580          	bcp	a,#128
1023  0112 27fa          	jreq	L354
1024                     ; 347 	for (index = 0; index <3 ; index++)
1026  0114 3f00          	clr	L773_index
1027  0116               L754:
1028                     ; 349 	SPIDR =0xAA;
1030  0116 a6aa          	ld	a,#170
1031  0118 b731          	ld	_SPIDR,a
1033  011a               L174:
1034                     ; 350    while(ValBit(SPICSR,7)==0);		//Wait for SPIF Bit to go up (Data sent)	
1036  011a b633          	ld	a,_SPICSR
1037  011c a580          	bcp	a,#128
1038  011e 27fa          	jreq	L174
1039                     ; 351    fbuff[index] = SPIDR;				  //Store it into long word table
1041  0120 be00          	ld	x,L773_index
1042  0122 b631          	ld	a,_SPIDR
1043  0124 e700          	ld	(_fbuff,x),a
1044                     ; 347 	for (index = 0; index <3 ; index++)
1046  0126 3c00          	inc	L773_index
1049  0128 b600          	ld	a,L773_index
1050  012a a103          	cp	a,#3
1051  012c 25e8          	jrult	L754
1052                     ; 354 	SetBit(PBDR,DEV_P);					   //Deselect Device
1054  012e 1003          	bset	_PBDR,#0
1055                     ; 355 }/* end of Read_1_Byte */
1058  0130 81            	ret
1085                     ; 363 void Check_Indexbutton ( void )
1085                     ; 364 {   
1086                     	switch	.text
1087  0131               _Check_Indexbutton:
1090                     ; 365 	if ((PADR&0x80)==0x80) //Filter PA7 connected to Index Button
1092  0131 b600          	ld	a,_PADR
1093  0133 a480          	and	a,#128
1094  0135 a180          	cp	a,#128
1095  0137 270d          	jreq	L705
1097                     ; 371 		Key_Debounce();
1099  0139 ad44          	call	_Key_Debounce
1101                     ; 372 		if (IButton_flag == 1)   
1103  013b b608          	ld	a,_IButton_flag
1104  013d a101          	cp	a,#1
1105  013f 2605          	jrne	L705
1106                     ; 374 		SetNew_Index();
1108  0141 ad45          	call	_SetNew_Index
1110                     ; 375 		LED_Display();
1112  0143 cd00b7        	call	_LED_Display
1114  0146               L705:
1115                     ; 378   Key_Debounce();
1117  0146 ad37          	call	_Key_Debounce
1119                     ; 379   IButton_flag = 0x01;
1121  0148 a601          	ld	a,#1
1122  014a b708          	ld	_IButton_flag,a
1123                     ; 380 }/* end of Check_Indexbutton */
1126  014c 81            	ret
1128                     	bsct
1129  0001               L315_IndexFileAddressLocation:
1130  0001 00            	dc.b	0
1171                     ; 387 void Check_Playbutton ( void )
1171                     ; 388 {
1172                     	switch	.text
1173  014d               _Check_Playbutton:
1176                     ; 391 	if((PBDR & 0x10) == 0x10) //Filter PB4 connected to Play Button
1178  014d b603          	ld	a,_PBDR
1179  014f a410          	and	a,#16
1180  0151 a110          	cp	a,#16
1181  0153 2603          	jrne	L335
1182                     ; 394 	  _asm("nop");
1185  0155 9d            nop
1188  0156 2022          	jra	L535
1189  0158               L335:
1190                     ; 399 	  	Key_Debounce();
1192  0158 ad25          	call	_Key_Debounce
1194                     ; 400 		if (PButton_flag==1)
1196  015a b607          	ld	a,_PButton_flag
1197  015c a101          	cp	a,#1
1198  015e 261a          	jrne	L535
1199                     ; 403       IndexFileAddressLocation = (file_index<<3); // calculate entry offset into flash location for record  
1201  0160 b605          	ld	a,_file_index
1202  0162 48            	sll	a
1203  0163 48            	sll	a
1204  0164 48            	sll	a
1205  0165 b701          	ld	L315_IndexFileAddressLocation,a
1206                     ; 404 		IndexFileAddressLocation = IndexFileAddressLocation - 4;							 //adjust offset to start of record. 
1208  0167 b601          	ld	a,L315_IndexFileAddressLocation
1209  0169 a004          	sub	a,#4
1210  016b b701          	ld	L315_IndexFileAddressLocation,a
1211                     ; 407 		audio_file_address_mgmt[0] = IndexFileAddressLocation;   //Max value on 8 Bits : below => 15*8-4 = 74 max index ref. But can go up to 20... 
1213  016d b601          	ld	a,L315_IndexFileAddressLocation
1214  016f b709          	ld	_audio_file_address_mgmt,a
1215                     ; 408 		audio_file_address_mgmt[1] = 0x00; 
1217  0171 3f0a          	clr	_audio_file_address_mgmt+1
1218                     ; 409 		audio_file_address_mgmt[2] = 0x00;
1220  0173 3f0b          	clr	_audio_file_address_mgmt+2
1221                     ; 412 		Get_Current_Pointers ();
1223  0175 ad22          	call	_Get_Current_Pointers
1225                     ; 413 		Playbyte ();
1227  0177 cd0214        	call	_Playbyte
1229  017a               L535:
1230                     ; 416 PButton_flag = 0x01;  //Play button is off ; button press =0 1= open
1232  017a a601          	ld	a,#1
1233  017c b707          	ld	_PButton_flag,a
1234                     ; 417 }/* end of Check_Playbutton */
1237  017e 81            	ret
1260                     ; 424 void Key_Debounce ( void )
1260                     ; 425 {
1261                     	switch	.text
1262  017f               _Key_Debounce:
1265                     ; 426 tcnt = DLAYCONSTANT;	
1267  017f a6a0          	ld	a,#160
1268  0181 b713          	ld	_tcnt,a
1269  0183               L155:
1270                     ; 427 while (tcnt!=0); 
1273  0183 3d13          	tnz	_tcnt
1274  0185 26fc          	jrne	L155
1275                     ; 428 }/* end of Key_Debounce */
1278  0187 81            	ret
1303                     ; 435 void SetNew_Index ( void )
1303                     ; 436 {
1304                     	switch	.text
1305  0188               _SetNew_Index:
1308                     ; 438    IButton_flag = 0x00; //button press =0 1= open
1310  0188 3f08          	clr	_IButton_flag
1311                     ; 440    if (file_index == max_file_index) //check file index boundary
1313  018a b605          	ld	a,_file_index
1314  018c b104          	cp	a,_max_file_index
1315  018e 2606          	jrne	L765
1316                     ; 442 		 file_index = 1;
1318  0190 a601          	ld	a,#1
1319  0192 b705          	ld	_file_index,a
1321  0194 2002          	jra	L175
1322  0196               L765:
1323                     ; 445 		 file_index = file_index + 1;
1325  0196 3c05          	inc	_file_index
1326  0198               L175:
1327                     ; 448 }/* end of SetNew_Index */
1330  0198 81            	ret
1332                     	bsct
1333  0002               L375_index_addr:
1334  0002 0000          	dc.w	0
1371                     ; 455 void Get_Current_Pointers ( void )
1371                     ; 456 {
1372                     	switch	.text
1373  0199               _Get_Current_Pointers:
1376                     ; 459 	ClrBit(PBDR,0); //Tie S pin low to select flash  
1378  0199 1103          	bres	_PBDR,#0
1379                     ; 461 	SPIDR = 0x03;
1381  019b a603          	ld	a,#3
1382  019d b731          	ld	_SPIDR,a
1384  019f               L716:
1385                     ; 462 	while(ValBit(SPICSR,7)==0); 					//Wait for SPIF bit to go up (data sent) 
1387  019f b633          	ld	a,_SPICSR
1388  01a1 a580          	bcp	a,#128
1389  01a3 27fa          	jreq	L716
1390                     ; 463 	SPIDR; 											   //Step to clear the SPIF bit
1392  01a5 b631          	ld	a,_SPIDR
1393                     ; 466    for (index_addr=2;index_addr>=0;index_addr--)
1395  01a7 a602          	ld	a,#2
1396  01a9 b703          	ld	L375_index_addr+1,a
1397  01ab 3f02          	clr	L375_index_addr
1398  01ad               L326:
1399                     ; 468 		SPIDR = audio_file_address_mgmt[index_addr]; //location 2 is MS-byte for 24 bit address 
1401  01ad be03          	ld	x,L375_index_addr+1
1402  01af e609          	ld	a,(_audio_file_address_mgmt,x)
1403  01b1 b731          	ld	_SPIDR,a
1405  01b3               L536:
1406                     ; 470 		while(ValBit(SPICSR,7)==0); 						//Wait for SPIF bit to go up (data sent) 
1408  01b3 b633          	ld	a,_SPICSR
1409  01b5 a580          	bcp	a,#128
1410  01b7 27fa          	jreq	L536
1411                     ; 471 		SPIDR; 													//Step to clear the SPIF bit
1413  01b9 b631          	ld	a,_SPIDR
1414                     ; 466    for (index_addr=2;index_addr>=0;index_addr--)
1416  01bb 3d03          	tnz	L375_index_addr+1
1417  01bd 2602          	jrne	L04
1418  01bf 3a02          	dec	L375_index_addr
1419  01c1               L04:
1420  01c1 3a03          	dec	L375_index_addr+1
1423  01c3 3d02          	tnz	L375_index_addr
1424  01c5 2ae6          	jrpl	L326
1425                     ; 477   for (index_addr=4;index_addr<=7;index_addr++)
1427  01c7 a604          	ld	a,#4
1428  01c9 b703          	ld	L375_index_addr+1,a
1429  01cb 3f02          	clr	L375_index_addr
1430  01cd               L146:
1431                     ; 479   SPIDR = 0x55;							//Send dummy value to generate the 8 clock pulses
1433  01cd a655          	ld	a,#85
1434  01cf b731          	ld	_SPIDR,a
1436  01d1               L356:
1437                     ; 480 	while(ValBit(SPICSR,7)==0); 					//Wait for SPIF bit to go up (data sent) 
1439  01d1 b633          	ld	a,_SPICSR
1440  01d3 a580          	bcp	a,#128
1441  01d5 27fa          	jreq	L356
1442                     ; 481   audio_file_address_mgmt[index_addr] = SPIDR; //LSB read first, stored at audio_file_address_mgmt[4]
1444  01d7 be03          	ld	x,L375_index_addr+1
1445  01d9 b631          	ld	a,_SPIDR
1446  01db e709          	ld	(_audio_file_address_mgmt,x),a
1447                     ; 477   for (index_addr=4;index_addr<=7;index_addr++)
1449  01dd 3c03          	inc	L375_index_addr+1
1450  01df 2602          	jrne	L24
1451  01e1 3c02          	inc	L375_index_addr
1452  01e3               L24:
1455  01e3 b603          	ld	a,L375_index_addr+1
1456  01e5 a008          	sub	a,#8
1457  01e7 b602          	ld	a,L375_index_addr
1458  01e9 a200          	sbc	a,#0
1459  01eb 2be0          	jrmi	L146
1460                     ; 486   for (index_addr = 0; index_addr<=3; index_addr++)
1462  01ed 3f02          	clr	L375_index_addr
1463  01ef 3f03          	clr	L375_index_addr+1
1464  01f1               L756:
1465                     ; 488 	SPIDR =0x55; 										 //Send dummy value to generate the 8 clock pulses
1467  01f1 a655          	ld	a,#85
1468  01f3 b731          	ld	_SPIDR,a
1470  01f5               L176:
1471                     ; 489 	while(ValBit(SPICSR,7)==0); 					 //Wait for SPIF bit to go up (data sent) 
1473  01f5 b633          	ld	a,_SPICSR
1474  01f7 a580          	bcp	a,#128
1475  01f9 27fa          	jreq	L176
1476                     ; 490 	audio_file_address_mgmt[index_addr]=SPIDR; //Get value from flash
1478  01fb be03          	ld	x,L375_index_addr+1
1479  01fd b631          	ld	a,_SPIDR
1480  01ff e709          	ld	(_audio_file_address_mgmt,x),a
1481                     ; 486   for (index_addr = 0; index_addr<=3; index_addr++)
1483  0201 3c03          	inc	L375_index_addr+1
1484  0203 2602          	jrne	L44
1485  0205 3c02          	inc	L375_index_addr
1486  0207               L44:
1489  0207 b603          	ld	a,L375_index_addr+1
1490  0209 a004          	sub	a,#4
1491  020b b602          	ld	a,L375_index_addr
1492  020d a200          	sbc	a,#0
1493  020f 2be0          	jrmi	L756
1494                     ; 494 SetBit(PBDR,0); // Deselect device
1496  0211 1003          	bset	_PBDR,#0
1497                     ; 496 }/* end of Get_Current_Pointers */
1500  0213 81            	ret
1502                     	bsct
1503  0004               L576_index_address:
1504  0004 0000          	dc.w	0
1505  0006               L776_end_of_file:
1506  0006 0000          	dc.w	0
1555                     ; 504 void Playbyte ( void )
1555                     ; 505 {
1556                     	switch	.text
1557  0214               _Playbyte:
1560                     ; 508 	ClrBit(PBDR,0);	//Tie to low flash S pin
1562  0214 1103          	bres	_PBDR,#0
1563                     ; 509 	SPIDR = 0x03;
1565  0216 a603          	ld	a,#3
1566  0218 b731          	ld	_SPIDR,a
1568  021a               L727:
1569                     ; 510 	while(ValBit(SPICSR,7)==0); 	//Wait for SPIF bit to go up (data sent) 
1571  021a b633          	ld	a,_SPICSR
1572  021c a580          	bcp	a,#128
1573  021e 27fa          	jreq	L727
1574                     ; 511 	SPIDR;
1576  0220 b631          	ld	a,_SPIDR
1577                     ; 514    for (index_address=2;index_address>=0;index_address--)
1579  0222 a602          	ld	a,#2
1580  0224 b705          	ld	L576_index_address+1,a
1581  0226 3f04          	clr	L576_index_address
1582  0228               L337:
1583                     ; 516 	SPIDR = audio_file_address_mgmt[index_address]; //location 2 is MS-byte for 24 bit address 
1585  0228 be05          	ld	x,L576_index_address+1
1586  022a e609          	ld	a,(_audio_file_address_mgmt,x)
1587  022c b731          	ld	_SPIDR,a
1589  022e               L547:
1590                     ; 518 	while(ValBit(SPICSR,7)==0); 					   //Wait for SPIF bit to go up (data sent) 
1592  022e b633          	ld	a,_SPICSR
1593  0230 a580          	bcp	a,#128
1594  0232 27fa          	jreq	L547
1595                     ; 519 	SPIDR; 													//Step to clear the SPIF bit
1597  0234 b631          	ld	a,_SPIDR
1598                     ; 514    for (index_address=2;index_address>=0;index_address--)
1600  0236 3d05          	tnz	L576_index_address+1
1601  0238 2602          	jrne	L05
1602  023a 3a04          	dec	L576_index_address
1603  023c               L05:
1604  023c 3a05          	dec	L576_index_address+1
1607  023e 3d04          	tnz	L576_index_address
1608  0240 2ae6          	jrpl	L337
1609                     ; 523    end_of_file = 0;
1611  0242 3f06          	clr	L776_end_of_file
1612  0244 3f07          	clr	L776_end_of_file+1
1613  0246               L157:
1614                     ; 527 	SPIDR = 0x55;
1616  0246 a655          	ld	a,#85
1617  0248 b731          	ld	_SPIDR,a
1619  024a               L367:
1620                     ; 528 	while(ValBit(SPICSR,7)==0); 					//Wait for SPIF bit to go up (data sent) 
1622  024a b633          	ld	a,_SPICSR
1623  024c a580          	bcp	a,#128
1624  024e 27fa          	jreq	L367
1625                     ; 530    pwmrdy = 0; 					//init pwmrdy, processed by pwm interrupt service routine
1627  0250 3f12          	clr	_pwmrdy
1628                     ; 531    pwm_val = SPIDR;									//pass audio val to pwm variable  
1630  0252 b631          	ld	a,_SPIDR
1631  0254 b711          	ld	_pwm_val,a
1633  0256               L377:
1634                     ; 535 	while(pwmrdy < 0x4);
1636  0256 b612          	ld	a,_pwmrdy
1637  0258 a104          	cp	a,#4
1638  025a 25fa          	jrult	L377
1639                     ; 546 	pwmrdy = 0; 		//reset pwmrdy
1641  025c 3f12          	clr	_pwmrdy
1642                     ; 548 			if((PADR&0x80)==0x00)
1644  025e b600          	ld	a,_PADR
1645  0260 a580          	bcp	a,#128
1646  0262 260b          	jrne	L777
1647                     ; 550 				Key_Debounce();
1649  0264 cd017f        	call	_Key_Debounce
1651                     ; 551 				end_of_file = 1; //Interruption of file to read
1653  0267 a601          	ld	a,#1
1654  0269 b707          	ld	L776_end_of_file+1,a
1655  026b 3f06          	clr	L776_end_of_file
1657  026d 2036          	jra	L1001
1658  026f               L777:
1659                     ; 557 				if ((audio_file_address_mgmt[5] == 0) && (audio_file_address_mgmt[6] == 0))
1661  026f 3d0e          	tnz	_audio_file_address_mgmt+5
1662  0271 2614          	jrne	L3001
1664  0273 3d0f          	tnz	_audio_file_address_mgmt+6
1665  0275 2610          	jrne	L3001
1666                     ; 559 					if (audio_file_address_mgmt[4]>0)
1668  0277 3d0d          	tnz	_audio_file_address_mgmt+4
1669  0279 2704          	jreq	L5001
1670                     ; 561 						audio_file_address_mgmt[4]--; //Decrement last 8 digits
1672  027b 3a0d          	dec	_audio_file_address_mgmt+4
1674  027d 2026          	jra	L1001
1675  027f               L5001:
1676                     ; 565 						end_of_file = 1; 
1678  027f a601          	ld	a,#1
1679  0281 b707          	ld	L776_end_of_file+1,a
1680  0283 3f06          	clr	L776_end_of_file
1681  0285 201e          	jra	L1001
1682  0287               L3001:
1683                     ; 570 					if (audio_file_address_mgmt[4]==0)
1685  0287 3d0d          	tnz	_audio_file_address_mgmt+4
1686  0289 2618          	jrne	L3101
1687                     ; 574 						if (audio_file_address_mgmt[5] == 0) 
1689  028b 3d0e          	tnz	_audio_file_address_mgmt+5
1690  028d 260c          	jrne	L5101
1691                     ; 578 							audio_file_address_mgmt[6]--;
1693  028f 3a0f          	dec	_audio_file_address_mgmt+6
1694                     ; 579 							audio_file_address_mgmt[5] = 0xFF;
1696  0291 a6ff          	ld	a,#255
1697  0293 b70e          	ld	_audio_file_address_mgmt+5,a
1698                     ; 580 							audio_file_address_mgmt[4] = 0xFF;
1700  0295 a6ff          	ld	a,#255
1701  0297 b70d          	ld	_audio_file_address_mgmt+4,a
1703  0299 200a          	jra	L1001
1704  029b               L5101:
1705                     ; 584 							audio_file_address_mgmt[5]--;
1707  029b 3a0e          	dec	_audio_file_address_mgmt+5
1708                     ; 585 							audio_file_address_mgmt[4] = 0xFF;
1710  029d a6ff          	ld	a,#255
1711  029f b70d          	ld	_audio_file_address_mgmt+4,a
1712  02a1 2002          	jra	L1001
1713  02a3               L3101:
1714                     ; 590 						audio_file_address_mgmt[4]--; //Decrement last 8 digits
1716  02a3 3a0d          	dec	_audio_file_address_mgmt+4
1717  02a5               L1001:
1718                     ; 524    while (!end_of_file)
1720  02a5 b607          	ld	a,L776_end_of_file+1
1721  02a7 ba06          	or	a,L776_end_of_file
1722  02a9 279b          	jreq	L157
1723                     ; 595   SetBit(PBDR,0); //Low to high transition on the S pin for silent value, silent pwm
1725  02ab 1003          	bset	_PBDR,#0
1726                     ; 598 pwm_val = 0x80; //Quiet PWM value
1728  02ad a680          	ld	a,#128
1729  02af b711          	ld	_pwm_val,a
1730                     ; 600 }/* end of Playbyte */
1733  02b1 81            	ret
1840                     	xdef	_main
1841                     	switch	.ubsct
1842  0000               _fbuff:
1843  0000 00000000      	ds.b	4
1844                     	xdef	_fbuff
1845  0004               _max_file_index:
1846  0004 00            	ds.b	1
1847                     	xdef	_max_file_index
1848  0005               _file_index:
1849  0005 00            	ds.b	1
1850                     	xdef	_file_index
1851  0006               _audioval:
1852  0006 00            	ds.b	1
1853                     	xdef	_audioval
1854  0007               _PButton_flag:
1855  0007 00            	ds.b	1
1856                     	xdef	_PButton_flag
1857  0008               _IButton_flag:
1858  0008 00            	ds.b	1
1859                     	xdef	_IButton_flag
1860  0009               _audio_file_address_mgmt:
1861  0009 000000000000  	ds.b	8
1862                     	xdef	_audio_file_address_mgmt
1863                     	xdef	_Playbyte
1864                     	xdef	_Get_Current_Pointers
1865                     	xdef	_SetNew_Index
1866                     	xdef	_Key_Debounce
1867                     	xdef	_Check_Playbutton
1868                     	xdef	_Check_Indexbutton
1869                     	xdef	_Read_1_Byte
1870                     	xdef	_LED_Display
1871                     	xdef	_GlobalVar_Init
1872                     	xdef	_LiteTimer_Init
1873                     	xdef	_PWM_Init
1874                     	xdef	_SPI_Init
1875                     	xdef	_IO_Init
1876                     	xdef	_RC_Calibration
1877  0011               _pwm_val:
1878  0011 00            	ds.b	1
1879                     	xdef	_pwm_val
1880  0012               _pwmrdy:
1881  0012 00            	ds.b	1
1882                     	xdef	_pwmrdy
1883  0013               _tcnt:
1884  0013 00            	ds.b	1
1885                     	xdef	_tcnt
1905                     	end
