/******************** (C) COPYRIGHT 2006 STMicroelectronics **********************
* File Name          : io7flite0.h
* Author             : Application team
* Date First Issued  : 05/30/2006 :  V1.0
* Description        : IO definitions
                       ( POW Code : GP.DEM0008.01 )
**********************************************************************************
* History:
* Date          Version     Description
* 05/30/06   :  V1.0        First issue of firmware
*********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
***********************************************************************************/

/*	Ports Section 		*/

/* START_Calibration Register*/
@tiny volatile unsigned char RCCR0	 @0xFFDE;
@tiny volatile unsigned char RCCR1	 @0xFFDF;

@tiny volatile	char PADR    @0x00;	/* Port A Data Register 	*/
@tiny volatile	char PADDR   @0x01;	/* Port A Data Direction 	*/
@tiny volatile	char PAOR    @0x02;	/* Port A Option register 	*/
@tiny volatile	char PBDR    @0x03;	/* Port B Data Register 	*/
@tiny volatile	char PBDDR   @0x04;	/* Port B Data Direction 	*/
@tiny volatile	char PBOR    @0x05;	/* Port B Option Register 	*/

/*	Lite Timer Section 	*/

@tiny volatile	char LTCSR   @0x0b;	/* Lite Timer Control/Status Register	*/
@tiny volatile	char LTICR   @0x0c;	/* Lite Timer Input Capture Register	*/

/*	Auto-Reload Timer Section 	*/

@tiny volatile	char ATCSR   @0x0d;	/* Timer Control/Status Register	*/
@tiny volatile	char CNTRH   @0x0e;	/* Counter Register High		*/
@tiny volatile	char CNTRL   @0x0f;	/* Counter Register Low			*/
@tiny volatile	char ATRH    @0x10;	/* Auto-Reload Register High		*/
@tiny volatile	char ATRL    @0x11;	/* Auto-Reload Register Low		*/
@tiny volatile	char PWMCR   @0x12;	/* PWM Output Control Register		*/
@tiny volatile	char PWM0CSR @0x13;	/* PWM 0 Control/Status RegisterI2CCR	*/
@tiny volatile	char DCR0H   @0x17;	/* PWM 0 Duty Cycle Register High	*/
@tiny volatile	char DCR0L   @0x18;	/* PWM 0 Duty Cycle Register Low	*/

/*	Flash Section		*/

@tiny volatile	char FCSR    @0x2f;	/* Flash Control/Status Register	*/

/*	EEPROM Section		*/

@tiny volatile	char EECSR   @0x30;	/* Data EEPROM Control/Status Register	*/

/*	SPI Section		*/

@tiny volatile	char SPIDR   @0x31;	/* SPI Data I/O Register		*/
@tiny volatile	char SPICR   @0x32;	/* SPI Control Register			*/
@tiny volatile	char SPICSR  @0x33;	/* SPI Status Register			*/

/*	ADC Section	*/

@tiny volatile	char ADCCSR  @0x34;	/* A/D Control Status Register		*/
@tiny volatile	char ADCDAT  @0x35;	/* A/D Data Register			*/
@tiny volatile	char ADCAMP  @0x36;	/* A/D Amplifier Control Register	*/

/*	Interrupt Control Section	*/

@tiny volatile	char EICR    @0x37;	/* External Interrupt Control Register	*/

/*	Main Clock Control Section	*/

@tiny volatile	char MCCSR   @0x38;	/* Main Clock Control/Status Register	*/

/*	Clock And Reset Section		*/

@tiny volatile	char RCCR    @0x39;	/* RC Oscillator Control Register	*/
@tiny volatile	char SICSR   @0x3a;	/* Syatem Integrity Control/ Status Register */

/******************** (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE*****/

