/******************** (C) COPYRIGHT 2006 STMicroelectronics*******************
* File Name          : bitdef.h
* Author             : Application team
* Date First Issued  : 05/30/2006 :  V1.0
* Description        : Hardware registers bit definitions
                       ( POW Code : GP.DEM0008.01 )
**********************************************************************************
* History:
* Date          Version     Description
* 05/30/06   :  V1.0        First issue of firmware
*********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
**********************************************************************************/
/* General bit definition......................................................*/

#define ZERO		0x00
#define ONE		0x01
#define TWO		0x02
#define THREE		0x03
#define FOUR		0x04
#define FIVE		0x05	
#define SIX		0x06
#define SEVEN		0x07
#define EIGHT		0x08
#define NINE		0x09
#define TEN		0x0A


/* Lite Timer Control/Status Register */

#define	ICIE		0x07			// Interrupt enable
#define	ICF		0x06			// Input capture flag
#define	TB		0x05			// Timebase period selection
#define	TBIE		0x04			// Timebase interrupt enable
#define	TBF		0x03			// Timebase interrupt flag
#define	WDGRF		0x02			// Force reset/reset status flag
#define	WDGE		0x01			// Watchdog enable
#define	WDGD		0x00			// Watchdog reset delay

/* ARTimer Control/Status Register */

#define	OVF		0x02			// Overflow flag
#define	OVFIE		0x01			// Overflow interrupt enable
#define	CMPIE		0x00			// Compare interrupt enable

/* PWM 0 Control/Status Register */

#define	OP0		0x01			// PWM0 output polarity
#define	CMPF		0x00			// PWM0 compare flag

/* PWM Output Control Register */

#define	OE0		0x00			// PWM mode enable

/* Flash Control/Status Register */

#define	OPT		0x02			// Option byte programming mode
#define	LAT		0x01			// Read/write bit
#define	PGM		0x00			// Program bit

/* Data EEPROM Control/Status Register */

#define	E2LAT		0x01			// Latch access transfer
#define	E2PGM		0x00			// Programming control and status

/* SPI Control Register */

#define	SPIE		0x07			// Serial peripheral interrupt enable
#define	SPE		0x06			// Serial peripheral output enable
#define	SPR2		0x05			// Divider enable
#define	MSTR		0x04			// Master
#define	CPOL		0x03			// Clock polarity
#define	CPHA		0x02			// Clock phase

/* SPI Control/Status Register */

#define	SPIF		0x07			// Serial peripheral data transfer flag
#define	WCOL		0x06			// Write collision status
#define	OVR		0x05			// SPI overrun error
#define	MODF		0x04			// Mode fault flag
#define	SOD		0x02			// SPI output disable
#define	SSM		0x01			// _SS mode selection
#define	SSI		0x00			// _SS internal mode

/* A/D Control Status Register */

#define	EOC		0x07			// Conversion complete
#define	ADON		0x05			// A/D converter on

/* A/D Amplifier Control Register */

#define	AMPON		0x00			// Amplifier control bit

/* Main Clock Control/Status Register */

#define	MCO		0x01			// Main clock out enable
#define	SMS		0x00			// Slow mode select

/* Syatem Integrity Control/ Status Register */

#define	LOCKED		0x03			// PLL locked flag
#define	LVDRF		0x02			// LVD reset flag
#define	AVDF		0x01			// Voltage detector flag
#define	AVDIE		0x00			// Voltage detector interrupt enable

/******************** (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE*****/
