/******************** (C) COPYRIGHT 2006 STMicroelectronics
 **********************
 * File Name          : interrupt_routines.c
 * Author             : Application team
 * Date First Issued  : 05/30/2005 :  V1.0
 * Description        : Basic interrupt vector routines
( POW Code : GP.DEM0008.01 )
 **********************************************************************************
 * History:
 * Date          Version     Description
 * 05/30/06   :  V1.0        First issue of firmware
 *********************************************************************************
THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 **********************************************************************************/


#include "define.h"
#include "interface.h"
#include "interrupt_routines.h"

@interrupt void LTIC_ISR(void)
{
  // Lite timer compare interrupt service routine
  tcnt--; // Decrement counter from xx to 00
  LTCSR; //Clear interrupt
  return ;
}

@interrupt void TO_ISR(void)
{
  //Timer overflow interrupt service routine
  pwmrdy = pwmrdy + 1;

  //Better sound quality 32kHz sample duration for 8MHz CPU
  //#ifdef KHZ8BIT8OVS4
  DCR0L = pwm_val; // Set pwm duty cycle
  //#endif

  //Lower sound quality 8kHz sample duration for 8MHz CPU
  //#ifdef KHZ8BIT8OVS1
  //DCR0H = pwm_val_high;	// Set pwm duty cycle
  //DCR0L = pwm_val_low;	// Set pwm duty cycle
  //#endif


  ATCSR; // Clear OVF flag
  return ;
}

@interrupt void TC_ISR(void)
{
  PWM0CSR; //Clear flag		
  return ;
}

/******************** (C) COPYRIGHT 2006 STMicroelectronics *****END OF
    FILE*****/
