/******************** (C) COPYRIGHT 2006 STMicroelectronics
  **********************
 * File Name          : interrupt_vector.c
 * Author             : Application team
 * Date First Issued  : 05/30/2005 :  V1.0
 * Description        : Basic interrupt vector tables
( POW Code : GP.DEM0008.01 )
 **********************************************************************************
 * History:
 * Date          Version     Description
 * 05/30/06   :  V1.0        First issue of firmware
 *********************************************************************************
THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 **********************************************************************************/

#include "define.h"
#include "interrupt_routines.h"


@interrupt void NonHandledInterrupt(void)
{
  /* in order to detect unexpected events during development,
  it is recommended to set a breakpoint on the following instruction
   */
  return ;
}


/* Interrupt vector table, to be linked at the address
0xFFE0 (in ROM) */
void(*const _vectab[])() =
{
  NonHandledInterrupt,  /* 0xFFE0 */
  NonHandledInterrupt,  /* 0xFFE2 */
  LTIC_ISR,  /* 0xFFE4 */
  NonHandledInterrupt,  /* 0xFFE6 */
  TO_ISR,  /* 0xFFE8 */
  TC_ISR,  /* 0xFFEA */
  NonHandledInterrupt,  /* 0xFFEC */
  NonHandledInterrupt,  /* 0xFFEE */
  NonHandledInterrupt,  /* 0xFFF0 */
  NonHandledInterrupt,  /* 0xFFF2 */
  NonHandledInterrupt,  /* 0xFFF4 */
  NonHandledInterrupt,  /* 0xFFF6 */
  NonHandledInterrupt,  /* 0xFFF8 */
  NonHandledInterrupt,  /* 0xFFFA */
  NonHandledInterrupt,  /* Trap vector */
  _stext,  /* Reset Vector */
};
