/******************** (C) COPYRIGHT 2006 STMicroelectronics **********************
* File Name          : main.c
* Author             : Application team
* Date First Issued  : 05/30/2005 :  V1.0
* Description        : main code
                       ( POW Code : GP.DEM0008.01 )
**********************************************************************************
* History:
* Date          Version     Description
* 05/30/06   :  V1.0        First issue of firmware
*********************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
 CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
 AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
 OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
 OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
 CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
********************************************************************************/

#include "define.h"
#include "Interface.h"

/* START_PARAMETER*/

#define 	RC_Calib			0x38		//Manually adjusted value
#define  	DEV_P					0     // Select flash memory pin S, sel_n on PB0
#define		RAMBUFFER			4		  // 4 bytes buffer size  
#define		STRA_LENGTH		8			// 8 bytes to store start address and length of audio 
#define		NUMAUDIOADDR	0			// Number of audio files address start      
//#define	DLAYCONSTANT	0x7f			// ms of dbounce delay
#define		DLAYCONSTANT	0xA0			// ms of dbounce delay
/* END_PARAMETER*/

/*START_PROTOTYPE*/
void RC_Calibration        ( void ); 	   //RC Calibration routine 
void IO_Init 			         ( void ); 	   //Port initialization
void SPI_Init 			       ( void ); 	   //Serial Peripheral Interface initialization
void PWM_Init 			       ( void );	   //Pulse Width Modulation initialization
void LiteTimer_Init        ( void ); 	   //LiteTimer Init routine
void GlobalVar_Init        ( void );	   //Global Variable Initialization 
void LED_Display           ( void );     //This routine sets index LEDs
void Read_1_Byte 		       ( void );	   //Read 1 Byte of External Flash Memory  
void Check_Indexbutton     ( void );     //Check if Index button pressed
void Check_Playbutton      ( void );     //Check if play button pressed
void Key_Debounce 	       ( void );  	 //Push-button Debouncing
void SetNew_Index 	       ( void );  	 //New Index Button
void Get_Current_Pointers  ( void );     //Get Current File to Play pointer address
void Playbyte 				     ( void );	   //Play Byte read from memory			

/*END_PROTOTYPE*/

/*START_STRUCT*/
unsigned char audio_file_address_mgmt[8];
/* END_STRUCT*/

/* START_GLOBAL Variables Declarations */

unsigned char IButton_flag;		// 0= key press, 1= key open  (index button)
unsigned char PButton_flag;		// 0= key press, 1= key open (play button)
unsigned char tcnt;						// timer counter variable 
unsigned char pwm_val;				// PWM VALUE  
unsigned char audioval;				// temp storage for audio byte
volatile char pwmrdy;					// process by pwm interrupt service routine
unsigned char file_index;			// storage for active sound clips
unsigned char max_file_index;	// storage for # of sound clips
unsigned char fbuff[4];			  // 4 bytes reserved in RAM data from flash


/* END_GLOBAL Variables Declarations */

/* --------------------------------------------------------------------------- */
/* Function:       main() */
/* Purpose:        main routine */
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void main ( void ) {
	 //!Not in Debug Mode!//
	 RC_Calibration ();				//Calibrate the RC for 8MHz
	 
    //MCCSR |= 0x02;        // MCO Enable, for Frequency Check
    //!Not in Debug Mode!//
			
   IO_Init();								//IO Init ... PA,PB...
	 PWM_Init();							//PWM Init
	 
	 SetBit(PBDR, DEV_P);     //Deselect Flash / Set PB.0
	 
	 SPI_Init();							//SPI Init
	 LiteTimer_Init();				//Lite Timer Init routine

    _asm("RIM");					  //Enable all interrupts

	 GlobalVar_Init();				//Variable initialization 
	 LED_Display();					  //Display int file_index value
	 
	 // Get address for the number of audio files from flash memory
 	 // and store it in the fadr structure
	 audio_file_address_mgmt[0] = NUMAUDIOADDR;
 	 Read_1_Byte();								// Read flash address 0 get number of clips        	
	 max_file_index = fbuff[0]; 	// Save # of index files, max file is 15
	
    while ( 1 )
	 {
    Check_Indexbutton();       //check index button 
	Check_Playbutton();          //check play button
	 }
}/* end of main */

/* --------------------------------------------------------------------------- */
/* Function:       RC_Calibration() */
/* Purpose:        RC_Calibration routine */
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void RC_Calibration ( void ) 
{
	
//Local variables
  //static unsigned char RCCR_Adjust=0;
 /*if ((RCCR1 + 0x0F) > 0xFF)
  {
  RCCR = 0xFF;
  }else
  {	
  RCCR = RCCR1 + 0x0F;
  }*/
  
	RCCR = RC_Calib; // If Factory not good enough ! Do it manually !
}
//end of RC_Calibration */


/* --------------------------------------------------------------------------- */
/* Function:       IO_Init() */
/* Purpose:        IO_Init routine */
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void IO_Init ( void ) {
   PADDR = 0x1F;			// Port A DATA DIR REG config as output 
   PAOR  = 0x1F;			// OPTION REG config PORT A[0..4] as push-pull 
   PBDDR = 0x0B;			// Port B DATA DIR REG config as output 
   PBOR  = 0x1F;			// OPTION REG config PORT B[0..4] as push-pull 
}/* end of IO_Init */

/* --------------------------------------------------------------------------- */
/* Function:       SPI_Init() */
/* Purpose:        Serial Peripheral Interface_Init routine */
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void SPI_Init ( void ) {
	
SetBit(SPICSR,1);			//configure SPICSR, then SPICR
SetBit(SPICSR,0);			//SS pin to 1 : master configuration

SPICR = 0x70;				 //SPI= interrupt disable, output enable,
								     //ST7=Master
								     //Polarity=0 and Phase=0,
								     //clock = Core clock/8 load 7c for clk/4
}/* end of SPI_Init */

/* --------------------------------------------------------------------------- */
/* Function:       PWM_Init() */
/* Purpose:        Pulse Width Modulation_Init routine using 12Bit ATR Timer*/
/* Date:            */
/* --------------------------------------------------------------------------- */
void PWM_Init ( void ) {

// Set 12 BIT DCR REGISTER "DUTY CYCLE REGISTER" 
// for 8 bit PCM we use only the upper 8 bits, the low nibble is set to zero
DCR0H = 0x0F;

DCR0L = 0x80;

//DCR0L = 0x00;

// Set 12-BIT AUTO RELOAD REGISTER TO 0F00H 
// NOTE: COUNTER COUNTS FROM ATR TO FFF
// THIS SETS THE PWM RESOLUTION. RESOLUTION = 1/(4096 -ATR) or RESOLUTION = 1/(FFF-ATR)

// FOR 8 BIT RESOLUTION, 2^8th ~ 256, ATR REG IS SET TO F00H

ATRH = 0x0F;
ATRL = 0x00;

//SET ATCSR "TIMER CONTROL STATUS REGISTER"
// ATCSR
// BIT-7 RESERVED
// BIT-6 ICF INPUT CAPTURE FLAG
// BIT-5 ICIE INPUT CAPTURE INTERRUPT ENABLE
// BIT-4:3 CK 1:0 COUNTER CLOCK SEL 00=OFF 01=1mSTB@8MHZ 10=FCPU 11=32MHZ
// BIT-2 OVF OVERFLOW FLAG
// BIT-1 OVFIE OVERFLOW INTERRUPT ENABLE
// BIT-0 CMPIE COMPARE INTERRUPT ENABLE

ATCSR = 0x13;		//Control/status reg  CLK=FCPU enable OVF CMP interrupts Enable

pwm_val = 0x80; //Quiet PWM value

// PWMCR PWM OUTPUT CONTROL REGISTER
// BIT-7 0
// BIT-6 OE3 OUTPUT ENABLE 3
// BIT-5 0
// BIT-4 OE2 OUTPUT ENABLE 2
// BIT-3 0 
// BIT-2 OE1 OUTPUT ENABLE 1
// BIT-1 0
// BIT-0 OE0 OUTPUT ENABLE 0

//enable pwm channel 0
PWMCR = 0x01;		//PWM CONTROL REG / PWM CHANNEL 0 enable	  

}/* end of PWM_Init */

/* --------------------------------------------------------------------------- */
/* Function:       LiteTimer_Init() */
/* Purpose:        LiteTimer Init routine*/
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void LiteTimer_Init ( void )
{
SetBit (LTCSR,4);	//Set TBIE to 1 
LTICR;						//Clear ICF bit by reading LTICR.

}/* end of LiteTimer_Init */


/* --------------------------------------------------------------------------- */
/* Function:       GlobalVar_Init() */
/* Purpose:        GlobalVar_Init Init routine*/
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void GlobalVar_Init ( void )
{
	max_file_index 	= 0x0F; 	  //storage for # of sound clips
	file_index 		  = 0x01;		  //storage for active sound clips
	IButton_flag 	  = 0x01;		  //0= key press, 1= key open  (index button)
	PButton_flag 	  = 0x01;		  //0= key press, 1= key open  (play button)
	tcnt	 		      = 0xFE;		  //Initial timer counter

	//LED Diag
	//All LED's ON !
  PADR &= ~0x1B;     

while (tcnt!=0x00);

  //All LED's OFF !
  PADR |= 0x1B;
	
	//LED - 1 Test
	tcnt	 					= 0xFE;		//Initial timer counter
	ClrBit(PADR,0);
	while (tcnt!=0x00);			
	SetBit(PADR,0);

	//LED - 2 Test
	tcnt			= 0xFE;		//Initial timer counter
	ClrBit(PADR,1);
	while (tcnt!=0x00);
	SetBit(PADR,1);
	
	//LED - 3 Test
	tcnt	 					= 0xFE;		//Initial timer counter
	ClrBit(PADR,3);
	while (tcnt!=0x00);
	SetBit(PADR,3);
	
	//LED - 4 Test
	tcnt	 					= 0xFE;		//Initial timer counter
	ClrBit(PADR,4);
	while (tcnt!=0x00);
	SetBit(PADR,4);
	
}						/* end of GlobalVar_Init */

/* --------------------------------------------------------------------------- */
/* Function:       LED_Disp() */
/* Purpose:        LED_Disp routine*/
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void LED_Display ( void )
{

	if(ValBit(file_index,0) == 0)
	{
		SetBit(PADR,0);
	}
	else
	{
		ClrBit(PADR,0);
	}
	
	if(ValBit(file_index,1) == 0)
	{
		SetBit(PADR,1);
	}
	else
	{
		ClrBit(PADR,1);
	}
	
	if(ValBit(file_index,2) == 0)
	{
		SetBit(PADR,3);
	}
	else
	{
		ClrBit(PADR,3);
	}
	
	if(ValBit(file_index,3) == 0)
	{
		SetBit(PADR,4);
	}
	else
	{
		ClrBit(PADR,4);
	}
	
}
/* --------------------------------------------------------------------------- */
/* Function:       Read_1_Byte() */
/* Purpose:        Read_1_Byte routine*/
/* Date:           02/14/2006 */
/* ---------------------------------------------------------------------------*/ 

void Read_1_Byte ( void )
{	
   static unsigned char index = 0;

	ClrBit(PBDR,DEV_P);					//Tie to low Flash S Pin
	SPIDR = 0x03;								//Read Instruction -> send to SPIDR
	while(ValBit(SPICSR,7)==0);	//Wait for SPIF Bit to go up (Data sent)	
	SPIDR;											//Step to clear the SPIF bit

	SPIDR = audio_file_address_mgmt[2]; //location 2 is MS-byte for 24 bit address 
																			//get address byte from fadr structure
   while(ValBit(SPICSR,7)==0);	      //Wait for SPIF Bit to go up (Data sent)	
	
	SPIDR = audio_file_address_mgmt[1]; //location 2 is MS-byte for 24 bit address 
   while(ValBit(SPICSR,7)==0);	      //Wait for SPIF Bit to go up (Data sent)	
	
	SPIDR = audio_file_address_mgmt[0]; //location 2 is MS-byte for 24 bit address 
   while(ValBit(SPICSR,7)==0);	      //Wait for SPIF Bit to go up (Data sent)	
	
	//Generate 8 clock pulses 
   //Send dummy value to generate the clock , Read 4 Bytes of External Flash
	//index = 0;
	for (index = 0; index <3 ; index++)
	{
	SPIDR =0xAA;
   while(ValBit(SPICSR,7)==0);		//Wait for SPIF Bit to go up (Data sent)	
   fbuff[index] = SPIDR;				  //Store it into long word table
   }

	SetBit(PBDR,DEV_P);					   //Deselect Device
}/* end of Read_1_Byte */

/* --------------------------------------------------------------------------- */
/* Function:       Check_Indexbutton() */
/* Purpose:        Check_Indexbutton routine*/
/* Date:           02/14/2006 */
/* Parameter : 		 IButton_flag =  0= key press, 1= key open*/
/* --------------------------------------------------------------------------- */
void Check_Indexbutton ( void )
{   
	if ((PADR&0x80)==0x80) //Filter PA7 connected to Index Button
	{
		//Button not pressed
	}
	else
	{ //Button pressed
		Key_Debounce();
		if (IButton_flag == 1)   
		{
		SetNew_Index();
		LED_Display();
    }
  }	
  Key_Debounce();
  IButton_flag = 0x01;
}/* end of Check_Indexbutton */

/* --------------------------------------------------------------------------- */
/* Function:       Check_Playbutton() */
/* Purpose:        Check_Playbutton routine*/
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void Check_Playbutton ( void )
{
static unsigned char IndexFileAddressLocation=0; //Should be as Wide as 32 Bits FF FF FF FF but for less than 15 songs, one byte is enough.
	
	if((PBDR & 0x10) == 0x10) //Filter PB4 connected to Play Button
	{
	  //Button not pressed
	  _asm("nop");
	}
	else
   {
      //Button pressed
	  	Key_Debounce();
		if (PButton_flag==1)
		{
		//New press on PButton
      IndexFileAddressLocation = (file_index<<3); // calculate entry offset into flash location for record  
		IndexFileAddressLocation = IndexFileAddressLocation - 4;							 //adjust offset to start of record. 
		// IndexFileAddressLocation = Computed flash memory address (0) 
		// STORE START ADDRESS 1st BYTE 
		audio_file_address_mgmt[0] = IndexFileAddressLocation;   //Max value on 8 Bits : below => 15*8-4 = 74 max index ref. But can go up to 20... 
		audio_file_address_mgmt[1] = 0x00; 
		audio_file_address_mgmt[2] = 0x00;
		//audio_file_address_mgmt[1] = (IndexFileAddressLocation>>8); 
		//audio_file_address_mgmt[2] = (IndexFileAddressLocation>>16);
		Get_Current_Pointers ();
		Playbyte ();
   	} 
	}
PButton_flag = 0x01;  //Play button is off ; button press =0 1= open
}/* end of Check_Playbutton */

/* --------------------------------------------------------------------------- */
/* Function:       Key_Debounce() */
/* Purpose:        Key_Debounce routine*/
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void Key_Debounce ( void )
{
tcnt = DLAYCONSTANT;	
while (tcnt!=0); 
}/* end of Key_Debounce */

/* --------------------------------------------------------------------------- */
/* Function:       SetNew_Index() */
/* Purpose:        SetNew_Index routine*/
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void SetNew_Index ( void )
{

   IButton_flag = 0x00; //button press =0 1= open

   if (file_index == max_file_index) //check file index boundary
	 {
		 file_index = 1;
	 }else
	 {
		 file_index = file_index + 1;
	 }

}/* end of SetNew_Index */

/* --------------------------------------------------------------------------- */
/* Function:       Get_Current_Pointers() */
/* Purpose:        Get_Current_Pointers routine*/
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void Get_Current_Pointers ( void )
{
static int index_addr = 0 ;
	
	ClrBit(PBDR,0); //Tie S pin low to select flash  
	//Send read instruction 
	SPIDR = 0x03;
	while(ValBit(SPICSR,7)==0); 					//Wait for SPIF bit to go up (data sent) 
	SPIDR; 											   //Step to clear the SPIF bit

   //Send 24 bit address to spi
   for (index_addr=2;index_addr>=0;index_addr--)
	{
		SPIDR = audio_file_address_mgmt[index_addr]; //location 2 is MS-byte for 24 bit address 
																//get address byte from fadr structure
		while(ValBit(SPICSR,7)==0); 						//Wait for SPIF bit to go up (data sent) 
		SPIDR; 													//Step to clear the SPIF bit
  }

  //Phase one : Read length
	//Read data from spi 

  for (index_addr=4;index_addr<=7;index_addr++)
  {
  SPIDR = 0x55;							//Send dummy value to generate the 8 clock pulses
	while(ValBit(SPICSR,7)==0); 					//Wait for SPIF bit to go up (data sent) 
  audio_file_address_mgmt[index_addr] = SPIDR; //LSB read first, stored at audio_file_address_mgmt[4]
  } 
	
	//Phase two : Read Start Address
	//Read start address
  for (index_addr = 0; index_addr<=3; index_addr++)
	{
	SPIDR =0x55; 										 //Send dummy value to generate the 8 clock pulses
	while(ValBit(SPICSR,7)==0); 					 //Wait for SPIF bit to go up (data sent) 
	audio_file_address_mgmt[index_addr]=SPIDR; //Get value from flash
															 //Store it into table
   }

SetBit(PBDR,0); // Deselect device

}/* end of Get_Current_Pointers */

/* --------------------------------------------------------------------------- */
/* Function:       Playbyte() */
/* Purpose:        Playbyte routine*/
/* This routine passes bytes to the PWM routine to be played		*/
/* Date:           02/14/2006 */
/* --------------------------------------------------------------------------- */
void Playbyte ( void )
{
	static int index_address=0, end_of_file=0;
	
	ClrBit(PBDR,0);	//Tie to low flash S pin
	SPIDR = 0x03;
	while(ValBit(SPICSR,7)==0); 	//Wait for SPIF bit to go up (data sent) 
	SPIDR;

   //Send 24 bit address to spi
   for (index_address=2;index_address>=0;index_address--)
	{
	SPIDR = audio_file_address_mgmt[index_address]; //location 2 is MS-byte for 24 bit address 
															   //get address byte from fadr structure
	while(ValBit(SPICSR,7)==0); 					   //Wait for SPIF bit to go up (data sent) 
	SPIDR; 													//Step to clear the SPIF bit
   }

   //Read again /Get value from flash    
   end_of_file = 0;
   while (!end_of_file)
   {
	
	SPIDR = 0x55;
	while(ValBit(SPICSR,7)==0); 					//Wait for SPIF bit to go up (data sent) 
   
   pwmrdy = 0; 					//init pwmrdy, processed by pwm interrupt service routine
   pwm_val = SPIDR;									//pass audio val to pwm variable  
	
	//Wait for PWM value sent 4 times, pwmrdy decremented in interrupt
	#ifdef OVERSAMPLE4
	while(pwmrdy < 0x4);
	#endif
	#ifdef OVERSAMPLE2
	while(pwmrdy < 0x2);
	#endif
	#ifdef OVERSAMPLE1
	while(pwmrdy < 0x1);
	#endif
//	{
//	_asm("nop");
//	}
	pwmrdy = 0; 		//reset pwmrdy
   //Check for IndexButton_Activity
			if((PADR&0x80)==0x00)
			{//Button pressed, end of audio clip reached
				Key_Debounce();
				end_of_file = 1; //Interruption of file to read
			}
			else
			{
			//Button not pressed / No activity
			//Boundary checking for sound file length starts here
				if ((audio_file_address_mgmt[5] == 0) && (audio_file_address_mgmt[6] == 0))
				{
					if (audio_file_address_mgmt[4]>0)
				   {
						audio_file_address_mgmt[4]--; //Decrement last 8 digits
					 }
					else
				   {//means we reached end of file...
						end_of_file = 1; 
					}
				}
				else
			  {
					if (audio_file_address_mgmt[4]==0)
				  {
						//Borrow to upper digits :
						//Check on audio_file_address_mgmt[5]
						if (audio_file_address_mgmt[5] == 0) 
						{
						//Borrow to upper digits 6 not null or screened performed before
						//Check on audio_file_address_mgmt[6]
							audio_file_address_mgmt[6]--;
							audio_file_address_mgmt[5] = 0xFF;
							audio_file_address_mgmt[4] = 0xFF;
					  }
						else
					  {
							audio_file_address_mgmt[5]--;
							audio_file_address_mgmt[4] = 0xFF;
						}
					}
					else
				  {
						audio_file_address_mgmt[4]--; //Decrement last 8 digits
					}					
				}
			}
	}
  SetBit(PBDR,0); //Low to high transition on the S pin for silent value, silent pwm


pwm_val = 0x80; //Quiet PWM value

}/* end of Playbyte */

/******************** (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE*****/



