/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : common.h
* Author             : MCD Application Team
* Version            : V2.0.0
* Date               : 08/08/2008
* Description        : This file provides the prototypes of the routines in common.c
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __COMMON_H
#define __COMMON_H

#define Flash_512KB
//#define Flash_256KB
//#define Flash_1MB
//#define Flash_2MB

/* Includes ------------------------------------------------------------------*/
#include "stdio.h"
#include "string.h"
#include "91x_lib.h"
#include "execute_application.h"
#ifdef Flash_512KB_256KB
#define ApplicationAddress 0x80000
#endif


#ifdef Flash_2MB_1MB
#define ApplicationAddress 0x200000
#endif

#include "ymodem.h"

/* Exported types ------------------------------------------------------------*/

/* Exported constants --------------------------------------------------------*/
/* Constants used by Serial Command Line Mode */
#define CMD_STRING_SIZE     128

/* Exported macro ------------------------------------------------------------*/
/* Common routines */
#define IS_AF(c)	((c >= 'A') && (c <= 'F'))
#define IS_af(c)	((c >= 'a') && (c <= 'f'))
#define IS_09(c)	((c >= '0') && (c <= '9'))
#define ISVALIDHEX(c)	IS_AF(c) || IS_af(c) || IS_09(c)
#define ISVALIDDEC(c)	IS_09(c)
#define CONVERTDEC(c)	(c - '0')

#define CONVERTHEX_alpha(c)	(IS_AF(c) ? (c - 'A'+10) : (c - 'a'+10))
#define CONVERTHEX(c)   (IS_09(c) ? (c - '0') : CONVERTHEX_alpha(c))

/* Exported functions ------------------------------------------------------- */
void Int2Str(u8* str,s32 intnum);
u32 Str2Int(u8 *inputstr,s32 *intnum);
u32 GetIntegerInput(s32 * num);
u32 SerialKeyPressed(u8 *key);
u8 GetKey(void);
void SerialPutChar(u8 c);
void SerialPutString(u8 *s);
void GetInputString(u8 * buffP);
u32 FLASH_SectorMask(vu32 Size);
void Main_Menu(void);
void SerialDownload(void);
#endif  /* _COMMON_H */

/*******************(C)COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
