/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : execute_application.h
* Author             : MCD Application Team
* Version            : V2.0.0
* Date               : 08/08/2008
* Description        : This file provides routines's prototypes.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __IAP_H
#define __IAP_H
/* Includes ------------------------------------------------------------------*/
#include "91x_lib.h"
#include "execute_application.h"
/* Exported types ------------------------------------------------------------*/

#ifdef Flash_512KB_256KB
#define Application_Address 0x80000
#endif


#ifdef Flash_2MB_1MB
#define Application_Address 0x200000
#endif

#define Version_Number       0x10         /* The version number         */

#define GC_Command           0x00           /* Get command                */
#define GID_Command          0x02            /* Get device ID       */
#define RM_Command           0x11             /* Read memory command        */
#define GO_Command           0x21             /* Go command                 */
#define WM_Command           0x31             /* Write memory command       */
#define ER_Command           0x43             /* One sector Erase command   */
#define WUP_Command          0x71             /* Global Write unprotect command   */




#define ACK_BYTE               0x79 	       /* Acknowlede Byte ID        */
#define NACK_BYTE              0x1F 	       /* Not Acknowlede Byte ID    */

#define Area_Error             0x1          /* Error Address Area */
#define Flash_Area             0x2          /* Flash Address      */

#define RAM_Buffer             0x4003800   /* RAM buffer address */

/* Private macro -------------------------------------------------------------*/
#define UART_WaitForByte()     while ( UART_GetFlagStatus(UART0, UART_FLAG_RxFIFOEmpty) != RESET)
#define UART_WaitForSend()     while (UART_GetFlagStatus(UART0, UART_FLAG_TxFIFOFull) != RESET)
/* Exported functions ------------------------------------------------------- */
void Select_Command(void);

#endif  /* _IAP_H */


/*******************(C)COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
