/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 01/16/2007
* Description        : Main program body
********************************************************************************
* History:
* 01/16/2007 : V1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "75x_lib.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
vu32  EnterSTOPMode = 0;  /* This variable is modified in RTC_IRQHandler each 4 second */
ErrorStatus OSC4MStartUpStatus01;
vu32 i;

/* Private function prototypes -----------------------------------------------*/
void MRCC_Configuration(void);
void GPIO_Configuration_STR750_EVAL(void);
void GPIO_Configuration_Uniboard(void);
void RTC_Configuration(void);
void EXTIT_Configuration(void);
void EIC_Configuration(void);

/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void main()
{
#ifdef DEBUG
  debug();
#endif

  /* MRCC configuration */
  MRCC_Configuration();

  /* GPIO pins configuration */
#ifdef STR750_EVAL
  GPIO_Configuration_STR750_EVAL();
#else /* Uniboard */
  GPIO_Configuration_Uniboard();
#endif

#ifdef RTC_ON
  /* RTC configuration */
  RTC_Configuration();
#endif

  /* EXTIT configuration */
  EXTIT_Configuration();

  /* EIC configuration */
  EIC_Configuration();

  /* Turn off the led connected to P0.16 pin */
  GPIO_WriteBit(GPIO0, GPIO_Pin_16, Bit_SET);
  /* Turn on the led connected to P2.19 pin */
  GPIO_WriteBit(GPIO2, GPIO_Pin_19, Bit_RESET);
  
  /* Insert a delay */
  for(i = 0x8FFFFF; i != 0; i--);
  
  /* Turn off the led connected to P2.19 pin */
  GPIO_WriteBit(GPIO2, GPIO_Pin_19, Bit_SET);

  /* Turn on the led connected to P2.18 pin */
  GPIO_WriteBit(GPIO2, GPIO_Pin_18, Bit_RESET);


  while(1)
  {
    /* Enter in STOP mode each 5 second */
    if(EnterSTOPMode != 0)
    {
#ifdef  RTC_ON
      /* Wait until last write operation on RTC registers has finished */
      RTC_WaitForLastTask();
      /* Alarm in 10 seconds */
      RTC_SetAlarm(RTC_GetCounter() + 10);
      /* Wait until the write operation is performed */
      while(RTC_GetFlagStatus(RTC_FLAG_RTOFF) == RESET);
#endif	
      
      /* Turn off the led connected to P2.18 pin */
      GPIO_WriteBit(GPIO2, GPIO_Pin_18, Bit_SET);
      /* Turn off the led connected to P0.16 pin */
      GPIO_WriteBit(GPIO0, GPIO_Pin_16, Bit_SET);

#if defined(STOP_MVREG_Off)
      /* Enter STOP mode with MVREG off */
      MRCC_EnterSTOPMode(MRCC_STOPParam_MVREGOff);

      /* Enable OSC4M Oscillator */
      MRCC_OSC4MConfig(MRCC_OSC4M_Default);
      /* if the clock is detected on OSC4M */
      while (MRCC_GetFlagStatus(MRCC_FLAG_NCKD) != RESET)
      {
        /* Wait for OSC4M start-up */
        OSC4MStartUpStatus01 = MRCC_WaitForOSC4MStartUp();
        if(OSC4MStartUpStatus01 == SUCCESS)
        {
          /* Set CKSYS to 60MHz if the clock is detected on OSC4M */
          MRCC_CKSYSConfig(MRCC_CKSYS_OSC4MPLL, MRCC_PLL_Mul_15);
        }
      }
#elif defined(STOP_OSC4M_Off)
      /* Enter STOP mode with OSC4M off */
      MRCC_EnterSTOPMode(MRCC_STOPParam_OSC4MOff);

      /* Enable OSC4M Oscillator */
      MRCC_OSC4MConfig(MRCC_OSC4M_Default);

      /* if the clock is detected on OSC4M */
      while (MRCC_GetFlagStatus(MRCC_FLAG_NCKD) != RESET)
      {
        /* Wait for OSC4M start-up */
        OSC4MStartUpStatus01 = MRCC_WaitForOSC4MStartUp();
        if(OSC4MStartUpStatus01 == SUCCESS)
        {
          /* Set CKSYS to 60MHz if the clock is detected on OSC4M */
          MRCC_CKSYSConfig(MRCC_CKSYS_OSC4MPLL, MRCC_PLL_Mul_15);
        }
      }
#elif defined(STOP_FLASH_Off)
      /* Enter STOP mode with FLASH off */
      MRCC_EnterSTOPMode(MRCC_STOPParam_FLASHOff);
#elif defined(STOP_FLASH_PLL_Off)
      /* Disable PLL */
      MRCC_CKSYSConfig(MRCC_CKSYS_OSC4M, MRCC_PLL_Disabled);
      /* Enter STOP mode with FLASH off */
      MRCC_EnterSTOPMode(MRCC_STOPParam_FLASHOff);
      MRCC_CKSYSConfig(MRCC_CKSYS_OSC4MPLL, MRCC_PLL_Mul_15);
#elif defined(STOP_FLASH_OSC4M_Off)
      /* Enter STOP mode with OSC4M off */
      MRCC_EnterSTOPMode(MRCC_STOPParam_FLASHOff | MRCC_STOPParam_OSC4MOff);

      /* Enable OSC4M Oscillator */
      MRCC_OSC4MConfig(MRCC_OSC4M_Default);

      /* if the clock is detected on OSC4M */
      while (MRCC_GetFlagStatus(MRCC_FLAG_NCKD) != RESET)
      {
        /* Wait for OSC4M start-up */
        OSC4MStartUpStatus01 = MRCC_WaitForOSC4MStartUp();
        if(OSC4MStartUpStatus01 == SUCCESS)
        {
          /* Set CKSYS to 60MHz if the clock is detected on OSC4M */
          MRCC_CKSYSConfig(MRCC_CKSYS_OSC4MPLL, MRCC_PLL_Mul_15);
        }
      }
#else /* MRCC_STOP_Default */
      MRCC_EnterSTOPMode(MRCC_STOPParam_Default);

#endif

      /* Verify that the system has resumed from STOP mode (LP_DONE set to '1') */
      if(MRCC_GetFlagStatus(MRCC_FLAG_LPDONE) != RESET)
      {/* The system entered and resumed from STOP mode */
        /* Turn on the led connected to P2.18 pin */
	GPIO_WriteBit(GPIO2, GPIO_Pin_18, Bit_RESET);

        /* Turn off the led connected to P2.19 pin */
        GPIO_WriteBit(GPIO2, GPIO_Pin_19, Bit_SET);

        /* Clear LP_DONE flag */
        MRCC_ClearFlag(MRCC_FLAG_LPDONE);
      }
      else
      {/* The system fails to enter in STOP mode */
        /* Turn on the led connected to P2.19 pin */
        GPIO_WriteBit(GPIO2, GPIO_Pin_19, Bit_RESET);
      }
      EnterSTOPMode = 0;
    }
  }
}

/*******************************************************************************
* Function Name  : MRCC_Configuration
* Description    : Configures the different system clocks.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void MRCC_Configuration(void)
{
  /* MRCC system reset(for debug purpose) */
  MRCC_DeInit();

  /* Wait for OSC4M start-up */
  OSC4MStartUpStatus01 = MRCC_WaitForOSC4MStartUp();

  if(OSC4MStartUpStatus01 == SUCCESS)
  {
    /* Set HCLK to 60MHz */
    MRCC_HCLKConfig(MRCC_CKSYS_Div1);

    /* Set CKTIM to 30MHz */
    MRCC_CKTIMConfig(MRCC_HCLK_Div2);

    /* Set PCLK to 30MHz */
    MRCC_PCLKConfig(MRCC_CKTIM_Div1);

    /* Enable Flash burst mode */
    CFG_FLASHBurstConfig(CFG_FLASHBurst_Enable);

    /* Set CKSYS to 60MHz */
    MRCC_CKSYSConfig(MRCC_CKSYS_OSC4MPLL, MRCC_PLL_Mul_15);
  }

  /* GPIO pins optimized for 3V3 operation */
  MRCC_IOVoltageRangeConfig(MRCC_IOVoltageRange_3V3);

  /* Enable EXTIT and GPIO clocks */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_EXTIT | MRCC_Peripheral_GPIO, ENABLE);

#ifdef RTC_ON
  /* Enable OSC32K*/
  MRCC_OSC32KConfig(MRCC_OSC32K_Enable, MRCC_OSC32KBypass_Disable);
  while(MRCC_GetFlagStatus(MRCC_FLAG_OSC32KRDY) == RESET);
  /* Enable RTC clock */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_RTC,ENABLE);
#else
  /* Disable RTC clock */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_RTC,DISABLE);
  /* Disable OSC32K*/
  MRCC_OSC32KConfig(MRCC_OSC32K_Disable, MRCC_OSC32KBypass_Disable);
#endif

  /* Enable No Clock Detected interrupt */
  MRCC_ITConfig(MRCC_IT_NCKD, ENABLE);
}

/*******************************************************************************
* Function Name  : GPIO_Configuration_STR750_EVAL
* Description    : Configures the used I/O ports pins.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_Configuration_STR750_EVAL(void)
{
  GPIO_InitTypeDef  GPIO_InitStructure;

  /* Configure some pins of P0 as Output push-pull */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1 | GPIO_Pin_3 | GPIO_Pin_5 | GPIO_Pin_7 | GPIO_Pin_9 | GPIO_Pin_11 |
                                GPIO_Pin_13 | GPIO_Pin_15 | GPIO_Pin_16 | GPIO_Pin_17 | GPIO_Pin_18 |
                                GPIO_Pin_19 | GPIO_Pin_21 | GPIO_Pin_22 | GPIO_Pin_23 | GPIO_Pin_25 |
                                GPIO_Pin_26 | GPIO_Pin_27 | GPIO_Pin_28 | GPIO_Pin_29 |
                                GPIO_Pin_30 | GPIO_Pin_31;
  GPIO_Init(GPIO0, &GPIO_InitStructure);
  GPIO_Write(GPIO0,GPIO_Read(GPIO0)& ~0xFEEFAAAA);

  /* Configure some pins of P1 as Output push-pull */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2 | GPIO_Pin_3 | GPIO_Pin_4 |
                                GPIO_Pin_6 | GPIO_Pin_8 | GPIO_Pin_9 | GPIO_Pin_11;
  GPIO_Init(GPIO1, &GPIO_InitStructure);
  GPIO_Write(GPIO1,GPIO_Read(GPIO1)& ~0x00B5F);

  /* Configure pin P1.14 of P1 as Analog Input */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_14;
  GPIO_Init(GPIO1, &GPIO_InitStructure);


  /* Configure P2 as Output push-pull */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_All;
  GPIO_Init(GPIO2, &GPIO_InitStructure);
  GPIO_Write(GPIO2,0x00000);

  /* Configure P2.18 and P2.19 as Output push-pull */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_18 | GPIO_Pin_19;
  GPIO_Init(GPIO2, &GPIO_InitStructure);

  /* Turn off leds connected to P2.18 and P2.19 pins */
  GPIO_Write(GPIO2, GPIO_Read(GPIO2) | 0xC0000);

  /* Turn off led connected to P0.16 pin */
  GPIO_WriteBit(GPIO0, GPIO_Pin_16, Bit_SET);

  /* Turn off led connected to P1.1 pin */
  GPIO_WriteBit(GPIO1, GPIO_Pin_1, Bit_SET);

  /* Configure P1.05 as input (EXTIT_Line7) */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5;
  GPIO_Init(GPIO1, &GPIO_InitStructure);

}

/*******************************************************************************
* Function Name  : GPIO_Configuration_Uniboard
* Description    : Configures the used I/O ports pins.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_Configuration_Uniboard(void)
{

  GPIO_InitTypeDef GPIO_InitStructure;

  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_All;

  GPIO_Init(GPIO0, &GPIO_InitStructure);
  GPIO_Write(GPIO0, 0x0);


  GPIO_Init(GPIO1, &GPIO_InitStructure);
  GPIO_Write(GPIO1, 0x0);


  GPIO_Init(GPIO2, &GPIO_InitStructure);
  GPIO_Write(GPIO2, 0x0);

  /* Configure P1.05 as input (EXTIT_Line7) */
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_5;
  GPIO_Init(GPIO1, &GPIO_InitStructure);
}


/*******************************************************************************
* Function Name  : RTC_Configuration
* Description    : Configures RTC clock source and prescaler.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
#ifdef RTC_ON
void RTC_Configuration(void)
{
  /* RTC clock source configuration ------------------------------------------*/
  /* Enable OSC32K*/
  MRCC_OSC32KConfig(MRCC_OSC32K_Enable, MRCC_OSC32KBypass_Disable);
  while(MRCC_GetFlagStatus(MRCC_FLAG_OSC32KRDY) == RESET);

  /* Select OSC32K as CK_RTC clock source */
  MRCC_CKRTCConfig(MRCC_CKRTC_OSC32K);
  /* Wait for RTC clock to be ready */
  while(MRCC_GetFlagStatus(MRCC_FLAG_CKRTCOK) == RESET);

  /* RTC configuration -------------------------------------------------------*/
  /* Enable RTC Clock */
  MRCC_PeripheralClockConfig(MRCC_Peripheral_RTC, ENABLE);

  /* Wait for RTC registers synchronization */
  RTC_WaitForSynchro();

  /* Wait until last write operation on RTC registers has finished */
  RTC_WaitForLastTask();
  /* Set RTC prescaler: set RTC period to 1 second */
  RTC_SetPrescaler(32767); /* RTC period = CK_RTC/RTC_PR = (32.768 KHz)/(32767+1) */

  /* Wait until last write operation on RTC registers has finished */
  RTC_WaitForLastTask();
  /* Enable the RTC Second interrupt */
  RTC_ITConfig(RTC_IT_Second, ENABLE);
}
#endif

/*******************************************************************************
* Function Name  : EXTIT_Configuration
* Description    : Configures EXTIT line7 and EXTIT line15(WKP_STDBY pin or
                   RTC_Alarm).
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EXTIT_Configuration(void)
{
  EXTIT_InitTypeDef  EXTIT_InitStructure;

  /* Clear EXTIT line7&15 pending bits */
  EXTIT_ClearITPendingBit(EXTIT_ITLine7 | EXTIT_ITLine15);

  EXTIT_InitStructure.EXTIT_ITLine = EXTIT_ITLine7 | EXTIT_ITLine15;
  EXTIT_InitStructure.EXTIT_ITTrigger = EXTIT_ITTrigger_Rising;
  EXTIT_InitStructure.EXTIT_ITLineCmd = ENABLE;
  EXTIT_Init(&EXTIT_InitStructure);
}

/*******************************************************************************
* Function Name  : EIC_Configuration
* Description    : Configures the interrupt controller.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void EIC_Configuration(void)
{
  EIC_IRQInitTypeDef  EIC_IRQInitStructure;

  /* Configure and enable EXTIT IRQ Channel */
  EIC_IRQInitStructure.EIC_IRQChannel = EXTIT_IRQChannel;
  EIC_IRQInitStructure.EIC_IRQChannelPriority = 1;
  EIC_IRQInitStructure.EIC_IRQChannelCmd = ENABLE;
  EIC_IRQInit(&EIC_IRQInitStructure);

  /* Configure and enable WAKUP IRQ Channel */
  EIC_IRQInitStructure.EIC_IRQChannel = WAKUP_IRQChannel;
  EIC_IRQInitStructure.EIC_IRQChannelPriority = 1;
  EIC_IRQInit(&EIC_IRQInitStructure);

#ifdef RTC_ON  
  /* Configure and enable RTC IRQ Channel */
  EIC_IRQInitStructure.EIC_IRQChannel = RTC_IRQChannel;
  EIC_IRQInitStructure.EIC_IRQChannelPriority = 2;
  EIC_IRQInit(&EIC_IRQInitStructure);
#endif

  /* Enable EIC IRQ output request to CPU */
  EIC_IRQCmd(ENABLE);
}

/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/


