
/****************** (c) 2006  STMicroelectronics, Inc. ***********************/

/**************************************************************************
     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR
     COMPILER : COSMIC
     FILENAME : MACROS.H 
     RELEASE  : 1.0
     DATE     : Oct 2006
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173
***************************************************************************

      *********************************************
      *   This file                               *
      *          - contains all C macros          *
      *          - contains all ASM macros        *
      *********************************************

MODIFICATIONS :

******************************************************************************/


#ifndef  _MACROS_H
#define  _MACROS_H

/****************************************************************/

/* BIT FUNCTION MACROS FOR USE IN C
***********************************/
#ifndef  _BIT_MACRO
#define  _BIT_MACRO

#define  BIT(A)                 ( 1 << (A) )
#define  bitToggle(A, B)        ( (A) ^= (B) )
#define  bitSet(A, B)           ( (A) |= (B) )
#define  bitClr(A, B)           ( (A) &= ~(B) )
#define  bitTest_TRUE(A, B)     (  ( (A) & (B) ) )
#define  bitTest_FALSE(A, B)    ( !( (A) & (B) ) )

#endif

/*********************************************************/

#define sim()	_asm("sim")	/* set interrupt mask    */
#define rim()	_asm("rim")	/* reset interrupt mask  */
#define halt()	_asm("halt")	/* HALT the processor    */

/************************************
Motor control peripheral soft reset
*************************************/
#define MCsoft_reset()	{                                \
    MCFR = RST;   /* reset MC cell */                    \
    MCFR = 0;     /* clear reset of MC Register*/        \
}

/**********
MCU reset
***********/
#define MCU_reset()  {                                   \
    WWDGCR = 0xff;    /* when watchdog is active,  */    \
    halt();           /* HALT will RESET MCU       */    \
}

/****************
ADC 10bit read
****************/
#define  getADC_10bit(var , channel)  {        \
    ADCCSR = ADON + (channel);                 \
    ADCDRMSB; /*read ADCDRMSB to clear EOC */  \
    while (bitTest_FALSE(ADCCSR, EOC)) ;       \
    (var) = (ADCDRMSB << 2 ) + ADCDRLSB;       \
    ADCDRMSB;                                  \
}

/****************
ADC 8bit read
****************/
#define  getADC_8bit(var , channel)  {         \
    ADCCSR = ADON + (channel);                 \
    ADCDRMSB;  /*read ADCDRMSB to clear EOC */ \
    while (bitTest_FALSE(ADCCSR, EOC)) ;       \
    (var) = ADCDRMSB;                          \
}
/****************************************************************/
/*******************************************************************/          

#endif   /*  end of MACRO.H  */
