
/****************** (c) 2006  STMicroelectronics, Inc. ***********************/

/**************************************************************************
     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR
     COMPILER : COSMIC
     FILENAME : MAIN.C 
     RELEASE  : 1.0
     DATE     : Feb 2007
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173
***************************************************************************

MODIFICATIONS :
  - On STARTER KIT, jumper J15 was altered by opening few signals for access
    to probe(pins 11-12 and 13-14).  The signals are MCZEM and MCDEM
  - W10 is fully opened to reveal mid pin, which is PD7, used for flagging
/******************************************************************************
... Test status: .............................................................*
******************************************************************************/

#define _MAIN_C

#include "include.inc"

extern u8    runCmd;
extern u16   starting_failed;

/************************************************************************
*************************************************************************/
/*************************
 delay loop for 1mS
**************************/
void wait_1ms(u16 count_ms)  {
u16 count;

  for ( ; count_ms-- ; )
    for(count = 235; --count; )
      ;
  
  return;
}
/****************************************************************************/

   /********************************************/
   /*************  MAIN FUNCTION   *************/
   /********************************************/
void main(void) {

  sim();
  wait_1ms(10);
  
  #if TEST
  // FLAG pin initialisation
  bitSet (PDDDR, BIT(7));
  bitSet (PDOR, BIT(7));
  #endif
  
  // internal OPAM
  OACSR = 00;    // OAON = 0/1;  opamp disable/enable
  // OPAM settings
  wait_1ms(10);
  OACSR  = OAON;
  wait_1ms(20);
  OACSR = OAON + OFFCMP + AVGCMP;
  wait_1ms(20);
  //OACSR = HIGHGAIN + OAON + OFFCMP + AVGCMP;
  while ( !( OACSR & CMPOVR) );
  
  // Master clk ctrl register
  MCCSR = 0x02;      // Enable timer interrupt
  
  // System variables initialisation 
  runCmd = 0;
  starting_failed = 0;
  
  // Open loop sensorless BLDC motor control code
  rim();
  while(1) {
    if (runCmd) {
      align_rotor();
      enable_MC_interrupts();
      while (runCmd) {
        if (starting_failed == 0)
          break;
      }
    } else 
      MCsoft_reset();
  }

  return;
}
/************************************************************************/ 
/********** Program Ends Here *******************************************/ 
/************************************************************************/ 
