
/****************** (c) 2006  STMicroelectronics, Inc. ***********************/

/**************************************************************************
     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR
     COMPILER : COSMIC
     FILENAME : PARAMETERS.H
     RELEASE  : 1.0
     DATE     : Oct 2006
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173
***************************************************************************


    ****************************************************************
    *  This file contains all system parameters                    *
    *  such as                                                     *
               - dead time
               - D event sanity control settings
               - Z event sanity control settings
               - Over current event sanity control settings
               - Z,C and D debug and PWM output control settings
               - D, Z sampling clock control settings
               - BEMF comparator ref control settings
               - Z sampling control settings
                  - at end of PWM off 
                  - at high freq (with or without delay)
                  - delay control settings, when Z sampling at on
               - MC peripheral clock freq control settings
    ****************************************************************
    

MODIFICATIONS :

******************************************************************************/

#ifndef   _PARAMETERS_H
#define   _PARAMETERS_H

#ifndef   _ST72MC_H
#include  "st72mc.h"
#endif

/**************************************************************************/
/**************************************************************************/
#define   TEST   1

#define   NULL                  0x00
#define   DEBOUNCE_TIME_COUNT   50

/*Parameters for Motor Controller
***********************************/
#define  Carrier_mag    (long)1000   /* Carrier magnitude */
#define  start_duty     5  /* duty cycle at start of alignment */
#define  n_align_step   25      /* number of step in aligment phase */
#define  duty_ramp      6   /* current ramping in alignment phase  */

#define   MAX_DUTY_CYCLE     ((Carrier_mag + 1) << 3)
/**************************************************************************/
/**************************************************************************/

/* Motor mode
***************/
#define  SIX_STEP_MODE   0
#define  SINE_MODE       PCN

/* dead time parameters
************************/
#define  NO_DEAD_TIME        0
//#define  DEAD_TIME           (DTE + ...)   /* identify value based on req */

/**************************************************************************/
/**************************************************************************/
/* D event control general definitions
***************************************/
#define  D_blank_5us      0
#define  D_blank_10us     1
#define  D_blank_15us     2
#define  D_blank_20us     3
#define  D_blank_25us     4
#define  D_blank_30us     5
#define  D_blank_35us     6
#define  D_blank_40us     7
#define  D_blank_60us     8
#define  D_blank_80us     9
#define  D_blank_100us   10
#define  D_blank_120us   11
#define  D_blank_140us   12
#define  D_blank_160us   13
#define  D_blank_180us   14
#define  D_blank_200us   15

/* D event control settings
*****************************/
#define  D_sample(A)      ( ((A)-1) * 0x10)               /* from 1 to 16  */

/**************************************************************************/
/**************************************************************************/
/* Z event control general definitions
****************************************/
#define  Z_blank_5us      0
#define  Z_blank_10us     1
#define  Z_blank_15us     2
#define  Z_blank_20us     3
#define  Z_blank_25us     4
#define  Z_blank_30us     5
#define  Z_blank_35us     6
#define  Z_blank_40us     7
#define  Z_blank_60us     8
#define  Z_blank_80us     9
#define  Z_blank_100us   10
#define  Z_blank_120us   11
#define  Z_blank_140us   12
#define  Z_blank_160us   13
#define  Z_blank_180us   14
#define  Z_blank_200us   15

/* Z event control settings
*****************************/
#define  Z_sample(A)      ( ((A)-1) * 0x10)               /* from 1 to 16  */

/**************************************************************************/
/**************************************************************************/
/* Over current event control general definitions
**************************************************/
#define  Current_blank_OFF      0
#define  Current_blank_0_5us    1
#define  Current_blank_1_0us    2
#define  Current_blank_1_5us    3
#define  Current_blank_2_0us    4
#define  Current_blank_2_5us    5
#define  Current_blank_3_0us    6
#define  Current_blank_3_5us    7

/* Over current event control settings
****************************************/
#define  OC_sample(A)      ( ((A)-1) * 0x8)               /* from 1 to 8  */

/**************************************************************************/
/**************************************************************************/
/* PWM output and debug (Z, C, D) general definitions
******************************************************/
#define  DEBUG_ON          DG
#define  DEBUG_OFF         0

#define  CONNECT_PWMU      PWMU
#define  CONNECT_PWMV      PWMV
#define  CONNECT_PWMW      PWMW
#define  DISCONNECT_PWMU   0
#define  DISCONNECT_PWMV   0
#define  DISCONNECT_PWMW   0

/**************************************************************************/
/**************************************************************************/
/* PWM control general definitions
************************************/
// PWM clock freq
#define  Fmtc_div_1   0
#define  Fmtc_div_2   1
#define  Fmtc_div_3   2
#define  Fmtc_div_4   3
#define  Fmtc_div_5   4
#define  Fmtc_div_6   5
#define  Fmtc_div_7   6 
#define  Fmtc_div_8   7

// PWM counter mode  
#define  EDGE_ALIGNED    0
#define  CENTER_ALIGNED  CMS

// PWM resolution
#define  bit16  0
#define  bit8   PMS

/**************************************************************************/
/**************************************************************************/
/*  D and Z sampling clock general definitions
************************************************/
#define   Sampling_1MHz     0
#define   Sampling_500KHz   SCF0
#define   Sampling_250KHz   SCF1
#define   Sampling_125KHz   (SCF0 + SCF1)

#define   Sampling_OFF      0
#define   Sampling_ON       ZSV

#define   Gnd_unused_MCIx     0
#define   Float_unused_MCIx   DISS

/**************************************************************************/
/**************************************************************************/
/* BEMZ comparator reference - general defintions
***************************************************/
#define   ref_0_2V   0
#define   ref_0_6V   1
#define   ref_1_0V   2
#define   ref_1_5V   3
#define   ref_2_0V   4
#define   ref_2_5V   5
#define   ref_3_5V   6
#define   ref_ext    7

/* Z sampling definitions
***************************/
#define  End_of_PWM_off   0
#define  Sample_at_SCF    SPLG

/* MCRC settings
******************/
#define  MCRC_low_duty_cycle   (HZ + End_of_PWM_off + ref_0_2V)
#define  MCRC_high_duty_cycle  (HZ + Sample_at_SCF  + ref_ext)

/**************************************************************************/
/**************************************************************************/

/* MCONF settings
******************/

/* Delay for sampling at Ton - reference definitions
*******************************************************/
#define  No_delay       (0*0x10)
#define  Delay2_5us     (1*0x10)
#define  Delay5_0us     (2*0x10)
#define  Delay7_5us     (3*0x10)
#define  Delay10_0us    (4*0x10)
#define  Delay12_5us    (5*0x10)
#define  Delay15_0us    (6*0x10)
#define  Delay17_5us    (7*0x10)
#define  Delay20_0us    (8*0x10)
#define  Delay22_5us    (9*0x10)
#define  Delay25_0us   (10*0x10)
#define  Delay27_5us   (11*0x10)
#define  Delay30_0us   (12*0x10)
#define  Delay32_5us   (13*0x10)
#define  Delay35_0us   (14*0x10)
#define  Delay37_5us   (15*0x10)

/* Delay for sampling at Ton - setting
***************************************/
#define  Ton_sample_delay   (Delay10_0us)

/* MC Peripheral frequency definitions
*****************************************/
#define  Fmtc        0
#define  Fmtc_by_2   XT8
#define  Fmtc_by_4   XT16

/**************************************************************************/
/**************************************************************************/
/* OPAM input setting definitions
**********************************/
#define   OPAMP_in_OAZ     0
#define   OPAMP_in_MCCFI   CFAV

/* Chopper definitions
************************/

/* Chopping control defintions
********************************/
#define   CHOPPING_OFF     0
#define   CHOP_ODD         HFE0
#define   CHOP_EVEN        HFE1
#define   CHOP_BOTH        (HFE1 + HFE0)

// chopping freq definitions at Fmtc = 8MHz (or) 16MHz
#define  CHOP_FREQ_100KHz_AT_FMTC_8MHZ     0
#define  CHOP_FREQ_200KHz_AT_FMTC_8MHZ     1
#define  CHOP_FREQ_400KHz_AT_FMTC_8MHZ     2
#define  CHOP_FREQ_500KHz_AT_FMTC_8MHZ     3
#define  CHOP_FREQ_800KHz_AT_FMTC_8MHZ     4
#define  CHOP_FREQ_1000KHz_AT_FMTC_8MHZ    5
#define  CHOP_FREQ_1330KHz_AT_FMTC_8MHZ    6
#define  CHOP_FREQ_2000KHz_AT_FMTC_8MHZ    7

// chopping freq definitions at Fmtc = 4MHz
#define  CHOP_FREQ_50KHz_AT_FMTC_4MHZ      0
#define  CHOP_FREQ_100KHz_AT_FMTC_4MHZ     1
#define  CHOP_FREQ_200KHz_AT_FMTC_4MHZ     2
#define  CHOP_FREQ_250KHz_AT_FMTC_4MHZ     3
#define  CHOP_FREQ_400KHz_AT_FMTC_4MHZ     4
#define  CHOP_FREQ_500KHz_AT_FMTC_4MHZ     5
#define  CHOP_FREQ_666KHz_AT_FMTC_4MHZ     6
#define  CHOP_FREQ_1000KHz_AT_FMTC_4MHZ    7

/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

#endif   /* End of INCLUDE.INC  */
