
/****************** (c) 2006  STMicroelectronics, Inc. ***********************/

/**************************************************************************
     PROGRAM  : SENSORLESS CONTROL OF 3 PHASE BLDC MOTOR
     COMPILER : COSMIC
     FILENAME : TYPEDEF.H
     RELEASE  : 1.0
     DATE     : Oct 2006
     AUTHOR   : Power Systems Application Lab
                STMicroelectronics, Inc.
                Schaumburg, IL - 60173
***************************************************************************

	****************************************
	*   This file contains                 *
	*   	- typedefs for all variables   *
	****************************************

MODIFICATIONS :

****************************************************************************/

#ifndef  _TYPEDEF_H
#define  _TYPEDEF_H

/******************************************************/

typedef  unsigned char  u8;
typedef  signed char    s8;
typedef  unsigned int   u16;
typedef  signed int     s16;
typedef  unsigned long  u32;
typedef  signed long    s32;

union uDouble_byte {
  u16 word;
  struct  {
    u8 b1;
    u8 b0;
  }byte;
};

/**************************/

union sDouble_byte {
  s16 word;
  struct  {
    s8 b1;
    u8 b0;
  }byte;
};

/***************************/

union uDouble_word {
  u32  dw;
  struct  {
    u16 w1;
    u16 w0;
  }word;
  struct  {
    u8 b3;
    u8 b2;
    u8 b1;
    u8 b0;
  }byte;
  struct {
    u8  b3;
    u16  b21;
    u8  b0;
  } wb;
};

/**************************/

union sDouble_word {
  s32  dw;
  struct  {
    s16  w1;
    u16  w0;
  } word;
  struct  {
    s8 b3;
    u8 b2;
    u8 b1;
    u8 b0;
  }byte;
  struct {
    s8  b3;
    u16  b21;
    u8  b0;
  } wb;
};

/**************************/

typedef  union uDouble_byte    uDOUBLE_8;
typedef  union sDouble_byte    sDOUBLE_8;
typedef  union uDouble_word    uQUAD_8;
typedef  union sDouble_word    sQUAD_8;

/*******************************************************************/

#endif   /* end of TYPEDEF.H  */