/******************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name : PMBus.h 
Group            : MPA Systems Lab.
Author           : Telecom Team
Date First Issued: 01/09/2006
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
********************************Documentation**********************************
General Purpose - Contains prototypes for all the commands of PMBus
********************************Revision History*******************************
_______________________________________________________________________________
Date :01/09/2006                  Release:1.0 
******************************************************************************/
#ifndef PMBUS_H
#define PMBUS_H

#include "ST7_config.h"

#include "SMBus_master.h"  


/*---------------------------------------------------------------------------*/
                  /* Description of all the functions defined in this module */
									
/* Initialise I2C registers, configures slave address and communication speed*/
void PMBus_Init (void);
void Enable_I2C (void);

															/* Function to manage all PMBus read commannds */
PMB_ErrCode_t PMBus_CommandRead (unsigned char * ); 

														 /* Function to manage all PMBus write commannds */
PMB_ErrCode_t PMBus_CommandWrite (unsigned char * ); 

                 /* Function to Calculate data length and SMBus bus protocol */
PMB_ErrCode_t PMBus_DataComm (unsigned char * ); 

void PMBus_DataLengthCalc (void); 

#endif
/**** (c) 2005   STMicroelectronics *************************** END OF FILE **/