/******************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name : SMBus_Master.h 
Group            : MPA Systems Lab.
Author           : Telecom Team
Date First Issued: 01/09/2006
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
********************************Documentation**********************************
General Purpose - Contains prototype of all functions and enumurated data types 
                  used in SMBus_Master.c. 
********************************Revision History*******************************
_______________________________________________________________________________
Date :01/09/2006                  Release:1.0 
******************************************************************************/
#ifndef SMBMASTER_H
#define SMBMASTER_H

#include "ST7_config.h" 

#pragma space extern [] @tiny
extern volatile unsigned char Command_Code;/* Variable to store command code */


/*---------------------------------------------------------------------------*/
                  /* Description of all the functions defined in this module */
PMB_ErrCode_t SMB_TxRx (void);
																	                      /* Sends a data byte */
PMB_ErrCode_t SMBm_SendByte (unsigned char);

PMB_ErrCode_t SMBm_ReceiveByte (unsigned char, unsigned char * );
                                            /* Sends command code and a byte */
PMB_ErrCode_t SMBm_WriteByte (unsigned char);

																	 /* Sends command code and receives a byte */
PMB_ErrCode_t SMBm_ReadByte (unsigned char *);

                                            /* Sends command code and a word */
PMB_ErrCode_t SMBm_WriteWord(unsigned char*);

																	 /* Sends command code and receives a word */
PMB_ErrCode_t SMBm_ReadWord (unsigned char *);

														 /* Sends command code and send 32 bytes of data */
PMB_ErrCode_t SMBm_WriteBlock(unsigned char *, 
                              unsigned char);
															
												 /* Sends command code and receives 32 bytes of data */
PMB_ErrCode_t SMBm_ReadBlock (unsigned char *);

BOOL SMB_ClkLow_Delay (void);          /* 25ms delay loop for byte transfer */

void SMB_CRC8 (void) ;                        /* For calculating PEC */

#endif
/**** (c) 2005   STMicroelectronics *************************** END OF FILE **/