/******************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name : SMBus_Slave.h 
Group            : MPA Systems Lab.
Author           : Telecom Team
Date First Issued: 01/09/2006
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
********************************Documentation**********************************
General Purpose - Contains prototypes for all the functions of slave SMBus. 
********************************Revision History*******************************
_______________________________________________________________________________
Date :01/09/2006                  Release:1.0 
******************************************************************************/
#ifndef SMBSLAVE_H
#define SMBSLAVE_H

#include "ST7_config.h"

/*---------------------------------------------------------------------------*/
                                              /* Assignment of slave address */
typedef enum {
             SMBs_DYNMIC_ADD         = (unsigned char) 0xFF,
             SMBs_10BIT_ADD          = (unsigned char) 0xF0,
             SMBs_DEVICE_DFLT        = (unsigned char) 0xC2,
             SMBs_DFLT_ADD           = (unsigned char) 0x6E, 
             SMBs_ACCESS_HOST        = (unsigned char) 0x50,
             SMBs_ALERT_RESPONSE     = (unsigned char) 0x18,
             SMBs_HOST               = (unsigned char) 0x10,             
             SMBs_MISC               = (unsigned char) 0x04,             
             SMBs_CBUS               = (unsigned char) 0x02,
             SMBs_GCAL               = (unsigned char) 0x00
             }SMBs_Address_t;               
/*---------------------------------------------------------------------------*/	 
                  /* Description of error and status messages of slave SMBus */
typedef enum {
             SMBs_BUSY                         = (unsigned char) 0x1A,
             SMBs_TIMEOUT                      = (unsigned char) 0x18, 
             SMBs_DEVICE_ACCESS_DENIED         = (unsigned char) 0x12,
             SMBs_NOT_ACK                      = (unsigned char) 0x10,
             SMBs_UNKNOWN_FAILURE              = (unsigned char) 0x04,
             SMBs_BUS_ERROR                    = (unsigned char) 0x02,
             SMBs_OK                           = (unsigned char) 0x00
             }SMBs_ErrCode_t;               
/*---------------------------------------------------------------------------*/
                  /* Description of all the functions defined in this module */

void SMBs_Init (SMBs_Address_t,unsigned char, unsigned char);  
                   /* Initialise I2C registers and selects the slave address */                                                 

SMBs_ErrCode_t SMBs_SendByte (unsigned char *);       /* Transmits data byte */

SMBs_ErrCode_t SMBs_Rx_CmdCode (unsigned char*, unsigned char *) ; 
                                    /* Receives slave address & command code */ 

SMBs_ErrCode_t SMBs_WriteByte (unsigned char *);  
                                    /* Sends data byte based on command code */

SMBs_ErrCode_t SMBs_ReadByte (unsigned char*);      
                                 /* Receives data byte based on command code */

SMBs_ErrCode_t SMBs_WriteWord (unsigned char * );            /* Sends a word */

SMBs_ErrCode_t SMBs_ReadWord (unsigned char *);           /* Receives a word */

SMBs_ErrCode_t SMBs_WriteBlock (unsigned char*,unsigned char);
                                                    /* Sends a block of data */
                                   
SMBs_ErrCode_t SMBs_ReadBlock (unsigned char*);  /* Receives a block of data */
                          
SMBs_ErrCode_t SMBs_ProcessCall_Block (unsigned char*,unsigned char,
                                      unsigned char*);
                         /* Reads a Block of data and writes a block of data */

void SMBs_IT_Function (void) ;                  /* Interrupt service routine */

void SMBs_Tx (void) ;                    /* Data Transmission routine */

static void SMBs_Rx (void) ;                       /* Data Reception routine */

#ifdef SMB_PEC
void SMB_CRC8 (void) ;                        /* For calculating PEC */
#endif

#endif

/**** (c) 2005   STMicroelectronics *************************** END OF FILE **/