/*****************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name : ST7_Config.h
Group            : MPA Systems Lab.
Author           : Telecom Team
Date First Issued: 01/09/2006
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
********************************Documentation**********************************
General Purpose - This file contains the following 	
	(i) Includes peripheral pegisters mapping file 
	(ii) Includes all header files for linking
	(iii) Compiler Selection
	(iv) Macros for Assembly instructions
	(v) Fcpu Definition

********************************Revision History*******************************
_______________________________________________________________________________
Date :01/09/2006                  Release:1.0 
******************************************************************************/
#ifndef	ST7_CONFIG_H
#define	ST7_CONFIG_H                                                          

#include "st72264g1.h"  

/*---------------Prototype Definitions of Peripheral Functions---------------*/
#include "st7_hr.h"  
#include "sci.h"  
#include "PMBus.h"  

#endif 

/*--------------To display all PMBus commands in PC Hyperterminal------------*/
#define DISPLAY_HYPERTERMINAL


/*-------------------------Selection of Slave Address------------------------*/
#define SLAVEADD		0x10
#define ALERTRESPONSEADD		0x18

/*---------------------Select the mode of communication ---------------------*/
#define SCI_POLLING_TX                            /*Polling mode transmission*/
#define SCI_ITDRV_WITHOUTBUF_RX		                             
                             /*Interrupt driven without buffer reception mode*/

/*-----------------------------Compiler Selection----------------------------*/ 
#ifdef __CSMC__
#define _COSMIC_
#else
#error "Unsupported Compiler!"                 /* Compiler defines not found */
#endif

/*----------------------------Enumerated data type---------------------------*/
#ifndef enum_type
#define enum_type
typedef enum {
	FALSE	=(unsigned char) 0x00,			
	TRUE   = !(FALSE)                
        }BOOL; 
#endif	     

#ifndef enum_type1
#define enum_type1

typedef enum {
        PMBUS_BUSY                        = (unsigned char) 0x1A,
        PMBUS_TIMEOUT                     = (unsigned char) 0x18, 
        PMBUS_DEVICE_ACCESS_DENIED        = (unsigned char) 0x12,
				PMBUS_RX_DATA_EMPTY	  						= (unsigned char) 0xFE,
				PMBUS_NACK            						= (unsigned char) 0x10,
				PMBUS_ARLO					  						= (unsigned char) 0x04,	
				PMBUS_BERR					  						= (unsigned char) 0x02,
				PMBUS_ADD_TX_OK			  						= (unsigned char) 0x01,
				PMBUS_COMM_OK				  						= (unsigned char) 0x00
				}PMB_ErrCode_t;


#endif	     



/*---------------------Macros for Assembly instructions----------------------*/
#define EnableInterrupts {_asm ("RIM");}  
#define Nop {_asm ("nop");} 

/*** (c) 2005   STMicroelectronics ****************** END OF FILE ************/