/*****************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name : ST7_hr.h 
Group            : MPA Systems Lab.
Author           : Telecom Team
Date First Issued: 01/09/2006
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
********************************Documentation**********************************
General Purpose - Contains hardware register bit definitions for ST7 MCU 

********************************Revision History*******************************
_______________________________________________________________________________
Date :01/09/2006                  Release:1.0 
******************************************************************************/

#ifndef ST7_HR_H
#define ST7_HR_H 

#include "ST7_config.h" 

/*****************************************************************************/
/******************** I/O HARDWARE REGISTER BIT DEFINITIONS ******************/
/*****************************************************************************/
#define PORTA_DEFAULT  0x04   /* PA2 push pull output, others floating input */
#define GLOW_LED       0x04   /* PA2 push pull output, others floating input */
#define SMB_ALERT      0x08                               /* SMBUS alert pin */

#define PORTB_DEFAULT  0xFF                     /* PB [0:7] push pull output */
#define OUTEN          0x04    /* Power Management pin OUTEN: Floating input */
#define PWRGD          0x08  /* Power Management pin PWRGD: push pull output */

#define PORTC_DEFAULT  0x3E   /* PC0 floating input, others push pull output */
#define CONTROL        0x01                                   /* Control pin */

/*****************************************************************************/
/******************* PC COMMUNICATION STATUS BITS DEFINITION *****************/
/*****************************************************************************/
#define COMMAND_INIT	0x00                 /* To initialise Commands from PC */
#define COMMAND_READ	0x31        /* Command to receive data from demo to PC */
#define COMMAND_WRITE 0x32        /* Command to receive data from PC to Demo */
#define COMMAND_WDG 	0x30                       /* Command to read all data */

#define COMMAND_GC		0x33               /* Command to perform group command */

/*****************************************************************************/
/******* I2C HARDWARE  R E G I S T E R   B I T   D E F I N I T I O N S *******/
/*****************************************************************************/
#define COMM_SPEED  	0xD0                 /* I2C Comm speed set as 400kHz */
#define ACK         	0x04                         /* I2C acknowledge flag */
#define START       	0x08                                   /* Start flag */
#define STOP        	0x02                                    /* Stop flag */
#define PE          	0x20                       /* Peripheral enable flag */
#define BTF         	0x08                    /* Byte transfer status flag */
#define EVF         	0x80                                   /* Event flag */
#define AF          	0x10                          /* Acknowledge failure */
#define STATUS      	0xBB                                 /* Status flags */
#define SB          	0x01                       /* Start bit status flags */
#define ITE         	0x01                       /* Interrupt enable flags */
#define TRA         	0x20                       /* Interrupt enable flags */
#define ERR         	0x16                                  /* Error flags */
#define ALBE        	0x16               /* Arbitration loss and bus error */
#define MSL        		0x02               
#define BUSY       		0x10               
#define FRI       		0x40               
#define STOPF      		0x08               
#define ADSL      		0x04               

/*****************************************************************************/
/******* SCI HARDWARE  R E G I S T E R   B I T   D E F I N I T I O N S *******/
/*****************************************************************************/
#define TDRE	  	    0x80
#define TC            0x40
#define RDRF		      0x20
#define IDLE		      0x10
#define ORE           0x08
#define NE            0x04
#define FE            0x02
#define PERR          0x01                                                    
#define SCI_ERR_INIT	0x00 

/*****************************************************************************/
/*************CRC VRIABLES FOR PACKET ERROR CHECKING USING CRC8 **************/
/*****************************************************************************/
#define	CRC_U16		(unsigned int) 0xFF00              /* To convert U8 to U16 */
#define	CRC_COUNT		0x08                  /* No. of times data to be shifted */
#define	CRC_MSB		(unsigned int) 0x8000       /* Checking for bit '1' as MSB */
#define	CRC_POLY	(unsigned int) 0x8380    /* CRC byte XORed with this value */

/*****************************************************************************/
/********** SMBUS MASTER PROTOCOL CODES FOR DIFFERENT BUS PROTOCOLS **********/
/*****************************************************************************/
/* SMB_Mode is a 1 byte variable, which represents the different bus protocols 
and other options of SMBus. This byte is categorised as follows. 

 MSB                                                            LSB  
 PEC - M/Sl- Tx/Rx - Sr/S - CC/D - Reserved - Bus Mode 1 - Bus Mode 0  
 
 Following is the bit definition. 
 PEC: 1 - PEC enabled, 0 - PEC disabled, 
 M/Sl: 1 - Master mode, 0 - Slave mdoe, 
 Tx/Rx: 1 - transmitter mode, 0 - receiver mode, 
 Sr/S: 1 - Repeated Start, 0 - normal Start, 
 CC/D: 1 - command code transmission, 0 - data transmission,  
 Reserved: value kept as 0, 
 Bus mode [1:0]: 00 - Byte protocol, 01 - Word protocol, 
                 10 - Block protocol, 11 - Process call protocol   */

																							#define SLAVE_ADD_DEFAULT				0x80

#define SMB_BYTE_NC				0x04
#define SMB_BYTE					0x08
#define SMB_WORD					0x09
#define SMB_BLOCK					0x0B
#define SMB_MSL						0x40
#define SMB_ARA						0x80
#define SMB_GC						0x20
#define SMB_READ					0x10
#define SMB_NO_PROTOCOL		0x00
                                                   /* SMBus common variables */
#define PEC_ENABLE					0xFF
#define PEC_DISABLE					0x00
#define I2C_HIGH_SPEED			0x84
#define I2C_SLOW_SPEED			0x23
#define SMB_CLKLOWMAX_LIMIT		(unsigned int) 1775
#define SMB_CLKLOWBYTE_LIMIT		(unsigned int) 705

#endif

/*** (c) 2005   STMicroelectronics ****************** END OF FILE ************/