/******************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name : SCI.c 
Group            : MPA Systems Lab.
Author           : Telecom Team
Date First Issued: 01/09/2006   
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
********************************Documentation**********************************
General Purpose - Contains source code for all the functions of SCI

********************************Revision History*******************************
_______________________________________________________________________________
Date :01/09/2006 			Release:1.0
     	
  
******************************************************************************/
#include "ST7_hr.h"
#include "Sci.h"                                   /*Declaration of functions*/

#pragma space extern [] @tiny
@tiny volatile unsigned char SCI_Error;    /*Declaration of Global Variables*/
volatile unsigned char SCI_Rx_DATA;
volatile unsigned char *PtrToSCIBuffRx;
volatile unsigned char SCI_Rx_Buff;
volatile unsigned char SCI_Pol_Stat;  
extern unsigned char Data_Status ;

#ifdef DISPLAY_HYPERTERMINAL
const unsigned char Hex_Display[3] = " 0x";
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : SCI_Init
INPUT        : 1.SCI_DEFAULT_PARAM1, SCI_WORDLENGTH_9,SCI_ODPARITY_SELECT,
				 SCI_EVPARITY_SELECT or SCI_WAKEUP_ADDR
               2.SCI_MUTE_ENABLE,SCI_BREAK_ENABLE,SCI_DEFAULT_PARAM2
OUTPUT       : None	 		 
DESCRIPTION  : Initializes the SCI in the required mode
COMMENTS     : Must be called before starting any sci operation
-----------------------------------------------------------------------------*/
void SCI_Init (void)
{   
	#asm                             /* Loads reset value in all SCI registers */
	clr		_SCICR1
	clr		_SCICR2
	tnz		_SCISR
	clr		_SCIDR
	#endasm                           /* Configuration of SCI control register */
	
	SCIBRR = 0xC0 ;	
	
  SCI_Pol_Stat = 0;
	SCI_Error = 0;               /*Initializes globalvariables*/
	SCI_Rx_Buff = 0;
}


/*-----------------------------------------------------------------------------
ROUTINE NAME    : SCI_PutBuffer
INPUT           : *PtrtoBuffer,NbOfBytes
OUTPUT          : None
DESCRIPTION     : Transmits ASCII from the user buffer in polling mode and 
                  starts transmission in interrupt driven with buffer mode
COMMENTS        : None
-----------------------------------------------------------------------------*/
void SCI_ASCIIDisplay (const unsigned char *PtrtoBuffer, unsigned char NbOfBytes)
{  
	unsigned char temp; 
	#asm                             
	tnz		_SCISR
	#endasm

	for (; NbOfBytes > 0 ; NbOfBytes--)
  { 
		if (Data_Status ==1 )
		{
			SCI_PutBuffer (Hex_Display, 3);
		}

    temp = (unsigned char) (*PtrtoBuffer >> 4);              
    if (temp > 0x09) 
    {
     	temp = (unsigned char) (temp + 0x07) ;
    }
    temp += 0x30 ;
	
		SCIDR = temp;              /*Loads the byte to be transmitted*/
	  while (!(SCISR & TC));  

    temp = *PtrtoBuffer ;              	    
    temp = (unsigned char) (temp & 0x0F);              	    

    if (temp > 0x09) 
    {
     	temp = (unsigned char) (temp + 0x07) ;
    }
    temp += 0x30 ;
        
		SCIDR = temp;              /*Loads the byte to be transmitted*/        
    while (!(SCISR & TC));  
                                  /*Waits for the completion of transmission*/
    PtrtoBuffer++;               /*Moves the pointer to the next location*/
	} 
}

/*-----------------------------------------------------------------------------
ROUTINE NAME    : SCI_PutBuffer
INPUT           : *PtrtoBuffer,NbOfBytes
OUTPUT          : None
DESCRIPTION     : Transmits  data from the user buffer in polling mode and 
                  starts transmission in interrupt driven with buffer mode
COMMENTS        : None
-----------------------------------------------------------------------------*/
void SCI_PutBuffer (const unsigned char *PtrtoBuffer, unsigned char NbOfBytes)
{  
	#asm                             
	tnz		_SCISR
	#endasm
	
	for (; NbOfBytes > 0 ; NbOfBytes--)
  { 
		SCIDR = *PtrtoBuffer;              /*Loads the byte to be transmitted*/
    while (!(SCISR & TC));  
                                  /*Waits for the completion of transmission*/
    PtrtoBuffer++;               /*Moves the pointer to the next location*/
	} 
}

/*-----------------------------------------------------------------------------
ROUTINE NAME    : SCI_GetByte
INPUT           : None
OUTPUT          : Received Data
DESCRIPTION     : Retunrs a data received to the user
COMMENTS        : None
-----------------------------------------------------------------------------*/
unsigned char SCI_GetByte(void)
{  

#if defined SCI_ITDRV_WITHOUTBUF_RX 
    SCI_Error = 0x00;
    return(SCI_Rx_DATA); 	  
#else	
    return (SCIDR);           
#endif
}

/*-----------------------------------------------------------------------------
ROUTINE NAME	: SCI_GetBuffer
INPUT           : *PtrtoBuffer, NbOfBytes 
OUTPUT          : None	
DESCRIPTION     : Starts the reception in the interrupt subroutine
COMMENTS        : Any data received before calling this function is ignored
-----------------------------------------------------------------------------*/
#ifdef SCI_ITDRV_WITHOUTBUF_RX
void SCI_GetBuffer(unsigned char *PtrtoBuffer,unsigned char NbOfBytes) 
{
    PtrToSCIBuffRx = PtrtoBuffer;/*Copies user buffer to the global variable */
    SCI_Rx_Buff = NbOfBytes;
    SCI_Rx_Buff++;
    SCI_Error = 0x00;                                     
    SCICR2 |= (unsigned char)RDRF;    /*Enable Interrupt*/    
}                                                         

#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME    : SCI_IsReceptionCompleted
INPUT           : None
OUTPUT          : Error Status
DESCRIPTION     : Returns the error status occurred during the reception in the
                  interrupt subroutine if the reception is completed.
COMMENTS        : Must be called after SCI_GetBuffer and SCI_GetString in 
                  Interrupt Driven mode to get the reception status.
                  Must be called before SCI_GetByte in interrupt Driven mode.
-----------------------------------------------------------------------------*/
SCI_RxError_t SCI_IsReceptionCompleted (void)  
{   
#if defined SCI_ITDRV_WITHOUTBUF_RX          
//    SCI_Pol_Stat = 0;          

    if ((SCI_Error == 0) && (SCI_Rx_Buff > 1)) 
                                        /*Buffer Reception request undergoing*/
    {   
        return(SCI_BUFFER_ONGOING) ;
    }
    else if ((SCI_Rx_Buff == 0) && (SCI_Pol_Stat == 0))	
                                                   /*Single Byte not received*/
    {
        return (SCI_RX_DATA_EMPTY);	
    }
    else                                             /*Reception is completed*/
    {       
        SCI_Pol_Stat = 0; 
        SCI_Rx_Buff = 0;
        return (SCI_Error);
    }		   
#else 
        return (SCI_RX_DATA_EMPTY);                  /*Dummy return statement*/
#endif		
}     

/*-----------------------------------------------------------------------------
ROUTINE NAME    : SCI_ISR
INPUT           : None
OUTPUT          : None
DESCRIPTION     : This function manages SCI communication when a SCI Interrupt 
								occurs.
COMMENTS        : None
-----------------------------------------------------------------------------*/
#ifdef _COSMIC_                                  /* Test for Cosmic Compiler */
@interrupt                                      /* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"                 /* Compiler Defines not found! */
#endif  

void  SCI_ISR (void)
{                                                 
/******************************************************************************
Reception in Interrupt Driven Without Buffer mode
******************************************************************************/

#ifdef SCI_ITDRV_WITHOUTBUF_RX 
    unsigned char temp;  
    
    if(SCISR & ORE)          /*If Interrupt is generated due to overrun error*/
    {
        SCI_Error = (unsigned char)(SCISR & SCI_ErrValue);
        *PtrToSCIBuffRx = SCIDR;	
        SCI_Pol_Stat = 2;
				PtrToSCIBuffRx++;  
    } 
    else if (SCISR & RDRF)
    {        
        if ((SCI_Rx_Buff > 1) && (SCI_Error == 0))
        {              
            SCI_Error = (unsigned char)(SCISR & SCI_ErrValue) ;  
            *PtrToSCIBuffRx = SCIDR;
            SCI_Rx_Buff--;  
            SCI_Pol_Stat = 2;                       /*If a buffer is received*/
            PtrToSCIBuffRx++;  
            if(SCI_Rx_Buff == 1)
            { 
                SCICR2 &= (unsigned char)(~RDRF);   //Disableinterrupt
            }    
        }
        else if ((SCI_Rx_Buff == 0) )  
       /*If interrupt is generated before calling SCI_GetBuffer/SCI_GetString*/
        {  
            SCI_Error = (unsigned char)(SCISR & SCI_ErrValue) ;  
            SCI_Rx_DATA = SCIDR;
            SCI_Pol_Stat = 1;
        }                    
        else
        {   
            SCI_Pol_Stat = 1;
            temp = SCIDR;
        }				
    }	
#endif 
}
/**** (c) 2005   STMicroelectronics *************************** END OF FILE **/ 