/******************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name :  sci.h 
Group            : MPA Systems Lab.
Author           : Telecom Team
Date First Issued: 01/09/2006 
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
********************************Documentation**********************************
General Purpose - Contains prototypes for all the functions of SCI

********************************Revision History*******************************
_______________________________________________________________________________
Date :01/09/2006  			Release:1.0
******************************************************************************/
#ifndef SCI_H
#define SCI_H  

#include "ST7_config.h" 

/*---------------------------------------------------------------------------*/
                                           /*Parameters for Control Register1*/

#define SCI_ErrValue 0x0f                         /*Error bits in SR register*/

#define SCI_RECEIVE_OVERRUN	0x20

#define SCI_TX_ENABLE	0x08

#define SCI_RX_ENABLE	0x04 


typedef enum {                                                  /*Error Types*/
	SCI_BUFFER_ONGOING		= (unsigned char) 0xff,
	SCI_RECEIVE_OK          = (unsigned char) 0x00,
	SCI_RX_DATA_EMPTY       = (unsigned char) 0xfd
	    }SCI_RxError_t;

/*---------------------------------------------------------------------------*/
                 /* Description of all the functions defined in this module. */
void SCI_Init ( void );      /*Initialises the SCI*/

void SCI_PutBuffer(const unsigned char*,unsigned char); 
                                                    /*Transmits a user buffer*/
                 /*Transmits a user buffer to hyperterminal on ASCII format */
void SCI_ASCIIDisplay (const unsigned char *, unsigned char);
unsigned char SCI_GetByte( void);               /*Receives a single data byte*/

#ifdef SCI_ITDRV_WITHOUTBUF_RX
void SCI_GetBuffer (unsigned char*,unsigned char);		
            /*Starts the reception in user buffer in the interrupt subroutine*/
#endif

SCI_RxError_t SCI_IsReceptionCompleted(void);	
              /*Checks if reception is completed and returns the error status*/

#endif

/**** (c) 2005   STMicroelectronics *************************** END OF FILE **/