/*****************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name : Main.c 
Group            : MPA Systems Lab.
Author           : Telecom Team
Date First Issued: 01/09/2006
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
********************************Documentation**********************************
General Purpose - Contains main source code. In this file, interface between PC
							and PMBus demo board is written. 

********************************Revision History*******************************
_______________________________________________________________________________
Date :01/09/2006                  Release:1.0 
******************************************************************************/

#include "ST7_config.h"                              /* Fcpu defined as 8MHz */
#include "main.h"     
#include "ST7_hr.h"

#pragma space extern [] @tiny
extern volatile unsigned int SMB_TimeCount;                /* Time count variable */

unsigned char Data_Status ; 
unsigned char Data_Display ; 
extern volatile unsigned char SMBus_Mode ;
@tiny volatile unsigned char PMBus_SlaveAdd ;
extern volatile unsigned char SMB_Err_Status ;                    /* Error status */
extern volatile unsigned char SMBus_PEC ;
extern volatile unsigned char SMB_Byte_Count ;   /* Variable to show data length */
volatile unsigned char SMB_GC_Counter ;   /* Variable to show data length */
volatile unsigned char SMB_GC_ByteCount ;   /* Variable to show data length */
extern volatile unsigned char SMB_PEC_Status ;                     /* CRC-8 result */

extern unsigned char Data_Buff [32] ;       /* Buffer to store data */
volatile unsigned char SlaveAdd_Buff [5] ;       /* Buffer to store command code for group command */
volatile unsigned char Command_Buff [5] ;       /* Buffer to store command code for group command */
unsigned char DataLength_Buff [5];
volatile unsigned char SMB_Byte_Count1 ;   /* Variable to show data length */

/*-----------------------------------------------------------------------------
ROUTINE NAME : Main
INPUT        : None
OUTPUT       : None
DESCRIPTION  : Main routine which receives commands from PC and interface with 
							demo board. Using this file, user can write/ read PMBus commands.
COMMENTS     : Programs jumpts into this routine when microcontroller is reset
-----------------------------------------------------------------------------*/
void main()
{           
	unsigned char temp,Rx_CmdCode, temp1 ;
	PMB_ErrCode_t PMBus_Err ;  /* To check errors in SCI reception */
	/*------------------ Local variables used in main.c -----------------------*/
	SCI_RxError_t SCI_Err ;  /* To check errors in SCI reception */
	
	/*----------------------- Port A configuration ----------------------------*/
	PADDR &= (unsigned char)~PORTA_DEFAULT;/* PA2 push pull output to drive LED*/
  PADDR = PORTA_DEFAULT ;         /* Other pins configured as floating input */
	PAOR = (unsigned char)(PORTA_DEFAULT | 0x08) ; /* For alert Interrupt */
	PADR = GLOW_LED ;
	PADR &= (unsigned char)~GLOW_LED ;
	
  /*----------------------- Port B configuration ----------------------------*/
	PBDDR = PORTB_DEFAULT;              /* PB [0:7] push pull low level output */
  PBOR = PORTB_DEFAULT; 
  PBDR &= (unsigned char)~PORTB_DEFAULT ;
	
  /*----------------------- Port C configuration ----------------------------*/
  PCDDR = CONTROL ;     /* PC0 floating input, others push pull output */
  PCOR = CONTROL ;
  PCDR = CONTROL ;

  /*----------------------- SCI configuration -------------------------------*/
	SCI_Init () ;      /* Initialise SCI */
                        /*Selects the transmission reception baudrate as 500k*/
	
	EnableInterrupts;                                 /* Resets interrupt mask */
	
                                    /* Enables Transmitter and receiver mode */
	SCICR2 |= (SCI_TX_ENABLE | SCI_RX_ENABLE) ; 
	
	MISCR1 = 0x00 ;  /* EI0 on falling edge low level */
	/*---------------------PMBus communication configuration-------------------*/
        /* I2C configuration: slave address 0x30, communication speed 100kHz */
	PMBus_Init (); 
	Data_Status = 0x80;
	/*---Continuous loop to receive commands from PC and PMBus communication---*/
	#ifdef test
	I2CCCR = 0x23 ;
	I2CCR |= START ;
	while (!(I2CSR1 & SB));
	I2CDR = 0x80 ;
	while (I2CSR1 & SB);
	while (!(I2CSR1 & EVF));
	I2CCR |= PE ;
	while (!(I2CSR1 & BTF));
	I2CDR = 0x01 ;
	while (!(I2CSR1 & BTF));
	I2CDR = 0xC0 ;
	while (!(I2CSR1 & BTF));
  I2CCR |= STOP; 
	while (I2CCR & STOP);
	Nop; 
	#endif
	
	while (1)            
	{
		SCI_PutBuffer(Msg_NewLine, 4) ;
		Display_Dash (); 				
						 /* Message "ST MICROELECTRONICS PMBUS DEMO" displayed */
		SCI_PutBuffer(Msg_Int,44);     
	
		Display_Dash (); 	
		SCICR2 |= (SCI_RECEIVE_OVERRUN) ;
		if (Data_Status == 0x80 )
		{
			#ifdef DISPLAY_HYPERTERMINAL
			SCI_PutBuffer(Msg_Enter,10);
			SCI_PutBuffer(Msg_ComSpeed,44);
			#endif
		/* Wait for the first communication speed selection*/
			
			do{
			SCI_Err = SCI_IsReceptionCompleted();
			}while (SCI_Err == SCI_RX_DATA_EMPTY);

			if(SCI_Err == SCI_RECEIVE_OK)  
			{                          /* Checking for validity of received byte */
				Rx_CmdCode = SCI_GetByte();                /*Correct Data Byte received*/
						
			  if (Rx_CmdCode == 0x31)
				{
					I2CCCR = I2C_SLOW_SPEED ;    /* 100kHz I2C communication speed */
				}
				else if (Rx_CmdCode == 0x32 )
				{
					I2CCCR = I2C_HIGH_SPEED ;          /* 400kHz I2C communication speed */
				}
			}
		#ifdef DISPLAY_HYPERTERMINAL
			SCI_PutBuffer(Msg_Enter,10);
			SCI_PutBuffer(Msg_PECSelection,40);
			#endif
		/* Wait for the first communication speed selection*/
	
			do{
			SCI_Err = SCI_IsReceptionCompleted();
			}while (SCI_Err == SCI_RX_DATA_EMPTY);

			if(SCI_Err == SCI_RECEIVE_OK)  
			{                          /* Checking for validity of received byte */
				Rx_CmdCode = SCI_GetByte();                /*Correct Data Byte received*/
						
				if (Rx_CmdCode == 0x31)
				{
					SMBus_PEC = PEC_ENABLE ;         /* Packet error checking enabled */
				}
				else if (Rx_CmdCode == 0x32)
				{
					SMBus_PEC = PEC_DISABLE ;        /* Packet error checking disabled */
				}
			}
		
			#ifdef DISPLAY_HYPERTERMINAL
			SCI_PutBuffer(Msg_Enter,10);
			SCI_PutBuffer(Msg_SlAd,17);
			#endif
		/* Wait for the first command code reception*/
	
			do{
			SCI_Err = SCI_IsReceptionCompleted();
			}while (SCI_Err == SCI_RX_DATA_EMPTY);

			if(SCI_Err == SCI_RECEIVE_OK)  
			{                          /* Checking for validity of received byte */
				Rx_CmdCode = SCI_GetByte();                /*Correct Data Byte received*/
						
				Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
					
				PMBus_SlaveAdd = Rx_CmdCode ;
																/* Wait for the second command code reception*/
				do{
					SCI_Err = SCI_IsReceptionCompleted();
				} while (SCI_Err == SCI_RX_DATA_EMPTY);
				if(SCI_Err == SCI_RECEIVE_OK)  
				{                      /* Checking for validity of received byte */
					Rx_CmdCode = SCI_GetByte();                /*Correct Data Byte received*/
					Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
					PMBus_SlaveAdd = (unsigned char) (PMBus_SlaveAdd << 4) ;
					PMBus_SlaveAdd |= (unsigned char) Rx_CmdCode ;
				}
			}
		}
		Data_Status = 0; 
		
		if (SMBus_Mode == SMB_ARA)
		{
			SMBus_Mode = (unsigned char) SMB_BYTE_NC ; 
			Enable_I2C ();
		
			PMBus_Err |= SMBm_ReceiveByte (ALERTRESPONSEADD, Command_Buff);
			if (!(PMBus_Err)){
				PMBus_SlaveAdd = *Command_Buff ; 
				SMBus_Mode &= (unsigned char) ~SMB_ARA ;
			}
			PAOR |= 0x08 ; /* To enable Alert interrupt so that master can process */
		}
		
		PBDR |= (unsigned char) (PWRGD | OUTEN ) ;
	   /*------------ Messages to display in PC Hyperterminal ---------------*/
		#ifdef DISPLAY_HYPERTERMINAL
		SCI_PutBuffer(Msg_Press,10);     /* Message "Press 0 to Read" displayed */
		SCI_PutBuffer(Msg_Read,9);       
		
		SCI_PutBuffer(Msg_Press,10);     /* Message "Press 1 to Write" displayed */
		SCI_PutBuffer(Msg_Write,10);
		
		SCI_PutBuffer(Msg_Press,10);		/* Message "Press 0 then * to read all "*/
		SCI_PutBuffer(Msg_GroupCommand,23); 
		
		SCI_PutBuffer(Msg_Press,10);		/* Message "Press 0 then * to read all "*/
		SCI_PutBuffer(Msg_ReadAll,26);   
		SMB_PEC_Status = 0 ;
		#endif
		
		              /* Loop to wait for write/ read command reception from PC */
		do{
			SCI_Err = SCI_IsReceptionCompleted();
		} while (SCI_Err == SCI_RX_DATA_EMPTY);

		Rx_CmdCode = COMMAND_INIT ;		                        				
			
		if(SCI_Err == SCI_RECEIVE_OK)    /*Checking for validity of received byte*/
		{
			Rx_CmdCode = SCI_GetByte();                /*Correct Data Byte received*/

			if (Rx_CmdCode == COMMAND_READ)           /* Checking for read command */
			{
                           /* Message "Enter 2-digit command code" displayed */
				#ifdef DISPLAY_HYPERTERMINAL
				SCI_PutBuffer(Msg_Enter,10);
				SCI_PutBuffer(Msg_CCode,16);													 
				#endif
																 /* Wait for the first command code reception*/
				do{
					SCI_Err = SCI_IsReceptionCompleted();
				} while (SCI_Err == SCI_RX_DATA_EMPTY);


				Rx_CmdCode = COMMAND_INIT ;		                    

				if(SCI_Err == SCI_RECEIVE_OK)  
				{                          /* Checking for validity of received byte */
					Rx_CmdCode = SCI_GetByte();           /*Correct Data Byte received */
					Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
					Command_Code = Rx_CmdCode ;
																/* Wait for the second command code reception*/
					do{
					SCI_Err = SCI_IsReceptionCompleted();
					} while (SCI_Err == SCI_RX_DATA_EMPTY);
	
					if(SCI_Err == SCI_RECEIVE_OK)  
					{                      /* Checking for validity of received byte */
						Rx_CmdCode = SCI_GetByte();          /*Correct Data Byte received */
						Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
						Command_Code = (unsigned char) (Command_Code << 4) ;
						Command_Code |= (unsigned char) Rx_CmdCode ;
						#ifdef DISPLAY_HYPERTERMINAL							
						Msg_OffsetRead (); 
						#endif
						if (Msg_Offset == 255)
						{
							#ifdef DISPLAY_HYPERTERMINAL	
							SCI_PutBuffer(Msg_Inv,23);
							#endif
						}
						else
						{							
							PMBus_CommandRead (Data_Buff);   /* Byte read */							
							if (!(SMB_Err_Status))
							{							
								Data_Display = 0x07 ;
								Display_ReadCommand () ;
							}
						}                 
					}
				} 
			}
																		/* Checking for write command */
			else if ((Rx_CmdCode == COMMAND_WRITE))
			{
				temp1 = Rx_CmdCode ;
				
				SCI_PutBuffer(Msg_Enter,10);
				SCI_PutBuffer(Msg_CCode,16);
				do{
					SCI_Err = SCI_IsReceptionCompleted();
				} while (SCI_Err == SCI_RX_DATA_EMPTY);
	
				Rx_CmdCode = COMMAND_INIT ;		

				if(SCI_Err == SCI_RECEIVE_OK)  
				{              /* Checking for validity of received byte */
					Rx_CmdCode = SCI_GetByte();/*Correct Data Byte received */ 

					Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
					Command_Code = Rx_CmdCode ;
																/* Wait for the second command code reception*/
					do{
						SCI_Err = SCI_IsReceptionCompleted();
					} while (SCI_Err == SCI_RX_DATA_EMPTY);
					if(SCI_Err == SCI_RECEIVE_OK)  
					{                      /* Checking for validity of received byte */
						Rx_CmdCode = SCI_GetByte();          /*Correct Data Byte received */
						Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
						Command_Code = (unsigned char)(Command_Code << 4) ;
						Command_Code |= (unsigned char) Rx_CmdCode ;
						
						for (temp =0; temp <15; temp ++)
						{
							if (Command_Code == Cmd_Read_Buff [temp])
							{
								temp1 = 0;
								break ;
							}
							else
							{
								temp1 = 0xff ;
							}
						}
						if (temp1)
						{
						PMBus_DataLengthCalc ();
						if (SMBus_Mode & SMB_BYTE)
						{
							SCI_PutBuffer(Msg_Enter,10);
							SCI_PutBuffer(Msg_EData,22);						
							SCI_GetBuffer(Data_Buff,(unsigned char)(SMB_Byte_Count*2));  
				       /* To be sure that the communication by this point 
				                                     has been completed */													
							do {
								SCI_Err = SCI_IsReceptionCompleted();
							} while (SCI_Err == SCI_BUFFER_ONGOING);
							for (temp =0; temp < (SMB_Byte_Count*2); temp ++)
							{
								Data_Status =  *(Data_Buff+temp);
           		  Data_Status = ASCII_Converter (Data_Status);
								*(Data_Buff+temp) = Data_Status;
							}
							for (temp =0; temp < SMB_Byte_Count; temp ++)
							{
								Data_Status = *(Data_Buff + (temp * 2)) ;
								Data_Status = (unsigned char)(Data_Status << 4) ;
								Data_Status |= *(Data_Buff + ((temp * 2)+1));
								Data_Buff [temp] = Data_Status ;
							}
						}
						if ((Command_Code == 0x1A) || (Command_Code == 0xC0))
						{
							SMBus_Mode = (unsigned char)SMB_GC ;    
							temp = 0xff ;
						}
						else
						{
							temp = 0 ;
						}
						PMBus_CommandWrite (Data_Buff); 
						if (temp) 
						{
							PMBus_CommandRead (Data_Buff);   /* Byte read */							
							if (!(SMB_Err_Status))
							{							
								Data_Display = 0x07 ;
								Display_ReadCommand () ;
							}
						}
						}
						else
						{
							#ifdef DISPLAY_HYPERTERMINAL
							SCI_PutBuffer(Msg_Inv,23);
							#endif
						}
					}
				}		                                                
			}
			else if (Rx_CmdCode == COMMAND_GC)
			{
				SCI_PutBuffer(Msg_Enter,10);
				SCI_PutBuffer(Msg_PCT,23);
				SMB_GC_ByteCount = 0 ;
				
				for (temp1 = 0; temp1 <5; temp1 ++)
				{
					SCI_Err= 0 ;
					SCICR2 |= (SCI_RECEIVE_OVERRUN) ;
					
					SCI_PutBuffer(Msg_Enter,10);
					SCI_PutBuffer(Msg_SlAd,17);
					
					do{
						SCI_Err = SCI_IsReceptionCompleted();
					} while (SCI_Err == SCI_RX_DATA_EMPTY);
	
					if(SCI_Err == SCI_RECEIVE_OK)  
					{              /* Checking for validity of received byte */
						Rx_CmdCode = SCI_GetByte();/*Correct Data Byte received */ 
						if (Rx_CmdCode == 42)
						{
							temp1 = 5;
						}
						else
						{
						SMB_GC_Counter ++ ;
						Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
						PMBus_SlaveAdd = Rx_CmdCode ;
																/* Wait for the second command code reception*/
						do{
							SCI_Err = SCI_IsReceptionCompleted();
						} while (SCI_Err == SCI_RX_DATA_EMPTY);
						if(SCI_Err == SCI_RECEIVE_OK)  
						{                      /* Checking for validity of received byte */
							Rx_CmdCode = SCI_GetByte();          /*Correct Data Byte received */
							Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
							
							PMBus_SlaveAdd = (unsigned char)(PMBus_SlaveAdd << 4) ;
							PMBus_SlaveAdd |= (unsigned char) Rx_CmdCode ;
							
							SlaveAdd_Buff [temp1]= PMBus_SlaveAdd ;
					
							SCI_PutBuffer(Msg_Enter,10);
							SCI_PutBuffer(Msg_CCode,16);
					
							do{
								SCI_Err = SCI_IsReceptionCompleted();
							} while (SCI_Err == SCI_RX_DATA_EMPTY);
	
							if(SCI_Err == SCI_RECEIVE_OK)  
							{              /* Checking for validity of received byte */
								Rx_CmdCode = SCI_GetByte();/*Correct Data Byte received */ 
						
								Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
								Command_Code = Rx_CmdCode ;
																/* Wait for the second command code reception*/
								do{
									SCI_Err = SCI_IsReceptionCompleted();
								} while (SCI_Err == SCI_RX_DATA_EMPTY);
								if(SCI_Err == SCI_RECEIVE_OK)  
								{                      /* Checking for validity of received byte */
									Rx_CmdCode = SCI_GetByte();          /*Correct Data Byte received */
									Rx_CmdCode = ASCII_Converter (Rx_CmdCode); 
									Command_Code = (unsigned char)(Command_Code << 4) ;
									Command_Code |= (unsigned char) Rx_CmdCode ;
							
									Command_Buff [temp1]= Command_Code ;
									PMBus_DataLengthCalc ();
									DataLength_Buff [temp1]= SMB_Byte_Count ;
							
									if (SMBus_Mode & SMB_BYTE)
									{
										SCI_PutBuffer(Msg_Enter,10);
										SCI_PutBuffer(Msg_EData,22);						
										SCI_GetBuffer((Data_Buff + SMB_GC_ByteCount ),(unsigned char)(SMB_Byte_Count*2));  
				       /* To be sure that the communication by this point 
				                                     has been completed */													
										do {
											SCI_Err = SCI_IsReceptionCompleted();
										} while (SCI_Err == SCI_BUFFER_ONGOING);
								
										for (temp =0; temp < (SMB_Byte_Count*2); temp ++)
										{
											Data_Status =  *(Data_Buff+ SMB_GC_ByteCount + temp);
											Data_Status = ASCII_Converter (Data_Status);
											*(Data_Buff + SMB_GC_ByteCount + temp ) = Data_Status;
										}
										for (temp =0; temp < SMB_Byte_Count; temp ++)
										{
											Data_Status = *(Data_Buff + SMB_GC_ByteCount + (temp * 2)) ;
											Data_Status = (unsigned char)(Data_Status << 4) ;
											Data_Status |= *(Data_Buff + SMB_GC_ByteCount+ ((temp * 2)+1));
											Data_Buff [temp + SMB_GC_ByteCount] = Data_Status ;
										}
										SMB_GC_ByteCount += SMB_Byte_Count ;
									}
								}
							}
						}
						}
					}	
				}
				temp1 = 0 ;
				if (SMB_GC_Counter >= 1)
				{
				for (temp = 0; temp <SMB_GC_Counter ; temp ++)
				{
					SMBus_Mode = SMB_NO_PROTOCOL;
					if (temp != (SMB_GC_Counter-1))
					{
						SMBus_Mode = (unsigned char)SMB_GC ;    
					}
					
					PMBus_SlaveAdd = SlaveAdd_Buff [temp] ;
					SMB_Byte_Count = DataLength_Buff [temp];
					Command_Code = (unsigned char)Command_Buff[temp];
					//if (PMBus_SlaveAdd != 0)
					//{
						PMBus_Err = PMBus_CommandWrite ((Data_Buff + temp1)); 
						
					//}
					temp1 = (unsigned char) (temp1 + (unsigned char) DataLength_Buff [temp]) ;
					//SlaveAdd_Buff [temp] = 0; 
				}
				}				
				SMB_GC_Counter = 0 ;
				SMB_GC_ByteCount = 0 ;
			}
			else if (Rx_CmdCode == COMMAND_WDG)      /* Checking for read all command */
			{
                                 /* Wait for the first command code reception*/
				Data_Display = 0x02 ;
				Display_ReadCommand () ;
				for (temp =0; temp < 38; temp++)
				{
					Command_Code = Msg_Offset_Buff [temp];
					Msg_OffsetRead (); 
					PMBus_CommandRead (Data_Buff); 
					if (SMB_Err_Status)
					{
						temp = 38 ; 
					}
					else
					{
						Data_Display = 0x04 ;
						Display_ReadCommand () ;                        
					}	
				}
				
			}	
			else
			{
				#ifdef DISPLAY_HYPERTERMINAL
				SCI_PutBuffer(Msg_Inv,23);
				#endif
			}
		}	
		else
		{
			#ifdef DISPLAY_HYPERTERMINAL
			SCI_PutBuffer(Msg_Inv,23);
			#endif
		}
		if ((SMB_Err_Status)|| (PMBus_Err))
		{
			SCI_PutBuffer(Msg_Err,23);		
			PMBus_Err = 0 ; 
			Data_Status = 0x80;
		}		
		
		SMBus_Mode = 0 ;
		SMB_Byte_Count = 0 ;
	}
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Msg_OffsetRead
INPUT        : None
OUTPUT       : None
DESCRIPTION  : Sets Offset for message display in read mode 
COMMENTS     : None
-----------------------------------------------------------------------------*/
void Msg_OffsetRead (void)
{
	unsigned char temp; 
	for (temp=0; temp<39; temp++)
	{
		if (temp ==38)
		{
			Msg_Offset = Msg_Offset_Buff [temp];
		}
		else if (Command_Code == Msg_Offset_Buff [temp])
		{
			Msg_Offset = temp ;
			temp = 39 ;
			break ;
		}
	}
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : ASCII_Converter
INPUT        : Data to be converted
OUTPUT       : Converted data
DESCRIPTION  : Check validity of received SCI Byte and converts to hex code 
COMMENTS     : None
-----------------------------------------------------------------------------*/
unsigned char ASCII_Converter (unsigned char temp)
{
	if (temp > 64)
	{
		temp = (unsigned char)(temp - 55) ;
	}
	else if ((temp > 47) &&(temp < 58))
	{
		temp = (unsigned char)(temp - 48) ;
	}
	else
	{
		#ifdef DISPLAY_HYPERTERMINAL
		SCI_PutBuffer(Msg_Inv,23);
		#endif
	} 
	return (temp) ; 
}

/*----------------------------------- ------------------------------------------
ROUTINE NAME : Display_ReadCommand
INPUT        : None
OUTPUT       : None
DESCRIPTION  : Display read commands thro' PMBus
COMMENTS     : None
-----------------------------------------------------------------------------*/
void Display_ReadCommand (void)
{
	unsigned char temp ; 
	#ifdef DISPLAY_HYPERTERMINAL
	if (Data_Display 	& 0x02)
	{
		SCI_PutBuffer(Msg_NewLine,4);
		SCI_PutBuffer(Msg_PMBusCode,16);
		
		SCI_PutBuffer(Msg_CName, 14) ;
		
		SCI_PutBuffer(Msg_Space,1);	  
		SCI_PutBuffer(Msg_DLength,7);
							
		SCI_PutBuffer(Msg_Data,6);							               
		SCI_PutBuffer(Msg_NewLine,4);
		Display_Dash (); 
	}	
	if (Data_Display 	& 0x04)
	{
		SCI_PutBuffer(Msg_NewLine,4);
		Data_Status = 1 ; 
		SCI_ASCIIDisplay((unsigned char *)&Command_Code,1);
		Data_Status = 0 ; 
		SCI_PutBuffer(Msg_Tab,4);
		
		SCI_PutBuffer((Msg_1 + 15 * Msg_Offset),15);	
		
		SCI_PutBuffer(Msg_Space,2);	  
		SCI_ASCIIDisplay((unsigned char *)&SMB_Byte_Count1,1);			
		SCI_PutBuffer(Msg_Space,4);	  
		Data_Status = 1 ; 
		SCI_ASCIIDisplay(Data_Buff,SMB_Byte_Count1);	
		Data_Status = 0 ; 
		SCI_PutBuffer(Msg_NewLine,4);
	}
	#endif
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : Display_ReadCommand
INPUT        : None
OUTPUT       : None
DESCRIPTION  : Display read commands thro' PMBus
COMMENTS     : None
-----------------------------------------------------------------------------*/
void Display_Dash (void)
{
	unsigned char temp ;
	for (temp = 0 ; temp < 36; temp ++)
	{
		SCI_PutBuffer(Msg_Dash,2);
	}
}	
	

/*** (c) 2005   STMicroelectronics ****************** END OF FILE ************/