/*****************************************************************************
COPYRIGHT 2005 STMicroelectronics
Source File Name : Main.h 
Group            : MPA Systems Lab.
Author           : Telecom Team
Date First Issued: 01/09/2006
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
********************************Documentation**********************************
General Purpose - This file contains prototypes of functions written in main.c. 
	The command variables are also defined in this file.  

********************************Revision History*******************************
_______________________________________________________________________________
Date :01/09/2006                  Release:1.0 
******************************************************************************/

#ifndef MAIN_H
#define MAIN_H

#include "ST7_config.h" 

/*--------------Declaration of functions prototype used in main.c -------------*/
void Msg_OffsetRead (void);
unsigned char ASCII_Converter (unsigned char) ;
void Display_ReadCommand (void);
void Display_Dash (void);

/*---------------Declaration of global variables used in Main ---------------*/
#pragma space extern [] @tiny
volatile unsigned char Msg_Offset ;              /* Offset of message buffer */
extern volatile unsigned char Command_Code;/* Variable to store command code */


#pragma section const () 

const unsigned char ComCode_DataLength_Buff [38] = {1,1,1,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,1,2,1,1,1,1,2,2,2,1,7,6,6,6,6,6,1,1,2,2};

const unsigned char Msg_Offset_Buff [39] = {0x01,0x02,0x20,0x21,0x24,0x25,0x26,0x42,0x43,0x46,0x4A,0x4F,0x50,0x51,0x60,0x61,0x64,0x65,0x78,0x79,0x7A,0x7B,0x7D,0x80,0x8B,0x8C,0x8D,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0xD0,0xD1,0x1A, 0xC0, 0xFF};

const unsigned char Cmd_Read_Buff [15] = {0x78,0x79,0x7A,0x7B,0x7D,0x80,0x8B,0x8C,0x8D,0x98,0x99,0x9A,0xD0,0xD1,0xFF};


#ifdef DISPLAY_HYPERTERMINAL

/*---------------Declaration of messages to be displayed in PC --------------*/
const unsigned char Msg_Int[44] = "\n\r\t\t\tST MICROELECTRONICS PMBUS DEMO\n\r";
const unsigned char Msg_ComSpeed [44] = "1 for 100kHz and 2 for 400kHz Comm Speed\n\r";
const unsigned char Msg_PECSelection [40] = "1 to Enable PEC and 2 to Disable PEC\n\r";
const unsigned char Msg_SlAd[17] = "Slave Address\n\r";
const unsigned char Msg_Read[9] = "1 to Read" ; 
const unsigned char Msg_Write[10] = "2 to Write" ; 

const unsigned char Msg_GroupCommand [23] = "3 for Group commands" ;
const unsigned char Msg_PCT [23] = "* to end group commands" ;
const unsigned char Msg_Err[23] = "\n\rPMBus Comm Time-out" ; 
const unsigned char Msg_ReadAll[26] = "0 to read all commands\n\r" ; 
const unsigned char Msg_CCode[16]= "command code\n\r"; 
const unsigned char Msg_EData[22]= "Data in Hex format\n\r"; 
const unsigned char Msg_Inv[23]= "\n\rCommand Invalid\n\r"; 
const unsigned char Msg_PMBusCode[16]= "\n\rCommand Code"; 
const unsigned char Msg_DLength[7]= "\tBytes"; 
const unsigned char Msg_Data[6]= "\tData";  
const unsigned char Msg_Dash[2]= "--";  
const unsigned char Msg_NewLine[4]= "\n\r";  
const unsigned char Msg_Tab[4]= "\t\t";  
const unsigned char Msg_Space[4]= "    ";  
const unsigned char Msg_Enter[10]= "\n\rEnter ";  
const unsigned char Msg_Press[10]= "\n\rPress ";  


/*------------------Mapping of display message in Flash ---------------------*/
const unsigned char Msg_CName[14] = "\tCommand Name"; 

/*---------------Declaration of messages to be displayed in PC --------------*/
const unsigned char Msg_1 [15]= "OPERATION      "; 
const unsigned char Msg_2 [15]= "ON_OFF_CONFIG  "; 
const unsigned char Msg_3 [15]= "VOUT_MODE      "; 
const unsigned char Msg_4 [15]= "VOUT_COMMAND   "; 
const unsigned char Msg_5 [15]= "VOUT_MAX       "; 
const unsigned char Msg_6 [15]= "VOUT_MARGIN_HIG"; 
const unsigned char Msg_7 [15]= "VOUT_MARGIN_LOW"; 
const unsigned char Msg_8 [15]= "VOUT_OV_WARN_LM"; 
const unsigned char Msg_9 [15]= "VOUT_UV_WARN_LM"; 
const unsigned char Msg_10 [15]= "IOUT_OC_FAULT_L"; 
const unsigned char Msg_11 [15]= "IOUT_OC_WARN_LM"; 
const unsigned char Msg_12 [15]= "OT_FAULT_LIMIT "; 
const unsigned char Msg_13 [15]= "OT_FAULT_RESPON"; 
const unsigned char Msg_14 [15]= "OT_WARN_LIMIT  "; 
const unsigned char Msg_15 [15]= "TON_DELAY      ";
const unsigned char Msg_16 [15]= "TON_RISE       "; 
const unsigned char Msg_17 [15]= "TOFF_DELAY     "; 
const unsigned char Msg_18 [15]= "TOFF_FALL      "; 
const unsigned char Msg_19 [15]= "STATUS_BYTE    "; 
const unsigned char Msg_20 [15]= "STATUS_WORD    "; 
const unsigned char Msg_21 [15]= "STATUS_VOUT    "; 
const unsigned char Msg_22 [15]= "STATUS_IOUT    "; 
const unsigned char Msg_23 [15]= "STATUS_TEMPERAT"; 
const unsigned char Msg_24 [15]= "STATUS_MFR_SPEF"; 
const unsigned char Msg_25 [15]= "READ_VOUT      "; 
const unsigned char Msg_26 [15]= "READ_IOUT      "; 
const unsigned char Msg_27 [15]= "READ_TEMPERATUR"; 
const unsigned char Msg_28 [15]= "PMBUS_REVISION "; 
const unsigned char Msg_29 [15]= "MFR_ID         "; 
const unsigned char Msg_30 [15]= "MFR_MODEL      "; 
const unsigned char Msg_31 [15]= "MFR_REVISION   "; 
const unsigned char Msg_32 [15]= "MFR_LOCATION   "; 
const unsigned char Msg_33 [15]= "MFR_DATE       "; 
const unsigned char Msg_34 [15]= "MFR_SERIAL     "; 
const unsigned char Msg_35 [15]= "MFR_SPECIFIC_00"; 
const unsigned char Msg_36 [15]= "MFR_SPECIFIC_01"; 

#endif 

#endif  

/*** (c) 2005   STMicroelectronics ****************** END OF FILE ************/