/*;******************* (C) COPYRIGHT 2006 STMicroelectronics ***************************************
;* File Name               : Startup.s													
;* Date First Issued       : 05/18/2006 : Version 1.0 	                                                                                    
;* Author                  : MCD Tools 					              
;* Description             : This file contains optimized Startup file and Vect file functions for 
;*			    					  GCC-arm compiler.It has been designed by ST Microelectronics and ported 
;*	                          to AS-ARM    
;*		      	  				  On reset, the ARM core starts up in Supervisor (SVC) mode,
;*		      	  				  in ARM state,with IRQ and FIQ disabled.
;***************************************************************************************************
;* History:																	        
;*05/22/2007 : Version 1.2
;*05/24/2006 : Version 1.1
;*05/18/2006 : Version 1.0
;***************************************************************************************************
;* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH
;* CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
;* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT
;* OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT
;* OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION
;* CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
;**************************************************************************************************/
	
/*; At power up, the CPU defaults to run on the oscillator clock, so Depending 
; of your Application,Disable or Enable the following Define*/
		
		.equ   PLL_Clock, 1		/*; Use PLL as the default clock source @ 96 MHz */
		                        /* only with Bank 0 @ 0x0 and Bank 1 @ 0x80000*/
		/*.equ   RTC_Clock, 1     /*; Use RTC as the default clock source*/
		/*.equ   OSC_Clock, 1     /*; Use OSC as the default clock source*/

.ifndef PLL_Clock
	.equ	PLL_Clock, 0
.endif  
.ifndef RTC_Clock 
	.equ	RTC_Clock , 0
.endif 
.ifndef OSC_Clock 
	.equ	OSC_Clock , 0
.endif   
                         
							  
/* --- Standard definitions of Mode bits and Interrupt (I & F) flags in PSRs --- */

	.equ	Mode_USR,		0x10
	.equ	Mode_FIQ,		0x11
	.equ	Mode_IRQ,		0x12
	.equ	Mode_SVC,		0x13
	.equ	Mode_ABT,		0x17
	.equ	Mode_UND,		0x1B
	.equ	Mode_SYS,		0x1F				/* available on ARM Arch 4 and later */

	.equ	I_Bit,			0x80				/* when I bit is set, IRQ is disabled */
	.equ	F_Bit,			0x40				/* when F bit is set, FIQ is disabled */

	.equ	SRAM32,			0x00
	.equ	SRAM64,			0x08
	.equ	SRAM96,			0x10


/* --- STR9X SCU specific definitions---*/
	.equ	SCU_BASE_Address,       0x5C002000 		/*; SCU Base Address */
	.equ	SCU_CLKCNTR_OFST,       0x00000000 		/*; Clock Control register Offset*/
	.equ	SCU_PLLCONF_OFST,       0x00000004 		/*; PLL Configuration register Offset*/
	.equ	SCU_SYSSTATUS_OFST,     0x00000008 		/*; System Status Register Offset*/
	.equ	SCU_SCR0_OFST,          0x00000034 		/*; System Configuration Register 0 Offset*/

/* --- STR9X FMI specific definitions --- */
	.equ	FMI_BASE_UMB,		   0x54000000		/* Flash FMI base address (unbuffered) */
	.equ	BBSR_off_addr,		   0x00				/*Boot Bank Size Register*/
	.equ	NBBSR_off_addr,	 	   0x04				/*Non-boot Bank Size Register*/
	.equ	BBADR_off_addr,		   0x0C				/*Boot Bank Base Address Register*/
	.equ	NBBADR_off_addr,	   0x10				/*Non-boot Bank Base Address Register*/
	.equ	CR_off_addr,		   0x18				/*Control Register*/


.extern main
/* These variables are declared in str91xcommon.id file and they correspond to the addresses for vector table*/
.extern VIC0VECT								/*call this const from Common.id linker -->	0xFFFFF030*/
.extern VIC1VECT								/*call this const from Common.id linker-->	0xFC000030*/

/* the following are useful for initializing the .data section */
.extern _sidata 								/* start address for the initialization values of the .data section. defined in linker script */
.extern _sdata 									/* start address for the .data section. defined in linker script */
.extern _edata 									/* end address for the .data section. defined in linker script */

/* the following are useful for initializing the .bss section */
.extern _sbss 									/* start address for the .bss section. defined in linker script */
.extern _ebss 									/* end address for the .bss section. defined in linker script */
/* Startup Code must be linked first at Address at which it expects to run. */



/* --- System memory locations */

/* init value for the stack pointer. defined in linker script */
.extern _estack

/* Stack Sizes. The default values are in the linker script, but they can be overriden. */
.extern _UND_Stack_Init
.extern _SVC_Stack_Init
.extern _ABT_Stack_Init
.extern _FIQ_Stack_Init
.extern _IRQ_Stack_Init
.extern _USR_Stack_Init

.extern _UND_Stack_Size
.extern _SVC_Stack_Size
.extern _ABT_Stack_Size
.extern _FIQ_Stack_Size
.extern _IRQ_Stack_Size
.extern _USR_Stack_Size

SVC_Stack           =     _SVC_Stack_Init					/*_estack*/           /* 256 byte SVC stack at*/
																		                      /* top of memory */
                                              
IRQ_Stack           =     _IRQ_Stack_Init 				/*SVC_Stack - 256*/   /*; followed by IRQ stack */
USR_Stack           =     _USR_Stack_Init 				/*IRQ_Stack-1024*/    /*; followed by USR stack */
FIQ_Stack           =     _FIQ_Stack_Init				   /*USR_Stack-1024*/    /*; followed by FIQ stack*/
ABT_Stack           =     _ABT_Stack_Init					/*FIQ_Stack-256*/     /*; followed by ABT stack */
UNDEF_Stack         =     _UND_Stack_Init 				/*ABT_Stack-256*/     /*; followed by UNDEF stack */

/*******************************************************************************
;                     Import exception handlers
********************************************************************************/

        .extern  Undefined_Handler
        .extern  SWI_Handler
        .extern  Prefetch_Handler
        .extern  Abort_Handler
        .extern  FIQ_Handler		
/*******************************************************************************
;            Export Peripherals IRQ handlers table address
********************************************************************************/

	.global _start	
	.globl _startup
	.global	Reset_Vec
	.arm

/* --- Copy the vector table in the flash --- */	
    .section .flashtext,"ax",%progbits
_startup:
/* Note: LDR PC instructions are used here, though branch (B) instructions */
/* could also be used, unless the FLASH is at an address >32MB. */
/*******************************************************************************
                        Exception vectors
*******************************************************************************/

Reset_Vec:	LDR     pc, Reset_Addr		/* Reset Handler */
Undef_Vec:	LDR     pc, Undefined_Addr
SWI_Vec:	   LDR     pc, SWI_Addr
PAbt_Vec:	LDR     pc, Prefetch_Addr
DAbt_Vec:	LDR     pc, Abort_Addr
			   NOP							/* Reserved vector */
IRQ_Vec:	   LDR     pc, IRQ_Addr
/*******************************************************************************
* Function Name  : FIQHandler
* Description    : This function is called when FIQ
                   exception is entered.
* Input          : none
* Output         : none
*******************************************************************************/
FIQHandler:
       SUB    lr,lr,#4        /*; Update the link register.*/
       STMFD  sp!,{r0-r7,lr}  /*; Save The workspace plus the current return*/
                              /*; address lr_fiq into the FIQ stack.*/
       ldr r0,=FIQ_Handler
       ldr lr,=FIQ_Handler_end
       bx r0                  /*;Branch to FIQ_Handler.*/
FIQ_Handler_end:

      LDMFD   sp!,{r0-r7,pc}^ /*; Return to the instruction following...*/
                              /*; ...the exception interrupt.*/

/*******************************************************************************
               Exception handlers address table
*******************************************************************************/

Reset_Addr:		.long	_start
Undefined_Addr:.long	UndefinedHandler
SWI_Addr:		.long	SWIHandler
Prefetch_Addr:	.long	PrefetchHandler
Abort_Addr:		.long	AbortHandler
				   .long	0				/* reserved */
IRQ_Addr:		.long	IRQHandler

.text
/********************************************************************************
;                                  MACRO
********************************************************************************/
/*******************************************************************************
* Macro Name     : SaveContext
* Description    : This macro used to save the context before entering
                           an exception handler.
* Input          : The range of registers to store.
* Output         : none
*******************************************************************************/

.macro	SaveContext reg1 reg2
		STMFD	sp!,{\reg1-\reg2,lr}	/* Save The workspace plus the current return */
										   /* address lr_ mode into the stack */
		MRS		r1, spsr				/* Save the spsr_mode into r1 */
		STMFD	sp!, {r1}				/* Save spsr */
.endm
/*******************************************************************************
* Macro Name     : RestoreContext
* Description    : This macro used to restore the context to return from
                          an exception handler and continue the program execution.
* Input          : The range of registers to restore.
* Output         : none
*******************************************************************************/

.macro	RestoreContext reg1 reg2
		LDMFD	sp!, {r1}				/* Restore the saved spsr_mode into r1 */
		MSR		spsr_cxsf, r1			/* Restore spsr_mode */
		LDMFD	sp!, {\reg1-\reg2,pc}^	/* Return to the instruction following */
										/* the exception interrupt */
.endm

/*******************************************************************************
                         Exception Handlers
*******************************************************************************/
/*******************************************************************************
* Function Name  : UndefinedHandler
* Description    : This function called when undefined instruction
                   exception is entered.
* Input          : none
* Output         : none
*******************************************************************************/
UndefinedHandler:
        SaveContext r0,r12    /*; Save the workspace plus the current*/
                              /*; return address lr_ und and spsr_und.*/

       ldr r0,=Undefined_Handler
       ldr lr,=Undefined_Handler_end
       bx r0                  /*; Branch to Undefined_Handler.*/

Undefined_Handler_end:
        RestoreContext r0,r12 /*; Return to the instruction following...*/
                              /*; ...the undefined instruction.*/
/*******************************************************************************
* Function Name  : SWIHandler
* Description    : This function called when SWI instruction executed.
* Input          : none
* Output         : none
*******************************************************************************/
SWIHandler:
        SaveContext r0,r12    /*; Save the workspace plus the current*/
                              /*; return address lr_ svc and spsr_svc.*/

        ldr r0,=SWI_Handler
        ldr lr,=SWI_Handler_end
        bx r0                 /*; Branch to SWI_Handler.*/

SWI_Handler_end:
        RestoreContext r0,r12 /*; Return to the instruction following...*/
                              /*; ...the SWI instruction.*/
/*******************************************************************************
* Function Name  : PrefetchHandler
* Description    : This function called when Prefetch Abort
                   exception is entered.
* Input          : none
* Output         : none
*******************************************************************************/		
PrefetchHandler:
        SUB    lr,lr,#4       /*; Update the link register.*/
        SaveContext r0,r12    /*; Save the workspace plus the current*/
                              /*; return address lr_abt and spsr_abt.*/

       ldr r0,=Prefetch_Handler
       ldr lr,=Prefetch_Handler_end
       bx r0                 /*; Branch to Prefetch_Handler.*/

Prefetch_Handler_end:
        RestoreContext r0,r12 /*; Return to the instruction following that...*/
                              /*; ...has generated the prefetch abort exception.*/
/*******************************************************************************
* Function Name  : AbortHandler
* Description    : This function is called when Data Abort
                   exception is entered.
* Input          : none
* Output         : none
*******************************************************************************/

AbortHandler:
        SUB    lr,lr,#8       /*; Update the link register.*/
        SaveContext r0,r12    /*; Save the workspace plus the current*/
                              /*; return address lr_ abt and spsr_abt.*/
       ldr r0,=Abort_Handler
       ldr lr,=Abort_Handler_end
       bx r0                 /*; Branch to Abort_Handler.*/

Abort_Handler_end:

        RestoreContext r0,r12 /*; Return to the instruction following that...*/
                              /*; ...has generated the data abort exception.*/
/*******************************************************************************
* Function Name  : IRQHandler
* Description    : This function called when IRQ exception is entered.
* Input          : none
* Output         : none
*******************************************************************************/

IRQHandler:
      SUB    lr, lr, #4				   /* Update the link register */
SaveContext r0, r12				/* Save the workspace plus the current */
										/* return address lr_irq and spsr_irq */
      LDR    r0, =VIC0VECT
      LDR    r0, [r0]					/* Read the routine address */
      LDR    r1, =VIC1VECT
      LDR    r1, [r1]
    /* Padding between the acknowledge and re-enable of interrupts */
    /* For more details, please refer to the following URL */
    /* http://www.arm.com/support/faqip/3682.html */
      NOP
      NOP
      MSR    cpsr_c,#0x1F            /*; Switch to SYS mode and enable IRQ*/
      STMFD  sp!,{lr}                /*; Save the link register.*/
      LDR    lr, =ReturnAddress 	  /*; Read the return address.*/
      BX     r0                      /*; Branch to the IRQ handler.*/
ReturnAddress:
      LDMFD	sp!, {lr}						/* Restore the link register. */
      MSR		cpsr_c, #Mode_IRQ|I_Bit|F_Bit	/* Switch to IRQ mode and disable IRQ */
      LDR		r0, =VIC0VECT			/* Write to the VectorAddress to clear the */
      STR		r0, [r0]				   /* respective interrupt in the internal interrupt */
      LDR		r1, =VIC1VECT			/* Write to the VectorAddressDaisy to clear the */
      STR		r1, [r1]				   /* respective interrupt in the internal interrupt */
RestoreContext r0, r12			/* Restore the context and return to the program execution. */

/******************************************************************************
;*
;*
;* Description    : Startup Code (executed after Reset) 
;*
;*****************************************************************************/

_start:
		LDR     pc, =NextInst
NextInst:

		NOP		/* Wait for OSC stabilization */
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP





  /*; -------------------------------------------------------------------------------------------------
	; Description  :   Enable the Buffered mode.
	;                 Just enable the buffered define on the 91x_conf.h
	;		      http://www.arm.com/pdfs/DDI0164A_966E_S.pdf 
	; -------------------------------------------------------------------------------------------------*/

      MRC     p15, 0, r0, c1, c0, 0   /*; Read CP15 register 1 into r0*/
      ORR     r0, r0, #0x8            /*; Enable Write Buffer on AHB*/
      MCR     p15, 0, r0, c1, c0, 0   /*; Write CP15 register 1*/




/* Remap Flash Bank 0 at address 0x0 and Bank 1 at address 0x80000, */
/* when the bank 0 is the boot bank, then enable the Bank 1. */

		LDR		r0, =FMI_BASE_UMB
		
		LDR		r1, =_bb_size			/* configure 512KB Boot bank 0 */
		STR		r1, [r0, #BBSR_off_addr]

		
		LDR		r1, =_nbb_size			/* configure 32KB Non Boot bank 1 */
		STR		r1, [r0, #NBBSR_off_addr]
		
		
		LDR		r1, =(0x00000000 >> 2)		/* Boot Bank Base Address 0x0 */
		STR		r1, [r0, #BBADR_off_addr]

		
		LDR		r1, =_nbb_addr		/* Non Boot Bank Base Address 0x20000  ;The Flash Bank address NBBADDR[23:0] is a word address and is mapped to CPU core address A[25:2].*/
		STR		r1, [r0, #NBBADR_off_addr]
	
		
		LDR		r1, =0x18					/*Bit 3:B0EN: Flash Bank 0 enable;Bit 4:B1EN: Flash Bank 1 enable
													; Enable CS on both banks
													STR     R7, [R6, #FMI_CR_OFST]        
													; LDR     R7, = 0x19 ;in RevD 
													; to enable 8 words PFQ deepth  */
		STR		r1, [r0, #CR_off_addr]


/* --- Enable 96K RAM, PFQBC enabled, DTCM & AHB wait-states disabled ---*/

		LDR		r0, =SCU_BASE_Address
		LDR		r1, =0x0191		
								/*System configuration register 0 (SCU_SCR0) 
								EN_PFQBC :enabled
								DTCM Wait state disable
								AHB Wait state disable 
								SRAM size(Bits 4:3):10
								SRAM_LK_EN: 0 AHB Lock transfer disabled (default)
								EMI_MUX:0: Multiplexed mode
								EMI_ALE_POLR: 1: Active high (default)
								EMI_ALE_LNGT: 1: Two clock cycles (default)
								Bits12:14 :UART_IRDA[2:0]:EXT_ETMT_EDBGR:P30_SELEDBG:
								*/
        STR     R1, [R0, #SCU_SCR0_OFST]
/*; ------------------------------------------------------------------------------
 --- System clock configuration
 ------------------------------------------------------------------------------   */

.if PLL_Clock  /*; Use 96 MHZ PLL clock as the default frequency*/
/*	.section .fastrun,"ax",%progbits
/*; --- wait states Flash confguration */

        LDR     R6, = 0x00080000            /*;Write a Write Flash Configuration */
        LDR     R7, =0x60                   /*;Register command (60h) to any word*/
        STRH    R7, [R6]                    /*;address in Bank 1.*/
 
 
        LDR     R6, = 0x00083040            /*;Write a Write Flash Configuration  */
        LDR     R7, = 0x3                   /*;Register Confirm command (03h)*/
        STRH    R7, [R6]                    /*;2Wstaites in read,PWD,LVD enabled, */
                                            /*;High BUSCFG.*/

/*; --- PLL configuration      */

        LDR     R1, = 0x00020002              /*;Set OSC as clock source*/
        STR     R1, [R0, #SCU_CLKCNTR_OFST ] 


        NOP     /*; Wait for OSC stabilization*/
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP
        NOP




        LDR     R1, = 0x000ac019               /*;Set PLL ENABLE, to 96Mhz */
        STR     R1, [R0, #SCU_PLLCONF_OFST]
        
       
Wait_Loop:      
 
        LDR     R1,[R0, #SCU_SYSSTATUS_OFST]   /*;Wait until PLL is Locked*/
		  ANDS    R1, R1, #0x01 
		  BEQ     Wait_Loop
        
        
        LDR     R1, = 0x00020080             /*;Set PLL as clock source after pll */
        STR     R1, [R0, #SCU_CLKCNTR_OFST ] /*;is locked and  FMICLK=RCLK,*/
                                             /*;PCLK=RCLK/2*/

.endif


.if  RTC_Clock   /*;Use RTC  as the default clock source*/

        LDR     R1, = 0x00020001              /*;Set RTC as clock source and */
        STR     R1, [R0, #SCU_CLKCNTR_OFST ]  /*;FMICLK=RCLK, PCLK=RCLK*/
                                              
.endif


.if OSC_Clock  /*;Use Osc as the default clock source*/

        LDR     R1, = 0x00020002              /*;Set OSC as clock source  and */
        STR     R1, [R0, #SCU_CLKCNTR_OFST ]  /*;FMICLK=RCLK, PCLK=RCLK*/
                                              
.endif                                           
 
	
		
  
/* Setup Stack for each mode */

/* Enter Abort Mode and set its Stack Pointer */

		MSR		cpsr_c, #Mode_ABT|I_Bit|F_Bit
		LDR		sp, =ABT_Stack

/* Enter Undefined Instruction Mode and set its Stack Pointer */

		MSR		cpsr_c, #Mode_UND|I_Bit|F_Bit
		LDR		sp, =UNDEF_Stack

/* Enter Supervisor Mode and set its Stack Pointer */

		MSR		cpsr_c, #Mode_SVC|I_Bit|F_Bit
		LDR		sp, =_estack /*RAM_Limit*/

/* Enter FIQ Mode and set its Stack Pointer */

		MSR		cpsr_c, #Mode_FIQ|I_Bit|F_Bit
		LDR		sp, =FIQ_Stack

/* Enter IRQ Mode and set its Stack Pointer */

		MSR		cpsr_c, #Mode_IRQ|I_Bit|F_Bit
		LDR		sp, =IRQ_Stack

/* Enter System/User Mode and set its Stack Pointer */

		MSR		cpsr_c, #Mode_SYS
		LDR		sp, =USR_Stack
		
/* Set bits 17-18 (Instruction/Data TCM order) of the ARM966ES */
/* Core Configuration Control Register */
 
      MOV     r0, #0x60000
      MCR     p15,0x1,r0,c15,c1,0
		
/* Relocate .data section (Copy from FLASH to RAM) */

		LDR		r1, =_sidata
		LDR		r2, =_sdata
		LDR		r3, =_edata
LoopRel:
		CMP		r2, r3
		LDRLO	r0, [r1], #4
		STRLO	r0, [r2], #4
		BLO		LoopRel

/* Clear .bss section (Zero init) */
		MOV		r0, #0
		LDR		r1, =_sbss	
		LDR		r2, =_ebss	
LoopZI:
		CMP		r1, r2
		STRLO	r0, [r1], #4
		BLO		LoopZI

/* --- Enter the C code, use B instruction so as to never return --- */
/*    B		main														/**/

/* --- 				Now enter the C code 					             ---	*/
      ldr    PC, =main												/**/
             


	.end	

/****** (C) COPYRIGHT 2006 STMicroelectronics *********/
