/**
  ******************************************************************************
  * @file    CEC/inc/main.h
  * @author  MCD Application Team
  * @version V1.1.0
  * @date    10/15/2010
  * @brief   Header file for main module.
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2010 STMicroelectronics</center></h2>
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#if defined STM32F10X_MD_VL
#include "stm32100b_eval/stm32100b_eval_lcd.h"
#include "stm32100b_eval/stm32100b_eval_cec.h"
#elif defined STM32F10X_HD_VL
#include "stm32100e_eval/stm32100e_eval_lcd.h"
#include "stm32100e_eval/stm32100e_eval_cec.h"
#endif
#include "cec_display.h"
#include <stdio.h>
#include <stdlib.h>
#include "stm32_eval.h"
#include "stm32f10x_it.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
void GPIO_Configuration(void);
void NVIC_Configuration(void);
void USART_Configuration(void);

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */

/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/
