/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class ScatterChart
extends XYChart {
    private static final float SIZE = 3.0f;
    private static final int SHAPE_WIDTH = 10;
    private float size = 3.0f;

    public ScatterChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.size = xYMultipleSeriesRenderer.getPointSize();
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n) {
        XYSeriesRenderer xYSeriesRenderer = (XYSeriesRenderer)simpleSeriesRenderer;
        paint.setColor(xYSeriesRenderer.getColor());
        if (xYSeriesRenderer.isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStyle(Paint.Style.STROKE);
        }
        int n2 = fArray.length;
        switch (xYSeriesRenderer.getPointStyle()) {
            case X: {
                for (int i = 0; i < n2; i += 2) {
                    this.drawX(canvas, paint, fArray[i], fArray[i + 1]);
                }
                break;
            }
            case CIRCLE: {
                for (int i = 0; i < n2; i += 2) {
                    this.drawCircle(canvas, paint, fArray[i], fArray[i + 1]);
                }
                break;
            }
            case TRIANGLE: {
                float[] fArray2 = new float[6];
                for (int i = 0; i < n2; i += 2) {
                    this.drawTriangle(canvas, paint, fArray2, fArray[i], fArray[i + 1]);
                }
                break;
            }
            case SQUARE: {
                for (int i = 0; i < n2; i += 2) {
                    this.drawSquare(canvas, paint, fArray[i], fArray[i + 1]);
                }
                break;
            }
            case DIAMOND: {
                float[] fArray3 = new float[8];
                for (int i = 0; i < n2; i += 2) {
                    this.drawDiamond(canvas, paint, fArray3, fArray[i], fArray[i + 1]);
                }
                break;
            }
            case POINT: {
                canvas.drawPoints(fArray, paint);
            }
        }
    }

    @Override
    public int getLegendShapeWidth() {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, Paint paint) {
        if (((XYSeriesRenderer)simpleSeriesRenderer).isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStyle(Paint.Style.STROKE);
        }
        switch (((XYSeriesRenderer)simpleSeriesRenderer).getPointStyle()) {
            case X: {
                this.drawX(canvas, paint, f + 10.0f, f2);
                break;
            }
            case CIRCLE: {
                this.drawCircle(canvas, paint, f + 10.0f, f2);
                break;
            }
            case TRIANGLE: {
                this.drawTriangle(canvas, paint, new float[6], f + 10.0f, f2);
                break;
            }
            case SQUARE: {
                this.drawSquare(canvas, paint, f + 10.0f, f2);
                break;
            }
            case DIAMOND: {
                this.drawDiamond(canvas, paint, new float[8], f + 10.0f, f2);
                break;
            }
            case POINT: {
                canvas.drawPoint(f + 10.0f, f2, paint);
            }
        }
    }

    private void drawX(Canvas canvas, Paint paint, float f, float f2) {
        canvas.drawLine(f - this.size, f2 - this.size, f + this.size, f2 + this.size, paint);
        canvas.drawLine(f + this.size, f2 - this.size, f - this.size, f2 + this.size, paint);
    }

    private void drawCircle(Canvas canvas, Paint paint, float f, float f2) {
        canvas.drawCircle(f, f2, this.size, paint);
    }

    private void drawTriangle(Canvas canvas, Paint paint, float[] fArray, float f, float f2) {
        fArray[0] = f;
        fArray[1] = f2 - this.size - this.size / 2.0f;
        fArray[2] = f - this.size;
        fArray[3] = f2 + this.size;
        fArray[4] = f + this.size;
        fArray[5] = fArray[3];
        this.drawPath(canvas, fArray, paint, true);
    }

    private void drawSquare(Canvas canvas, Paint paint, float f, float f2) {
        canvas.drawRect(f - this.size, f2 - this.size, f + this.size, f2 + this.size, paint);
    }

    private void drawDiamond(Canvas canvas, Paint paint, float[] fArray, float f, float f2) {
        fArray[0] = f;
        fArray[1] = f2 - this.size;
        fArray[2] = f - this.size;
        fArray[3] = f2;
        fArray[4] = f;
        fArray[5] = f2 + this.size;
        fArray[6] = f + this.size;
        fArray[7] = f2;
        this.drawPath(canvas, fArray, paint, true);
    }
}

