package com.phoceis.STdatalogger;

import java.io.FileInputStream;

import android.app.Activity;
import android.content.Context;
import android.graphics.AvoidXfermode.Mode;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory;
import android.graphics.BitmapFactory.Options;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader.TileMode;
import android.os.Bundle;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ImageView.ScaleType;
import android.widget.RelativeLayout;
import android.widget.TableLayout.LayoutParams;
import com.phoceis.STdatalogger.R; 


import com.phoceis.coverFlow.CoverFlow;

public class coverFlowActivity extends Activity {
	
	private RelativeLayout powerPointST;
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        
    	super.onCreate(savedInstanceState);       
        setContentView(R.layout.coverflow);
        
        this.getWindow().setFormat(PixelFormat.RGBA_8888);
        powerPointST = (RelativeLayout) coverFlowActivity.this.findViewById(R.id.powerPointST);
        		
		CoverFlow coverFlow;
		coverFlow = new CoverFlow(this);
		coverFlow.setAdapter(new ImageAdapter(this));
		
		ImageAdapter coverImageAdapter = new ImageAdapter(this);
		
		//coverImageAdapter.createReflectedImages();
		coverFlow.setAdapter(coverImageAdapter);
		coverFlow.setLayoutParams(new CoverFlow.LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
		coverFlow.setGravity(Gravity.TOP);
		coverFlow.setSpacing(-180);
		coverFlow.setSelection(0, true);
		coverFlow.setAnimationDuration(1000);
		
		powerPointST.addView(coverFlow);	
    }


public class ImageAdapter extends BaseAdapter
{
	int mGalleryItemBackground;
	private Context mContext;
	
	private Integer[] mImageIds = { R.drawable.diapositive01, R.drawable.diapositive02, R.drawable.diapositive03, R.drawable.diapositive04, R.drawable.diapositive05, R.drawable.diapositive06,R.drawable.diapositive07,R.drawable.diapositive08,R.drawable.diapositive09,R.drawable.diapositive10,R.drawable.diapositive11,R.drawable.diapositive12,R.drawable.diapositive13,R.drawable.diapositive14,R.drawable.diapositive15,R.drawable.diapositive16,R.drawable.diapositive17};
	private ImageView[] mImages;
	
	public ImageAdapter(Context c)
	{
		mContext = c;
		mImages = new ImageView[mImageIds.length];
	}
	
	public boolean createReflectedImages()
	{
		// The gap we want between the reflection and the original image
		final int reflectionGap = 0;
		
		int index = 0;
		for (int imageId : mImageIds)
		{
			Bitmap originalImage = BitmapFactory.decodeResource(getResources(), imageId);
			int width = originalImage.getWidth();
			int height = originalImage.getHeight();
			
			// This will not scale but will flip on the Y axis
			Matrix matrix = new Matrix();
			matrix.preScale(1, -1);
			
			// Create a Bitmap with the flip matrix applied to it.
			// We only want the bottom half of the image
			Bitmap reflectionImage = Bitmap.createBitmap(originalImage, 0, height / 2, width, height / 2, matrix, false);
			
			// Create a new bitmap with same width but taller to fit reflection
			Bitmap bitmapWithReflection = Bitmap.createBitmap(width, (height + height / 2), Config.ARGB_8888);
			
			// Create a new Canvas with the bitmap that's big enough for
			// the image plus gap plus reflection
			Canvas canvas = new Canvas(bitmapWithReflection);
			// Draw in the original image
			canvas.drawBitmap(originalImage, 0, 0, null);
			// Draw in the gap
			Paint deafaultPaint = new Paint();
			canvas.drawRect(0, height, width, height + reflectionGap, deafaultPaint);
			// Draw in the reflection
			canvas.drawBitmap(reflectionImage, 0, height + reflectionGap, null);
			
			clearBitmap(reflectionImage);
			
			// Create a shader that is a linear gradient that covers the reflection
			Paint paint = new Paint();
			LinearGradient shader = new LinearGradient(0, originalImage.getHeight(), 0, bitmapWithReflection.getHeight() + reflectionGap, 0x70ffffff, 0x00ffffff, TileMode.CLAMP);
			
			clearBitmap(originalImage);
			
			// Set the paint to use this shader (linear gradient)
			paint.setShader(shader);
			// Set the Transfer mode to be porter duff and destination in
			//paint.setXfermode(new PorterDuffXfermode(Mode.DST_IN));
			paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
			
			// Draw a rectangle using the paint with our linear gradient
			canvas.drawRect(0, height, width, bitmapWithReflection.getHeight() + reflectionGap, paint);
			
			ImageView imageView = new ImageView(mContext);
			imageView.setImageBitmap(bitmapWithReflection);
			
			imageView.setLayoutParams(new CoverFlow.LayoutParams(600, 334));
			imageView.setScaleType(ScaleType.MATRIX);
			mImages[index++] = imageView;
			
		}
		return true;
	}
	
	public int getCount()
	{
		return mImageIds.length;
	}
	
	public Object getItem(int position)
	{
		return position;
	}
	
	public long getItemId(int position)
	{
		return position;
	}
	
	public View getView(int position, View convertView, ViewGroup parent)
	{
		
		// Use this code if you want to load from resources
		ImageView i = new ImageView(mContext);
		i.setImageResource(mImageIds[position]);
		i.setLayoutParams(new CoverFlow.LayoutParams(550, 305));
		i.setScaleType(ImageView.ScaleType.FIT_CENTER);
		
		
		// Make sure we set anti-aliasing otherwise we get jaggies
		
		return i;
		
		
	}
	
	// /**
	// * Returns the size (0.0f to 1.0f) of the views depending on the 'offset' to the center.
	// */
	// public float getScale(boolean focused, int offset)
	// {
	// /* Formula: 1 / (2 ^ offset) */
	// return Math.max(0, 1.0f / (float) Math.pow(2, Math.abs(offset)));
	// }
}

public static void clearBitmap(Bitmap bm)
{
	bm.recycle();
	bm = null;
	System.gc();
}

}

