package com.phoceis.STdatalogger;

import java.util.Timer;
import java.util.TimerTask;

import com.phoceis.STdatalogger.R;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;


public class dataLoggerAppActivity extends Activity {
    /** Called when the activity is first created. */
	
	private Button btnApplications,btnwww;
	private ImageView imgScan;
	private Timer rollImage;
	private int drawableImageID;
	
	private NfcAdapter mAdapter;
	private PendingIntent mPendingIntent;
	private IntentFilter[] mFilters;
	private String[][] mTechLists;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        
    	super.onCreate(savedInstanceState);
    	
        mAdapter = NfcAdapter.getDefaultAdapter(this);
        mPendingIntent = PendingIntent.getActivity(this, 0,
                new Intent(this, getClass()).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);
        IntentFilter ndef = new IntentFilter(NfcAdapter.ACTION_TECH_DISCOVERED);
        mFilters = new IntentFilter[] {
                ndef,
        };
        mTechLists = new String[][] { new String[] { android.nfc.tech.NfcV.class.getName() } };
        
        setContentView(R.layout.main); 
        
        btnApplications = (Button) this.findViewById(R.id.btnApplications);
        btnwww= (Button) this.findViewById(R.id.btnwww);
        imgScan = (ImageView)this.findViewById(R.id.imgViewScan);
        
        drawableImageID = R.drawable.wait1;
        
        rollImage = new Timer();
        rollImage.schedule(new TimerTask() {
			@Override
			public void run() {
				TimerMethod();
			}
		}, 0, 500);
    
        /* ******************* BUTTON COVER-FLOW ***************************** */
        this.btnApplications.setOnClickListener(new View.OnClickListener() {			
			public void onClick(View v) {			
				Intent intent = new Intent(dataLoggerAppActivity.this, com.phoceis.STdatalogger.coverFlowActivity.class);
			    startActivityForResult(intent, 100);				
			}
		});
        
        /* ******************* BUTTON WWW.ST.COM ***************************** */
        this.btnwww.setOnClickListener(new View.OnClickListener() {			
			public void onClick(View v) {			
				
				String url = "http://www.st.com/dualeeprom";
				Intent i = new Intent(Intent.ACTION_VIEW);
				i.setData(Uri.parse(url));
				startActivity(i);
			}
		});
    
    }
	
	@Override
    public void onResume() {
        super.onResume();
        mAdapter.enableForegroundDispatch(this, mPendingIntent, mFilters, mTechLists);
    }

    @Override
    public void onNewIntent(Intent intent) {
       Log.i("Foreground dispatch", "Discovered tag with intent: " + intent);
       Tag tagFromIntent = intent.getParcelableExtra(NfcAdapter.EXTRA_TAG);             
       myApplication ma = (myApplication)getApplication();
       ma.setCurrentTag(tagFromIntent);
       Intent newIntent = new Intent(dataLoggerAppActivity.this, com.phoceis.STdatalogger.showGraphActivity.class);
       startActivity(newIntent);
    }

    @Override
    public void onPause() {
        super.onPause();
        mAdapter.disableForegroundDispatch(this);
    }

	
	private void TimerMethod()
	{
		//This method is called directly by the timer
		//and runs in the same thread as the timer.

		//We call the method that will work with the UI
		//through the runOnUiThread method.
		this.runOnUiThread(Timer_Tick);
	}

	private Runnable Timer_Tick = new Runnable() {
		@Override
		public void run() {
			if (drawableImageID==R.drawable.wait1)
			{
				drawableImageID = R.drawable.wait2;
			} else if (drawableImageID==R.drawable.wait2)
			{			
				drawableImageID = R.drawable.wait3;
			} else if (drawableImageID==R.drawable.wait3)
			{				
				drawableImageID = R.drawable.wait4;
			} else if (drawableImageID==R.drawable.wait4)
			{
				drawableImageID = R.drawable.wait1;				
			}			
			imgScan.setImageDrawable(getResources().getDrawable(drawableImageID));
		}
	};

	
}
