/**
THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS WITH CODING 
INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME. 
AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR 
CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE CONTENT OF SUCH FIRMWARE 
AND/OR THE USE MADE BY CUSTOMERS OF THE CODING INFORMATION CONTAINED HEREIN IN CONNECTION 
WITH THEIR PRODUCTS.
*/
package com.phoceis.STdatalogger;


import java.text.NumberFormat;

import org.achartengine.ChartFactory;
import org.achartengine.GraphicalView;
import org.achartengine.chart.PointStyle;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

import com.phoceis.STdatalogger.R;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.Paint.Align;
import android.nfc.NfcAdapter;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;


public class statisticsActivity extends Activity{

public TextView textCurrentTemp,textMinTemp,textMaxTemp,textAvgTemp;
public Button btnSettings;

 
private NfcAdapter mAdapter;
private PendingIntent mPendingIntent;
private IntentFilter[] mFilters;
private String[][] mTechLists;
private GraphicalView graphBar;
public Boolean isCalculating = false;
	
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.statistics);
       
        isCalculating = true;
        
        textCurrentTemp = (TextView) this.findViewById(R.id.textCurrentTemp);
        textMinTemp = (TextView) this.findViewById(R.id.textMinTemp);
        textMaxTemp = (TextView) this.findViewById(R.id.textMaxTemp);
        textAvgTemp = (TextView) this.findViewById(R.id.textAvgTemp);
        btnSettings = (Button) this.findViewById(R.id.btnSettings);
       
        
        mAdapter = NfcAdapter.getDefaultAdapter(this);
        mPendingIntent = PendingIntent.getActivity(this, 0, new Intent(this, getClass()).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0);
        IntentFilter ndef = new IntentFilter(NfcAdapter.ACTION_TECH_DISCOVERED);
        mFilters = new IntentFilter[] {
                ndef,
        };
        mTechLists = new String[][] { new String[] { android.nfc.tech.NfcV.class.getName() } };         
       
        myApplication ma = (myApplication)getApplication();
        
        NumberFormat MyFormat = NumberFormat.getInstance();
		MyFormat.setMinimumFractionDigits(1);
		MyFormat.setMaximumFractionDigits(1);
		
		String sMaxTemp = MyFormat.format(ma.getMaxTemp());
		textMaxTemp.setText(sMaxTemp);
		
		String sMinTemp = MyFormat.format(ma.getMinTemp());
		textMinTemp.setText(sMinTemp);
		
		String sAvgTemp = MyFormat.format(ma.getAvgTemp());
		textAvgTemp.setText(sAvgTemp);
		
		String sCurrentTemp = MyFormat.format(ma.getCurrentTemp());
		textCurrentTemp.setText(sCurrentTemp);
		
        this.btnSettings.setOnClickListener(new View.OnClickListener() {			
    		@Override
			public void onClick(View v) 
    		{	
    			btnSettings.setEnabled(false);
    			if(!isCalculating)
    			{
    				Intent intent = new Intent(statisticsActivity.this, com.phoceis.STdatalogger.changeSettingsActivity.class);
    				startActivityForResult(intent, 100);	
    			}
    		}
    			
    	});
        
        refreshHistogram();
        
	}
	
	@Override
    public void onResume() {
        super.onResume();
        btnSettings.setEnabled(true);
        mAdapter.enableForegroundDispatch(this, mPendingIntent, mFilters, mTechLists);
    }
	
	void refreshHistogram()
	{
		myApplication ma = (myApplication)getApplication();
		int maxOccurences = 0;
		
		int tempMin = (int)ma.getMinTemp();
		int tempMax = (int)ma.getMaxTemp();
		//int nbTemp = (int)ma.getNbOfAcquiredTemp();
		double[] Array = ma.getArrayTemp().get(0);
		int nbTemp = Array.length;
		
		if(ma.isGraphDownloadedOnceWithoutError() == false || ma.getArrayTemp().size() == 0)
			return;
		
        int[] colors = new int[] { Color.BLUE};
        PointStyle[] styles = new PointStyle[] { PointStyle.TRIANGLE };
        XYMultipleSeriesRenderer renderer = com.phoceis.STdatalogger.AbstractDemoChart.buildRenderer(colors, styles);
        int length = renderer.getSeriesRendererCount();
        for (int i = 0; i < length; i++) {
          ((XYSeriesRenderer) renderer.getSeriesRendererAt(i)).setFillPoints(true);
        }        
        
        
        XYMultipleSeriesDataset myDataset = new XYMultipleSeriesDataset (); 
        XYSeries mySeries = new XYSeries ("Population"); 
        
        for(int i=tempMin; i<= tempMax; i++)
        {
        	int occurences = 0;
        	
        	for(int j=0; j<nbTemp ; j++)
        	{
        		
        		if((int)Array[j] == i)
        		{
        			occurences++;
        		}
        	}
    
        	mySeries.add(i, occurences);
        	
        	if(occurences > maxOccurences)
        		maxOccurences =occurences;
        }
        
        myDataset.addSeries (mySeries);
        
        
        AbstractDemoChart.setChartSettings(renderer, "", "Temperatures", "Occurrences", ma.getMinTemp()-1, ma.getMaxTemp()+1, 0, maxOccurences+1,Color.DKGRAY, Color.DKGRAY);
       
        renderer.setMargins(new int[] { 10, 50, 30, 10 });
        renderer.setLegendHeight(16);
        renderer.setXLabels(5);
        renderer.setYLabels(5);
        renderer.setPointSize(14);
        renderer.setShowGrid(false);
        renderer.setXLabelsAlign(Align.CENTER);
        renderer.setMarginsColor(0xffff);
        
        renderer.setAxisTitleTextSize(20);
        renderer.setLabelsTextSize(16);
        renderer.setLegendTextSize(16);
        renderer.setShowLegend(true);
        renderer.setZoomEnabled(false, false);
        renderer.setAntialiasing(true);
        renderer.setYLabelsAlign(Align.RIGHT);
        renderer.setPanLimits(new double[] { ma.getMinTemp()-1, ma.getMaxTemp()+1, 0, maxOccurences+1});
        
        LinearLayout layout = (LinearLayout) findViewById(R.id.barchart);
        
        layout.removeAllViews();
        
        graphBar = ChartFactory.getBarChartView (this, myDataset, renderer, org.achartengine.chart.BarChart.Type.DEFAULT); 
 
        layout.addView(graphBar, new LayoutParams(LayoutParams.WRAP_CONTENT , LayoutParams.WRAP_CONTENT )); 
        isCalculating = false;
        btnSettings.setEnabled(true);
	}
	
}
