/**
  ******************************************************************************
  * @file    gl_fonts.c
  * @author  MCD Application Team
  * @version V2.0.0
  * @date    11-July-2011
  * @brief   This file provides text fonts for STM32xx-EVAL's LCD driver.
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2011 STMicroelectronics</center></h2>
  ******************************************************************************
  */
  
/* Includes ------------------------------------------------------------------*/
#include "gl_fonts.h"

/** @addtogroup Embedded_GUI_Library
  * @{
  */
   
/** @addtogroup GL_FONTS
  * @brief      This file includes the Fonts driver of STM32-EVAL boards.
  * @{
  */  

/* External variables --------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private defines -----------------------------------------------------------*/
/* Private macros ------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

/**
  * @brief  ASCII font 16x24 table definition
  */
const uint16_t GL_ASCII16x24_Table [] =
  {
    /**
      * @brief        Space ' '
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '!'
      */
    0x0000, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000,
    0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '"'
      */
    0x0000, 0x0000, 0x00CC, 0x00CC, 0x00CC, 0x00CC, 0x00CC, 0x00CC,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '#'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0C60, 0x0C60,
    0x0C60, 0x0630, 0x0630, 0x1FFE, 0x1FFE, 0x0630, 0x0738, 0x0318,
    0x1FFE, 0x1FFE, 0x0318, 0x0318, 0x018C, 0x018C, 0x018C, 0x0000,
    /**
      * @brief        '$'
      */
    0x0000, 0x0080, 0x03E0, 0x0FF8, 0x0E9C, 0x1C8C, 0x188C, 0x008C,
    0x0098, 0x01F8, 0x07E0, 0x0E80, 0x1C80, 0x188C, 0x188C, 0x189C,
    0x0CB8, 0x0FF0, 0x03E0, 0x0080, 0x0080, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '%'
      */
    0x0000, 0x0000, 0x0000, 0x180E, 0x0C1B, 0x0C11, 0x0611, 0x0611,
    0x0311, 0x0311, 0x019B, 0x018E, 0x38C0, 0x6CC0, 0x4460, 0x4460,
    0x4430, 0x4430, 0x4418, 0x6C18, 0x380C, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '&'
      */
    0x0000, 0x01E0, 0x03F0, 0x0738, 0x0618, 0x0618, 0x0330, 0x01F0,
    0x00F0, 0x00F8, 0x319C, 0x330E, 0x1E06, 0x1C06, 0x1C06, 0x3F06,
    0x73FC, 0x21F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '''
      */
    0x0000, 0x0000, 0x000C, 0x000C, 0x000C, 0x000C, 0x000C, 0x000C,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '('
      */
    0x0000, 0x0200, 0x0300, 0x0180, 0x00C0, 0x00C0, 0x0060, 0x0060,
    0x0030, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030,
    0x0060, 0x0060, 0x00C0, 0x00C0, 0x0180, 0x0300, 0x0200, 0x0000,
    /**
      * @brief        ')'
      */
    0x0000, 0x0020, 0x0060, 0x00C0, 0x0180, 0x0180, 0x0300, 0x0300,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0300, 0x0300, 0x0180, 0x0180, 0x00C0, 0x0060, 0x0020, 0x0000,
    /**
      * @brief        '*'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00C0, 0x00C0,
    0x06D8, 0x07F8, 0x01E0, 0x0330, 0x0738, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '+'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0180, 0x3FFC, 0x3FFC, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        ','
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0180, 0x0180, 0x0100, 0x0100, 0x0080, 0x0000, 0x0000,
    /**
      * @brief        '-'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x07E0, 0x07E0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '.'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x00C0, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '/'
      */
    0x0000, 0x0C00, 0x0C00, 0x0600, 0x0600, 0x0600, 0x0300, 0x0300,
    0x0300, 0x0380, 0x0180, 0x0180, 0x0180, 0x00C0, 0x00C0, 0x00C0,
    0x0060, 0x0060, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '0'
      */
    0x0000, 0x03E0, 0x07F0, 0x0E38, 0x0C18, 0x180C, 0x180C, 0x180C,
    0x180C, 0x180C, 0x180C, 0x180C, 0x180C, 0x180C, 0x0C18, 0x0E38,
    0x07F0, 0x03E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '1'
      */
    0x0000, 0x0100, 0x0180, 0x01C0, 0x01F0, 0x0198, 0x0188, 0x0180,
    0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '2'
      */
    0x0000, 0x03E0, 0x0FF8, 0x0C18, 0x180C, 0x180C, 0x1800, 0x1800,
    0x0C00, 0x0600, 0x0300, 0x0180, 0x00C0, 0x0060, 0x0030, 0x0018,
    0x1FFC, 0x1FFC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '3'
      */
    0x0000, 0x01E0, 0x07F8, 0x0E18, 0x0C0C, 0x0C0C, 0x0C00, 0x0600,
    0x03C0, 0x07C0, 0x0C00, 0x1800, 0x1800, 0x180C, 0x180C, 0x0C18,
    0x07F8, 0x03E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '4'
      */
    0x0000, 0x0C00, 0x0E00, 0x0F00, 0x0F00, 0x0D80, 0x0CC0, 0x0C60,
    0x0C60, 0x0C30, 0x0C18, 0x0C0C, 0x3FFC, 0x3FFC, 0x0C00, 0x0C00,
    0x0C00, 0x0C00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '5'
      */
    0x0000, 0x0FF8, 0x0FF8, 0x0018, 0x0018, 0x000C, 0x03EC, 0x07FC,
    0x0E1C, 0x1C00, 0x1800, 0x1800, 0x1800, 0x180C, 0x0C1C, 0x0E18,
    0x07F8, 0x03E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '6'
      */
    0x0000, 0x07C0, 0x0FF0, 0x1C38, 0x1818, 0x0018, 0x000C, 0x03CC,
    0x0FEC, 0x0E3C, 0x1C1C, 0x180C, 0x180C, 0x180C, 0x1C18, 0x0E38,
    0x07F0, 0x03E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '7'
      */
    0x0000, 0x1FFC, 0x1FFC, 0x0C00, 0x0600, 0x0600, 0x0300, 0x0380,
    0x0180, 0x01C0, 0x00C0, 0x00E0, 0x0060, 0x0060, 0x0070, 0x0030,
    0x0030, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '8'
      */
    0x0000, 0x03E0, 0x07F0, 0x0E38, 0x0C18, 0x0C18, 0x0C18, 0x0638,
    0x07F0, 0x07F0, 0x0C18, 0x180C, 0x180C, 0x180C, 0x180C, 0x0C38,
    0x0FF8, 0x03E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '9'
      */
    0x0000, 0x03E0, 0x07F0, 0x0E38, 0x0C1C, 0x180C, 0x180C, 0x180C,
    0x1C1C, 0x1E38, 0x1BF8, 0x19E0, 0x1800, 0x0C00, 0x0C00, 0x0E1C,
    0x07F8, 0x01F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        ':'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        ';'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0180, 0x0180,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0180, 0x0180, 0x0100, 0x0100, 0x0080, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '<'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x1000, 0x1C00, 0x0F80, 0x03E0, 0x00F8, 0x0018, 0x00F8, 0x03E0,
    0x0F80, 0x1C00, 0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '='
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x1FF8, 0x0000, 0x0000, 0x0000, 0x1FF8, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '>'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0008, 0x0038, 0x01F0, 0x07C0, 0x1F00, 0x1800, 0x1F00, 0x07C0,
    0x01F0, 0x0038, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '?'
      */
    0x0000, 0x03E0, 0x0FF8, 0x0C18, 0x180C, 0x180C, 0x1800, 0x0C00,
    0x0600, 0x0300, 0x0180, 0x00C0, 0x00C0, 0x00C0, 0x0000, 0x0000,
    0x00C0, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '@'
      */
    0x0000, 0x0000, 0x07E0, 0x1818, 0x2004, 0x29C2, 0x4A22, 0x4411,
    0x4409, 0x4409, 0x4409, 0x2209, 0x1311, 0x0CE2, 0x4002, 0x2004,
    0x1818, 0x07E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'A'
      */
    0x0000, 0x0380, 0x0380, 0x06C0, 0x06C0, 0x06C0, 0x0C60, 0x0C60,
    0x1830, 0x1830, 0x1830, 0x3FF8, 0x3FF8, 0x701C, 0x600C, 0x600C,
    0xC006, 0xC006, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'B'
      */
    0x0000, 0x03FC, 0x0FFC, 0x0C0C, 0x180C, 0x180C, 0x180C, 0x0C0C,
    0x07FC, 0x0FFC, 0x180C, 0x300C, 0x300C, 0x300C, 0x300C, 0x180C,
    0x1FFC, 0x07FC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'C'
      */
    0x0000, 0x07C0, 0x1FF0, 0x3838, 0x301C, 0x700C, 0x6006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x6006, 0x700C, 0x301C,
    0x1FF0, 0x07E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'D'
      */
    0x0000, 0x03FE, 0x0FFE, 0x0E06, 0x1806, 0x1806, 0x3006, 0x3006,
    0x3006, 0x3006, 0x3006, 0x3006, 0x3006, 0x1806, 0x1806, 0x0E06,
    0x0FFE, 0x03FE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'E'
      */
    0x0000, 0x3FFC, 0x3FFC, 0x000C, 0x000C, 0x000C, 0x000C, 0x000C,
    0x1FFC, 0x1FFC, 0x000C, 0x000C, 0x000C, 0x000C, 0x000C, 0x000C,
    0x3FFC, 0x3FFC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'F'
      */
    0x0000, 0x3FF8, 0x3FF8, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
    0x1FF8, 0x1FF8, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
    0x0018, 0x0018, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'G'
      */
    0x0000, 0x0FE0, 0x3FF8, 0x783C, 0x600E, 0xE006, 0xC007, 0x0003,
    0x0003, 0xFE03, 0xFE03, 0xC003, 0xC007, 0xC006, 0xC00E, 0xF03C,
    0x3FF8, 0x0FE0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'H'
      */
    0x0000, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C,
    0x3FFC, 0x3FFC, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C,
    0x300C, 0x300C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'I'
      */
    0x0000, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'J'
      */
    0x0000, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600,
    0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0x0618, 0x0618, 0x0738,
    0x03F0, 0x01E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'K'
      */
    0x0000, 0x3006, 0x1806, 0x0C06, 0x0606, 0x0306, 0x0186, 0x00C6,
    0x0066, 0x0076, 0x00DE, 0x018E, 0x0306, 0x0606, 0x0C06, 0x1806,
    0x3006, 0x6006, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'L'
      */
    0x0000, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
    0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
    0x1FF8, 0x1FF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'M'
      */
    0x0000, 0xE00E, 0xF01E, 0xF01E, 0xF01E, 0xD836, 0xD836, 0xD836,
    0xD836, 0xCC66, 0xCC66, 0xCC66, 0xC6C6, 0xC6C6, 0xC6C6, 0xC6C6,
    0xC386, 0xC386, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'N'
      */
    0x0000, 0x300C, 0x301C, 0x303C, 0x303C, 0x306C, 0x306C, 0x30CC,
    0x30CC, 0x318C, 0x330C, 0x330C, 0x360C, 0x360C, 0x3C0C, 0x3C0C,
    0x380C, 0x300C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'O'
      */
    0x0000, 0x07E0, 0x1FF8, 0x381C, 0x700E, 0x6006, 0xC003, 0xC003,
    0xC003, 0xC003, 0xC003, 0xC003, 0xC003, 0x6006, 0x700E, 0x381C,
    0x1FF8, 0x07E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'P'
      */
    0x0000, 0x0FFC, 0x1FFC, 0x380C, 0x300C, 0x300C, 0x300C, 0x300C,
    0x180C, 0x1FFC, 0x07FC, 0x000C, 0x000C, 0x000C, 0x000C, 0x000C,
    0x000C, 0x000C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'Q'
      */
    0x0000, 0x07E0, 0x1FF8, 0x381C, 0x700E, 0x6006, 0xE003, 0xC003,
    0xC003, 0xC003, 0xC003, 0xC003, 0xE007, 0x6306, 0x3F0E, 0x3C1C,
    0x3FF8, 0xF7E0, 0xC000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'R'
      */
    0x0000, 0x0FFE, 0x1FFE, 0x3806, 0x3006, 0x3006, 0x3006, 0x3806,
    0x1FFE, 0x07FE, 0x0306, 0x0606, 0x0C06, 0x1806, 0x1806, 0x3006,
    0x3006, 0x6006, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'S'
      */
    0x0000, 0x03E0, 0x0FF8, 0x0C1C, 0x180C, 0x180C, 0x000C, 0x001C,
    0x03F8, 0x0FE0, 0x1E00, 0x3800, 0x3006, 0x3006, 0x300E, 0x1C1C,
    0x0FF8, 0x07E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'T'
      */
    0x0000, 0x7FFE, 0x7FFE, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'U'
      */
    0x0000, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C,
    0x300C, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C, 0x300C, 0x1818,
    0x1FF8, 0x07E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'V'
      */
    0x0000, 0x6003, 0x3006, 0x3006, 0x3006, 0x180C, 0x180C, 0x180C,
    0x0C18, 0x0C18, 0x0E38, 0x0630, 0x0630, 0x0770, 0x0360, 0x0360,
    0x01C0, 0x01C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'W'
      */
    0x0000, 0x6003, 0x61C3, 0x61C3, 0x61C3, 0x3366, 0x3366, 0x3366,
    0x3366, 0x3366, 0x3366, 0x1B6C, 0x1B6C, 0x1B6C, 0x1A2C, 0x1E3C,
    0x0E38, 0x0E38, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'X'
      */
    0x0000, 0xE00F, 0x700C, 0x3018, 0x1830, 0x0C70, 0x0E60, 0x07C0,
    0x0380, 0x0380, 0x03C0, 0x06E0, 0x0C70, 0x1C30, 0x1818, 0x300C,
    0x600E, 0xE007, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'Y'
      */
    0x0000, 0xC003, 0x6006, 0x300C, 0x381C, 0x1838, 0x0C30, 0x0660,
    0x07E0, 0x03C0, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'Z'
      */
    0x0000, 0x7FFC, 0x7FFC, 0x6000, 0x3000, 0x1800, 0x0C00, 0x0600,
    0x0300, 0x0180, 0x00C0, 0x0060, 0x0030, 0x0018, 0x000C, 0x0006,
    0x7FFE, 0x7FFE, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '['
      */
    0x0000, 0x03E0, 0x03E0, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060,
    0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060,
    0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x03E0, 0x03E0, 0x0000,
    /**
      * @brief        '\'
      */
    0x0000, 0x0030, 0x0030, 0x0060, 0x0060, 0x0060, 0x00C0, 0x00C0,
    0x00C0, 0x01C0, 0x0180, 0x0180, 0x0180, 0x0300, 0x0300, 0x0300,
    0x0600, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        ']'
      */
    0x0000, 0x03E0, 0x03E0, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300,
    0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x03E0, 0x03E0, 0x0000,
    /**
      * @brief        '^'
      */
    0x0000, 0x0000, 0x01C0, 0x01C0, 0x0360, 0x0360, 0x0360, 0x0630,
    0x0630, 0x0C18, 0x0C18, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '_'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '''
      */
    0x0000, 0x000C, 0x000C, 0x000C, 0x000C, 0x000C, 0x000C, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'a'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03F0, 0x07F8,
    0x0C1C, 0x0C0C, 0x0F00, 0x0FF0, 0x0CF8, 0x0C0C, 0x0C0C, 0x0F1C,
    0x0FF8, 0x18F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'b'
      */
    0x0000, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x03D8, 0x0FF8,
    0x0C38, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x0C38,
    0x0FF8, 0x03D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'c'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03C0, 0x07F0,
    0x0E30, 0x0C18, 0x0018, 0x0018, 0x0018, 0x0018, 0x0C18, 0x0E30,
    0x07F0, 0x03C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'd'
      */
    0x0000, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1BC0, 0x1FF0,
    0x1C30, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1C30,
    0x1FF0, 0x1BC0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'e'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03C0, 0x0FF0,
    0x0C30, 0x1818, 0x1FF8, 0x1FF8, 0x0018, 0x0018, 0x1838, 0x1C30,
    0x0FF0, 0x07C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'f'
      */
    0x0000, 0x0F80, 0x0FC0, 0x00C0, 0x00C0, 0x00C0, 0x07F0, 0x07F0,
    0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
    0x00C0, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'g'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0DE0, 0x0FF8,
    0x0E18, 0x0C0C, 0x0C0C, 0x0C0C, 0x0C0C, 0x0C0C, 0x0C0C, 0x0E18,
    0x0FF8, 0x0DE0, 0x0C00, 0x0C0C, 0x061C, 0x07F8, 0x01F0, 0x0000,
    /**
      * @brief        'h'
      */
    0x0000, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x07D8, 0x0FF8,
    0x1C38, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818,
    0x1818, 0x1818, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'i'
      */
    0x0000, 0x00C0, 0x00C0, 0x0000, 0x0000, 0x0000, 0x00C0, 0x00C0,
    0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
    0x00C0, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'j'
      */
    0x0000, 0x00C0, 0x00C0, 0x0000, 0x0000, 0x0000, 0x00C0, 0x00C0,
    0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
    0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00F8, 0x0078, 0x0000,
    /**
      * @brief        'k'
      */
    0x0000, 0x000C, 0x000C, 0x000C, 0x000C, 0x000C, 0x0C0C, 0x060C,
    0x030C, 0x018C, 0x00CC, 0x006C, 0x00FC, 0x019C, 0x038C, 0x030C,
    0x060C, 0x0C0C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'l'
      */
    0x0000, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
    0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
    0x00C0, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'm'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3C7C, 0x7EFF,
    0xE3C7, 0xC183, 0xC183, 0xC183, 0xC183, 0xC183, 0xC183, 0xC183,
    0xC183, 0xC183, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'n'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0798, 0x0FF8,
    0x1C38, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818,
    0x1818, 0x1818, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'o'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03C0, 0x0FF0,
    0x0C30, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x0C30,
    0x0FF0, 0x03C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'p'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03D8, 0x0FF8,
    0x0C38, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x0C38,
    0x0FF8, 0x03D8, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0000,
    /**
      * @brief        'q'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1BC0, 0x1FF0,
    0x1C30, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1C30,
    0x1FF0, 0x1BC0, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x0000,
    /**
      * @brief        'r'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07B0, 0x03F0,
    0x0070, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030,
    0x0030, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        's'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03E0, 0x03F0,
    0x0E38, 0x0C18, 0x0038, 0x03F0, 0x07C0, 0x0C00, 0x0C18, 0x0E38,
    0x07F0, 0x03E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        't'
      */
    0x0000, 0x0000, 0x0080, 0x00C0, 0x00C0, 0x00C0, 0x07F0, 0x07F0,
    0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
    0x07C0, 0x0780, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'u'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1818, 0x1818,
    0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1818, 0x1C38,
    0x1FF0, 0x19E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'v'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x180C, 0x0C18,
    0x0C18, 0x0C18, 0x0630, 0x0630, 0x0630, 0x0360, 0x0360, 0x0360,
    0x01C0, 0x01C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'w'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x41C1, 0x41C1,
    0x61C3, 0x6363, 0x6363, 0x6363, 0x3636, 0x3636, 0x3636, 0x1C1C,
    0x1C1C, 0x1C1C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'x'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x381C, 0x1C38,
    0x0C30, 0x0660, 0x0360, 0x0360, 0x0360, 0x0360, 0x0660, 0x0C30,
    0x1C38, 0x381C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        'y'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3018, 0x1830,
    0x1830, 0x1870, 0x0C60, 0x0C60, 0x0CE0, 0x06C0, 0x06C0, 0x0380,
    0x0380, 0x0380, 0x0180, 0x0180, 0x01C0, 0x00F0, 0x0070, 0x0000,
    /**
      * @brief        'z'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1FFC, 0x1FFC,
    0x0C00, 0x0600, 0x0300, 0x0180, 0x00C0, 0x0060, 0x0030, 0x0018,
    0x1FFC, 0x1FFC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    /**
      * @brief        '{'
      */
    0x0000, 0x0300, 0x0180, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0,
    0x00C0, 0x0060, 0x0060, 0x0030, 0x0060, 0x0040, 0x00C0, 0x00C0,
    0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x0180, 0x0300, 0x0000, 0x0000,
    /**
      * @brief        '|'
      */
    0x0000, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000,
    /**
      * @brief        '}'
      */
    0x0000, 0x0060, 0x00C0, 0x01C0, 0x0180, 0x0180, 0x0180, 0x0180,
    0x0180, 0x0300, 0x0300, 0x0600, 0x0300, 0x0100, 0x0180, 0x0180,
    0x0180, 0x0180, 0x0180, 0x0180, 0x00C0, 0x0060, 0x0000, 0x0000,
    /**
      * @brief        '~'
      */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x10F0, 0x1FF8, 0x0F08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
  };

/**
  * @brief  ASCII font 12x12 table definition
  */  
const uint16_t GL_ASCII12x12_Table [] =
  {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0000, 0x2000, 0x0000, 0x0000,
    0x0000, 0x5000, 0x5000, 0x5000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0900, 0x0900, 0x1200, 0x7f00, 0x1200, 0x7f00, 0x1200, 0x2400, 0x2400, 0x0000, 0x0000,
    0x1000, 0x3800, 0x5400, 0x5000, 0x5000, 0x3800, 0x1400, 0x5400, 0x5400, 0x3800, 0x1000, 0x0000,
    0x0000, 0x3080, 0x4900, 0x4900, 0x4a00, 0x32c0, 0x0520, 0x0920, 0x0920, 0x10c0, 0x0000, 0x0000,
    0x0000, 0x0c00, 0x1200, 0x1200, 0x1400, 0x1800, 0x2500, 0x2300, 0x2300, 0x1d80, 0x0000, 0x0000,
    0x0000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0800, 0x1000, 0x1000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1000, 0x1000,
    0x0000, 0x4000, 0x2000, 0x2000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x2000, 0x2000,
    0x0000, 0x2000, 0x7000, 0x2000, 0x5000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0800, 0x0800, 0x7f00, 0x0800, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x2000, 0x4000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x0000, 0x0000,
    0x0000, 0x1000, 0x1000, 0x1000, 0x2000, 0x2000, 0x2000, 0x2000, 0x4000, 0x4000, 0x0000, 0x0000,
    0x0000, 0x1000, 0x2800, 0x4400, 0x4400, 0x4400, 0x4400, 0x4400, 0x2800, 0x1000, 0x0000, 0x0000,
    0x0000, 0x1000, 0x3000, 0x5000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x1000, 0x0000, 0x0000,
    0x0000, 0x3000, 0x4800, 0x4400, 0x0400, 0x0800, 0x1000, 0x2000, 0x4000, 0x7c00, 0x0000, 0x0000,
    0x0000, 0x3000, 0x4800, 0x0400, 0x0800, 0x1000, 0x0800, 0x4400, 0x4800, 0x3000, 0x0000, 0x0000,
    0x0000, 0x0800, 0x1800, 0x1800, 0x2800, 0x2800, 0x4800, 0x7c00, 0x0800, 0x0800, 0x0000, 0x0000,
    0x0000, 0x3c00, 0x2000, 0x4000, 0x7000, 0x4800, 0x0400, 0x4400, 0x4800, 0x3000, 0x0000, 0x0000,
    0x0000, 0x1800, 0x2400, 0x4000, 0x5000, 0x6800, 0x4400, 0x4400, 0x2800, 0x1000, 0x0000, 0x0000,
    0x0000, 0x7c00, 0x0400, 0x0800, 0x1000, 0x1000, 0x1000, 0x2000, 0x2000, 0x2000, 0x0000, 0x0000,
    0x0000, 0x1000, 0x2800, 0x4400, 0x2800, 0x1000, 0x2800, 0x4400, 0x2800, 0x1000, 0x0000, 0x0000,
    0x0000, 0x1000, 0x2800, 0x4400, 0x4400, 0x2c00, 0x1400, 0x0400, 0x4800, 0x3000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2000, 0x2000, 0x4000,
    0x0000, 0x0000, 0x0400, 0x0800, 0x3000, 0x4000, 0x3000, 0x0800, 0x0400, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x7c00, 0x0000, 0x0000, 0x7c00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x4000, 0x2000, 0x1800, 0x0400, 0x1800, 0x2000, 0x4000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x3800, 0x6400, 0x4400, 0x0400, 0x0800, 0x1000, 0x1000, 0x0000, 0x1000, 0x0000, 0x0000,
    0x0000, 0x0f80, 0x1040, 0x2ea0, 0x51a0, 0x5120, 0x5120, 0x5120, 0x5320, 0x4dc0, 0x2020, 0x1040,
    0x0000, 0x0800, 0x1400, 0x1400, 0x1400, 0x2200, 0x3e00, 0x2200, 0x4100, 0x4100, 0x0000, 0x0000,
    0x0000, 0x3c00, 0x2200, 0x2200, 0x2200, 0x3c00, 0x2200, 0x2200, 0x2200, 0x3c00, 0x0000, 0x0000,
    0x0000, 0x0e00, 0x1100, 0x2100, 0x2000, 0x2000, 0x2000, 0x2100, 0x1100, 0x0e00, 0x0000, 0x0000,
    0x0000, 0x3c00, 0x2200, 0x2100, 0x2100, 0x2100, 0x2100, 0x2100, 0x2200, 0x3c00, 0x0000, 0x0000,
    0x0000, 0x3e00, 0x2000, 0x2000, 0x2000, 0x3e00, 0x2000, 0x2000, 0x2000, 0x3e00, 0x0000, 0x0000,
    0x0000, 0x3e00, 0x2000, 0x2000, 0x2000, 0x3c00, 0x2000, 0x2000, 0x2000, 0x2000, 0x0000, 0x0000,
    0x0000, 0x0e00, 0x1100, 0x2100, 0x2000, 0x2700, 0x2100, 0x2100, 0x1100, 0x0e00, 0x0000, 0x0000,
    0x0000, 0x2100, 0x2100, 0x2100, 0x2100, 0x3f00, 0x2100, 0x2100, 0x2100, 0x2100, 0x0000, 0x0000,
    0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0000, 0x0000,
    0x0000, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x4800, 0x4800, 0x3000, 0x0000, 0x0000,
    0x0000, 0x2200, 0x2400, 0x2800, 0x2800, 0x3800, 0x2800, 0x2400, 0x2400, 0x2200, 0x0000, 0x0000,
    0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x3e00, 0x0000, 0x0000,
    0x0000, 0x2080, 0x3180, 0x3180, 0x3180, 0x2a80, 0x2a80, 0x2a80, 0x2a80, 0x2480, 0x0000, 0x0000,
    0x0000, 0x2100, 0x3100, 0x3100, 0x2900, 0x2900, 0x2500, 0x2300, 0x2300, 0x2100, 0x0000, 0x0000,
    0x0000, 0x0c00, 0x1200, 0x2100, 0x2100, 0x2100, 0x2100, 0x2100, 0x1200, 0x0c00, 0x0000, 0x0000,
    0x0000, 0x3c00, 0x2200, 0x2200, 0x2200, 0x3c00, 0x2000, 0x2000, 0x2000, 0x2000, 0x0000, 0x0000,
    0x0000, 0x0c00, 0x1200, 0x2100, 0x2100, 0x2100, 0x2100, 0x2100, 0x1600, 0x0d00, 0x0100, 0x0000,
    0x0000, 0x3e00, 0x2100, 0x2100, 0x2100, 0x3e00, 0x2400, 0x2200, 0x2100, 0x2080, 0x0000, 0x0000,
    0x0000, 0x1c00, 0x2200, 0x2200, 0x2000, 0x1c00, 0x0200, 0x2200, 0x2200, 0x1c00, 0x0000, 0x0000,
    0x0000, 0x3e00, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000,
    0x0000, 0x2100, 0x2100, 0x2100, 0x2100, 0x2100, 0x2100, 0x2100, 0x1200, 0x0c00, 0x0000, 0x0000,
    0x0000, 0x4100, 0x4100, 0x2200, 0x2200, 0x2200, 0x1400, 0x1400, 0x1400, 0x0800, 0x0000, 0x0000,
    0x0000, 0x4440, 0x4a40, 0x2a40, 0x2a80, 0x2a80, 0x2a80, 0x2a80, 0x2a80, 0x1100, 0x0000, 0x0000,
    0x0000, 0x4100, 0x2200, 0x1400, 0x1400, 0x0800, 0x1400, 0x1400, 0x2200, 0x4100, 0x0000, 0x0000,
    0x0000, 0x4100, 0x2200, 0x2200, 0x1400, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800, 0x0000, 0x0000,
    0x0000, 0x7e00, 0x0200, 0x0400, 0x0800, 0x1000, 0x1000, 0x2000, 0x4000, 0x7e00, 0x0000, 0x0000,
    0x0000, 0x3000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
    0x0000, 0x4000, 0x4000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1000, 0x1000, 0x0000, 0x0000,
    0x0000, 0x6000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
    0x0000, 0x1000, 0x2800, 0x2800, 0x2800, 0x4400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7e00,
    0x4000, 0x2000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x3800, 0x4400, 0x0400, 0x3c00, 0x4400, 0x4400, 0x3c00, 0x0000, 0x0000,
    0x0000, 0x4000, 0x4000, 0x5800, 0x6400, 0x4400, 0x4400, 0x4400, 0x6400, 0x5800, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x3000, 0x4800, 0x4000, 0x4000, 0x4000, 0x4800, 0x3000, 0x0000, 0x0000,
    0x0000, 0x0400, 0x0400, 0x3400, 0x4c00, 0x4400, 0x4400, 0x4400, 0x4c00, 0x3400, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x3800, 0x4400, 0x4400, 0x7c00, 0x4000, 0x4400, 0x3800, 0x0000, 0x0000,
    0x0000, 0x6000, 0x4000, 0xe000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x3400, 0x4c00, 0x4400, 0x4400, 0x4400, 0x4c00, 0x3400, 0x0400, 0x4400,
    0x0000, 0x4000, 0x4000, 0x5800, 0x6400, 0x4400, 0x4400, 0x4400, 0x4400, 0x4400, 0x0000, 0x0000,
    0x0000, 0x4000, 0x0000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000,
    0x0000, 0x4000, 0x0000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000,
    0x0000, 0x4000, 0x4000, 0x4800, 0x5000, 0x6000, 0x5000, 0x5000, 0x4800, 0x4800, 0x0000, 0x0000,
    0x0000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x5200, 0x6d00, 0x4900, 0x4900, 0x4900, 0x4900, 0x4900, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x5800, 0x6400, 0x4400, 0x4400, 0x4400, 0x4400, 0x4400, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x3800, 0x4400, 0x4400, 0x4400, 0x4400, 0x4400, 0x3800, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x5800, 0x6400, 0x4400, 0x4400, 0x4400, 0x6400, 0x5800, 0x4000, 0x4000,
    0x0000, 0x0000, 0x0000, 0x3400, 0x4c00, 0x4400, 0x4400, 0x4400, 0x4c00, 0x3400, 0x0400, 0x0400,
    0x0000, 0x0000, 0x0000, 0x5000, 0x6000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x3000, 0x4800, 0x4000, 0x3000, 0x0800, 0x4800, 0x3000, 0x0000, 0x0000,
    0x0000, 0x4000, 0x4000, 0xe000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x6000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x4400, 0x4400, 0x4400, 0x4400, 0x4400, 0x4c00, 0x3400, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x4400, 0x4400, 0x2800, 0x2800, 0x2800, 0x2800, 0x1000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x4900, 0x4900, 0x5500, 0x5500, 0x5500, 0x5500, 0x2200, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x4400, 0x2800, 0x2800, 0x1000, 0x2800, 0x2800, 0x4400, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x4400, 0x4400, 0x2800, 0x2800, 0x2800, 0x1000, 0x1000, 0x1000, 0x1000,
    0x0000, 0x0000, 0x0000, 0x7800, 0x0800, 0x1000, 0x2000, 0x2000, 0x4000, 0x7800, 0x0000, 0x0000,
    0x0000, 0x1000, 0x2000, 0x2000, 0x2000, 0x2000, 0x4000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
    0x0000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
    0x0000, 0x4000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x7400, 0x5800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x7000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5000, 0x5000, 0x7000, 0x0000, 0x0000
  };

/**
  * @brief  ASCII font 8x12 table definition
  */  
const uint16_t GL_ASCII8x12_Table [] =
  {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00,
    0x00, 0x00, 0x00, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x14, 0x14, 0x3e, 0x14, 0x28, 0x7c, 0x28, 0x28, 0x00,
    0x00, 0x00, 0x10, 0x38, 0x54, 0x50, 0x38, 0x14, 0x14, 0x54, 0x38, 0x10,
    0x00, 0x00, 0x00, 0x44, 0xa8, 0xa8, 0x50, 0x14, 0x1a, 0x2a, 0x24, 0x00,
    0x00, 0x00, 0x00, 0x20, 0x50, 0x50, 0x20, 0xe8, 0x98, 0x98, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x40, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x00, 0x00, 0x80, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x00, 0x00, 0x00, 0x40, 0xe0, 0x40, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0xf8, 0x20, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x40, 0x40, 0x80, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x20, 0x60, 0xa0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00,
    0x00, 0x00, 0x00, 0x60, 0x90, 0x10, 0x10, 0x20, 0x40, 0x80, 0xf0, 0x00,
    0x00, 0x00, 0x00, 0x60, 0x90, 0x10, 0x60, 0x10, 0x10, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x10, 0x30, 0x50, 0x50, 0x90, 0xf8, 0x10, 0x10, 0x00,
    0x00, 0x00, 0x00, 0x70, 0x40, 0x80, 0xe0, 0x10, 0x10, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x60, 0x90, 0x80, 0xa0, 0xd0, 0x90, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0xf0, 0x10, 0x20, 0x20, 0x20, 0x40, 0x40, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0x60, 0x90, 0x90, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0xb0, 0x50, 0x10, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x60, 0x80, 0x60, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x60, 0x10, 0x60, 0x80, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x60, 0x90, 0x10, 0x20, 0x40, 0x40, 0x00, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x1c, 0x22, 0x5b, 0xa5, 0xa5, 0xa5, 0xa5, 0x9e, 0x41,
    0x00, 0x00, 0x00, 0x20, 0x50, 0x50, 0x50, 0x50, 0x70, 0x88, 0x88, 0x00,
    0x00, 0x00, 0x00, 0xf0, 0x88, 0x88, 0xf0, 0x88, 0x88, 0x88, 0xf0, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x44, 0x84, 0x80, 0x80, 0x84, 0x44, 0x38, 0x00,
    0x00, 0x00, 0x00, 0xe0, 0x90, 0x88, 0x88, 0x88, 0x88, 0x90, 0xe0, 0x00,
    0x00, 0x00, 0x00, 0xf8, 0x80, 0x80, 0xf8, 0x80, 0x80, 0x80, 0xf8, 0x00,
    0x00, 0x00, 0x00, 0x78, 0x40, 0x40, 0x70, 0x40, 0x40, 0x40, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x44, 0x84, 0x80, 0x9c, 0x84, 0x44, 0x38, 0x00,
    0x00, 0x00, 0x00, 0x88, 0x88, 0x88, 0xf8, 0x88, 0x88, 0x88, 0x88, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x90, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x88, 0x90, 0xa0, 0xe0, 0xa0, 0x90, 0x90, 0x88, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xf0, 0x00,
    0x00, 0x00, 0x00, 0x82, 0xc6, 0xc6, 0xaa, 0xaa, 0xaa, 0xaa, 0x92, 0x00,
    0x00, 0x00, 0x00, 0x84, 0xc4, 0xa4, 0xa4, 0x94, 0x94, 0x8c, 0x84, 0x00,
    0x00, 0x00, 0x00, 0x30, 0x48, 0x84, 0x84, 0x84, 0x84, 0x48, 0x30, 0x00,
    0x00, 0x00, 0x00, 0xf0, 0x88, 0x88, 0x88, 0xf0, 0x80, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x30, 0x48, 0x84, 0x84, 0x84, 0x84, 0x58, 0x34, 0x04,
    0x00, 0x00, 0x00, 0x78, 0x44, 0x44, 0x78, 0x50, 0x48, 0x44, 0x42, 0x00,
    0x00, 0x00, 0x00, 0x70, 0x88, 0x80, 0x70, 0x08, 0x88, 0x88, 0x70, 0x00,
    0x00, 0x00, 0x00, 0xf8, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00,
    0x00, 0x00, 0x00, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x48, 0x30, 0x00,
    0x00, 0x00, 0x00, 0x88, 0x88, 0x50, 0x50, 0x50, 0x50, 0x50, 0x20, 0x00,
    0x00, 0x00, 0x00, 0x92, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x00,
    0x00, 0x00, 0x00, 0x84, 0x48, 0x48, 0x30, 0x30, 0x48, 0x48, 0x84, 0x00,
    0x00, 0x00, 0x00, 0x88, 0x50, 0x50, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00,
    0x00, 0x00, 0x00, 0xf8, 0x08, 0x10, 0x20, 0x20, 0x40, 0x80, 0xf8, 0x00,
    0x00, 0x00, 0x00, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x00,
    0x00, 0x00, 0x00, 0xc0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x00, 0x00, 0x00, 0x40, 0xa0, 0xa0, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
    0x00, 0x00, 0x00, 0x80, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x10, 0x70, 0x90, 0x90, 0x70, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x80, 0xa0, 0xd0, 0x90, 0x90, 0xd0, 0xa0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x90, 0x80, 0x80, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x10, 0x10, 0x50, 0xb0, 0x90, 0x90, 0xb0, 0x50, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x90, 0xf0, 0x80, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0xc0, 0x80, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xb0, 0x90, 0x90, 0xb0, 0x50, 0x10,
    0x00, 0x00, 0x00, 0x80, 0x80, 0xa0, 0xd0, 0x90, 0x90, 0x90, 0x90, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x00, 0x00, 0x80, 0x80, 0x90, 0xa0, 0xc0, 0xa0, 0x90, 0x90, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xda, 0x92, 0x92, 0x92, 0x92, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xd0, 0x90, 0x90, 0x90, 0x90, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x90, 0x90, 0x90, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xd0, 0x90, 0x90, 0xd0, 0xa0, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xb0, 0x90, 0x90, 0xb0, 0x50, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xc0, 0x80, 0x80, 0x80, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x90, 0x40, 0x20, 0x90, 0x60, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x80, 0xc0, 0x80, 0x80, 0x80, 0x80, 0xc0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x90, 0x90, 0x90, 0xb0, 0x50, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x50, 0x50, 0x50, 0x20, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0xaa, 0xaa, 0xaa, 0xaa, 0x44, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x50, 0x20, 0x20, 0x50, 0x88, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x50, 0x50, 0x50, 0x20, 0x20, 0x20,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x10, 0x20, 0x40, 0x80, 0xf0, 0x00,
    0x00, 0x00, 0x00, 0xc0, 0x80, 0x80, 0x80, 0x00, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x00, 0x00, 0xc0, 0x40, 0x40, 0x40, 0x20, 0x40, 0x40, 0x40, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0xb0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xe0, 0x00
  };

/**
  * @brief  ASCII font 8x8 table definition
  */
const uint16_t GL_ASCII8x8_Table [] =
  {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x00, 0x40,
    0xa0, 0xa0, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x24, 0x24, 0xfe, 0x48, 0xfc, 0x48, 0x48,
    0x38, 0x54, 0x50, 0x38, 0x14, 0x14, 0x54, 0x38,
    0x44, 0xa8, 0xa8, 0x50, 0x14, 0x1a, 0x2a, 0x24,
    0x10, 0x28, 0x28, 0x10, 0x74, 0x4c, 0x4c, 0x30,
    0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08,
    0x10, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10,
    0x00, 0x00, 0x24, 0x18, 0x3c, 0x18, 0x24, 0x00,
    0x00, 0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18,
    0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x20,
    0x18, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x18,
    0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08,
    0x38, 0x44, 0x00, 0x04, 0x08, 0x10, 0x20, 0x7c,
    0x18, 0x24, 0x04, 0x18, 0x04, 0x04, 0x24, 0x18,
    0x04, 0x0c, 0x14, 0x24, 0x44, 0x7e, 0x04, 0x04,
    0x3c, 0x20, 0x20, 0x38, 0x04, 0x04, 0x24, 0x18,
    0x18, 0x24, 0x20, 0x38, 0x24, 0x24, 0x24, 0x18,
    0x3c, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x10,
    0x18, 0x24, 0x24, 0x18, 0x24, 0x24, 0x24, 0x18,
    0x18, 0x24, 0x24, 0x24, 0x1c, 0x04, 0x24, 0x18,
    0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x10, 0x00,
    0x00, 0x00, 0x04, 0x18, 0x20, 0x18, 0x04, 0x00,
    0x00, 0x00, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x18, 0x04, 0x18, 0x20, 0x00,
    0x18, 0x24, 0x04, 0x08, 0x10, 0x10, 0x00, 0x10,
    0x3c, 0x42, 0x99, 0xa5, 0xa5, 0x9d, 0x42, 0x38,
    0x38, 0x44, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44,
    0x78, 0x44, 0x44, 0x78, 0x44, 0x44, 0x44, 0x78,
    0x1c, 0x22, 0x42, 0x40, 0x40, 0x42, 0x22, 0x1c,
    0x70, 0x48, 0x44, 0x44, 0x44, 0x44, 0x48, 0x70,
    0x7c, 0x40, 0x40, 0x7c, 0x40, 0x40, 0x40, 0x7c,
    0x3c, 0x20, 0x20, 0x38, 0x20, 0x20, 0x20, 0x20,
    0x1c, 0x22, 0x42, 0x40, 0x4e, 0x42, 0x22, 0x1c,
    0x44, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x44,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x24, 0x24, 0x18,
    0x44, 0x48, 0x50, 0x70, 0x50, 0x48, 0x48, 0x44,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3c,
    0x82, 0xc6, 0xc6, 0xaa, 0xaa, 0xaa, 0xaa, 0x92,
    0x42, 0x62, 0x52, 0x52, 0x4a, 0x4a, 0x46, 0x42,
    0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18,
    0x78, 0x44, 0x44, 0x44, 0x78, 0x40, 0x40, 0x40,
    0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x2c, 0x1a,
    0x78, 0x44, 0x44, 0x78, 0x50, 0x48, 0x44, 0x42,
    0x38, 0x44, 0x40, 0x38, 0x04, 0x44, 0x44, 0x38,
    0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18,
    0x44, 0x44, 0x28, 0x28, 0x28, 0x28, 0x28, 0x10,
    0x92, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x44,
    0x42, 0x24, 0x24, 0x18, 0x18, 0x24, 0x24, 0x42,
    0x44, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x7c, 0x04, 0x08, 0x10, 0x10, 0x20, 0x40, 0x7c,
    0x1c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1c,
    0x10, 0x10, 0x08, 0x08, 0x08, 0x08, 0x04, 0x04,
    0x1c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1c,
    0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x04, 0x1c, 0x24, 0x24, 0x1c,
    0x20, 0x20, 0x28, 0x34, 0x24, 0x24, 0x34, 0x28,
    0x00, 0x00, 0x18, 0x24, 0x20, 0x20, 0x24, 0x18,
    0x04, 0x04, 0x14, 0x2c, 0x24, 0x24, 0x2c, 0x14,
    0x00, 0x00, 0x18, 0x24, 0x3c, 0x20, 0x24, 0x18,
    0x00, 0x18, 0x10, 0x10, 0x18, 0x10, 0x10, 0x10,
    0x00, 0x18, 0x24, 0x24, 0x18, 0x04, 0x24, 0x18,
    0x20, 0x20, 0x28, 0x34, 0x24, 0x24, 0x24, 0x24,
    0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x08, 0x00, 0x08, 0x08, 0x08, 0x08, 0x28, 0x10,
    0x20, 0x20, 0x24, 0x28, 0x30, 0x28, 0x24, 0x24,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x00, 0x00, 0xa6, 0xda, 0x92, 0x92, 0x92, 0x92,
    0x00, 0x00, 0x28, 0x34, 0x24, 0x24, 0x24, 0x24,
    0x00, 0x00, 0x18, 0x24, 0x24, 0x24, 0x24, 0x18,
    0x00, 0x28, 0x34, 0x24, 0x38, 0x20, 0x20, 0x20,
    0x00, 0x14, 0x2c, 0x24, 0x1c, 0x04, 0x04, 0x04,
    0x00, 0x00, 0x2c, 0x30, 0x20, 0x20, 0x20, 0x20,
    0x00, 0x00, 0x18, 0x24, 0x10, 0x08, 0x24, 0x18,
    0x00, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x18,
    0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x2c, 0x14,
    0x00, 0x00, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10,
    0x00, 0x00, 0x92, 0xaa, 0xaa, 0xaa, 0xaa, 0x44,
    0x00, 0x00, 0x44, 0x28, 0x10, 0x10, 0x28, 0x44,
    0x00, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10,
    0x00, 0x00, 0x3c, 0x04, 0x08, 0x10, 0x20, 0x3c,
    0x00, 0x08, 0x10, 0x10, 0x20, 0x10, 0x10, 0x08,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x00, 0x10, 0x08, 0x08, 0x04, 0x08, 0x08, 0x10,
    0x00, 0x00, 0x00, 0x60, 0x92, 0x0c, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
  };


/**
  * @brief  ASCII font 8x12: each character is 8 column (8dots large) and 12 raw (12 dots high) 
  */
const uint16_t GL_ASCII8x12_bold_Table[] =
  {
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* ' ' 32 */
    0x00,  0x18,  0x3C,  0x3C,  0x3C,  0x18,  0x18,  0x00,  0x18,  0x18,  0x00,  0x00,   /* '!' 33 */
    0x36,  0x36,  0x36,  0x14,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '"' 34 */
    0x00,  0x6C,  0x6C,  0x6C,  0xFE,  0x6C,  0x6C,  0xFE,  0x6C,  0x6C,  0x00,  0x00,   /* '#' 35 */
    0x18,  0x18,  0x7C,  0xC6,  0xC0,  0x78,  0x3C,  0x06,  0xC6,  0x7C,  0x18,  0x18,   /* '$' 36 */
    0x00,  0x00,  0x00,  0x62,  0x66,  0x0C,  0x18,  0x30,  0x66,  0xC6,  0x00,  0x00,   /* '%' 37 */
    0x00,  0x38,  0x6C,  0x38,  0x38,  0x76,  0xF6,  0xCE,  0xCC,  0x76,  0x00,  0x00,   /* '&' 38 */
    0x0C,  0x0C,  0x0C,  0x18,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* ''' 39 */
    0x00,  0x0C,  0x18,  0x30,  0x30,  0x30,  0x30,  0x30,  0x18,  0x0C,  0x00,  0x00,   /* '(' 40 */
    0x00,  0x30,  0x18,  0x0C,  0x0C,  0x0C,  0x0C,  0x0C,  0x18,  0x30,  0x00,  0x00,   /* ')' 41 */
    0x00,  0x00,  0x00,  0x6C,  0x38,  0xFE,  0x38,  0x6C,  0x00,  0x00,  0x00,  0x00,   /* '*' 42 */
    0x00,  0x00,  0x00,  0x18,  0x18,  0x7E,  0x18,  0x18,  0x00,  0x00,  0x00,  0x00,   /* '+' 43 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x0C,  0x0C,  0x0C,  0x18,  0x00,   /* ',' 44 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0xFE,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '-' 45 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x18,  0x18,  0x00,  0x00,   /* '.' 46 */
    0x00,  0x00,  0x02,  0x06,  0x0C,  0x18,  0x30,  0x60,  0xC0,  0x80,  0x00,  0x00,   /* '/' 47 */
    0x00,  0x7C,  0xC6,  0xCE,  0xDE,  0xF6,  0xE6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '0' 48 */
    0x00,  0x18,  0x78,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x7E,  0x00,  0x00,   /* '1' 49 */
    0x00,  0x7C,  0xC6,  0xC6,  0x0C,  0x18,  0x30,  0x60,  0xC6,  0xFE,  0x00,  0x00,   /* '2' 50 */
    0x00,  0x7C,  0xC6,  0x06,  0x06,  0x3C,  0x06,  0x06,  0xC6,  0x7C,  0x00,  0x00,   /* '3' 51 */
    0x00,  0x0C,  0x1C,  0x3C,  0x6C,  0xCC,  0xFE,  0x0C,  0x0C,  0x0C,  0x00,  0x00,   /* '4' 52 */
    0x00,  0xFE,  0xC0,  0xC0,  0xC0,  0xFC,  0x06,  0x06,  0xC6,  0x7C,  0x00,  0x00,   /* '5' 53 */
    0x00,  0x7C,  0xC6,  0xC0,  0xC0,  0xFC,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '6' 54 */
    0x00,  0xFE,  0xC6,  0x0C,  0x18,  0x30,  0x30,  0x30,  0x30,  0x30,  0x00,  0x00,   /* '7' 55 */
    0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0x7C,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '8' 56 */
    0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0x7E,  0x06,  0x06,  0xC6,  0x7C,  0x00,  0x00,   /* '9' 57 */
    0x00,  0x00,  0x00,  0x0C,  0x0C,  0x00,  0x00,  0x0C,  0x0C,  0x00,  0x00,  0x00,   /* ':' 58 */
    0x00,  0x00,  0x00,  0x0C,  0x0C,  0x00,  0x00,  0x0C,  0x0C,  0x0C,  0x18,  0x00,   /* ';' 59 */
    0x00,  0x0C,  0x18,  0x30,  0x60,  0xC0,  0x60,  0x30,  0x18,  0x0C,  0x00,  0x00,   /* '<' 60 */
    0x00,  0x00,  0x00,  0x00,  0xFE,  0x00,  0xFE,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '=' 61 */
    0x00,  0x60,  0x30,  0x18,  0x0C,  0x06,  0x0C,  0x18,  0x30,  0x60,  0x00,  0x00,   /* '>' 62 */
    0x00,  0x7C,  0xC6,  0xC6,  0x0C,  0x18,  0x18,  0x00,  0x18,  0x18,  0x00,  0x00,   /* '?' 63 */
    0x00,  0x7C,  0xC6,  0xC6,  0xDE,  0xDE,  0xDE,  0xDC,  0xC0,  0x7E,  0x00,  0x00,   /* '@' 64 */
    0x00,  0x38,  0x6C,  0xC6,  0xC6,  0xC6,  0xFE,  0xC6,  0xC6,  0xC6,  0x00,  0x00,   /* 'A' 65 */
    0x00,  0xFC,  0x66,  0x66,  0x66,  0x7C,  0x66,  0x66,  0x66,  0xFC,  0x00,  0x00,   /* 'B' 66 */
    0x00,  0x3C,  0x66,  0xC0,  0xC0,  0xC0,  0xC0,  0xC0,  0x66,  0x3C,  0x00,  0x00,   /* 'C' 67 */
    0x00,  0xF8,  0x6C,  0x66,  0x66,  0x66,  0x66,  0x66,  0x6C,  0xF8,  0x00,  0x00,   /* 'D' 68 */
    0x00,  0xFE,  0x66,  0x60,  0x60,  0x7C,  0x60,  0x60,  0x66,  0xFE,  0x00,  0x00,   /* 'E' 69 */
    0x00,  0xFE,  0x66,  0x60,  0x60,  0x7C,  0x60,  0x60,  0x60,  0xF0,  0x00,  0x00,   /* 'F' 70 */
    0x00,  0x7C,  0xC6,  0xC6,  0xC0,  0xC0,  0xCE,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* 'G' 71 */
    0x00,  0xC6,  0xC6,  0xC6,  0xC6,  0xFE,  0xC6,  0xC6,  0xC6,  0xC6,  0x00,  0x00,   /* 'H' 72 */
    0x00,  0x3C,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x3C,  0x00,  0x00,   /* 'I' 73 */
    0x00,  0x3C,  0x18,  0x18,  0x18,  0x18,  0x18,  0xD8,  0xD8,  0x70,  0x00,  0x00,   /* 'J' 74 */
    0x00,  0xC6,  0xCC,  0xD8,  0xF0,  0xF0,  0xD8,  0xCC,  0xC6,  0xC6,  0x00,  0x00,   /* 'K' 75 */
    0x00,  0xF0,  0x60,  0x60,  0x60,  0x60,  0x60,  0x62,  0x66,  0xFE,  0x00,  0x00,   /* 'L' 76 */
    0x00,  0xC6,  0xC6,  0xEE,  0xFE,  0xD6,  0xD6,  0xD6,  0xC6,  0xC6,  0x00,  0x00,   /* 'M' 77 */
    0x00,  0xC6,  0xC6,  0xE6,  0xE6,  0xF6,  0xDE,  0xCE,  0xCE,  0xC6,  0x00,  0x00,   /* 'N' 78 */
    0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* 'O' 79 */
    0x00,  0xFC,  0x66,  0x66,  0x66,  0x7C,  0x60,  0x60,  0x60,  0xF0,  0x00,  0x00,   /* 'P' 80 */
    0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xD6,  0x7C,  0x06,  0x00,   /* 'Q' 81 */
    0x00,  0xFC,  0x66,  0x66,  0x66,  0x7C,  0x78,  0x6C,  0x66,  0xE6,  0x00,  0x00,   /* 'R' 82 */
    0x00,  0x7C,  0xC6,  0xC0,  0x60,  0x38,  0x0C,  0x06,  0xC6,  0x7C,  0x00,  0x00,   /* 'S' 83 */
    0x00,  0x7E,  0x5A,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x3C,  0x00,  0x00,   /* 'T' 84 */
    0x00,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* 'U' 85 */
    0x00,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0x6C,  0x38,  0x10,  0x00,  0x00,   /* 'V' 86 */
    0x00,  0xC6,  0xC6,  0xD6,  0xD6,  0xD6,  0xFE,  0xEE,  0xC6,  0xC6,  0x00,  0x00,   /* 'W' 87 */
    0x00,  0xC6,  0xC6,  0x6C,  0x38,  0x38,  0x38,  0x6C,  0xC6,  0xC6,  0x00,  0x00,   /* 'X' 88 */
    0x00,  0x66,  0x66,  0x66,  0x66,  0x3C,  0x18,  0x18,  0x18,  0x3C,  0x00,  0x00,   /* 'Y' 89 */
    0x00,  0xFE,  0xC6,  0x8C,  0x18,  0x30,  0x60,  0xC2,  0xC6,  0xFE,  0x00,  0x00,   /* 'Z' 90 */
    0x00,  0x7C,  0x60,  0x60,  0x60,  0x60,  0x60,  0x60,  0x60,  0x7C,  0x00,  0x00,   /* '[' 91 */
    0x00,  0x00,  0x80,  0xC0,  0x60,  0x30,  0x18,  0x0C,  0x06,  0x02,  0x00,  0x00,   /* '\' 92 */
    0x00,  0x7C,  0x0C,  0x0C,  0x0C,  0x0C,  0x0C,  0x0C,  0x0C,  0x7C,  0x00,  0x00,   /* ']' 93 */
    0x10,  0x38,  0x6C,  0xC6,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '^' 94 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFF,   /* '_' 95 */
    0x18,  0x18,  0x18,  0x0C,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '`' 96 */
    0x00,  0x00,  0x00,  0x00,  0x78,  0x0C,  0x7C,  0xCC,  0xDC,  0x76,  0x00,  0x00,   /* 'a' 97 */
    0x00,  0xE0,  0x60,  0x60,  0x7C,  0x66,  0x66,  0x66,  0x66,  0xFC,  0x00,  0x00,   /* 'b' 98 */
    0x00,  0x00,  0x00,  0x00,  0x7C,  0xC6,  0xC0,  0xC0,  0xC6,  0x7C,  0x00,  0x00,   /* 'c' 99 */
    0x00,  0x1C,  0x0C,  0x0C,  0x7C,  0xCC,  0xCC,  0xCC,  0xCC,  0x7E,  0x00,  0x00,   /* 'd' 100 */
    0x00,  0x00,  0x00,  0x00,  0x7C,  0xC6,  0xFE,  0xC0,  0xC6,  0x7C,  0x00,  0x00,   /* 'e' 101 */
    0x00,  0x1C,  0x36,  0x30,  0x30,  0xFC,  0x30,  0x30,  0x30,  0x78,  0x00,  0x00,   /* 'f' 102 */
    0x00,  0x00,  0x00,  0x00,  0x76,  0xCE,  0xC6,  0xC6,  0x7E,  0x06,  0xC6,  0x7C,   /* 'g' 103 */
    0x00,  0xE0,  0x60,  0x60,  0x6C,  0x76,  0x66,  0x66,  0x66,  0xE6,  0x00,  0x00,   /* 'h' 104 */
    0x00,  0x18,  0x18,  0x00,  0x38,  0x18,  0x18,  0x18,  0x18,  0x3C,  0x00,  0x00,   /* 'i' 105 */
    0x00,  0x0C,  0x0C,  0x00,  0x1C,  0x0C,  0x0C,  0x0C,  0x0C,  0xCC,  0xCC,  0x78,   /* 'j' 106 */
    0x00,  0xE0,  0x60,  0x60,  0x66,  0x6C,  0x78,  0x6C,  0x66,  0xE6,  0x00,  0x00,   /* 'k' 107 */
    0x00,  0x38,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x3C,  0x00,  0x00,   /* 'l' 108 */
    0x00,  0x00,  0x00,  0x00,  0x6C,  0xFE,  0xD6,  0xD6,  0xC6,  0xC6,  0x00,  0x00,   /* 'm' 109 */
    0x00,  0x00,  0x00,  0x00,  0xDC,  0x66,  0x66,  0x66,  0x66,  0x66,  0x00,  0x00,   /* 'n' 110 */
    0x00,  0x00,  0x00,  0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* 'o' 111 */
    0x00,  0x00,  0x00,  0x00,  0xDC,  0x66,  0x66,  0x66,  0x7C,  0x60,  0x60,  0xF0,   /* 'p' 112 */
    0x00,  0x00,  0x00,  0x00,  0x76,  0xCC,  0xCC,  0xCC,  0x7C,  0x0C,  0x0C,  0x1E,   /* 'q' 113 */
    0x00,  0x00,  0x00,  0x00,  0xDC,  0x66,  0x60,  0x60,  0x60,  0xF0,  0x00,  0x00,   /* 'r' 114 */
    0x00,  0x00,  0x00,  0x00,  0x7C,  0xC6,  0x70,  0x1C,  0xC6,  0x7C,  0x00,  0x00,   /* 's' 115 */
    0x00,  0x30,  0x30,  0x30,  0xFC,  0x30,  0x30,  0x30,  0x36,  0x1C,  0x00,  0x00,   /* 't' 116 */
    0x00,  0x00,  0x00,  0x00,  0xCC,  0xCC,  0xCC,  0xCC,  0xCC,  0x76,  0x00,  0x00,   /* 'u' 117 */
    0x00,  0x00,  0x00,  0x00,  0xC6,  0xC6,  0xC6,  0x6C,  0x38,  0x10,  0x00,  0x00,   /* 'v' 118 */
    0x00,  0x00,  0x00,  0x00,  0xC6,  0xC6,  0xD6,  0xD6,  0xFE,  0x6C,  0x00,  0x00,   /* 'w' 119 */
    0x00,  0x00,  0x00,  0x00,  0xC6,  0x6C,  0x38,  0x38,  0x6C,  0xC6,  0x00,  0x00,   /* 'x' 120 */
    0x00,  0x00,  0x00,  0x00,  0xC6,  0xC6,  0xC6,  0xCE,  0x76,  0x06,  0xC6,  0x7C,   /* 'y' 121 */
    0x00,  0x00,  0x00,  0x00,  0xFE,  0x8C,  0x18,  0x30,  0x62,  0xFE,  0x00,  0x00,   /* 'z' 122 */
    0x00,  0x0E,  0x18,  0x18,  0x18,  0x70,  0x18,  0x18,  0x18,  0x0E,  0x00,  0x00,   /* '{' 123 */
    0x00,  0x18,  0x18,  0x18,  0x18,  0x00,  0x18,  0x18,  0x18,  0x18,  0x00,  0x00,   /* '|' 124 */
    0x00,  0x70,  0x18,  0x18,  0x18,  0x0E,  0x18,  0x18,  0x18,  0x70,  0x00,  0x00,   /* '}' 125 */
    0x00,  0x76,  0xDC,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '~' 126 */
    0x00,  0x00,  0x00,  0x10,  0x38,  0x38,  0x6C,  0x6C,  0xFE,  0x00,  0x00,  0x00,   /* ' ' 127 */
    0x00,  0x3C,  0x66,  0xC0,  0xC0,  0xC0,  0xC6,  0x66,  0x3C,  0x18,  0xCC,  0x38,   /* '' 128 */
    0x00,  0xC6,  0xC6,  0x00,  0xC6,  0xC6,  0xC6,  0xC6,  0xCE,  0x76,  0x00,  0x00,   /* '' 129 */
    0x0C,  0x18,  0x30,  0x00,  0x7C,  0xC6,  0xFE,  0xC0,  0xC6,  0x7C,  0x00,  0x00,   /* '' 130 */
    0x30,  0x78,  0xCC,  0x00,  0x78,  0x0C,  0x7C,  0xCC,  0xDC,  0x76,  0x00,  0x00,   /* '' 131 */
    0x00,  0xCC,  0xCC,  0x00,  0x78,  0x0C,  0x7C,  0xCC,  0xDC,  0x76,  0x00,  0x00,   /* '' 132 */
    0x60,  0x30,  0x18,  0x00,  0x78,  0x0C,  0x7C,  0xCC,  0xDC,  0x76,  0x00,  0x00,   /* '' 133 */
    0x38,  0x6C,  0x38,  0x00,  0x78,  0x0C,  0x7C,  0xCC,  0xDC,  0x76,  0x00,  0x00,   /* '' 134 */
    0x00,  0x00,  0x00,  0x7C,  0xC6,  0xC0,  0xC0,  0xC6,  0x7C,  0x18,  0x6C,  0x38,   /* '' 135 */
    0x30,  0x78,  0xCC,  0x00,  0x7C,  0xC6,  0xFE,  0xC0,  0xC6,  0x7C,  0x00,  0x00,   /* '' 136 */
    0x00,  0xCC,  0xCC,  0x00,  0x7C,  0xC6,  0xFE,  0xC0,  0xC6,  0x7C,  0x00,  0x00,   /* '' 137 */
    0x30,  0x18,  0x0C,  0x00,  0x7C,  0xC6,  0xFE,  0xC0,  0xC6,  0x7C,  0x00,  0x00,   /* '' 138 */
    0x00,  0x66,  0x66,  0x00,  0x38,  0x18,  0x18,  0x18,  0x18,  0x3C,  0x00,  0x00,   /* '' 139 */
    0x18,  0x3C,  0x66,  0x00,  0x38,  0x18,  0x18,  0x18,  0x18,  0x3C,  0x00,  0x00,   /* '' 140 */
    0x60,  0x30,  0x18,  0x00,  0x38,  0x18,  0x18,  0x18,  0x18,  0x3C,  0x00,  0x00,   /* ' ' 141 */
    0xC6,  0xC6,  0x00,  0x38,  0x6C,  0xC6,  0xFE,  0xC6,  0xC6,  0xC6,  0x00,  0x00,   /* '' 142 */
    0x38,  0x6C,  0x38,  0x00,  0x38,  0x6C,  0xC6,  0xC6,  0xFE,  0xC6,  0xC6,  0x00,   /* '' 143 */
    0x0C,  0x18,  0x30,  0x00,  0xFE,  0x60,  0x60,  0x7C,  0x60,  0x60,  0xFE,  0x00,   /* '' 144 */
    0x00,  0x00,  0x00,  0x66,  0xDB,  0x1B,  0x7F,  0xD8,  0xDF,  0x76,  0x00,  0x00,   /* '' 145 */
    0x7E,  0xD8,  0xD8,  0xD8,  0xD8,  0xFE,  0xD8,  0xD8,  0xD8,  0xDE,  0x00,  0x00,   /* '' 146 */
    0x30,  0x78,  0xCC,  0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '' 147 */
    0x00,  0xC6,  0xC6,  0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '' 148 */
    0x30,  0x18,  0x0C,  0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '' 149 */
    0x30,  0x78,  0xCC,  0x00,  0xC6,  0xC6,  0xC6,  0xC6,  0xCE,  0x76,  0x00,  0x00,   /* '' 150 */
    0x60,  0x30,  0x18,  0x00,  0xC6,  0xC6,  0xC6,  0xC6,  0xCE,  0x76,  0x00,  0x00,   /* '' 151 */
    0x00,  0xC6,  0xC6,  0x00,  0xC6,  0xC6,  0xC6,  0xCE,  0x76,  0x06,  0xC6,  0x7C,   /* '' 152 */
    0xC6,  0xC6,  0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '' 153 */
    0xC6,  0xC6,  0x00,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '' 154 */
    0x18,  0x18,  0x3C,  0x66,  0x60,  0x60,  0x66,  0x3C,  0x18,  0x18,  0x00,  0x00,   /* '' 155 */
    0x00,  0x38,  0x6C,  0x60,  0x60,  0xF0,  0x60,  0x66,  0xF6,  0x6C,  0x00,  0x00,   /* '' 156 */
    0x00,  0x66,  0x66,  0x3C,  0x18,  0x7E,  0x18,  0x3C,  0x18,  0x18,  0x00,  0x00,   /* '' 157 */
    0xFC,  0xC6,  0xFC,  0xC0,  0xCC,  0xDE,  0xCC,  0xCC,  0xCC,  0xC6,  0x00,  0x00,   /* '' 158 */
    0x0E,  0x1B,  0x18,  0x18,  0x18,  0x7E,  0x18,  0x18,  0x18,  0x18,  0xD8,  0x70,   /* '' 159 */
    0x0C,  0x18,  0x30,  0x00,  0x78,  0x0C,  0x7C,  0xCC,  0xDC,  0x76,  0x00,  0x00,   /* ' ' 160 */
    0x0C,  0x18,  0x30,  0x00,  0x38,  0x18,  0x18,  0x18,  0x18,  0x3C,  0x00,  0x00,   /* '' 161 */
    0x0C,  0x18,  0x30,  0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '' 162 */
    0x18,  0x30,  0x60,  0x00,  0xCC,  0xCC,  0xCC,  0xCC,  0xDC,  0x76,  0x00,  0x00,   /* '' 163 */
    0x00,  0x76,  0xDC,  0x00,  0xBC,  0x66,  0x66,  0x66,  0x66,  0xE6,  0x00,  0x00,   /* '' 164 */
    0x76,  0xDC,  0x00,  0xC6,  0xC6,  0xE6,  0xF6,  0xDE,  0xCE,  0xC6,  0x00,  0x00,   /* '' 165 */
    0x3C,  0x6C,  0x6C,  0x3E,  0x00,  0x7E,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 166 */
    0x38,  0x6C,  0x6C,  0x38,  0x00,  0x7C,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 167 */
    0x00,  0x30,  0x30,  0x00,  0x30,  0x30,  0x60,  0xC6,  0xC6,  0x7C,  0x00,  0x00,   /* '' 168 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x7E,  0x60,  0x60,  0x60,  0x00,  0x00,  0x00,   /* '' 169 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x7E,  0x06,  0x06,  0x06,  0x00,  0x00,  0x00,   /* '' 170 */
    0x60,  0x62,  0x66,  0x6C,  0x18,  0x30,  0x60,  0xDC,  0x36,  0x0C,  0x18,  0x3E,   /* '' 171 */
    0x60,  0x62,  0x66,  0x6C,  0x18,  0x36,  0x6E,  0xDE,  0x36,  0x7E,  0x06,  0x06,   /* '' 172 */
    0x00,  0x18,  0x18,  0x00,  0x18,  0x18,  0x3C,  0x3C,  0x3C,  0x18,  0x00,  0x00,   /* '' 173 */
    0x00,  0x00,  0x00,  0x36,  0x6C,  0xD8,  0x6C,  0x36,  0x00,  0x00,  0x00,  0x00,   /* '' 174 */
    0x00,  0x00,  0x00,  0xD8,  0x6C,  0x36,  0x6C,  0xD8,  0x00,  0x00,  0x00,  0x00,   /* '' 175 */
    0x11,  0x44,  0x11,  0x44,  0x11,  0x44,  0x11,  0x44,  0x11,  0x44,  0x11,  0x44,   /* '' 176 */
    0x55,  0xAA,  0x55,  0xAA,  0x55,  0xAA,  0x55,  0xAA,  0x55,  0xAA,  0x55,  0xAA,   /* '' 177 */
    0xDD,  0x77,  0xDD,  0x77,  0xDD,  0x77,  0xDD,  0x77,  0xDD,  0x77,  0xDD,  0x77,   /* '' 178 */
    0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 179 */
    0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0xF8,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 180 */
    0x18,  0x18,  0x18,  0x18,  0xF8,  0x18,  0xF8,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 181 */
    0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0xF6,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 182 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFE,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 183 */
    0x00,  0x00,  0x00,  0x00,  0xF8,  0x18,  0xF8,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 184 */
    0x36,  0x36,  0x36,  0x36,  0xF6,  0x06,  0xF6,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 185 */
    0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 186 */
    0x00,  0x00,  0x00,  0x00,  0xFE,  0x06,  0xF6,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 187 */
    0x36,  0x36,  0x36,  0x36,  0xF6,  0x06,  0xFE,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 188 */
    0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0xFE,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 189 */
    0x18,  0x18,  0x18,  0x18,  0xF8,  0x18,  0xF8,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 190 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xF8,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 191 */
    0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x1F,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 192 */
    0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 193 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFF,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 194 */
    0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x1F,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 195 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 196 */
    0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0xFF,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 197 */
    0x18,  0x18,  0x18,  0x18,  0x1F,  0x18,  0x1F,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 198 */
    0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0x37,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 199 */
    0x36,  0x36,  0x36,  0x36,  0x37,  0x30,  0x3F,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 200 */
    0x00,  0x00,  0x00,  0x00,  0x3F,  0x30,  0x37,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 201 */
    0x36,  0x36,  0x36,  0x36,  0xF7,  0x00,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 202 */
    0x00,  0x00,  0x00,  0x00,  0xFF,  0x00,  0xF7,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 203 */
    0x36,  0x36,  0x36,  0x36,  0x37,  0x30,  0x37,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 204 */
    0x00,  0x00,  0x00,  0x00,  0xFF,  0x00,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 205 */
    0x36,  0x36,  0x36,  0x36,  0xF7,  0x00,  0xF7,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 206 */
    0x18,  0x18,  0x18,  0x18,  0xFF,  0x00,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 207 */
    0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 208 */
    0x00,  0x00,  0x00,  0x00,  0xFF,  0x00,  0xFF,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 209 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFF,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 210 */
    0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0x3F,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 211 */
    0x18,  0x18,  0x18,  0x18,  0x1F,  0x18,  0x1F,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 212 */
    0x00,  0x00,  0x00,  0x00,  0x1F,  0x18,  0x1F,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 213 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x3F,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 214 */
    0x36,  0x36,  0x36,  0x36,  0x36,  0x36,  0xFF,  0x36,  0x36,  0x36,  0x36,  0x36,   /* '' 215 */
    0x18,  0x18,  0x18,  0x18,  0xFF,  0x18,  0xFF,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 216 */
    0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0xF8,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 217 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x1F,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 218 */
    0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,   /* '' 219 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,   /* '' 220 */
    0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,  0xF0,   /* '' 221 */
    0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,  0x0F,   /* '' 222 */
    0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0xFF,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 223 */
    0x00,  0x00,  0x00,  0x76,  0xDC,  0xD8,  0xD8,  0xD8,  0xDC,  0x76,  0x00,  0x00,   /* '' 224 */
    0x00,  0x00,  0x00,  0x78,  0xCC,  0xD8,  0xFC,  0xC6,  0xE6,  0xDC,  0xC0,  0xC0,   /* '' 225 */
    0x00,  0xFE,  0x66,  0x62,  0x60,  0x60,  0x60,  0x60,  0x60,  0x60,  0x00,  0x00,   /* '' 226 */
    0x00,  0x00,  0x00,  0x00,  0xFE,  0x6C,  0x6C,  0x6C,  0x6C,  0x6C,  0x00,  0x00,   /* '' 227 */
    0x00,  0xFE,  0xC6,  0x62,  0x30,  0x18,  0x30,  0x62,  0xC6,  0xFE,  0x00,  0x00,   /* '' 228 */
    0x00,  0x00,  0x00,  0x00,  0x7E,  0xD8,  0xCC,  0xCC,  0xCC,  0x78,  0x00,  0x00,   /* '' 229 */
    0x00,  0x00,  0x00,  0x66,  0x66,  0x66,  0x66,  0x7C,  0x60,  0xC0,  0x80,  0x00,   /* '' 230 */
    0x00,  0x00,  0x00,  0x00,  0x76,  0xDC,  0x18,  0x18,  0x18,  0x18,  0x00,  0x00,   /* '' 231 */
    0x00,  0xFE,  0x38,  0x6C,  0xC6,  0xC6,  0xC6,  0x6C,  0x38,  0xFE,  0x00,  0x00,   /* '' 232 */
    0x00,  0x38,  0x6C,  0xC6,  0xC6,  0xFE,  0xC6,  0xC6,  0x6C,  0x38,  0x00,  0x00,   /* '' 233 */
    0x00,  0x38,  0x6C,  0xC6,  0xC6,  0xC6,  0x6C,  0x6C,  0x6C,  0xEE,  0x00,  0x00,   /* '' 234 */
    0x00,  0x3E,  0x60,  0x30,  0x3C,  0x66,  0xC6,  0xC6,  0xCC,  0x78,  0x00,  0x00,   /* '' 235 */
    0x00,  0x00,  0x00,  0x00,  0x7E,  0xDB,  0xDB,  0x7E,  0x00,  0x00,  0x00,  0x00,   /* '' 236 */
    0x00,  0x06,  0x0C,  0x7C,  0xDE,  0xF6,  0xE6,  0x7C,  0x60,  0xC0,  0x00,  0x00,   /* '' 237 */
    0x00,  0x1C,  0x30,  0x60,  0x60,  0x7C,  0x60,  0x60,  0x30,  0x1C,  0x00,  0x00,   /* '' 238 */
    0x00,  0x7C,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0xC6,  0x00,  0x00,   /* '' 239 */
    0x00,  0x00,  0x00,  0x00,  0xFE,  0x00,  0xFE,  0x00,  0xFE,  0x00,  0x00,  0x00,   /* '' 240 */
    0x00,  0x00,  0x00,  0x18,  0x18,  0x7E,  0x18,  0x18,  0x00,  0x7E,  0x00,  0x00,   /* '' 241 */
    0x00,  0x30,  0x18,  0x0C,  0x06,  0x0C,  0x18,  0x30,  0x00,  0x7E,  0x00,  0x00,   /* '' 242 */
    0x00,  0x0C,  0x18,  0x30,  0x60,  0x30,  0x18,  0x0C,  0x00,  0x7E,  0x00,  0x00,   /* '' 243 */
    0x00,  0x00,  0x0C,  0x1E,  0x1A,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,   /* '' 244 */
    0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x18,  0x58,  0x78,  0x30,  0x00,   /* '' 245 */
    0x00,  0x00,  0x18,  0x18,  0x00,  0x7E,  0x00,  0x18,  0x18,  0x00,  0x00,  0x00,   /* '' 246 */
    0x00,  0x00,  0x00,  0x00,  0x76,  0xDC,  0x00,  0x76,  0xDC,  0x00,  0x00,  0x00,   /* '' 247 */
    0x00,  0x78,  0xCC,  0xCC,  0x78,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 248 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x18,  0x18,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 249 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x18,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 250 */
    0x00,  0x00,  0x1F,  0x18,  0x18,  0x18,  0x18,  0xD8,  0x78,  0x38,  0x18,  0x00,   /* '' 251 */
    0xD8,  0x6C,  0x6C,  0x6C,  0x6C,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 252 */
    0x70,  0xD8,  0x30,  0x60,  0xF8,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,   /* '' 253 */
    0x00,  0x00,  0x00,  0x7E,  0x7E,  0x7E,  0x7E,  0x7E,  0x7E,  0x00,  0x00,  0x00,   /* '' 254 */
    0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00    /* '' 255 */
  };

gl_sFONT GL_Font16x24 =
  {
    GL_ASCII16x24_Table,
    16, /* Width */
    24, /* Height */
  };

gl_sFONT GL_Font12x12 =
  {
    GL_ASCII12x12_Table,
    12, /* Width */
    12, /* Height */
  };

gl_sFONT GL_Font8x12 =
  {
    GL_ASCII8x12_Table,
    8, /* Width */
    12, /* Height */
  };

gl_sFONT GL_Font8x12_bold =
  {
    GL_ASCII8x12_bold_Table,
    8, /* Width */
    12, /* Height */
  };

gl_sFONT GL_Font8x8 =
  {
    GL_ASCII8x8_Table,
    8, /* Width */
    8, /* Height */
  };


/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**
  * @}
  */

/**
  * @}
  */

/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
