/**
  ******************************************************************************
  * @file    images.c
  * @author  MCD Application Team
  * @version V2.0.0
  * @date    11-July-2011
  * @brief   Hex dumps of the 16-color 565 RGB images used by Graphics Library.
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2011 STMicroelectronics</center></h2>
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "images.h"
/** @addtogroup Embedded_GUI_Library
  * @{
  */

/** @addtogroup Images
  * @{
  */
   
/* External variables --------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private defines -----------------------------------------------------------*/
/* Private macros ------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

/** @defgroup Images_Private_Variables
  * @{
  */

/**
  * @brief A bitmap for the RadioButton Button Selected. This logo is 20x20 px.
  */
const uint8_t RButtonA[866] =
  {
    0x42, 0x4D, 0x62, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x62, 0x03, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0xE7,
    0x51, 0x8C, 0x08, 0x42, 0x00, 0x00, 0x00, 0x00, 0x08, 0x42, 0xB2, 0x94, 0x3C, 0xE7, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDE, 0xF7, 0x4D, 0x6B, 0x21, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x8E, 0x73, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x28, 0x42, 0x20, 0x00, 0x00, 0x00,
    0xC3, 0x18, 0x10, 0x84, 0x30, 0x84, 0x10, 0x84, 0xCF, 0x7B, 0x45, 0x29, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x42, 0x9D, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3C, 0xE7,
    0xA2, 0x10, 0x21, 0x08, 0xC7, 0x39, 0x92, 0x94, 0x5C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDF, 0xFF, 0xFB, 0xDE, 0x30, 0x84, 0x08, 0x42, 0x00, 0x00, 0x62, 0x10, 0x5C, 0xE7, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0xF7, 0x82, 0x10, 0x62, 0x10, 0x65, 0x29, 0xBA, 0xD6, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0xE7,
    0x86, 0x31, 0x00, 0x00, 0x00, 0x00, 0x3C, 0xE7, 0xFF, 0xFF, 0xDF, 0xFF, 0xD3, 0x9C, 0x61, 0x08,
    0x20, 0x00, 0x18, 0xC6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xEF, 0x7D, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1B, 0xDF, 0x20, 0x00, 0x00, 0x00, 0x24, 0x21,
    0xFF, 0xFF, 0x55, 0xAD, 0x41, 0x08, 0x00, 0x00, 0x34, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x9E, 0xF7, 0x8A, 0x52, 0x20, 0x00, 0x21, 0x08, 0xEC, 0x62, 0x9E, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x96, 0xB5, 0x00, 0x00, 0x00, 0x00, 0x5D, 0xEF, 0xE4, 0x20, 0x00, 0x00, 0xC3, 0x18,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x65, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x45, 0x29, 0xDE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x61, 0x08, 0x00, 0x00,
    0xCF, 0x7B, 0xC3, 0x18, 0x00, 0x00, 0xF3, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x8E, 0x73,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x92, 0x94, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x84, 0x00, 0x00, 0x08, 0x42, 0x04, 0x21, 0x00, 0x00, 0x14, 0xA5,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x86, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x9E, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0x92, 0x94, 0x00, 0x00,
    0x00, 0x00, 0xC3, 0x18, 0x00, 0x00, 0xF3, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0x24, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x41, 0x08, 0x7D, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x92, 0x94, 0x00, 0x00, 0x00, 0x00, 0xC7, 0x39, 0x00, 0x00, 0x34, 0xA5,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6D, 0x6B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x0C, 0x63, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x51, 0x8C, 0x00, 0x00,
    0xE3, 0x18, 0xD3, 0x9C, 0x00, 0x00, 0x61, 0x08, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0xF7,
    0x24, 0x21, 0x00, 0x00, 0x21, 0x08, 0x21, 0x08, 0x20, 0x00, 0x24, 0x21, 0x1C, 0xE7, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDE, 0xF7, 0x82, 0x10, 0x00, 0x00, 0xA7, 0x39, 0x7D, 0xEF, 0x20, 0x00, 0xC3, 0x18,
    0x54, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAE, 0x73, 0x00, 0x00, 0x41, 0x08,
    0x51, 0x8C, 0xDE, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x94, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0x63, 0xDF, 0xFF, 0xB6, 0xB5, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xEF, 0x9D, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x75, 0xAD, 0x00, 0x00, 0x00, 0x00, 0x41, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xEF, 0xC3, 0x18,
    0x00, 0x00, 0x82, 0x10, 0x14, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x75, 0xAD, 0xE3, 0x18, 0x00, 0x00, 0x24, 0x21, 0x1B, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x45, 0x29, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x6B,
    0x1C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9D, 0xEF, 0x92, 0x94, 0x00, 0x00,
    0x00, 0x00, 0x82, 0x10, 0x3C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDE, 0xF7, 0x69, 0x4A, 0x00, 0x00, 0x00, 0x00, 0xC3, 0x18, 0x30, 0x84, 0x71, 0x8C, 0x71, 0x8C,
    0xB2, 0x94, 0x24, 0x21, 0x00, 0x00, 0x00, 0x00, 0x4D, 0x6B, 0x9D, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x3C, 0xE7, 0x24, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x29, 0xD2, 0x94,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x55, 0xAD, 0xE7, 0x39, 0x00, 0x00, 0x00, 0x00,
    0xAE, 0x73, 0x3C, 0xE7, 0x9E, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF
  };

/**
  * @brief A bitmap for the RadioButton Button Unselected. This logo is 20x20 px.
  */
const uint8_t RButtonB[866] =
  {
    0x42, 0x4D, 0x62, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x62, 0x03, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0xE7,
    0x51, 0x8C, 0x08, 0x42, 0x00, 0x00, 0x00, 0x00, 0x08, 0x42, 0xB2, 0x94, 0x3C, 0xE7, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDE, 0xF7, 0x4D, 0x6B, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x8E, 0x73, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x28, 0x42, 0x00, 0x00, 0x00, 0x00,
    0xC3, 0x18, 0x10, 0x84, 0x30, 0x84, 0x10, 0x84, 0xCF, 0x7B, 0x45, 0x29, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x42, 0x9D, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3C, 0xE7,
    0x62, 0x10, 0x00, 0x00, 0xA7, 0x39, 0x92, 0x94, 0x5C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDF, 0xFF, 0xFB, 0xDE, 0x30, 0x84, 0x08, 0x42, 0x00, 0x00, 0x62, 0x10, 0x5C, 0xE7, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x45, 0x29, 0xBA, 0xD6, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0xE7,
    0x86, 0x31, 0x00, 0x00, 0x00, 0x00, 0x3C, 0xE7, 0xFF, 0xFF, 0xDF, 0xFF, 0x92, 0x94, 0x00, 0x00,
    0x00, 0x00, 0x18, 0xC6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1B, 0xDF, 0x20, 0x00, 0x00, 0x00, 0x24, 0x21,
    0xFF, 0xFF, 0x34, 0xA5, 0x20, 0x00, 0x00, 0x00, 0x34, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x96, 0xB5, 0x00, 0x00, 0x00, 0x00, 0x5D, 0xEF, 0xE4, 0x20, 0x00, 0x00, 0xC3, 0x18,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x61, 0x08, 0x00, 0x00,
    0xCF, 0x7B, 0xC3, 0x18, 0x00, 0x00, 0xF3, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x84, 0x00, 0x00, 0x08, 0x42, 0x04, 0x21, 0x00, 0x00, 0x14, 0xA5,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x92, 0x94, 0x00, 0x00,
    0x00, 0x00, 0xC3, 0x18, 0x00, 0x00, 0xF3, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x92, 0x94, 0x00, 0x00, 0x00, 0x00, 0xC7, 0x39, 0x00, 0x00, 0x34, 0xA5,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x51, 0x8C, 0x00, 0x00,
    0xE3, 0x18, 0xD3, 0x9C, 0x00, 0x00, 0x41, 0x08, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xDE, 0xF7, 0x82, 0x10, 0x00, 0x00, 0xA7, 0x39, 0x7D, 0xEF, 0x20, 0x00, 0x00, 0x00,
    0x54, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x94, 0x00, 0x00, 0x00, 0x00,
    0x0C, 0x63, 0xDF, 0xFF, 0xB6, 0xB5, 0x00, 0x00, 0x00, 0x00, 0xF7, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x75, 0xAD, 0x00, 0x00, 0x00, 0x00, 0x41, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xEF, 0xC3, 0x18,
    0x00, 0x00, 0x82, 0x10, 0x14, 0xA5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x75, 0xAD, 0xE3, 0x18, 0x00, 0x00, 0x24, 0x21, 0x1B, 0xDF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x45, 0x29, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x6B,
    0x1C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x9D, 0xEF, 0x92, 0x94, 0x00, 0x00,
    0x00, 0x00, 0x82, 0x10, 0x3C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDE, 0xF7, 0x69, 0x4A, 0x00, 0x00, 0x00, 0x00, 0xA3, 0x18, 0x30, 0x84, 0x71, 0x8C, 0x71, 0x8C,
    0xB2, 0x94, 0x24, 0x21, 0x00, 0x00, 0x00, 0x00, 0x4D, 0x6B, 0x9D, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x3C, 0xE7, 0x24, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x29, 0xD2, 0x94,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x55, 0xAD, 0xE7, 0x39, 0x00, 0x00, 0x00, 0x00,
    0xAE, 0x73, 0x3C, 0xE7, 0x9E, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF
  };

/**
  * @brief A bitmap for the CheckBox Button (not pressed). This logo is 20x20 px.
  */
const uint8_t CheckBox1[866] =
  {
    0x42, 0x4D, 0x62, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x62, 0x03, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
    0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x41, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x41, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x08, 0x61, 0x08, 0x41, 0x08, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00
  };

/**
  * @brief A bitmap for the CheckBox Button (not pressed). This logo is 20x20 px.
  */
const uint8_t CheckBox2[866] =
  {
    0x42, 0x4D, 0x62, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x62, 0x03, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x21, 0x08, 0x00, 0x00, 0x20, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
    0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xF7, 0xBD, 0xEB, 0x5A, 0xF7, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5D, 0xEF, 0xA7, 0x39, 0x00, 0x00, 0xE7, 0x39, 0x7D, 0xEF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0xE7, 0x65, 0x29,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCB, 0x5A, 0x9E, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0x9E, 0xF7, 0x08, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x10,
    0x2D, 0x6B, 0x7D, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xA6, 0x31, 0x00, 0x00, 0x00, 0x00,
    0xA2, 0x10, 0x04, 0x21, 0x41, 0x08, 0x00, 0x00, 0x41, 0x08, 0x2D, 0x6B, 0xBE, 0xF7, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x6B, 0x1C, 0xE7, 0x71, 0x8C, 0x00, 0x00,
    0x00, 0x00, 0x82, 0x10, 0xEB, 0x5A, 0x7D, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x71, 0x8C,
    0xFF, 0xFF, 0xFF, 0xFF, 0x7D, 0xEF, 0x65, 0x29, 0x00, 0x00, 0x00, 0x00, 0x61, 0x08, 0x6D, 0x6B,
    0xBE, 0xF7, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFB, 0xDE, 0x10, 0x84, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7,
    0xE3, 0x18, 0x00, 0x00, 0x00, 0x00, 0x82, 0x10, 0x10, 0x84, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x65, 0x29, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x00, 0xFF, 0xFF, 0x41, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x7D, 0xEF, 0xA2, 0x10, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xF7, 0x82, 0x10,
    0x00, 0x00, 0xFF, 0xFF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0x9A, 0xD6, 0x0C, 0x63, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x41, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x08, 0x61, 0x08, 0x41, 0x08, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x08, 0x21, 0x08,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00
  };

/**
  * @brief A bitmap for the ComboBox Button Arrow Up (not pressed). This logo is 22x22 px.
  */
const uint8_t ArrowUpUntouched[1034] =
  {
    0x42, 0x4D, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x0A, 0x04, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0x7E, 0xEF, 0x97, 0xB5, 0x52, 0x84, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C,
    0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C,
    0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0x32, 0x84, 0x77, 0xAD, 0x3D, 0xE7, 0x97, 0xB5,
    0xD8, 0xB5, 0x39, 0xC6, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE,
    0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE,
    0x3A, 0xCE, 0x3A, 0xCE, 0x19, 0xC6, 0xD8, 0xB5, 0x77, 0xAD, 0x73, 0x8C, 0x7A, 0xCE, 0xDF, 0xF7,
    0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE,
    0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE,
    0xDF, 0xF7, 0x7A, 0xCE, 0x73, 0x8C, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF, 0x5B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x5B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE,
    0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94,
    0xDB, 0xDE, 0xDF, 0xFF, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF,
    0x7B, 0xCE, 0x5B, 0xCE, 0xBC, 0xD6, 0xDD, 0xDE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x9C, 0xD6, 0xFD, 0xDE, 0x9B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF, 0x7B, 0xCE, 0xBC, 0xD6,
    0xD8, 0xB5, 0x56, 0xAD, 0x9C, 0xD6, 0x9C, 0xD6, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0xBC, 0xD6,
    0x3A, 0xC6, 0x36, 0xA5, 0x5B, 0xCE, 0xBC, 0xD6, 0x7B, 0xCE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE,
    0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xFF, 0xFF, 0x7B, 0xCE, 0xBC, 0xD6, 0x6E, 0x6B, 0x28, 0x42,
    0x19, 0xBE, 0xBC, 0xD6, 0x7B, 0xCE, 0x7B, 0xCE, 0x9B, 0xCE, 0xDD, 0xDE, 0x93, 0x94, 0xA6, 0x31,
    0x15, 0xA5, 0xBC, 0xD6, 0x7B, 0xCE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94,
    0xDB, 0xDE, 0xFF, 0xFF, 0x3A, 0xC6, 0xEC, 0x5A, 0x85, 0x29, 0xC6, 0x39, 0x69, 0x4A, 0x97, 0xB5,
    0x1E, 0xE7, 0x9B, 0xCE, 0x1E, 0xE7, 0x52, 0x8C, 0xC6, 0x39, 0xC6, 0x39, 0x86, 0x31, 0x52, 0x84,
    0xDD, 0xDE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xFF, 0xFF,
    0x7B, 0xCE, 0x36, 0xA5, 0xAB, 0x52, 0x03, 0x19, 0x85, 0x29, 0xAA, 0x52, 0x77, 0xAD, 0xFE, 0xDE,
    0x31, 0x84, 0x28, 0x42, 0x24, 0x21, 0x65, 0x29, 0xAF, 0x73, 0xD9, 0xBD, 0xBD, 0xD6, 0x7C, 0xCE,
    0xFF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xD6, 0xFF, 0xFF, 0xBC, 0xD6, 0x7F, 0xEF,
    0xB8, 0xB5, 0xEB, 0x5A, 0xA6, 0x31, 0xE3, 0x18, 0x0C, 0x63, 0xD4, 0x9C, 0xC7, 0x39, 0x03, 0x19,
    0x08, 0x3A, 0xF0, 0x7B, 0x9C, 0xD6, 0x5F, 0xEF, 0x9C, 0xD6, 0xBC, 0xD6, 0xFF, 0xFF, 0xDB, 0xD6,
    0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xD6, 0xFF, 0xFF, 0xDC, 0xDE, 0xDC, 0xDE, 0x9F, 0xF7, 0x5A, 0xCE,
    0xCB, 0x5A, 0xC7, 0x39, 0x85, 0x31, 0x85, 0x29, 0xA6, 0x31, 0xC7, 0x39, 0x10, 0x84, 0x7F, 0xEF,
    0x1D, 0xE7, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xFF, 0xFF, 0xDB, 0xD6, 0xB4, 0x94, 0xB4, 0x94,
    0xDB, 0xD6, 0xFF, 0xFF, 0x1D, 0xE7, 0x1D, 0xE7, 0x1D, 0xE7, 0x3D, 0xE7, 0xFC, 0xE6, 0x2C, 0x63,
    0x24, 0x21, 0xC7, 0x39, 0x44, 0x21, 0xB3, 0x94, 0x7F, 0xF7, 0x1D, 0xE7, 0x1D, 0xE7, 0x1D, 0xE7,
    0x1D, 0xE7, 0x1D, 0xE7, 0xFF, 0xFF, 0xDB, 0xD6, 0xB4, 0x94, 0xB4, 0x94, 0xBB, 0xD6, 0xFF, 0xFF,
    0x5E, 0xEF, 0x5E, 0xEF, 0x5E, 0xEF, 0x7E, 0xEF, 0x9F, 0xF7, 0xFC, 0xDE, 0x8E, 0x6B, 0x65, 0x29,
    0x35, 0xA5, 0x5E, 0xE7, 0xBF, 0xF7, 0x5E, 0xEF, 0x5E, 0xEF, 0x5E, 0xEF, 0x5E, 0xEF, 0x5E, 0xEF,
    0xFF, 0xFF, 0xBB, 0xD6, 0xB4, 0x94, 0xB4, 0x94, 0xBB, 0xD6, 0xFF, 0xFF, 0x9E, 0xF7, 0x9E, 0xF7,
    0x9E, 0xF7, 0x9E, 0xF7, 0x9E, 0xF7, 0xFF, 0xFF, 0x79, 0xCE, 0xD2, 0x94, 0x9D, 0xEF, 0xFF, 0xFF,
    0x9E, 0xEF, 0x9E, 0xF7, 0x9E, 0xF7, 0x9E, 0xF7, 0x9E, 0xF7, 0x9E, 0xF7, 0xFF, 0xFF, 0xBB, 0xD6,
    0xB4, 0x94, 0xB4, 0x94, 0xBB, 0xD6, 0xFF, 0xFF, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7,
    0xDE, 0xF7, 0xDE, 0xF7, 0xDF, 0xFF, 0xFF, 0xFF, 0xDE, 0xFF, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7,
    0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xFF, 0xFF, 0xBB, 0xD6, 0xB4, 0x94, 0xB4, 0x94,
    0xBB, 0xD6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xD6, 0xB4, 0x94, 0xB4, 0x94, 0xBB, 0xD6, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xBB, 0xD6, 0xB4, 0x94, 0x73, 0x8C, 0x39, 0xC6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x39, 0xC6,
    0x73, 0x8C, 0x76, 0xAD, 0x97, 0xAD, 0x59, 0xC6, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7,
    0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7,
    0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x59, 0xC6, 0x97, 0xAD, 0x76, 0xAD, 0xDB, 0xD6,
    0x56, 0xA5, 0xB3, 0x94, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5,
    0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5,
    0xB7, 0xB5, 0x97, 0xB5, 0x93, 0x94, 0x56, 0xA5, 0xDB, 0xD6
  };

/**
  * @brief A bitmap for the ComboBox Button Arrow Up (pressed). This logo is 22x22 px.
  */
const uint8_t ArrowUpTouched[1034] =
  {
    0x42, 0x4D, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x0A, 0x04, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xF8, 0xBD, 0x51, 0x84, 0xCB, 0x52, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B,
    0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B,
    0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0xEB, 0x52, 0x30, 0x7C, 0xB7, 0xB5, 0x10, 0x7C,
    0x2C, 0x5B, 0x4D, 0x5B, 0xB5, 0x84, 0xB4, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84,
    0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84,
    0xB4, 0x84, 0xB5, 0x84, 0x4D, 0x5B, 0x2C, 0x5B, 0xF0, 0x7B, 0xEB, 0x52, 0x4D, 0x5B, 0x15, 0x95,
    0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6,
    0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6,
    0x15, 0x95, 0x4D, 0x5B, 0xEB, 0x52, 0x2C, 0x5B, 0xF5, 0x8C, 0x3E, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0xDF, 0xF5, 0x8C,
    0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B,
    0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDB, 0xDE, 0x38, 0xC6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x5C, 0xE7, 0x18, 0xC6, 0x9D, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE,
    0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6D, 0x6B, 0x65, 0x29,
    0x5C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x14, 0xA5, 0xC3, 0x18,
    0xF7, 0xBD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B,
    0x17, 0xBE, 0xFF, 0xFF, 0xBE, 0xF7, 0xAB, 0x5A, 0x62, 0x10, 0xE4, 0x20, 0xC7, 0x39, 0x38, 0xC6,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x71, 0x8C, 0xE4, 0x20, 0xE4, 0x20, 0x82, 0x10, 0xB2, 0x94,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF,
    0xDF, 0xFF, 0x17, 0xBE, 0x49, 0x4A, 0x00, 0x00, 0x62, 0x10, 0x29, 0x4A, 0xF7, 0xBD, 0xDF, 0xFF,
    0x51, 0x8C, 0x66, 0x31, 0x00, 0x00, 0x62, 0x10, 0xAE, 0x73, 0xFB, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0x18, 0xC6, 0x8A, 0x52, 0xA3, 0x18, 0x00, 0x00, 0xAA, 0x52, 0x34, 0xA5, 0xE4, 0x20, 0x00, 0x00,
    0x45, 0x29, 0xCF, 0x7B, 0x3C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE,
    0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0xD6,
    0x29, 0x4A, 0x04, 0x21, 0x82, 0x10, 0x62, 0x10, 0xC3, 0x18, 0xE4, 0x20, 0xEF, 0x7B, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B,
    0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDE, 0xF7, 0xCB, 0x5A,
    0x20, 0x00, 0xE4, 0x20, 0x41, 0x08, 0xD3, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x18, 0xBE, 0xFF, 0xFF,
    0xBE, 0xFF, 0xBE, 0xF7, 0x9E, 0xF7, 0xDF, 0xF7, 0xFF, 0xFF, 0x1C, 0xDF, 0xEC, 0x62, 0x82, 0x10,
    0xF4, 0x9C, 0x9E, 0xEF, 0xFF, 0xFF, 0xBE, 0xF7, 0xBE, 0xF7, 0xBE, 0xFF, 0xBE, 0xFF, 0xBE, 0xFF,
    0xFF, 0xFF, 0x18, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x18, 0xBE, 0xFF, 0xFF, 0x5D, 0xEF, 0x3D, 0xE7,
    0x3D, 0xE7, 0x3D, 0xE7, 0x3D, 0xE7, 0xFF, 0xFF, 0x18, 0xC6, 0x11, 0x84, 0x7D, 0xEF, 0xDF, 0xF7,
    0x1D, 0xE7, 0x3D, 0xE7, 0x5D, 0xEF, 0x5D, 0xEF, 0x5D, 0xEF, 0x5D, 0xEF, 0xFF, 0xFF, 0x18, 0xBE,
    0x2C, 0x5B, 0x2C, 0x5B, 0x38, 0xC6, 0xFF, 0xFF, 0xFD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6,
    0xDD, 0xD6, 0xDD, 0xD6, 0x3E, 0xE7, 0x9F, 0xEF, 0xFD, 0xDE, 0xDD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6,
    0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFF, 0xFF, 0x38, 0xC6, 0x2C, 0x5B, 0x2C, 0x5B,
    0x38, 0xC6, 0xFF, 0xFF, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE,
    0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE,
    0xBD, 0xCE, 0xBD, 0xCE, 0xFF, 0xFF, 0x38, 0xC6, 0x2C, 0x5B, 0x2C, 0x5B, 0x58, 0xC6, 0xFF, 0xFF,
    0xFB, 0xB5, 0xFB, 0xB5, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE,
    0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0xFB, 0xB5, 0xFB, 0xB5,
    0xFF, 0xFF, 0x58, 0xC6, 0x2C, 0x5B, 0xCB, 0x4A, 0xD6, 0xB5, 0xFF, 0xFF, 0x7F, 0xEF, 0x7F, 0xEF,
    0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF,
    0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0xFF, 0xFF, 0xD6, 0xB5,
    0xEB, 0x52, 0x51, 0x84, 0xF3, 0x94, 0xF7, 0xB5, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE,
    0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE,
    0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0xF7, 0xB5, 0xD3, 0x94, 0x10, 0x7C, 0x7A, 0xCE,
    0x72, 0x8C, 0xCA, 0x4A, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B,
    0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B,
    0x2C, 0x5B, 0x2C, 0x5B, 0xCB, 0x52, 0x51, 0x84, 0xF8, 0xBD
  };

/**
  * @brief A bitmap for the ComboBox Button Arrow Down (not pressed). This logo is 22x22 px.
  */
const uint8_t ArrowDownUntouched[1034] =
  {
    0x42, 0x4D, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x0A, 0x04, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0x7E, 0xEF, 0x97, 0xB5, 0x52, 0x84, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C,
    0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C,
    0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0xF5, 0x9C, 0x32, 0x84, 0x77, 0xAD, 0x3D, 0xE7, 0x97, 0xB5,
    0xD8, 0xB5, 0x39, 0xC6, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE,
    0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE, 0x3A, 0xCE,
    0x3A, 0xCE, 0x3A, 0xCE, 0x19, 0xC6, 0xD8, 0xB5, 0x77, 0xAD, 0x73, 0x8C, 0x7A, 0xCE, 0xDF, 0xF7,
    0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE,
    0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE, 0xDC, 0xDE,
    0xDF, 0xF7, 0x7A, 0xCE, 0x73, 0x8C, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF, 0x5B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x5B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE,
    0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94,
    0xDB, 0xDE, 0xDF, 0xFF, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0xBC, 0xD6, 0xFD, 0xDE, 0x9B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x1E, 0xE7, 0x97, 0xB5, 0x31, 0x84,
    0x9C, 0xD6, 0xDD, 0xDE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE,
    0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF, 0x7B, 0xCE, 0x7B, 0xCE,
    0x7B, 0xCE, 0x9B, 0xCE, 0xBC, 0xD6, 0x19, 0xC6, 0x4D, 0x63, 0x85, 0x29, 0x93, 0x94, 0x7B, 0xCE,
    0xDC, 0xD6, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE,
    0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x9B, 0xD6,
    0x5B, 0xCE, 0x0C, 0x5B, 0x44, 0x21, 0xC7, 0x39, 0x65, 0x29, 0x72, 0x8C, 0xDC, 0xD6, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94,
    0xDB, 0xDE, 0xDF, 0xFF, 0x7B, 0xCE, 0x5B, 0xCE, 0x1E, 0xDF, 0x19, 0xBE, 0xAA, 0x52, 0xE7, 0x39,
    0x86, 0x31, 0x85, 0x29, 0xC6, 0x31, 0xC6, 0x39, 0xF0, 0x7B, 0xFD, 0xDE, 0xBC, 0xD6, 0x7B, 0xCE,
    0x7B, 0xCE, 0x7B, 0xCE, 0xDF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xDE, 0xDF, 0xFF,
    0x7C, 0xCE, 0x5F, 0xEF, 0x97, 0xB5, 0xCB, 0x5A, 0xA6, 0x31, 0xE3, 0x18, 0xEC, 0x5A, 0xB4, 0x94,
    0xC6, 0x31, 0x03, 0x19, 0x08, 0x3A, 0xCF, 0x73, 0x7B, 0xCE, 0x1E, 0xE7, 0x7B, 0xCE, 0x7C, 0xCE,
    0xFF, 0xFF, 0xDB, 0xDE, 0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xD6, 0xFF, 0xFF, 0x9C, 0xD6, 0x36, 0xAD,
    0xAB, 0x52, 0x03, 0x21, 0x65, 0x29, 0xAA, 0x52, 0x97, 0xB5, 0x1E, 0xE7, 0x51, 0x8C, 0x28, 0x42,
    0x24, 0x21, 0x85, 0x29, 0xAF, 0x73, 0xD9, 0xBD, 0xDD, 0xDE, 0xBC, 0xD6, 0xFF, 0xFF, 0xDB, 0xD6,
    0xB4, 0x94, 0xB4, 0x94, 0xDB, 0xD6, 0xFF, 0xFF, 0xBB, 0xD6, 0x2C, 0x63, 0x85, 0x29, 0xC6, 0x31,
    0x69, 0x4A, 0xF8, 0xBD, 0x9F, 0xF7, 0xFC, 0xDE, 0x9F, 0xF7, 0x92, 0x94, 0xC7, 0x39, 0xC6, 0x31,
    0xA6, 0x31, 0x92, 0x94, 0x5E, 0xEF, 0xDC, 0xDE, 0xFF, 0xFF, 0xDB, 0xD6, 0xB4, 0x94, 0xB4, 0x94,
    0xDB, 0xD6, 0xFF, 0xFF, 0x1D, 0xE7, 0x5E, 0xEF, 0xAF, 0x73, 0x28, 0x42, 0x9B, 0xD6, 0x5E, 0xEF,
    0x1D, 0xE7, 0x1D, 0xE7, 0x1D, 0xE7, 0x7F, 0xF7, 0xF4, 0x9C, 0xA6, 0x31, 0x96, 0xB5, 0x7E, 0xEF,
    0x1D, 0xE7, 0x1D, 0xE7, 0xFF, 0xFF, 0xDB, 0xD6, 0xB4, 0x94, 0xB4, 0x94, 0xBB, 0xD6, 0xFF, 0xFF,
    0x5E, 0xEF, 0xBF, 0xF7, 0x9B, 0xD6, 0x18, 0xC6, 0x9F, 0xEF, 0x7E, 0xEF, 0x5E, 0xEF, 0x5E, 0xEF,
    0x5E, 0xEF, 0xBF, 0xF7, 0x1C, 0xDF, 0xF8, 0xBD, 0x3D, 0xE7, 0x9F, 0xF7, 0x5E, 0xEF, 0x5E, 0xEF,
    0xFF, 0xFF, 0xBB, 0xD6, 0xB4, 0x94, 0xB4, 0x94, 0xBB, 0xD6, 0xFF, 0xFF, 0x9E, 0xF7, 0x9E, 0xEF,
    0xDF, 0xF7, 0xFF, 0xFF, 0x9E, 0xF7, 0x9E, 0xEF, 0x9E, 0xF7, 0x9E, 0xF7, 0x9E, 0xF7, 0x9E, 0xEF,
    0xBE, 0xF7, 0xFF, 0xFF, 0xBE, 0xF7, 0x9E, 0xEF, 0x9E, 0xF7, 0x9E, 0xF7, 0xFF, 0xFF, 0xBB, 0xD6,
    0xB4, 0x94, 0xB4, 0x94, 0xBB, 0xD6, 0xFF, 0xFF, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7,
    0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7,
    0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xDE, 0xF7, 0xFF, 0xFF, 0xBB, 0xD6, 0xB4, 0x94, 0xB4, 0x94,
    0xBB, 0xD6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xD6, 0xB4, 0x94, 0xB4, 0x94, 0xBB, 0xD6, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xBB, 0xD6, 0xB4, 0x94, 0x73, 0x8C, 0x39, 0xC6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x39, 0xC6,
    0x73, 0x8C, 0x76, 0xAD, 0x97, 0xAD, 0x59, 0xC6, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7,
    0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7,
    0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x59, 0xC6, 0x97, 0xAD, 0x76, 0xAD, 0xDB, 0xD6,
    0x56, 0xA5, 0xB3, 0x94, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5,
    0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5, 0xB7, 0xB5,
    0xB7, 0xB5, 0x97, 0xB5, 0x93, 0x94, 0x56, 0xA5, 0xDB, 0xD6
  };

/**
  * @brief A bitmap for the ComboBox Button Arrow Down (pressed). This logo is 22x22 px.
  */
const uint8_t ArrowDownTouched[1034] =
  {
    0x42, 0x4D, 0x0A, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x0A, 0x04, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x12, 0x0B, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xF8, 0xBD, 0x51, 0x84, 0xCB, 0x52, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B,
    0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B,
    0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0xEB, 0x52, 0x30, 0x7C, 0xB7, 0xB5, 0x10, 0x7C,
    0x2C, 0x5B, 0x4D, 0x5B, 0xB5, 0x84, 0xB4, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84,
    0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84, 0x94, 0x84,
    0xB4, 0x84, 0xB5, 0x84, 0x4D, 0x5B, 0x2C, 0x5B, 0xF0, 0x7B, 0xEB, 0x52, 0x4D, 0x5B, 0x15, 0x95,
    0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6,
    0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6,
    0x15, 0x95, 0x4D, 0x5B, 0xEB, 0x52, 0x2C, 0x5B, 0xF5, 0x8C, 0x3E, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3E, 0xDF, 0xF5, 0x8C,
    0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B,
    0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x38, 0xC6, 0x71, 0x8C,
    0x9D, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x5C, 0xE7, 0x2C, 0x63, 0x62, 0x10, 0x34, 0xA5, 0xBE, 0xF7,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE,
    0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xDE, 0xF7, 0xAB, 0x5A, 0x20, 0x00, 0xE4, 0x20, 0x41, 0x08, 0xD3, 0x9C, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B,
    0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0xD6, 0x29, 0x4A, 0x04, 0x21,
    0x82, 0x10, 0x62, 0x10, 0xC3, 0x18, 0xE4, 0x20, 0xEF, 0x7B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0x18, 0xC6, 0x8A, 0x52, 0xA3, 0x18, 0x00, 0x00, 0xAA, 0x52, 0x34, 0xA5,
    0xE4, 0x20, 0x00, 0x00, 0x45, 0x29, 0xCF, 0x7B, 0x3C, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xDF, 0xFF, 0x17, 0xBE,
    0x49, 0x4A, 0x00, 0x00, 0x62, 0x10, 0x29, 0x4A, 0xF7, 0xBD, 0xDF, 0xFF, 0x51, 0x8C, 0x66, 0x31,
    0x00, 0x00, 0x62, 0x10, 0xAE, 0x73, 0xFB, 0xDE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE,
    0x2C, 0x5B, 0x2C, 0x5B, 0x17, 0xBE, 0xFF, 0xFF, 0xBE, 0xF7, 0xAB, 0x5A, 0x62, 0x10, 0xE4, 0x20,
    0xC7, 0x39, 0x38, 0xC6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x71, 0x8C, 0xE4, 0x20, 0xE4, 0x20,
    0x82, 0x10, 0xB2, 0x94, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B,
    0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x6D, 0x6B, 0x65, 0x31, 0x5C, 0xE7, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x34, 0xA5, 0xC3, 0x18, 0xF7, 0xBD, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x18, 0xBE, 0xFF, 0xFF,
    0xBE, 0xFF, 0xFF, 0xFF, 0xBA, 0xD6, 0xF8, 0xBD, 0xFF, 0xFF, 0xDF, 0xFF, 0x9E, 0xF7, 0xBE, 0xF7,
    0x9E, 0xF7, 0xFF, 0xFF, 0x3C, 0xE7, 0xB7, 0xB5, 0x7D, 0xEF, 0xFF, 0xFF, 0xBE, 0xFF, 0xBE, 0xFF,
    0xFF, 0xFF, 0x18, 0xBE, 0x2C, 0x5B, 0x2C, 0x5B, 0x18, 0xBE, 0xFF, 0xFF, 0x5D, 0xEF, 0x3D, 0xE7,
    0x9E, 0xF7, 0xDF, 0xFF, 0x3D, 0xE7, 0x3D, 0xE7, 0x3D, 0xE7, 0x3D, 0xE7, 0x3D, 0xE7, 0x3D, 0xE7,
    0x7E, 0xEF, 0xDF, 0xFF, 0x7E, 0xEF, 0x5D, 0xE7, 0x5D, 0xEF, 0x5D, 0xEF, 0xFF, 0xFF, 0x18, 0xBE,
    0x2C, 0x5B, 0x2C, 0x5B, 0x38, 0xC6, 0xFF, 0xFF, 0xFD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6,
    0xDD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6, 0xDD, 0xD6,
    0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFD, 0xD6, 0xFF, 0xFF, 0x38, 0xC6, 0x2C, 0x5B, 0x2C, 0x5B,
    0x38, 0xC6, 0xFF, 0xFF, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE,
    0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE, 0xBD, 0xCE,
    0xBD, 0xCE, 0xBD, 0xCE, 0xFF, 0xFF, 0x38, 0xC6, 0x2C, 0x5B, 0x2C, 0x5B, 0x58, 0xC6, 0xFF, 0xFF,
    0xFB, 0xB5, 0xFB, 0xB5, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE,
    0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0x1B, 0xBE, 0xFB, 0xB5, 0xFB, 0xB5,
    0xFF, 0xFF, 0x58, 0xC6, 0x2C, 0x5B, 0xCB, 0x4A, 0xD6, 0xB5, 0xFF, 0xFF, 0x7F, 0xEF, 0x7F, 0xEF,
    0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF,
    0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0x7F, 0xEF, 0xFF, 0xFF, 0xD6, 0xB5,
    0xEB, 0x52, 0x51, 0x84, 0xF3, 0x94, 0xF7, 0xB5, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE,
    0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE,
    0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0xF7, 0xB5, 0xD3, 0x94, 0x10, 0x7C, 0x7A, 0xCE,
    0x72, 0x8C, 0xCA, 0x4A, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B,
    0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B, 0x2C, 0x5B,
    0x2C, 0x5B, 0x2C, 0x5B, 0xCB, 0x52, 0x51, 0x84, 0xF8, 0xBD
  };

/**
  * @brief A bitmap for the Left part of a General Button. This logo is 8x26 px.
  */
const uint8_t BtnNormalLeft[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xDF, 0xEF, 0x9E, 0xE7, 0xB8, 0xA5, 0x11, 0x3B, 0x6C, 0x09, 0x8A, 0x00, 0x8A, 0x00,
    0x8A, 0x00, 0x9E, 0xE7, 0xF9, 0xAD, 0xF4, 0x5B, 0x33, 0x3B, 0x14, 0x33, 0x15, 0x3B, 0x15, 0x3B,
    0x15, 0x3B, 0x19, 0xAE, 0xD3, 0x53, 0xB2, 0x22, 0x38, 0x54, 0x3D, 0x75, 0xBF, 0x85, 0xDF, 0x8D,
    0xDF, 0x8D, 0xF4, 0x5B, 0x13, 0x33, 0x97, 0x3B, 0x9D, 0x85, 0xDE, 0x95, 0x1E, 0xA6, 0x3E, 0xA6,
    0x3E, 0xA6, 0xB1, 0x22, 0x35, 0x2B, 0x7B, 0x54, 0x7E, 0x85, 0xBE, 0x8D, 0xDE, 0x95, 0xFE, 0x9D,
    0xFE, 0x9D, 0xAF, 0x01, 0x36, 0x2B, 0xFE, 0x5C, 0x5E, 0x75, 0x9E, 0x85, 0xBE, 0x8D, 0xDE, 0x95,
    0xDE, 0x95, 0x2E, 0x01, 0x17, 0x2B, 0xFF, 0x5C, 0x3E, 0x6D, 0x5E, 0x7D, 0x9E, 0x85, 0xBE, 0x85,
    0x9E, 0x8D, 0x4E, 0x01, 0xF6, 0x22, 0xBE, 0x54, 0xFE, 0x64, 0x3E, 0x75, 0x5E, 0x7D, 0x7E, 0x7D,
    0x7E, 0x7D, 0x4E, 0x01, 0xF6, 0x22, 0x9E, 0x4C, 0xDE, 0x5C, 0x1E, 0x6D, 0x3E, 0x75, 0x5E, 0x75,
    0x5E, 0x7D, 0x4E, 0x01, 0xD6, 0x1A, 0x7E, 0x44, 0xBE, 0x54, 0xFE, 0x5C, 0x1E, 0x6D, 0x3E, 0x6D,
    0x3E, 0x6D, 0x2E, 0x01, 0xB6, 0x1A, 0x5E, 0x34, 0x7E, 0x44, 0xBE, 0x54, 0xDE, 0x5C, 0xFE, 0x64,
    0xFE, 0x64, 0x2E, 0x01, 0xB6, 0x12, 0x1E, 0x2C, 0x5E, 0x3C, 0x7E, 0x4C, 0xBE, 0x54, 0xDE, 0x54,
    0xDE, 0x54, 0x6E, 0x01, 0x16, 0x23, 0xBE, 0x4C, 0xBE, 0x54, 0xDE, 0x5C, 0xFE, 0x64, 0x1E, 0x65,
    0x1E, 0x65, 0x8E, 0x01, 0x76, 0x3B, 0x3E, 0x6D, 0x5E, 0x75, 0x5E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7D,
    0x7E, 0x85, 0x8E, 0x01, 0x96, 0x43, 0x7E, 0x85, 0x9E, 0x85, 0x9E, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D,
    0xBE, 0x8D, 0x8E, 0x01, 0x96, 0x43, 0x7E, 0x7D, 0x9E, 0x85, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D,
    0xBE, 0x8D, 0xAE, 0x01, 0x96, 0x43, 0x9E, 0x85, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x95, 0xDE, 0x95,
    0xDE, 0x95, 0xAE, 0x01, 0xB6, 0x43, 0xBE, 0x8D, 0xDE, 0x95, 0xDE, 0x95, 0xFE, 0x95, 0xFE, 0x95,
    0xFE, 0x9D, 0xAE, 0x01, 0xB6, 0x4B, 0xDE, 0x8D, 0xFE, 0x95, 0xFE, 0x9D, 0xFE, 0x9D, 0x1E, 0x9E,
    0x1E, 0x9E, 0x8E, 0x01, 0xD7, 0x4B, 0x1F, 0x96, 0x1E, 0x9E, 0x1E, 0xA6, 0x1E, 0xA6, 0x3E, 0xA6,
    0x3E, 0xA6, 0x2F, 0x12, 0xD6, 0x4B, 0xBD, 0x8D, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xAE,
    0x3E, 0xAE, 0x72, 0x4B, 0xD5, 0x4B, 0xFA, 0x74, 0x3E, 0xA6, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE,
    0x5E, 0xAE, 0xD6, 0x84, 0xB4, 0x53, 0x16, 0x54, 0xFC, 0x9D, 0x5D, 0xAE, 0x7E, 0xB6, 0x7E, 0xB6,
    0x7E, 0xB6, 0x9B, 0xBE, 0x75, 0x74, 0x12, 0x3B, 0x16, 0x5C, 0x5B, 0x85, 0xDD, 0x9D, 0xFD, 0x9D,
    0xFD, 0x9D, 0xBE, 0xE7, 0x5A, 0xB6, 0x54, 0x6C, 0x52, 0x43, 0x73, 0x43, 0x94, 0x43, 0x94, 0x4B,
    0x94, 0x4B, 0xDF, 0xEF, 0x9E, 0xE7, 0x19, 0xAE, 0xD3, 0x5B, 0x4E, 0x1A, 0x8C, 0x01, 0x6C, 0x01,
    0x8C, 0x01
  };

/**
  * @brief  A bitmap for the Right part of a General Button. This logo is 8x26 px.
  */
const uint8_t BtnNormalRight[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x2C, 0x09, 0xD0, 0x32, 0x78, 0x95, 0x7D, 0xE7,
    0xDF, 0xEF, 0x15, 0x3B, 0x15, 0x3B, 0x15, 0x3B, 0xF4, 0x32, 0xD2, 0x2A, 0x32, 0x3B, 0x77, 0x95,
    0x7D, 0xE7, 0xDF, 0x8D, 0xDF, 0x8D, 0xBF, 0x85, 0x3D, 0x75, 0xF8, 0x4B, 0x10, 0x0A, 0x52, 0x43,
    0xF9, 0xA5, 0x3E, 0xA6, 0x3E, 0xA6, 0x1E, 0xA6, 0xFE, 0x95, 0x9D, 0x8D, 0xB7, 0x43, 0x13, 0x33,
    0xD3, 0x5B, 0xFE, 0x9D, 0xFE, 0x9D, 0xDE, 0x95, 0xBE, 0x8D, 0x9E, 0x85, 0x9B, 0x5C, 0x35, 0x2B,
    0x91, 0x1A, 0xDE, 0x95, 0xDE, 0x95, 0xBE, 0x8D, 0x7E, 0x85, 0x5E, 0x75, 0x1E, 0x65, 0x36, 0x2B,
    0x6E, 0x01, 0x9E, 0x8D, 0x9E, 0x85, 0x9E, 0x85, 0x5E, 0x7D, 0x3E, 0x6D, 0x1F, 0x5D, 0x17, 0x2B,
    0x0D, 0x01, 0x7E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7D, 0x5E, 0x75, 0x1E, 0x65, 0xDF, 0x54, 0xF7, 0x22,
    0x2E, 0x01, 0x5E, 0x7D, 0x5E, 0x75, 0x3E, 0x75, 0x1E, 0x6D, 0xDE, 0x5C, 0xBF, 0x4C, 0xF7, 0x22,
    0x2E, 0x01, 0x3E, 0x6D, 0x3E, 0x6D, 0x1E, 0x65, 0xFE, 0x5C, 0xBE, 0x54, 0x9F, 0x44, 0xD7, 0x1A,
    0x2E, 0x01, 0xFE, 0x64, 0xFE, 0x64, 0xDE, 0x5C, 0xBE, 0x54, 0x7E, 0x44, 0x5F, 0x3C, 0xB7, 0x1A,
    0x0E, 0x01, 0xDE, 0x54, 0xDE, 0x54, 0xBE, 0x54, 0x7E, 0x4C, 0x5E, 0x3C, 0x3F, 0x34, 0xB7, 0x12,
    0x0E, 0x01, 0x1E, 0x65, 0x1E, 0x65, 0xFE, 0x64, 0xDE, 0x5C, 0xDE, 0x54, 0xBF, 0x4C, 0x17, 0x23,
    0x2E, 0x01, 0x7E, 0x85, 0x7E, 0x7D, 0x7E, 0x7D, 0x5E, 0x7D, 0x5E, 0x75, 0x5F, 0x75, 0x77, 0x3B,
    0x4E, 0x01, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0x9E, 0x8D, 0x9E, 0x85, 0x9F, 0x85, 0x97, 0x43,
    0x6E, 0x01, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0x9E, 0x8D, 0x9E, 0x85, 0x9F, 0x85, 0x97, 0x43,
    0x6E, 0x01, 0xDE, 0x95, 0xDE, 0x95, 0xBE, 0x95, 0xBE, 0x8D, 0xBE, 0x8D, 0xBF, 0x85, 0xB7, 0x43,
    0x8E, 0x01, 0xFE, 0x9D, 0xFE, 0x95, 0xFE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDF, 0x8D, 0xB7, 0x4B,
    0x8E, 0x01, 0x1E, 0x9E, 0x1E, 0x9E, 0xFE, 0x9D, 0xFE, 0x9D, 0xFE, 0x95, 0xFF, 0x95, 0xD7, 0x4B,
    0x8E, 0x01, 0x3E, 0xA6, 0x3E, 0xA6, 0x1E, 0xA6, 0x1E, 0x9E, 0x1E, 0x9E, 0x3F, 0x9E, 0xF7, 0x4B,
    0x6D, 0x01, 0x3E, 0xAE, 0x3E, 0xAE, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0xDE, 0x95, 0xF6, 0x4B,
    0x0F, 0x12, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x3E, 0xA6, 0x1A, 0x7D, 0xD5, 0x53,
    0x52, 0x43, 0x7E, 0xB6, 0x7E, 0xB6, 0x5E, 0xB6, 0x3D, 0xAE, 0xFD, 0x9D, 0x36, 0x5C, 0xD4, 0x53,
    0xD6, 0x7C, 0xFD, 0x9D, 0xFD, 0x9D, 0xDD, 0x9D, 0x5B, 0x85, 0x36, 0x5C, 0x32, 0x3B, 0x95, 0x74,
    0x9B, 0xBE, 0x94, 0x4B, 0x94, 0x4B, 0x94, 0x43, 0x73, 0x43, 0x52, 0x43, 0x54, 0x6C, 0x5A, 0xB6,
    0xBE, 0xE7, 0x8C, 0x01, 0x6C, 0x01, 0x6C, 0x01, 0x2E, 0x1A, 0xB2, 0x53, 0xF9, 0xAD, 0x9E, 0xE7,
    0xDF, 0xEF
  };

/**
  * @brief  A bitmap for the Central part of a General Button. This logo is 8x26 px.
  */
const uint8_t BtnNormal[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x8A, 0x00,
    0x8A, 0x00, 0x15, 0x3B, 0x15, 0x3B, 0x15, 0x3B, 0x15, 0x3B, 0x15, 0x3B, 0x15, 0x3B, 0x15, 0x3B,
    0x15, 0x3B, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D,
    0xDF, 0x8D, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE,
    0x5E, 0xAE, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E,
    0x1E, 0x9E, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95,
    0xDE, 0x95, 0x9E, 0x8D, 0x9E, 0x8D, 0x9E, 0x8D, 0x9E, 0x8D, 0x9E, 0x8D, 0x9E, 0x8D, 0x9E, 0x8D,
    0x9E, 0x8D, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85,
    0x7E, 0x85, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D,
    0x5E, 0x7D, 0x3E, 0x6D, 0x3E, 0x6D, 0x3E, 0x6D, 0x3E, 0x6D, 0x3E, 0x6D, 0x3E, 0x6D, 0x3E, 0x6D,
    0x3E, 0x6D, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65,
    0x1E, 0x65, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54,
    0xDE, 0x54, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65, 0x1E, 0x65,
    0x1E, 0x65, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85,
    0x7E, 0x85, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D,
    0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D,
    0xBE, 0x8D, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95,
    0xDE, 0x95, 0xFE, 0x9D, 0xFE, 0x9D, 0xFE, 0x9D, 0xFE, 0x9D, 0xFE, 0x9D, 0xFE, 0x9D, 0xFE, 0x9D,
    0xFE, 0x9D, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E,
    0x1E, 0x9E, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6,
    0x3E, 0xA6, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE,
    0x5E, 0xAE, 0x5E, 0xB6, 0x5E, 0xB6, 0x5E, 0xB6, 0x5E, 0xB6, 0x5E, 0xB6, 0x5E, 0xB6, 0x5E, 0xB6,
    0x5E, 0xB6, 0x7E, 0xB6, 0x7E, 0xB6, 0x7E, 0xB6, 0x7E, 0xB6, 0x7E, 0xB6, 0x7E, 0xB6, 0x7E, 0xB6,
    0x7E, 0xB6, 0xFD, 0x9D, 0xFD, 0x9D, 0xFD, 0x9D, 0xFD, 0x9D, 0xFD, 0x9D, 0xFD, 0x9D, 0xFD, 0x9D,
    0xFD, 0x9D, 0x94, 0x4B, 0x94, 0x4B, 0x94, 0x4B, 0x94, 0x4B, 0x94, 0x4B, 0x94, 0x4B, 0x94, 0x4B,
    0x94, 0x4B, 0x8C, 0x01, 0x8C, 0x01, 0x8C, 0x01, 0x8C, 0x01, 0x8C, 0x01, 0x8C, 0x01, 0x8C, 0x01,
    0x8C, 0x01
  };

/**
  * @brief  A bitmap for the Left part of a General Button Pressed. This logo is 8x26 px.
  */
const uint8_t BtnPressedLeft[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xDF, 0xEF, 0x9E, 0xE7, 0xB8, 0xA5, 0x31, 0x43, 0x6C, 0x09, 0x8A, 0x00, 0x8A, 0x00,
    0xAA, 0x00, 0xBE, 0xE7, 0x19, 0xAE, 0xD3, 0x53, 0xB1, 0x2A, 0xD2, 0x2A, 0xF3, 0x3A, 0x13, 0x3B,
    0x13, 0x3B, 0x5A, 0xBE, 0x14, 0x64, 0x91, 0x22, 0xB6, 0x43, 0x1B, 0x75, 0xBD, 0x8D, 0xDD, 0x8D,
    0xDD, 0x8D, 0x75, 0x74, 0x53, 0x3B, 0xB6, 0x43, 0xDD, 0x95, 0x1E, 0xA6, 0x5E, 0xAE, 0x5E, 0xAE,
    0x7E, 0xAE, 0xD1, 0x2A, 0x54, 0x3B, 0xBA, 0x6C, 0x1E, 0x9E, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6,
    0x5E, 0xA6, 0x4D, 0x01, 0x56, 0x3B, 0xBE, 0x85, 0xFE, 0x9D, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0xA6,
    0x1E, 0xA6, 0x8B, 0x00, 0x56, 0x43, 0xFF, 0x8D, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x9D, 0x1E, 0x9E,
    0x1E, 0x9E, 0xAC, 0x00, 0x56, 0x43, 0xDF, 0x85, 0xBE, 0x8D, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95,
    0xFE, 0x95, 0xAC, 0x00, 0x36, 0x3B, 0x9F, 0x7D, 0x9E, 0x85, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D,
    0xDE, 0x8D, 0xAC, 0x00, 0x16, 0x3B, 0x7F, 0x75, 0x7E, 0x7D, 0x7E, 0x85, 0x9E, 0x85, 0x9E, 0x85,
    0x9E, 0x85, 0x8C, 0x00, 0x16, 0x3B, 0x7F, 0x75, 0x5E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7D, 0x9E, 0x7D,
    0x9E, 0x85, 0x8C, 0x00, 0x16, 0x3B, 0x5F, 0x75, 0x5E, 0x7D, 0x5E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7D,
    0x7E, 0x85, 0x6C, 0x00, 0xD6, 0x2A, 0x1F, 0x5D, 0x1E, 0x65, 0x1E, 0x6D, 0x3E, 0x6D, 0x3E, 0x6D,
    0x3E, 0x75, 0x4C, 0x00, 0x76, 0x1A, 0x7F, 0x34, 0x7E, 0x3C, 0x9E, 0x4C, 0xBE, 0x54, 0xBE, 0x54,
    0xDE, 0x54, 0x2C, 0x00, 0x16, 0x02, 0xDF, 0x13, 0xDE, 0x23, 0x1E, 0x34, 0x5E, 0x3C, 0x7E, 0x44,
    0x7E, 0x44, 0x2C, 0x00, 0x16, 0x0A, 0xFF, 0x1B, 0x1E, 0x2C, 0x5E, 0x3C, 0x9E, 0x4C, 0xBE, 0x4C,
    0xBE, 0x4C, 0x2C, 0x00, 0x36, 0x0A, 0x3F, 0x24, 0x5E, 0x3C, 0x9E, 0x4C, 0xBE, 0x54, 0xDE, 0x5C,
    0xDE, 0x5C, 0x2C, 0x00, 0x56, 0x12, 0x7F, 0x34, 0x9E, 0x44, 0xDE, 0x54, 0xFE, 0x64, 0x1E, 0x65,
    0x1E, 0x6D, 0x2C, 0x00, 0x76, 0x1A, 0x9F, 0x3C, 0xBE, 0x54, 0xFE, 0x64, 0x3E, 0x6D, 0x3E, 0x6D,
    0x3E, 0x6D, 0x0B, 0x00, 0x76, 0x1A, 0xDF, 0x44, 0xDE, 0x5C, 0x1E, 0x6D, 0x5E, 0x75, 0x7E, 0x7D,
    0x7E, 0x7D, 0x8D, 0x00, 0xB6, 0x1A, 0xBE, 0x4C, 0x1E, 0x6D, 0x5E, 0x75, 0x7E, 0x7D, 0x9E, 0x85,
    0x9E, 0x85, 0xCF, 0x09, 0xB4, 0x1A, 0x3B, 0x44, 0x5E, 0x75, 0x9E, 0x85, 0xBE, 0x8D, 0xDE, 0x95,
    0xDE, 0x95, 0x52, 0x43, 0x92, 0x1A, 0x36, 0x23, 0x5E, 0x7D, 0xBE, 0x8D, 0xFE, 0x9D, 0x1E, 0x9E,
    0x1E, 0x9E, 0xB8, 0x9D, 0xB0, 0x2A, 0x2E, 0x01, 0x97, 0x33, 0xFD, 0x5C, 0x7F, 0x75, 0x9F, 0x7D,
    0x9F, 0x7D, 0x7D, 0xDF, 0x36, 0x8D, 0x90, 0x32, 0x31, 0x0A, 0x53, 0x22, 0xB4, 0x2A, 0xB4, 0x32,
    0xB4, 0x32, 0xDF, 0xEF, 0x7D, 0xDF, 0x37, 0x8D, 0x2E, 0x1A, 0x6A, 0x00, 0x08, 0x00, 0x08, 0x00,
    0x08, 0x00
  };

/**
  * @brief  A bitmap for the Right part of a General Button Pressed. This logo is 8x26 px.
  */
const uint8_t BtnPressedRight[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xAA, 0x00, 0x8A, 0x00, 0xAA, 0x00, 0x6C, 0x09, 0x51, 0x4B, 0xD9, 0xA5, 0x9E, 0xE7,
    0xDF, 0xEF, 0x13, 0x3B, 0xF3, 0x3A, 0xF3, 0x3A, 0xD2, 0x2A, 0xB1, 0x2A, 0xD3, 0x5B, 0x19, 0xB6,
    0xBE, 0xE7, 0xDD, 0x8D, 0xDD, 0x8D, 0xBD, 0x8D, 0x1A, 0x75, 0xB5, 0x43, 0x70, 0x1A, 0x14, 0x64,
    0x7A, 0xBE, 0x7E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x3E, 0xA6, 0xDD, 0x95, 0x95, 0x43, 0x32, 0x3B,
    0x75, 0x74, 0x5E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x1E, 0x9E, 0x99, 0x64, 0x54, 0x33,
    0xF1, 0x32, 0x1E, 0xA6, 0x1E, 0xA6, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x9D, 0x85, 0x55, 0x3B,
    0x6D, 0x09, 0x1E, 0x9E, 0x1E, 0x9E, 0xFE, 0x9D, 0xFE, 0x95, 0xFE, 0x95, 0xDF, 0x8D, 0x56, 0x43,
    0xAC, 0x00, 0xFE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xDE, 0x95, 0xBE, 0x8D, 0x9F, 0x7D, 0x36, 0x3B,
    0xCC, 0x00, 0xDE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0x9E, 0x85, 0x9F, 0x7D, 0x36, 0x3B,
    0xCC, 0x00, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x7E, 0x7D, 0x5F, 0x75, 0x16, 0x33,
    0xCC, 0x00, 0x9E, 0x85, 0x9E, 0x7D, 0x7E, 0x7D, 0x7E, 0x7D, 0x5E, 0x7D, 0x5F, 0x6D, 0x16, 0x33,
    0xAC, 0x00, 0x7E, 0x85, 0x7E, 0x7D, 0x7E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D, 0x3F, 0x6D, 0xF6, 0x32,
    0xAC, 0x00, 0x3E, 0x75, 0x3E, 0x6D, 0x3E, 0x6D, 0x1E, 0x6D, 0xFE, 0x64, 0xFF, 0x5C, 0xD6, 0x2A,
    0xAC, 0x00, 0xDE, 0x54, 0xBE, 0x54, 0xBE, 0x4C, 0x9E, 0x4C, 0x5E, 0x3C, 0x5F, 0x2C, 0x76, 0x12,
    0x8C, 0x00, 0x7E, 0x44, 0x7E, 0x44, 0x5E, 0x3C, 0x1E, 0x34, 0xDE, 0x23, 0xBF, 0x13, 0xF6, 0x01,
    0x4C, 0x00, 0xBE, 0x4C, 0xBE, 0x4C, 0x9E, 0x4C, 0x5E, 0x3C, 0x1E, 0x2C, 0xDF, 0x1B, 0x16, 0x02,
    0x4C, 0x00, 0xDE, 0x5C, 0xDE, 0x5C, 0xBE, 0x54, 0x9E, 0x4C, 0x5E, 0x3C, 0x1F, 0x24, 0x36, 0x0A,
    0x6C, 0x00, 0x1E, 0x6D, 0x1E, 0x65, 0xFE, 0x64, 0xBE, 0x54, 0x9E, 0x44, 0x5F, 0x2C, 0x56, 0x12,
    0x6C, 0x00, 0x3E, 0x6D, 0x3E, 0x6D, 0x1E, 0x6D, 0xFE, 0x64, 0xBE, 0x54, 0x7F, 0x34, 0x56, 0x12,
    0x6C, 0x00, 0x7E, 0x7D, 0x7E, 0x7D, 0x5E, 0x75, 0x1E, 0x6D, 0xDE, 0x5C, 0x9F, 0x3C, 0x76, 0x1A,
    0x4C, 0x00, 0x9E, 0x85, 0x9E, 0x85, 0x7E, 0x7D, 0x5E, 0x75, 0x1E, 0x65, 0xBE, 0x4C, 0xB6, 0x1A,
    0xCD, 0x00, 0xDE, 0x95, 0xDE, 0x95, 0xBE, 0x8D, 0x7E, 0x85, 0x5E, 0x75, 0x1B, 0x3C, 0xB4, 0x12,
    0x0F, 0x0A, 0x1E, 0x9E, 0x1E, 0x9E, 0xFE, 0x9D, 0xBE, 0x8D, 0x5D, 0x7D, 0x16, 0x23, 0x72, 0x12,
    0x73, 0x4B, 0x9F, 0x7D, 0x9F, 0x7D, 0x7F, 0x75, 0xFD, 0x64, 0xD8, 0x43, 0xF1, 0x01, 0x52, 0x43,
    0xD9, 0xA5, 0xB4, 0x32, 0xB4, 0x32, 0x94, 0x2A, 0x73, 0x22, 0x92, 0x1A, 0x72, 0x43, 0xB8, 0x9D,
    0x9E, 0xE7, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x6A, 0x00, 0x6F, 0x22, 0x78, 0x95, 0x9E, 0xE7,
    0xDF, 0xEF
  };

/**
  * @brief  A bitmap for the Central part of a General Button Pressed. This logo is 8x26 px.
  */
const uint8_t BtnPressed[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00,
    0xAA, 0x00, 0x13, 0x43, 0x13, 0x43, 0x13, 0x43, 0x13, 0x43, 0x13, 0x43, 0x13, 0x43, 0x13, 0x43,
    0x13, 0x43, 0xDD, 0x95, 0xDD, 0x95, 0xDD, 0x95, 0xDD, 0x95, 0xDD, 0x95, 0xDD, 0x95, 0xDD, 0x95,
    0xDD, 0x95, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE, 0x5E, 0xAE,
    0x5E, 0xAE, 0x3E, 0xAE, 0x3E, 0xAE, 0x3E, 0xAE, 0x3E, 0xAE, 0x3E, 0xAE, 0x3E, 0xAE, 0x3E, 0xAE,
    0x3E, 0xAE, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6, 0x3E, 0xA6,
    0x3E, 0xA6, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E, 0x1E, 0x9E,
    0x1E, 0x9E, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95,
    0xFE, 0x95, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D, 0xBE, 0x8D,
    0xBE, 0x8D, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85,
    0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85,
    0x9E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85, 0x7E, 0x85,
    0x7E, 0x85, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75,
    0x3E, 0x75, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54, 0xDE, 0x54,
    0xDE, 0x54, 0x7E, 0x44, 0x7E, 0x44, 0x7E, 0x44, 0x7E, 0x44, 0x7E, 0x44, 0x7E, 0x44, 0x7E, 0x44,
    0x7E, 0x44, 0xBE, 0x4C, 0xBE, 0x4C, 0xBE, 0x4C, 0xBE, 0x4C, 0xBE, 0x4C, 0xBE, 0x4C, 0xBE, 0x4C,
    0xBE, 0x4C, 0xFE, 0x5C, 0xFE, 0x5C, 0xFE, 0x5C, 0xFE, 0x5C, 0xFE, 0x5C, 0xFE, 0x5C, 0xFE, 0x5C,
    0xFE, 0x5C, 0x1E, 0x6D, 0x1E, 0x6D, 0x1E, 0x6D, 0x1E, 0x6D, 0x1E, 0x6D, 0x1E, 0x6D, 0x1E, 0x6D,
    0x1E, 0x6D, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75, 0x3E, 0x75,
    0x3E, 0x75, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D, 0x5E, 0x7D,
    0x5E, 0x7D, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85, 0x9E, 0x85,
    0x9E, 0x85, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95, 0xFE, 0x95,
    0xFE, 0x95, 0x3E, 0x9E, 0x3E, 0x9E, 0x3E, 0x9E, 0x3E, 0x9E, 0x3E, 0x9E, 0x3E, 0x9E, 0x3E, 0x9E,
    0x3E, 0x9E, 0xBF, 0x7D, 0xBF, 0x7D, 0xBF, 0x7D, 0xBF, 0x7D, 0xBF, 0x7D, 0xBF, 0x7D, 0xBF, 0x7D,
    0xBF, 0x7D, 0xB4, 0x32, 0xB4, 0x32, 0xB4, 0x32, 0xB4, 0x32, 0xB4, 0x32, 0xB4, 0x32, 0xB4, 0x32,
    0xB4, 0x32, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
    0x08, 0x00
  };

/**
  * @brief  A bitmap for the Left part of a Switch Button. This logo is 8x26 px.
  */
const uint8_t SwitchNormalLeft[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xDF, 0xEF, 0xBE, 0xEF, 0x7B, 0xBE, 0x96, 0x74, 0x52, 0x43, 0xB0, 0x22, 0xB0, 0x22,
    0xB1, 0x2A, 0xBE, 0xE7, 0x9B, 0xBE, 0x37, 0x8D, 0xB7, 0x74, 0x98, 0x64, 0x98, 0x64, 0x99, 0x6C,
    0x99, 0x6C, 0xBB, 0xC6, 0x17, 0x85, 0x56, 0x64, 0x7B, 0x85, 0x3E, 0x9E, 0x9F, 0xAE, 0x9F, 0xB6,
    0x9F, 0xB6, 0x38, 0x8D, 0x97, 0x6C, 0xFA, 0x74, 0x7F, 0xAE, 0xBF, 0xB6, 0xDF, 0xC6, 0xFF, 0xC6,
    0xFF, 0xC6, 0x56, 0x64, 0xB9, 0x6C, 0x9D, 0x85, 0x7F, 0xAE, 0x9F, 0xB6, 0xBF, 0xBE, 0xDF, 0xBE,
    0xDF, 0xBE, 0x74, 0x43, 0xBA, 0x64, 0xFF, 0x8D, 0x3F, 0xA6, 0x5F, 0xAE, 0x9F, 0xB6, 0x9F, 0xB6,
    0x9F, 0xB6, 0x33, 0x33, 0x9A, 0x5C, 0xFF, 0x8D, 0x1F, 0x96, 0x5F, 0xA6, 0x7F, 0xAE, 0x7F, 0xAE,
    0x7F, 0xAE, 0x33, 0x33, 0x7A, 0x5C, 0xDF, 0x85, 0xFF, 0x95, 0x3F, 0x9E, 0x5F, 0xA6, 0x5F, 0xA6,
    0x5F, 0xA6, 0x33, 0x33, 0x7A, 0x54, 0xBF, 0x85, 0xFF, 0x8D, 0x1F, 0x96, 0x3F, 0x9E, 0x3F, 0x9E,
    0x3F, 0xA6, 0x33, 0x33, 0x5A, 0x54, 0x9F, 0x7D, 0xBF, 0x85, 0xFF, 0x8D, 0x1F, 0x96, 0x1F, 0x96,
    0x1F, 0x9E, 0x33, 0x33, 0x5A, 0x54, 0x7F, 0x75, 0x9F, 0x7D, 0xDF, 0x85, 0xFF, 0x8D, 0xFF, 0x95,
    0xFF, 0x95, 0x33, 0x33, 0x3A, 0x4C, 0x5F, 0x6D, 0x7F, 0x75, 0xBF, 0x7D, 0xDF, 0x85, 0xDF, 0x8D,
    0xDF, 0x8D, 0x53, 0x3B, 0x7A, 0x5C, 0xBF, 0x85, 0xDF, 0x85, 0xDF, 0x8D, 0xFF, 0x95, 0x1F, 0x96,
    0x1F, 0x96, 0x53, 0x43, 0xDA, 0x6C, 0x3F, 0x9E, 0x3F, 0x9E, 0x5F, 0xA6, 0x5F, 0xA6, 0x5F, 0xA6,
    0x5F, 0xA6, 0x73, 0x43, 0xDA, 0x74, 0x5F, 0xAE, 0x7F, 0xAE, 0x7F, 0xAE, 0x9F, 0xB6, 0x9F, 0xB6,
    0x9F, 0xB6, 0x73, 0x43, 0xFA, 0x74, 0x5F, 0xA6, 0x7F, 0xAE, 0x7F, 0xAE, 0x9F, 0xB6, 0x9F, 0xB6,
    0x9F, 0xB6, 0x73, 0x43, 0xFA, 0x74, 0x7F, 0xAE, 0x7F, 0xAE, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6,
    0x9F, 0xB6, 0x73, 0x43, 0x1A, 0x7D, 0x9F, 0xAE, 0x9F, 0xB6, 0xBF, 0xB6, 0xBF, 0xBE, 0xBF, 0xBE,
    0xBF, 0xBE, 0x73, 0x43, 0x1A, 0x7D, 0xBF, 0xB6, 0xBF, 0xBE, 0xBF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE,
    0xDF, 0xBE, 0x73, 0x43, 0x3A, 0x7D, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xC6, 0xDF, 0xC6, 0xDF, 0xC6,
    0xFF, 0xC6, 0xD4, 0x53, 0x39, 0x7D, 0x9E, 0xB6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6,
    0xFF, 0xC6, 0xD7, 0x84, 0x18, 0x85, 0xFC, 0x9D, 0xFF, 0xC6, 0xFF, 0xC6, 0x1F, 0xCF, 0x1F, 0xCF,
    0x1F, 0xCF, 0xD9, 0xAD, 0x17, 0x85, 0x59, 0x85, 0xBE, 0xBE, 0x1F, 0xC7, 0x1F, 0xCF, 0x1F, 0xCF,
    0x3F, 0xCF, 0xFC, 0xD6, 0x98, 0x9D, 0x96, 0x74, 0x59, 0x8D, 0x3D, 0xAE, 0xBE, 0xBE, 0xBE, 0xBE,
    0xBE, 0xBE, 0xBE, 0xEF, 0xDC, 0xCE, 0x78, 0x95, 0xB6, 0x7C, 0xD7, 0x74, 0xF8, 0x7C, 0xF8, 0x7C,
    0xF8, 0x7C, 0xDF, 0xEF, 0xBE, 0xEF, 0xBB, 0xC6, 0x17, 0x8D, 0xF4, 0x5B, 0x52, 0x43, 0x52, 0x43,
    0x52, 0x43
  };

/**
  * @brief  A bitmap for the Right part of a Switch Button. This logo is 8x26 px.
  */
const uint8_t SwitchNormalRight[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xB1, 0x2A, 0xB0, 0x22, 0xB0, 0x22, 0x32, 0x3B, 0x75, 0x6C, 0x5A, 0xB6, 0x9E, 0xE7,
    0xDF, 0xEF, 0x99, 0x6C, 0x99, 0x6C, 0x99, 0x64, 0x78, 0x64, 0x76, 0x64, 0x96, 0x74, 0x3A, 0xB6,
    0x9E, 0xE7, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x1E, 0x9E, 0x5B, 0x7D, 0xD5, 0x4B, 0xB6, 0x74,
    0x9B, 0xBE, 0xFF, 0xC6, 0xFF, 0xC6, 0xDF, 0xC6, 0xBF, 0xB6, 0x7F, 0xAE, 0x1A, 0x75, 0x97, 0x6C,
    0x37, 0x8D, 0xDF, 0xBE, 0xDF, 0xBE, 0xBF, 0xBE, 0x9F, 0xB6, 0x7F, 0xAE, 0xBD, 0x8D, 0xB9, 0x6C,
    0x35, 0x5C, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x5F, 0xAE, 0x5F, 0xA6, 0x1F, 0x96, 0xBA, 0x64,
    0x54, 0x3B, 0x7F, 0xAE, 0x7F, 0xAE, 0x7F, 0xAE, 0x5F, 0xA6, 0x1F, 0x9E, 0x1F, 0x8E, 0x9A, 0x5C,
    0xF3, 0x2A, 0x5F, 0xA6, 0x5F, 0xA6, 0x5F, 0xA6, 0x3F, 0x9E, 0x1F, 0x96, 0xFF, 0x8D, 0x7A, 0x5C,
    0x13, 0x33, 0x3F, 0xA6, 0x3F, 0x9E, 0x3F, 0x9E, 0x1F, 0x96, 0xFF, 0x8D, 0xDF, 0x85, 0x7A, 0x5C,
    0x13, 0x33, 0x1F, 0x9E, 0x1F, 0x96, 0x1F, 0x96, 0xFF, 0x8D, 0xBF, 0x85, 0xBF, 0x7D, 0x5A, 0x54,
    0x13, 0x2B, 0xFF, 0x95, 0xFF, 0x95, 0xFF, 0x8D, 0xBF, 0x85, 0x9F, 0x7D, 0x9F, 0x75, 0x5A, 0x4C,
    0x13, 0x2B, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x85, 0x9F, 0x7D, 0x7F, 0x75, 0x7F, 0x6D, 0x3A, 0x4C,
    0x13, 0x2B, 0x1F, 0x96, 0x1F, 0x96, 0xFF, 0x95, 0xFF, 0x8D, 0xDF, 0x85, 0xDF, 0x85, 0x7A, 0x5C,
    0x33, 0x33, 0x5F, 0xA6, 0x5F, 0xA6, 0x5F, 0xA6, 0x5F, 0xA6, 0x3F, 0x9E, 0x3F, 0x9E, 0xDA, 0x6C,
    0x53, 0x3B, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x7F, 0xAE, 0x7F, 0xAE, 0x7F, 0xAE, 0xFA, 0x74,
    0x53, 0x3B, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x7F, 0xB6, 0x7F, 0xAE, 0x7F, 0xAE, 0xFA, 0x74,
    0x53, 0x3B, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x7F, 0xAE, 0x9F, 0xAE, 0x1A, 0x75,
    0x53, 0x3B, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x1A, 0x7D,
    0x53, 0x43, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xB6, 0x1A, 0x7D,
    0x73, 0x43, 0xFF, 0xC6, 0xDF, 0xC6, 0xDF, 0xC6, 0xDF, 0xC6, 0xDF, 0xBE, 0xDF, 0xBE, 0x3A, 0x7D,
    0x53, 0x3B, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xBF, 0xB6, 0x3A, 0x85,
    0xD4, 0x53, 0x1F, 0xCF, 0x1F, 0xCF, 0xFF, 0xCE, 0xFF, 0xC6, 0xFF, 0xC6, 0x1D, 0xA6, 0x19, 0x85,
    0xD6, 0x7C, 0x3F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0xFF, 0xCE, 0xBE, 0xBE, 0x5A, 0x8D, 0x18, 0x85,
    0xD9, 0xA5, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0x3D, 0xAE, 0x5A, 0x8D, 0xB6, 0x74, 0x98, 0x9D,
    0xFC, 0xD6, 0xF8, 0x7C, 0xF8, 0x7C, 0xF8, 0x7C, 0xD7, 0x74, 0xB6, 0x74, 0x78, 0x95, 0xDC, 0xCE,
    0xBE, 0xEF, 0x52, 0x43, 0x52, 0x43, 0x52, 0x43, 0xD3, 0x5B, 0x16, 0x85, 0x9B, 0xC6, 0xBE, 0xEF,
    0xDF, 0xEF
  };

/**
  * @brief  A bitmap for the Central part of a Switch Button. This logo is 8x26 px.
  */
const uint8_t SwitchNormal[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A,
    0xB1, 0x2A, 0x99, 0x6C, 0x99, 0x6C, 0x99, 0x6C, 0x99, 0x6C, 0x99, 0x6C, 0x99, 0x6C, 0x99, 0x6C,
    0x99, 0x6C, 0xBF, 0xB6, 0xBF, 0xB6, 0xBF, 0xB6, 0xBF, 0xB6, 0xBF, 0xB6, 0xBF, 0xB6, 0xBF, 0xB6,
    0xBF, 0xB6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6,
    0xFF, 0xC6, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE,
    0xDF, 0xBE, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6,
    0x9F, 0xB6, 0x7F, 0xAE, 0x7F, 0xAE, 0x7F, 0xAE, 0x7F, 0xAE, 0x7F, 0xAE, 0x7F, 0xAE, 0x7F, 0xAE,
    0x7F, 0xAE, 0x5F, 0xAE, 0x5F, 0xAE, 0x5F, 0xAE, 0x5F, 0xAE, 0x5F, 0xAE, 0x5F, 0xAE, 0x5F, 0xAE,
    0x5F, 0xAE, 0x3F, 0xA6, 0x3F, 0xA6, 0x3F, 0xA6, 0x3F, 0xA6, 0x3F, 0xA6, 0x3F, 0xA6, 0x3F, 0xA6,
    0x3F, 0xA6, 0x3F, 0x9E, 0x3F, 0x9E, 0x3F, 0x9E, 0x3F, 0x9E, 0x3F, 0x9E, 0x3F, 0x9E, 0x3F, 0x9E,
    0x3F, 0x9E, 0xFF, 0x95, 0xFF, 0x95, 0xFF, 0x95, 0xFF, 0x95, 0xFF, 0x95, 0xFF, 0x95, 0xFF, 0x95,
    0xFF, 0x95, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D,
    0xDF, 0x8D, 0x1F, 0x96, 0x1F, 0x96, 0x1F, 0x96, 0x1F, 0x96, 0x1F, 0x96, 0x1F, 0x96, 0x1F, 0x96,
    0x1F, 0x96, 0x5F, 0xA6, 0x5F, 0xA6, 0x5F, 0xA6, 0x5F, 0xA6, 0x5F, 0xA6, 0x5F, 0xA6, 0x5F, 0xA6,
    0x5F, 0xA6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6,
    0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6,
    0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6,
    0x9F, 0xB6, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE,
    0xBF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE, 0xDF, 0xBE,
    0xDF, 0xBE, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6,
    0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6,
    0xFF, 0xC6, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF,
    0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF, 0x1F, 0xCF,
    0x1F, 0xCF, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE, 0xBE,
    0xBE, 0xBE, 0xF8, 0x7C, 0xF8, 0x7C, 0xF8, 0x7C, 0xF8, 0x7C, 0xF8, 0x7C, 0xF8, 0x7C, 0xF8, 0x7C,
    0xF8, 0x7C, 0x72, 0x43, 0x72, 0x43, 0x72, 0x43, 0x72, 0x43, 0x72, 0x43, 0x72, 0x43, 0x72, 0x43,
    0x72, 0x43
  };

/**
  * @brief  A bitmap for the Left part of a Switch Button Pressed. This logo is 8x26 px.
  */
const uint8_t SwitchPressedLeft[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xDF, 0xEF, 0xBE, 0xEF, 0x79, 0xCE, 0x92, 0x94, 0x4D, 0x6B, 0xAA, 0x52, 0xAA, 0x52,
    0xAB, 0x5A, 0xBE, 0xE7, 0x9A, 0xCE, 0x34, 0xA5, 0xD2, 0x94, 0xB2, 0x94, 0xB2, 0x94, 0xD2, 0x94,
    0xD3, 0x9C, 0xBA, 0xCE, 0x34, 0xA5, 0x71, 0x8C, 0x96, 0xB5, 0x79, 0xCE, 0xDB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0x55, 0xAD, 0xB2, 0x94, 0x14, 0xA5, 0xBA, 0xD6, 0xFB, 0xDE, 0x1B, 0xDF, 0x1C, 0xE7,
    0x1C, 0xE7, 0x51, 0x8C, 0xD3, 0x9C, 0xD7, 0xBD, 0xBA, 0xD6, 0xDA, 0xD6, 0xFB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0x8E, 0x73, 0xD3, 0x9C, 0x58, 0xC6, 0x99, 0xCE, 0xBA, 0xD6, 0xDA, 0xD6, 0xDB, 0xDE,
    0xDB, 0xDE, 0x2D, 0x6B, 0xD2, 0x94, 0x58, 0xC6, 0x59, 0xCE, 0x9A, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6,
    0xBA, 0xD6, 0x4D, 0x6B, 0xB2, 0x94, 0x18, 0xC6, 0x58, 0xC6, 0x79, 0xCE, 0x9A, 0xD6, 0x9A, 0xD6,
    0x9A, 0xD6, 0x4D, 0x6B, 0xB2, 0x94, 0x17, 0xBE, 0x38, 0xC6, 0x59, 0xCE, 0x79, 0xCE, 0x79, 0xCE,
    0x79, 0xCE, 0x4D, 0x6B, 0xB2, 0x94, 0xF7, 0xBD, 0x18, 0xC6, 0x38, 0xC6, 0x59, 0xCE, 0x79, 0xCE,
    0x79, 0xCE, 0x4D, 0x6B, 0x92, 0x94, 0xD7, 0xBD, 0xF7, 0xBD, 0x18, 0xC6, 0x38, 0xC6, 0x38, 0xC6,
    0x38, 0xC6, 0x4D, 0x6B, 0x92, 0x94, 0xB6, 0xB5, 0xD7, 0xBD, 0xF7, 0xBD, 0x18, 0xC6, 0x18, 0xC6,
    0x18, 0xC6, 0x6D, 0x6B, 0xD2, 0x94, 0x17, 0xBE, 0x18, 0xC6, 0x38, 0xC6, 0x58, 0xC6, 0x59, 0xCE,
    0x59, 0xCE, 0x6D, 0x6B, 0x14, 0xA5, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x9A, 0xD6, 0x9A, 0xD6,
    0x9A, 0xD6, 0x8E, 0x73, 0x34, 0xA5, 0xBA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6, 0xDA, 0xD6, 0xDA, 0xD6,
    0xDA, 0xD6, 0x8E, 0x73, 0x34, 0xA5, 0xBA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6, 0xDA, 0xD6, 0xDA, 0xD6,
    0xDA, 0xD6, 0x8E, 0x73, 0x34, 0xA5, 0xBA, 0xD6, 0xBA, 0xD6, 0xDA, 0xD6, 0xDB, 0xDE, 0xDB, 0xDE,
    0xDB, 0xDE, 0x8E, 0x73, 0x34, 0xA5, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0x8E, 0x73, 0x34, 0xA5, 0xDB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0x6D, 0x6B, 0x55, 0xAD, 0x1B, 0xDF, 0xFB, 0xDE, 0xFB, 0xDE, 0x1B, 0xDF, 0x1B, 0xDF,
    0x1B, 0xDF, 0xEF, 0x7B, 0x55, 0xAD, 0xBA, 0xD6, 0x1B, 0xDF, 0x1B, 0xDF, 0x1C, 0xE7, 0x1C, 0xE7,
    0x1C, 0xE7, 0xF3, 0x9C, 0x34, 0xA5, 0x18, 0xC6, 0x1B, 0xDF, 0x1C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7,
    0x3C, 0xE7, 0xD7, 0xBD, 0x14, 0xA5, 0x55, 0xAD, 0xDB, 0xDE, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7,
    0x3C, 0xE7, 0xFB, 0xDE, 0x96, 0xB5, 0xB2, 0x94, 0x75, 0xAD, 0x59, 0xCE, 0xDB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0xBE, 0xEF, 0xDB, 0xD6, 0x75, 0xAD, 0xD2, 0x94, 0xF3, 0x9C, 0x13, 0x9D, 0x14, 0xA5,
    0x14, 0xA5, 0xDF, 0xEF, 0xBE, 0xEF, 0xBA, 0xD6, 0x34, 0xA5, 0xEF, 0x7B, 0x6D, 0x6B, 0x4D, 0x6B,
    0x6D, 0x6B
  };

/**
  * @brief  A bitmap for the Right part of a Switch Button Pressed. This logo is 8x26 px.
  */
const uint8_t SwitchPressedRight[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xAB, 0x5A, 0xAA, 0x52, 0xAA, 0x52, 0x2D, 0x6B, 0x71, 0x8C, 0x58, 0xC6, 0x9E, 0xE7,
    0xDF, 0xEF, 0xD3, 0x9C, 0xD2, 0x94, 0xD2, 0x94, 0xB2, 0x94, 0x71, 0x94, 0xB2, 0x94, 0x38, 0xBE,
    0x9E, 0xE7, 0xFB, 0xDE, 0xFB, 0xDE, 0xDB, 0xDE, 0x59, 0xCE, 0x75, 0xAD, 0xEF, 0x7B, 0xB2, 0x94,
    0x99, 0xCE, 0x1C, 0xE7, 0x1C, 0xE7, 0x1B, 0xDF, 0xFB, 0xDE, 0xBA, 0xD6, 0x34, 0xA5, 0xB2, 0x94,
    0x34, 0xA5, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xDA, 0xD6, 0xBA, 0xD6, 0xF7, 0xBD, 0xD3, 0x9C,
    0x30, 0x84, 0xDB, 0xDE, 0xDB, 0xDE, 0xDA, 0xD6, 0xBA, 0xD6, 0x99, 0xCE, 0x59, 0xCE, 0xD3, 0x9C,
    0x6D, 0x6B, 0xBA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6, 0x9A, 0xD6, 0x59, 0xCE, 0x59, 0xCE, 0xD2, 0x94,
    0x2C, 0x63, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x79, 0xCE, 0x58, 0xC6, 0x38, 0xC6, 0xB2, 0x94,
    0x2D, 0x6B, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x59, 0xCE, 0x38, 0xC6, 0x18, 0xC6, 0xB2, 0x94,
    0x2C, 0x63, 0x79, 0xCE, 0x79, 0xCE, 0x59, 0xCE, 0x38, 0xC6, 0x18, 0xC6, 0x17, 0xBE, 0xB2, 0x94,
    0x2C, 0x63, 0x38, 0xC6, 0x38, 0xC6, 0x38, 0xC6, 0x18, 0xC6, 0xF7, 0xBD, 0xF7, 0xBD, 0x92, 0x94,
    0x2C, 0x63, 0x18, 0xC6, 0x18, 0xC6, 0x18, 0xC6, 0xF7, 0xBD, 0xD7, 0xBD, 0xD7, 0xBD, 0x92, 0x94,
    0x2C, 0x63, 0x59, 0xCE, 0x59, 0xCE, 0x58, 0xC6, 0x38, 0xC6, 0x18, 0xC6, 0x38, 0xC6, 0xD2, 0x94,
    0x4D, 0x6B, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x99, 0xCE, 0x79, 0xCE, 0x9A, 0xD6, 0x14, 0xA5,
    0x6D, 0x6B, 0xDA, 0xD6, 0xDA, 0xD6, 0xDA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6, 0xDA, 0xD6, 0x34, 0xA5,
    0x6D, 0x6B, 0xDA, 0xD6, 0xDA, 0xD6, 0xDA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6, 0xDA, 0xD6, 0x34, 0xA5,
    0x6D, 0x6B, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDA, 0xD6, 0xBA, 0xD6, 0xDB, 0xDE, 0x34, 0xA5,
    0x6D, 0x6B, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xFB, 0xDE, 0x54, 0xA5,
    0x6D, 0x6B, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0x55, 0xAD,
    0x6D, 0x6B, 0x1B, 0xDF, 0x1B, 0xDF, 0x1B, 0xDF, 0xFB, 0xDE, 0xFB, 0xDE, 0x1C, 0xE7, 0x55, 0xAD,
    0x6D, 0x6B, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7, 0x1B, 0xDF, 0x1B, 0xDF, 0xDB, 0xDE, 0x55, 0xAD,
    0xCF, 0x7B, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x1C, 0xE7, 0x1B, 0xDF, 0x38, 0xC6, 0x34, 0xA5,
    0xD3, 0x9C, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0xFB, 0xDE, 0x75, 0xAD, 0x34, 0xA5,
    0xD7, 0xBD, 0xFB, 0xDE, 0xFB, 0xDE, 0xDB, 0xDE, 0x59, 0xCE, 0x75, 0xAD, 0xB2, 0x94, 0x96, 0xB5,
    0xFB, 0xDE, 0x14, 0xA5, 0x14, 0xA5, 0xF3, 0x9C, 0xF3, 0x9C, 0xD2, 0x94, 0x75, 0xAD, 0xDB, 0xD6,
    0xBE, 0xEF, 0x6D, 0x6B, 0x4D, 0x6B, 0x4D, 0x6B, 0xEF, 0x7B, 0x13, 0x9D, 0x9A, 0xCE, 0xBE, 0xEF,
    0xDF, 0xEF
  };

/**
  * @brief  A bitmap for the Central part of a Switch Button Pressed. This logo is 8x26 px.
  */
const uint8_t SwitchPressed[482] =
  {
    0x42, 0x4D, 0xE2, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x1A, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xE2, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xAB, 0x5A, 0xAB, 0x5A, 0xAB, 0x5A, 0xAB, 0x5A, 0xAB, 0x5A, 0xAB, 0x5A, 0xAB, 0x5A,
    0xAB, 0x5A, 0xD3, 0x9C, 0xD3, 0x9C, 0xD3, 0x9C, 0xD3, 0x9C, 0xD3, 0x9C, 0xD3, 0x9C, 0xD3, 0x9C,
    0xD3, 0x9C, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7,
    0x1C, 0xE7, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE,
    0xDB, 0xDE, 0xBA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6, 0xBA, 0xD6,
    0xBA, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6,
    0x9A, 0xD6, 0x99, 0xCE, 0x99, 0xCE, 0x99, 0xCE, 0x99, 0xCE, 0x99, 0xCE, 0x99, 0xCE, 0x99, 0xCE,
    0x99, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE, 0x79, 0xCE,
    0x79, 0xCE, 0x38, 0xC6, 0x38, 0xC6, 0x38, 0xC6, 0x38, 0xC6, 0x38, 0xC6, 0x38, 0xC6, 0x38, 0xC6,
    0x38, 0xC6, 0x18, 0xC6, 0x18, 0xC6, 0x18, 0xC6, 0x18, 0xC6, 0x18, 0xC6, 0x18, 0xC6, 0x18, 0xC6,
    0x18, 0xC6, 0x59, 0xCE, 0x59, 0xCE, 0x59, 0xCE, 0x59, 0xCE, 0x59, 0xCE, 0x59, 0xCE, 0x59, 0xCE,
    0x59, 0xCE, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6, 0x9A, 0xD6,
    0x9A, 0xD6, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE,
    0xDB, 0xDE, 0xDA, 0xD6, 0xDA, 0xD6, 0xDA, 0xD6, 0xDA, 0xD6, 0xDA, 0xD6, 0xDA, 0xD6, 0xDA, 0xD6,
    0xDA, 0xD6, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE, 0xDB, 0xDE,
    0xDB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0x1B, 0xDF, 0x1B, 0xDF, 0x1B, 0xDF, 0x1B, 0xDF, 0x1B, 0xDF, 0x1B, 0xDF, 0x1B, 0xDF,
    0x1B, 0xDF, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7, 0x1C, 0xE7,
    0x1C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7, 0x3C, 0xE7,
    0x3C, 0xE7, 0x5C, 0xE7, 0x5C, 0xE7, 0x5C, 0xE7, 0x5C, 0xE7, 0x5C, 0xE7, 0x5C, 0xE7, 0x5C, 0xE7,
    0x5C, 0xE7, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE, 0xFB, 0xDE,
    0xFB, 0xDE, 0x14, 0xA5, 0x14, 0xA5, 0x14, 0xA5, 0x14, 0xA5, 0x14, 0xA5, 0x14, 0xA5, 0x14, 0xA5,
    0x14, 0xA5, 0x6D, 0x6B, 0x6D, 0x6B, 0x6D, 0x6B, 0x6D, 0x6B, 0x6D, 0x6B, 0x6D, 0x6B, 0x6D, 0x6B,
    0x6D, 0x6B
  };

/**
  * @brief  A bitmap for the Left part of the Slidebar. This logo is 4x18 px.
  */
const uint8_t SlidebarLeft[210] =
  {
    0x42, 0x4D, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xD2, 0x00, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0x13, 0x33, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A, 0x13, 0x33, 0xB6, 0x74, 0xF9, 0x74,
    0xBD, 0x8D, 0x13, 0x33, 0x77, 0x64, 0x5E, 0xA6, 0xBF, 0xBE, 0x13, 0x2B, 0x5C, 0x7D, 0x5F, 0xA6,
    0x7F, 0xB6, 0x13, 0x2B, 0x9E, 0x7D, 0x1F, 0x9E, 0x5F, 0xA6, 0x33, 0x33, 0x7E, 0x75, 0xFF, 0x95,
    0x3F, 0x9E, 0x33, 0x33, 0x5E, 0x75, 0xDF, 0x85, 0x1F, 0x96, 0x33, 0x33, 0x3E, 0x6D, 0x9F, 0x7D,
    0xDF, 0x8D, 0x13, 0x33, 0x1E, 0x65, 0x7F, 0x75, 0xBF, 0x85, 0x13, 0x33, 0x3E, 0x65, 0x7F, 0x75,
    0xBF, 0x85, 0x13, 0x33, 0x3E, 0x6D, 0x9F, 0x7D, 0xDF, 0x8D, 0x13, 0x2B, 0x5E, 0x75, 0xDF, 0x85,
    0x1F, 0x96, 0x13, 0x2B, 0x7E, 0x7D, 0xFF, 0x95, 0x3F, 0x9E, 0x33, 0x33, 0x9E, 0x85, 0x1F, 0x9E,
    0x5F, 0xA6, 0x33, 0x33, 0x5C, 0x7D, 0x5F, 0xA6, 0x7F, 0xB6, 0x33, 0x33, 0x78, 0x64, 0x5E, 0xA6,
    0xBF, 0xBE, 0x33, 0x33, 0xF4, 0x5B, 0x98, 0x6C, 0xBD, 0x8D, 0x33, 0x33, 0xB1, 0x2A, 0xB1, 0x2A,
    0xB1, 0x2A
  };

/**
  * @brief  A bitmap for the Right part of the Slidebar. This logo is 4x18 px.
  */
const uint8_t SlidebarRight[210] =
  {
    0x42, 0x4D, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xD2, 0x00, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A, 0x13, 0x33, 0xBD, 0x8D, 0x98, 0x6C, 0xF4, 0x5B,
    0x13, 0x33, 0xBF, 0xBE, 0x5E, 0xA6, 0x78, 0x64, 0x13, 0x33, 0x7F, 0xB6, 0x5F, 0xA6, 0x5C, 0x7D,
    0x13, 0x2B, 0x5F, 0xA6, 0x1F, 0x9E, 0x9E, 0x85, 0x13, 0x2B, 0x3F, 0x9E, 0xFF, 0x95, 0x7E, 0x7D,
    0x33, 0x33, 0x1F, 0x96, 0xDF, 0x85, 0x5E, 0x75, 0x33, 0x33, 0xDF, 0x8D, 0x9F, 0x7D, 0x3E, 0x6D,
    0x33, 0x33, 0xBF, 0x85, 0x7F, 0x75, 0x3E, 0x65, 0x33, 0x33, 0xBF, 0x85, 0x7F, 0x75, 0x1E, 0x65,
    0x33, 0x33, 0xDF, 0x8D, 0x9F, 0x7D, 0x3E, 0x6D, 0x13, 0x33, 0x1F, 0x96, 0xDF, 0x85, 0x5E, 0x75,
    0x13, 0x2B, 0x3F, 0x9E, 0xFF, 0x95, 0x7E, 0x75, 0x13, 0x2B, 0x5F, 0xA6, 0x1F, 0x9E, 0x9E, 0x7D,
    0x33, 0x33, 0x7F, 0xB6, 0x5F, 0xA6, 0x5C, 0x7D, 0x33, 0x33, 0xBF, 0xBE, 0x5E, 0xA6, 0x77, 0x64,
    0x33, 0x33, 0xBD, 0x8D, 0xF9, 0x74, 0xB6, 0x74, 0x33, 0x33, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A,
    0x33, 0x33
  };

/**
  * @brief  A bitmap for the Central part of the Slidebar. This logo is 4x18 px.
  */
const uint8_t SlidebarCentral[210] =
  {
    0x42, 0x4D, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0xD2, 0x00, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A, 0xFE, 0x9D, 0xFE, 0x9D, 0xFE, 0x9D,
    0xFE, 0x9D, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE,
    0xBF, 0xBE, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6, 0x5F, 0xAE, 0x5F, 0xAE, 0x5F, 0xAE,
    0x5F, 0xAE, 0x3F, 0x9E, 0x3F, 0x9E, 0x3F, 0x9E, 0x3F, 0x9E, 0x1F, 0x96, 0x1F, 0x96, 0x1F, 0x96,
    0x1F, 0x96, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D, 0xDF, 0x8D,
    0xDF, 0x8D, 0x1F, 0x96, 0x1F, 0x96, 0x1F, 0x96, 0x1F, 0x96, 0x3F, 0x9E, 0x3F, 0x9E, 0x3F, 0x9E,
    0x3F, 0x9E, 0x5F, 0xAE, 0x5F, 0xAE, 0x5F, 0xAE, 0x5F, 0xAE, 0x9F, 0xB6, 0x9F, 0xB6, 0x9F, 0xB6,
    0x9F, 0xB6, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE, 0xBF, 0xBE, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6,
    0xFF, 0xC6, 0xFE, 0x9D, 0xFE, 0x9D, 0xFE, 0x9D, 0xFE, 0x9D, 0xB1, 0x2A, 0xB1, 0x2A, 0xB1, 0x2A,
    0xB1, 0x2A
  };

/**
  * @brief  A bitmap for the Cursor of the Slidebar. This logo is 6x20 px.
  */
const uint8_t SlidebarCursor[306] =
  {
    0x42, 0x4D, 0x32, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x32, 0x01, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x20, 0x4E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0xE0, 0x07, 0x00, 0x00, 0x1F, 0x00,
    0x00, 0x00, 0x14, 0x2B, 0x56, 0x33, 0x56, 0x33, 0x76, 0x33, 0x76, 0x33, 0x15, 0x2B, 0x15, 0x2B,
    0x39, 0x54, 0x39, 0x54, 0x39, 0x54, 0x39, 0x54, 0x35, 0x33, 0x15, 0x2B, 0x79, 0x5C, 0x79, 0x5C,
    0x79, 0x5C, 0x79, 0x5C, 0x15, 0x2B, 0x15, 0x2B, 0xBA, 0x64, 0xBA, 0x64, 0x9A, 0x64, 0x9A, 0x64,
    0x15, 0x2B, 0x15, 0x2B, 0xDA, 0x6C, 0xDA, 0x6C, 0xDA, 0x6C, 0xDA, 0x6C, 0x15, 0x2B, 0x14, 0x2B,
    0x1B, 0x75, 0x1B, 0x75, 0x1B, 0x75, 0x1B, 0x75, 0x15, 0x2B, 0x14, 0x2B, 0x1B, 0x75, 0x1B, 0x75,
    0x1B, 0x75, 0x1B, 0x75, 0x15, 0x2B, 0x15, 0x2B, 0x9C, 0x8D, 0x9C, 0x8D, 0x9C, 0x8D, 0x9C, 0x8D,
    0x35, 0x33, 0x35, 0x33, 0x3D, 0xAE, 0x3D, 0xAE, 0x3D, 0xA6, 0x3D, 0xA6, 0x35, 0x33, 0x35, 0x33,
    0x3D, 0xAE, 0x3D, 0xAE, 0x3D, 0xA6, 0x3D, 0xA6, 0x35, 0x33, 0x35, 0x33, 0x3D, 0xAE, 0x3D, 0xAE,
    0x3D, 0xA6, 0x3D, 0xA6, 0x35, 0x33, 0x15, 0x2B, 0x5D, 0xAE, 0x5D, 0xAE, 0x3D, 0xAE, 0x3D, 0xAE,
    0x35, 0x33, 0x14, 0x2B, 0x9C, 0x95, 0x9C, 0x95, 0x9C, 0x8D, 0x9C, 0x8D, 0x35, 0x33, 0x14, 0x2B,
    0x1B, 0x75, 0x1B, 0x75, 0x1B, 0x75, 0x1B, 0x75, 0x15, 0x2B, 0x14, 0x2B, 0x1B, 0x75, 0x1B, 0x75,
    0x1B, 0x75, 0x1B, 0x75, 0x15, 0x2B, 0x15, 0x2B, 0xDA, 0x6C, 0xDA, 0x6C, 0xDA, 0x6C, 0xDA, 0x6C,
    0x15, 0x2B, 0x15, 0x2B, 0xBA, 0x64, 0xBA, 0x64, 0x9A, 0x64, 0x9A, 0x64, 0x15, 0x2B, 0x15, 0x2B,
    0x79, 0x5C, 0x79, 0x5C, 0x79, 0x5C, 0x79, 0x5C, 0x15, 0x2B, 0x15, 0x2B, 0x39, 0x54, 0x39, 0x54,
    0x39, 0x54, 0x39, 0x54, 0x35, 0x33, 0x15, 0x2B, 0x15, 0x2B, 0x15, 0x2B, 0x15, 0x2B, 0x15, 0x2B,
    0x15, 0x2B
  };

/**
  * @}
  */ 
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/**
  * @}
  */ 

/**
  * @}
  */ 

/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/

