/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : Oversampling.h
* Author             : MCD Application Team
* Version            : V1.0.1
* Date               : 06/20/2008
* Description        : This file contains all the functions prototypes for the
*                      ADC oversampling..
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __OVERSAMPLING_H
#define __OVERSAMPLING_H

/* Includes ------------------------------------------------------------------*/
#include <stdio.h>
#include "stm32f10x_lib.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
//#define Thermal_Noise_Measure
#define Oversampling_Test

#define ADC_Additional_Bits 2
#define Input_Signal_Sampling_Period 50 /* Input Signal sampling period in s */ 

#define ADC_Oversampling_Factor  8 /*2*pow(2, ADC_Additional_Bits)*/
#define TIM_PWM_PERIOD 55
#define TIM_PWM_STEP ( (TIM_PWM_PERIOD  >> ADC_Additional_Bits) + 1 )
#define BUFFER_PW_WIDTH  ADC_Oversampling_Factor 
#define OFFSET_3V    0x3FFF

#ifdef Thermal_Noise_Measure
#define Total_Samples_Number 5000
#define Relevant_Samples_Number  100
#endif
#ifdef Oversampling_Test
#define Oversampling_Test_Samples 500
#endif 

#ifdef Thermal_Noise_Measure
void Oversampling_TestADCThermalNoise( vu16 *ADC_Code, vu16 *ADC_Code_Number );
#endif 
void Oversampling_InitData( void );
void Oversampling_CopyConvValuesToFile ( vu16 *Tab, u32 size );
u32  Oversampling_GetConversion( void );
#ifndef Thermal_Noise_Measure
void Oversampling_ComputePulseWidthBuffer (void);
#endif 
#endif   /* __OVERSAMPLING_H */

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
