/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : oversampling.c
* Author             : MCD Application Team
* Version            : V1.0.1
* Date               : 06/20/2008
* Description        : This file contains the oversampling functions body.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include <stdio.h>
#include "oversampling.h"

#ifdef Thermal_Noise_Measure  
/* This parameter to compute the ADC thermal noise */ 
u16 ADC_ConvertedValue[Total_Samples_Number];
u16 ADC_Codes[Relevant_Samples_Number];
u16 ADC_Codes_Number[Relevant_Samples_Number];
#else
u16 ADC_ConvertedValue[ADC_Oversampling_Factor];
u16 TimerPulseWidth[BUFFER_PW_WIDTH];
#endif 
#ifdef Oversampling_Test
u16 ADC_Oversampled_Buffer[Oversampling_Test_Samples];
#endif

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/    
/* Private function prototypes -----------------------------------------------*/
void Oversampling_InitBuffer ( u16 * Buffer , u32 size );

#ifdef __GNUC__
  /* With GCC/RAISONANCE, small printf (option LD Linker->Libraries->Small printf
     set to 'Yes') calls __io_putchar() */
  #define PUTCHAR_PROTOTYPE int __io_putchar(int ch)
#else
  #define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
#endif /* __GNUC__ */


/* Private functions ---------------------------------------------------------*/
/*******************************************************************************
* Function Name  : Oversampling_InitBuffer
* Description    : Initializes a data buffer which size is passed in parameter 
* Input1         : buffer   
* Input2         : buffer size
* Output         : None
* Return         : None
*******************************************************************************/
void Oversampling_InitBuffer( u16 * Buffer , u32 size )
{
  u32 index = 0;
  for( index = 0; index < size; index++)
  Buffer[index] = 0;
} 

/*******************************************************************************
* Function Name  : PUTCHAR_PROTOTYPE
* Description    : Retargets the C library printf function to the USART.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
PUTCHAR_PROTOTYPE
{
  /* Place your implementation of fputc here */
  /* e.g. write a character to the USART */
  USART_SendData(USART1, (u8) ch);

  /* Loop until the end of transmission */
  while(USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET)
  {
  }
  return ch;
} 

/*******************************************************************************
* Function Name  : Oversampling_InitData
* Description    : Initializes The different data buffers used in the 
*                  oversampling alogorithm according to the different cases:
*                  Thermal_Noise_Measure, Oversampling_Test 
* Input          : - u16 buffer   
*                  - u32: buffer size
* Output         : None
* Return         : None
*******************************************************************************/
void  Oversampling_InitData( void )
{
  #ifdef  Thermal_Noise_Measure
  Oversampling_InitBuffer( ADC_ConvertedValue, Total_Samples_Number);
  Oversampling_InitBuffer( ADC_Codes, Relevant_Samples_Number);
  Oversampling_InitBuffer( ADC_Codes_Number, Relevant_Samples_Number);
  #else
  Oversampling_InitBuffer( ADC_ConvertedValue, ADC_Oversampling_Factor); 
  /* Init the Capture compare values for the triangular waveform generation */
  Oversampling_ComputePulseWidthBuffer();
  #endif
  #ifdef Oversampling_Test
  Oversampling_InitBuffer ( ADC_Oversampled_Buffer, Oversampling_Test_Samples);
  #endif  
}  

/*******************************************************************************
* Function Name  :  Oversampling_TestADCThermalNoise
* Description    : Determines the number of each code bin included in the 
*                  samples. 
* Input          : - u16 buffer conatining the code bins  
*                  - u16 buffer containing the number of the corresponding code
*                  - u32: Code bins Number 
* Output         : None
* Return         : None
*******************************************************************************/
#ifdef Thermal_Noise_Measure
void  Oversampling_TestADCThermalNoise( vu16 *ADC_Code, vu16 *ADC_Code_Number)
{
  u32 index = 0;
  u32 i = 0; 
  u32 pointeur = 0; 
  
  do
  {  
    if ( index == 0)
     {
      ADC_Code[0] = ADC_ConvertedValue[0];
      ADC_Code_Number[0] = 1;
     } 
     else
     {
       i = 0; 
       do
        {
          if( ADC_ConvertedValue[index] == ADC_Code[i])
          {
            ADC_Code_Number[i]++;
            break;
          } 
          i++;
        } while( i<= pointeur);
        
        if( i == (pointeur+1))
        {
          pointeur++;
          ADC_Code[pointeur] = ADC_ConvertedValue[index];
          ADC_Code_Number[pointeur] = 1;
        } 
    } /* end else */  
    index++;
  } while( index < Total_Samples_Number);
  
 Oversampling_CopyConvValuesToFile(  ADC_Code , 100 );
 
 printf( "The occurance of each ADC code is as follow:\n");
        
 Oversampling_CopyConvValuesToFile(  ADC_Code_Number , 100 );

}  
#endif

/*******************************************************************************
* Function Name  : u32 Oversampling_GetConversion
* Description    : Gives the ADC oversampled conversion result  
* Input          : None 
* Output         : None
* Return         : Oversampled Result
*******************************************************************************/
u32 Oversampling_GetConversion ( void )
{
  u32 index = 0;
  u32 result = 0;
  
  for( index = 0; index < ADC_Oversampling_Factor ; index++)
    result += ADC_ConvertedValue[index];
  
  result = (result + 1 ) >> 1;
  
  /* This line is to compensate the offset AOP VIN+ = 3.3V */
  result =  OFFSET_3V - result; 
  
 return ( (u32)result );
    
}  

/*******************************************************************************
* Function Name  : Oversampling_CopyConvValuesToFile
* Description    : Copies the ADC converted value into a text file  
* Input1         : Buffer
* Input2         : Buffer size
* Output         : None
* Return         : None
*******************************************************************************/
void Oversampling_CopyConvValuesToFile ( vu16 *Tab, u32 size )
{    
  u32 index = 0;

  for ( index = 0; index < size ; index++ )
   {
	 printf("%x\r\n", Tab[index]);
   }  
   printf ("End\n\r");
}

/*******************************************************************************
* Function Name  : Oversampling_ComputePulseWidthBuffer
* Description    : Computes the Pulse width buffer that is used to update the 
*                  Compare register of Timer 3 used for the triangular waveform
*                  generation
* Input          : None   
* Output         : None
* Return         : None
*******************************************************************************/
#ifndef Thermal_Noise_Measure
void Oversampling_ComputePulseWidthBuffer ( void)
{
  u32 index = 0; 
  u32 Half_Size = ( ADC_Oversampling_Factor >> 1 );
   
   TimerPulseWidth[0] = TIM_PWM_STEP;
   
  for( index = 1 ; index < Half_Size - 1 ; index++)
    TimerPulseWidth[ index] = TimerPulseWidth[index - 1] + TIM_PWM_STEP;
  
 for( index = 0; index < Half_Size - 1 ; index++)
    TimerPulseWidth[Half_Size + index] = TimerPulseWidth[Half_Size - index-2];
 
 TimerPulseWidth[Half_Size - 1 ] = TIM_PWM_PERIOD;
 
} 
#endif

 
/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
