/******************** (C) COPYRIGHT 2008 STMicroelectronics ********************
* File Name          : dfu_mal.h
* Author             : MCD Application Team
* Version            : V2.2.1
* Date               : 09/22/2008
* Description        : Header for dfu_mal.c file.
********************************************************************************
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __DFU_MAL_H
#define __DFU_MAL_H

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_lib.h"
#include "dfu_mal.h"
#include "usb_desc.h"
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
#define MAL_OK   0
#define MAL_FAIL 1
#define MAX_USED_MEDIA 3
#define MAL_MASK 0xFC000000

#define INTERNAL_FLASH_BASE 0x08000000
#define SPI_FLASH_BASE      0x00000000
#define NOR_FLASH_BASE      0x64000000

#define NOR_M29W128F        0x2212
#define NOR_M29W128G        0x2221
#define NOR_S29GL128        0x2221

/* utils macro ---------------------------------------------------------------*/
#define _1st_BYTE(x)  (u8)((x)&0xFF)             /* 1st addressing cycle */
#define _2nd_BYTE(x)  (u8)(((x)&0xFF00)>>8)      /* 2nd addressing cycle */
#define _3rd_BYTE(x)  (u8)(((x)&0xFF0000)>>16)   /* 3rd addressing cycle */
#define _4th_BYTE(x)  (u8)(((x)&0xFF000000)>>24) /* 4th addressing cycle */
/* Exported macro ------------------------------------------------------------*/
#define SET_POLLING_TIMING(x)   buffer[1] = _1st_BYTE(x);\
                                buffer[2] = _2nd_BYTE(x);\
                                buffer[3] = _3rd_BYTE(x);  

/* Exported functions ------------------------------------------------------- */

u16 MAL_Init (void);
u16 MAL_Erase (u32 SectorAddress);
u16 MAL_Write (u32 SectorAddress, u32 DataLength);
u8  *MAL_Read (u32 SectorAddress, u32 DataLength);
u16 MAL_GetStatus(u32 SectorAddress ,u8 Cmd, u8 *buffer);

extern u8  MAL_Buffer[wTransferSize]; /* RAM Buffer for Downloaded Data */
#endif /* __DFU_MAL_H */

/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
